# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import json
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Dict, List, Mapping, Optional, Tuple, Union
from . import _utilities, _tables

__all__ = ['Provider']


class Provider(pulumi.ProviderResource):
    def __init__(__self__,
                 resource_name,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allow_reauth: Optional[pulumi.Input[bool]] = None,
                 application_credential_id: Optional[pulumi.Input[str]] = None,
                 application_credential_name: Optional[pulumi.Input[str]] = None,
                 application_credential_secret: Optional[pulumi.Input[str]] = None,
                 auth_url: Optional[pulumi.Input[str]] = None,
                 cacert_file: Optional[pulumi.Input[str]] = None,
                 cert: Optional[pulumi.Input[str]] = None,
                 cloud: Optional[pulumi.Input[str]] = None,
                 default_domain: Optional[pulumi.Input[str]] = None,
                 delayed_auth: Optional[pulumi.Input[bool]] = None,
                 disable_no_cache_header: Optional[pulumi.Input[bool]] = None,
                 domain_id: Optional[pulumi.Input[str]] = None,
                 domain_name: Optional[pulumi.Input[str]] = None,
                 endpoint_overrides: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 endpoint_type: Optional[pulumi.Input[str]] = None,
                 insecure: Optional[pulumi.Input[bool]] = None,
                 key: Optional[pulumi.Input[str]] = None,
                 max_retries: Optional[pulumi.Input[float]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 project_domain_id: Optional[pulumi.Input[str]] = None,
                 project_domain_name: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 swauth: Optional[pulumi.Input[bool]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 tenant_name: Optional[pulumi.Input[str]] = None,
                 token: Optional[pulumi.Input[str]] = None,
                 use_octavia: Optional[pulumi.Input[bool]] = None,
                 user_domain_id: Optional[pulumi.Input[str]] = None,
                 user_domain_name: Optional[pulumi.Input[str]] = None,
                 user_id: Optional[pulumi.Input[str]] = None,
                 user_name: Optional[pulumi.Input[str]] = None,
                 __props__=None,
                 __name__=None,
                 __opts__=None):
        """
        The provider type for the openstack package. By default, resources use package-wide configuration
        settings, however an explicit `Provider` instance may be created and passed during resource
        construction to achieve fine-grained programmatic control over provider settings. See the
        [documentation](https://www.pulumi.com/docs/reference/programming-model/#providers) for more information.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] allow_reauth: If set to `false`, OpenStack authorization won't be perfomed automatically, if the initial auth token get expired.
               Defaults to `true`
        :param pulumi.Input[str] application_credential_id: Application Credential ID to login with.
        :param pulumi.Input[str] application_credential_name: Application Credential name to login with.
        :param pulumi.Input[str] application_credential_secret: Application Credential secret to login with.
        :param pulumi.Input[str] auth_url: The Identity authentication URL.
        :param pulumi.Input[str] cacert_file: A Custom CA certificate.
        :param pulumi.Input[str] cert: A client certificate to authenticate with.
        :param pulumi.Input[str] cloud: An entry in a `clouds.yaml` file to use.
        :param pulumi.Input[str] default_domain: The name of the Domain ID to scope to if no other domain is specified. Defaults to `default` (Identity v3).
        :param pulumi.Input[bool] delayed_auth: If set to `false`, OpenStack authorization will be perfomed, every time the service provider client is called. Defaults
               to `true`.
        :param pulumi.Input[bool] disable_no_cache_header: If set to `true`, the HTTP `Cache-Control: no-cache` header will not be added by default to all API requests.
        :param pulumi.Input[str] domain_id: The ID of the Domain to scope to (Identity v3).
        :param pulumi.Input[str] domain_name: The name of the Domain to scope to (Identity v3).
        :param pulumi.Input[Mapping[str, Any]] endpoint_overrides: A map of services with an endpoint to override what was from the Keystone catalog
        :param pulumi.Input[bool] insecure: Trust self-signed certificates.
        :param pulumi.Input[str] key: A client private key to authenticate with.
        :param pulumi.Input[float] max_retries: How many times HTTP connection should be retried until giving up.
        :param pulumi.Input[str] password: Password to login with.
        :param pulumi.Input[str] project_domain_id: The ID of the domain where the proejct resides (Identity v3).
        :param pulumi.Input[str] project_domain_name: The name of the domain where the project resides (Identity v3).
        :param pulumi.Input[str] region: The OpenStack region to connect to.
        :param pulumi.Input[bool] swauth: Use Swift's authentication system instead of Keystone. Only used for interaction with Swift.
        :param pulumi.Input[str] tenant_id: The ID of the Tenant (Identity v2) or Project (Identity v3) to login with.
        :param pulumi.Input[str] tenant_name: The name of the Tenant (Identity v2) or Project (Identity v3) to login with.
        :param pulumi.Input[str] token: Authentication token to use as an alternative to username/password.
        :param pulumi.Input[bool] use_octavia: If set to `true`, API requests will go the Load Balancer service (Octavia) instead of the Networking service (Neutron).
        :param pulumi.Input[str] user_domain_id: The ID of the domain where the user resides (Identity v3).
        :param pulumi.Input[str] user_domain_name: The name of the domain where the user resides (Identity v3).
        :param pulumi.Input[str] user_id: Username to login with.
        :param pulumi.Input[str] user_name: Username to login with.
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            if allow_reauth is None:
                allow_reauth = _utilities.get_env_bool('OS_ALLOW_REAUTH')
            __props__['allow_reauth'] = pulumi.Output.from_input(allow_reauth).apply(json.dumps) if allow_reauth is not None else None
            if application_credential_id is None:
                application_credential_id = _utilities.get_env('OS_APPLICATION_CREDENTIAL_ID')
            __props__['application_credential_id'] = application_credential_id
            if application_credential_name is None:
                application_credential_name = _utilities.get_env('OS_APPLICATION_CREDENTIAL_NAME')
            __props__['application_credential_name'] = application_credential_name
            if application_credential_secret is None:
                application_credential_secret = _utilities.get_env('OS_APPLICATION_CREDENTIAL_SECRET')
            __props__['application_credential_secret'] = application_credential_secret
            if auth_url is None:
                auth_url = _utilities.get_env('OS_AUTH_URL')
            __props__['auth_url'] = auth_url
            if cacert_file is None:
                cacert_file = _utilities.get_env('OS_CACERT')
            __props__['cacert_file'] = cacert_file
            if cert is None:
                cert = _utilities.get_env('OS_CERT')
            __props__['cert'] = cert
            if cloud is None:
                cloud = _utilities.get_env('OS_CLOUD')
            __props__['cloud'] = cloud
            if default_domain is None:
                default_domain = (_utilities.get_env('OS_DEFAULT_DOMAIN') or 'default')
            __props__['default_domain'] = default_domain
            if delayed_auth is None:
                delayed_auth = _utilities.get_env_bool('OS_DELAYED_AUTH')
            __props__['delayed_auth'] = pulumi.Output.from_input(delayed_auth).apply(json.dumps) if delayed_auth is not None else None
            __props__['disable_no_cache_header'] = pulumi.Output.from_input(disable_no_cache_header).apply(json.dumps) if disable_no_cache_header is not None else None
            if domain_id is None:
                domain_id = _utilities.get_env('OS_DOMAIN_ID')
            __props__['domain_id'] = domain_id
            if domain_name is None:
                domain_name = _utilities.get_env('OS_DOMAIN_NAME')
            __props__['domain_name'] = domain_name
            __props__['endpoint_overrides'] = pulumi.Output.from_input(endpoint_overrides).apply(json.dumps) if endpoint_overrides is not None else None
            if endpoint_type is None:
                endpoint_type = _utilities.get_env('OS_ENDPOINT_TYPE')
            __props__['endpoint_type'] = endpoint_type
            if insecure is None:
                insecure = _utilities.get_env_bool('OS_INSECURE')
            __props__['insecure'] = pulumi.Output.from_input(insecure).apply(json.dumps) if insecure is not None else None
            if key is None:
                key = _utilities.get_env('OS_KEY')
            __props__['key'] = key
            __props__['max_retries'] = pulumi.Output.from_input(max_retries).apply(json.dumps) if max_retries is not None else None
            if password is None:
                password = _utilities.get_env('OS_PASSWORD')
            __props__['password'] = password
            if project_domain_id is None:
                project_domain_id = _utilities.get_env('OS_PROJECT_DOMAIN_ID')
            __props__['project_domain_id'] = project_domain_id
            if project_domain_name is None:
                project_domain_name = _utilities.get_env('OS_PROJECT_DOMAIN_NAME')
            __props__['project_domain_name'] = project_domain_name
            if region is None:
                region = _utilities.get_env('OS_REGION_NAME')
            __props__['region'] = region
            if swauth is None:
                swauth = _utilities.get_env_bool('OS_SWAUTH')
            __props__['swauth'] = pulumi.Output.from_input(swauth).apply(json.dumps) if swauth is not None else None
            if tenant_id is None:
                tenant_id = _utilities.get_env('OS_TENANT_ID', 'OS_PROJECT_ID')
            __props__['tenant_id'] = tenant_id
            if tenant_name is None:
                tenant_name = _utilities.get_env('OS_TENANT_NAME', 'OS_PROJECT_NAME')
            __props__['tenant_name'] = tenant_name
            if token is None:
                token = _utilities.get_env('OS_TOKEN', 'OS_AUTH_TOKEN')
            __props__['token'] = token
            if use_octavia is None:
                use_octavia = _utilities.get_env_bool('OS_USE_OCTAVIA')
            __props__['use_octavia'] = pulumi.Output.from_input(use_octavia).apply(json.dumps) if use_octavia is not None else None
            if user_domain_id is None:
                user_domain_id = _utilities.get_env('OS_USER_DOMAIN_ID')
            __props__['user_domain_id'] = user_domain_id
            if user_domain_name is None:
                user_domain_name = _utilities.get_env('OS_USER_DOMAIN_NAME')
            __props__['user_domain_name'] = user_domain_name
            if user_id is None:
                user_id = _utilities.get_env('OS_USER_ID')
            __props__['user_id'] = user_id
            if user_name is None:
                user_name = _utilities.get_env('OS_USERNAME')
            __props__['user_name'] = user_name
        super(Provider, __self__).__init__(
            'openstack',
            resource_name,
            __props__,
            opts)

    def translate_output_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return _tables.SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

