# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Dict, List, Mapping, Optional, Tuple, Union
from .. import _utilities, _tables
from . import outputs
from ._inputs import *

__all__ = ['Router']


class Router(pulumi.CustomResource):
    def __init__(__self__,
                 resource_name,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 admin_state_up: Optional[pulumi.Input[bool]] = None,
                 availability_zone_hints: Optional[pulumi.Input[List[pulumi.Input[str]]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 distributed: Optional[pulumi.Input[bool]] = None,
                 enable_snat: Optional[pulumi.Input[bool]] = None,
                 external_fixed_ips: Optional[pulumi.Input[List[pulumi.Input[pulumi.InputType['RouterExternalFixedIpArgs']]]]] = None,
                 external_gateway: Optional[pulumi.Input[str]] = None,
                 external_network_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[List[pulumi.Input[str]]]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 value_specs: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 vendor_options: Optional[pulumi.Input[pulumi.InputType['RouterVendorOptionsArgs']]] = None,
                 __props__=None,
                 __name__=None,
                 __opts__=None):
        """
        Manages a V2 router resource within OpenStack.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_openstack as openstack

        router1 = openstack.networking.Router("router1",
            admin_state_up=True,
            external_network_id="f67f0d72-0ddf-11e4-9d95-e1f29f417e2f")
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] admin_state_up: Administrative up/down status for the router
               (must be "true" or "false" if provided). Changing this updates the
               `admin_state_up` of an existing router.
        :param pulumi.Input[List[pulumi.Input[str]]] availability_zone_hints: An availability zone is used to make 
               network resources highly available. Used for resources with high availability so that they are scheduled on different availability zones. Changing
               this creates a new router.
        :param pulumi.Input[str] description: Human-readable description for the router.
        :param pulumi.Input[bool] distributed: Indicates whether or not to create a
               distributed router. The default policy setting in Neutron restricts
               usage of this property to administrative users only.
        :param pulumi.Input[bool] enable_snat: Enable Source NAT for the router. Valid values are
               "true" or "false". An `external_network_id` has to be set in order to
               set this property. Changing this updates the `enable_snat` of the router.
               Setting this value **requires** an **ext-gw-mode** extension to be enabled
               in OpenStack Neutron.
        :param pulumi.Input[List[pulumi.Input[pulumi.InputType['RouterExternalFixedIpArgs']]]] external_fixed_ips: An external fixed IP for the router. This
               can be repeated. The structure is described below. An `external_network_id`
               has to be set in order to set this property. Changing this updates the
               external fixed IPs of the router.
        :param pulumi.Input[str] external_gateway: The
               network UUID of an external gateway for the router. A router with an
               external gateway is required if any compute instances or load balancers
               will be using floating IPs. Changing this updates the external gateway
               of an existing router.
        :param pulumi.Input[str] external_network_id: The network UUID of an external gateway
               for the router. A router with an external gateway is required if any
               compute instances or load balancers will be using floating IPs. Changing
               this updates the external gateway of the router.
        :param pulumi.Input[str] name: A unique name for the router. Changing this
               updates the `name` of an existing router.
        :param pulumi.Input[str] region: The region in which to obtain the V2 networking client.
               A networking client is needed to create a router. If omitted, the
               `region` argument of the provider is used. Changing this creates a new
               router.
        :param pulumi.Input[List[pulumi.Input[str]]] tags: A set of string tags for the router.
        :param pulumi.Input[str] tenant_id: The owner of the floating IP. Required if admin wants
               to create a router for another tenant. Changing this creates a new router.
        :param pulumi.Input[Mapping[str, Any]] value_specs: Map of additional driver-specific options.
        :param pulumi.Input[pulumi.InputType['RouterVendorOptionsArgs']] vendor_options: Map of additional vendor-specific options.
               Supported options are described below.
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            __props__['admin_state_up'] = admin_state_up
            __props__['availability_zone_hints'] = availability_zone_hints
            __props__['description'] = description
            __props__['distributed'] = distributed
            __props__['enable_snat'] = enable_snat
            __props__['external_fixed_ips'] = external_fixed_ips
            if external_gateway is not None:
                warnings.warn("use external_network_id instead", DeprecationWarning)
                pulumi.log.warn("external_gateway is deprecated: use external_network_id instead")
            __props__['external_gateway'] = external_gateway
            __props__['external_network_id'] = external_network_id
            __props__['name'] = name
            __props__['region'] = region
            __props__['tags'] = tags
            __props__['tenant_id'] = tenant_id
            __props__['value_specs'] = value_specs
            __props__['vendor_options'] = vendor_options
            __props__['all_tags'] = None
        super(Router, __self__).__init__(
            'openstack:networking/router:Router',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            admin_state_up: Optional[pulumi.Input[bool]] = None,
            all_tags: Optional[pulumi.Input[List[pulumi.Input[str]]]] = None,
            availability_zone_hints: Optional[pulumi.Input[List[pulumi.Input[str]]]] = None,
            description: Optional[pulumi.Input[str]] = None,
            distributed: Optional[pulumi.Input[bool]] = None,
            enable_snat: Optional[pulumi.Input[bool]] = None,
            external_fixed_ips: Optional[pulumi.Input[List[pulumi.Input[pulumi.InputType['RouterExternalFixedIpArgs']]]]] = None,
            external_gateway: Optional[pulumi.Input[str]] = None,
            external_network_id: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            region: Optional[pulumi.Input[str]] = None,
            tags: Optional[pulumi.Input[List[pulumi.Input[str]]]] = None,
            tenant_id: Optional[pulumi.Input[str]] = None,
            value_specs: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            vendor_options: Optional[pulumi.Input[pulumi.InputType['RouterVendorOptionsArgs']]] = None) -> 'Router':
        """
        Get an existing Router resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] admin_state_up: Administrative up/down status for the router
               (must be "true" or "false" if provided). Changing this updates the
               `admin_state_up` of an existing router.
        :param pulumi.Input[List[pulumi.Input[str]]] all_tags: The collection of tags assigned on the router, which have been
               explicitly and implicitly added.
        :param pulumi.Input[List[pulumi.Input[str]]] availability_zone_hints: An availability zone is used to make 
               network resources highly available. Used for resources with high availability so that they are scheduled on different availability zones. Changing
               this creates a new router.
        :param pulumi.Input[str] description: Human-readable description for the router.
        :param pulumi.Input[bool] distributed: Indicates whether or not to create a
               distributed router. The default policy setting in Neutron restricts
               usage of this property to administrative users only.
        :param pulumi.Input[bool] enable_snat: Enable Source NAT for the router. Valid values are
               "true" or "false". An `external_network_id` has to be set in order to
               set this property. Changing this updates the `enable_snat` of the router.
               Setting this value **requires** an **ext-gw-mode** extension to be enabled
               in OpenStack Neutron.
        :param pulumi.Input[List[pulumi.Input[pulumi.InputType['RouterExternalFixedIpArgs']]]] external_fixed_ips: An external fixed IP for the router. This
               can be repeated. The structure is described below. An `external_network_id`
               has to be set in order to set this property. Changing this updates the
               external fixed IPs of the router.
        :param pulumi.Input[str] external_gateway: The
               network UUID of an external gateway for the router. A router with an
               external gateway is required if any compute instances or load balancers
               will be using floating IPs. Changing this updates the external gateway
               of an existing router.
        :param pulumi.Input[str] external_network_id: The network UUID of an external gateway
               for the router. A router with an external gateway is required if any
               compute instances or load balancers will be using floating IPs. Changing
               this updates the external gateway of the router.
        :param pulumi.Input[str] name: A unique name for the router. Changing this
               updates the `name` of an existing router.
        :param pulumi.Input[str] region: The region in which to obtain the V2 networking client.
               A networking client is needed to create a router. If omitted, the
               `region` argument of the provider is used. Changing this creates a new
               router.
        :param pulumi.Input[List[pulumi.Input[str]]] tags: A set of string tags for the router.
        :param pulumi.Input[str] tenant_id: The owner of the floating IP. Required if admin wants
               to create a router for another tenant. Changing this creates a new router.
        :param pulumi.Input[Mapping[str, Any]] value_specs: Map of additional driver-specific options.
        :param pulumi.Input[pulumi.InputType['RouterVendorOptionsArgs']] vendor_options: Map of additional vendor-specific options.
               Supported options are described below.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["admin_state_up"] = admin_state_up
        __props__["all_tags"] = all_tags
        __props__["availability_zone_hints"] = availability_zone_hints
        __props__["description"] = description
        __props__["distributed"] = distributed
        __props__["enable_snat"] = enable_snat
        __props__["external_fixed_ips"] = external_fixed_ips
        __props__["external_gateway"] = external_gateway
        __props__["external_network_id"] = external_network_id
        __props__["name"] = name
        __props__["region"] = region
        __props__["tags"] = tags
        __props__["tenant_id"] = tenant_id
        __props__["value_specs"] = value_specs
        __props__["vendor_options"] = vendor_options
        return Router(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="adminStateUp")
    def admin_state_up(self) -> bool:
        """
        Administrative up/down status for the router
        (must be "true" or "false" if provided). Changing this updates the
        `admin_state_up` of an existing router.
        """
        return pulumi.get(self, "admin_state_up")

    @property
    @pulumi.getter(name="allTags")
    def all_tags(self) -> List[str]:
        """
        The collection of tags assigned on the router, which have been
        explicitly and implicitly added.
        """
        return pulumi.get(self, "all_tags")

    @property
    @pulumi.getter(name="availabilityZoneHints")
    def availability_zone_hints(self) -> List[str]:
        """
        An availability zone is used to make 
        network resources highly available. Used for resources with high availability so that they are scheduled on different availability zones. Changing
        this creates a new router.
        """
        return pulumi.get(self, "availability_zone_hints")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Human-readable description for the router.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def distributed(self) -> bool:
        """
        Indicates whether or not to create a
        distributed router. The default policy setting in Neutron restricts
        usage of this property to administrative users only.
        """
        return pulumi.get(self, "distributed")

    @property
    @pulumi.getter(name="enableSnat")
    def enable_snat(self) -> bool:
        """
        Enable Source NAT for the router. Valid values are
        "true" or "false". An `external_network_id` has to be set in order to
        set this property. Changing this updates the `enable_snat` of the router.
        Setting this value **requires** an **ext-gw-mode** extension to be enabled
        in OpenStack Neutron.
        """
        return pulumi.get(self, "enable_snat")

    @property
    @pulumi.getter(name="externalFixedIps")
    def external_fixed_ips(self) -> List['outputs.RouterExternalFixedIp']:
        """
        An external fixed IP for the router. This
        can be repeated. The structure is described below. An `external_network_id`
        has to be set in order to set this property. Changing this updates the
        external fixed IPs of the router.
        """
        return pulumi.get(self, "external_fixed_ips")

    @property
    @pulumi.getter(name="externalGateway")
    def external_gateway(self) -> str:
        """
        The
        network UUID of an external gateway for the router. A router with an
        external gateway is required if any compute instances or load balancers
        will be using floating IPs. Changing this updates the external gateway
        of an existing router.
        """
        return pulumi.get(self, "external_gateway")

    @property
    @pulumi.getter(name="externalNetworkId")
    def external_network_id(self) -> str:
        """
        The network UUID of an external gateway
        for the router. A router with an external gateway is required if any
        compute instances or load balancers will be using floating IPs. Changing
        this updates the external gateway of the router.
        """
        return pulumi.get(self, "external_network_id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        A unique name for the router. Changing this
        updates the `name` of an existing router.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def region(self) -> str:
        """
        The region in which to obtain the V2 networking client.
        A networking client is needed to create a router. If omitted, the
        `region` argument of the provider is used. Changing this creates a new
        router.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def tags(self) -> Optional[List[str]]:
        """
        A set of string tags for the router.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> str:
        """
        The owner of the floating IP. Required if admin wants
        to create a router for another tenant. Changing this creates a new router.
        """
        return pulumi.get(self, "tenant_id")

    @property
    @pulumi.getter(name="valueSpecs")
    def value_specs(self) -> Optional[Mapping[str, Any]]:
        """
        Map of additional driver-specific options.
        """
        return pulumi.get(self, "value_specs")

    @property
    @pulumi.getter(name="vendorOptions")
    def vendor_options(self) -> Optional['outputs.RouterVendorOptions']:
        """
        Map of additional vendor-specific options.
        Supported options are described below.
        """
        return pulumi.get(self, "vendor_options")

    def translate_output_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return _tables.SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

