# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Dict, List, Mapping, Optional, Tuple, Union
from .. import _utilities, _tables
from . import outputs
from ._inputs import *

__all__ = ['ContainerV1']


class ContainerV1(pulumi.CustomResource):
    def __init__(__self__,
                 resource_name,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 acl: Optional[pulumi.Input[pulumi.InputType['ContainerV1AclArgs']]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 secret_refs: Optional[pulumi.Input[List[pulumi.Input[pulumi.InputType['ContainerV1SecretRefArgs']]]]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 __props__=None,
                 __name__=None,
                 __opts__=None):
        """
        Manages a V1 Barbican container resource within OpenStack.

        ## Example Usage
        ### Simple secret

        The container with the TLS certificates, which can be used by the loadbalancer HTTPS listener.

        ```python
        import pulumi
        import pulumi_openstack as openstack

        certificate1 = openstack.keymanager.SecretV1("certificate1",
            payload=(lambda path: open(path).read())("cert.pem"),
            payload_content_type="text/plain",
            secret_type="certificate")
        private_key1 = openstack.keymanager.SecretV1("privateKey1",
            payload=(lambda path: open(path).read())("cert-key.pem"),
            payload_content_type="text/plain",
            secret_type="private")
        intermediate1 = openstack.keymanager.SecretV1("intermediate1",
            payload=(lambda path: open(path).read())("intermediate-ca.pem"),
            payload_content_type="text/plain",
            secret_type="certificate")
        tls1 = openstack.keymanager.ContainerV1("tls1",
            secret_refs=[
                openstack.keymanager.ContainerV1SecretRefArgs(
                    name="certificate",
                    secret_ref=certificate1.secret_ref,
                ),
                openstack.keymanager.ContainerV1SecretRefArgs(
                    name="private_key",
                    secret_ref=private_key1.secret_ref,
                ),
                openstack.keymanager.ContainerV1SecretRefArgs(
                    name="intermediates",
                    secret_ref=intermediate1.secret_ref,
                ),
            ],
            type="certificate")
        subnet1 = openstack.networking.get_subnet(name="my-subnet")
        lb1 = openstack.loadbalancer.LoadBalancer("lb1", vip_subnet_id=subnet1.id)
        listener1 = openstack.loadbalancer.Listener("listener1",
            default_tls_container_ref=tls1.container_ref,
            loadbalancer_id=lb1.id,
            protocol="TERMINATED_HTTPS",
            protocol_port=443)
        ```
        ### Container with the ACL

        > **Note** Only read ACLs are supported

        ```python
        import pulumi
        import pulumi_openstack as openstack

        tls1 = openstack.keymanager.ContainerV1("tls1",
            acl=openstack.keymanager.ContainerV1AclArgs(
                read=openstack.keymanager.ContainerV1AclReadArgs(
                    project_access=False,
                    users=[
                        "userid1",
                        "userid2",
                    ],
                ),
            ),
            secret_refs=[
                openstack.keymanager.ContainerV1SecretRefArgs(
                    name="certificate",
                    secret_ref=openstack_keymanager_secret_v1["certificate_1"]["secret_ref"],
                ),
                openstack.keymanager.ContainerV1SecretRefArgs(
                    name="private_key",
                    secret_ref=openstack_keymanager_secret_v1["private_key_1"]["secret_ref"],
                ),
                openstack.keymanager.ContainerV1SecretRefArgs(
                    name="intermediates",
                    secret_ref=openstack_keymanager_secret_v1["intermediate_1"]["secret_ref"],
                ),
            ],
            type="certificate")
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['ContainerV1AclArgs']] acl: Allows to control an access to a container. Currently only
               the `read` operation is supported. If not specified, the container is
               accessible project wide. The `read` structure is described below.
        :param pulumi.Input[str] name: The name of the secret reference. The reference names must correspond the container type, more details are available [here](https://docs.openstack.org/barbican/stein/api/reference/containers.html).
        :param pulumi.Input[str] region: The region in which to obtain the V1 KeyManager client.
               A KeyManager client is needed to create a container. If omitted, the
               `region` argument of the provider is used. Changing this creates a new
               V1 container.
        :param pulumi.Input[List[pulumi.Input[pulumi.InputType['ContainerV1SecretRefArgs']]]] secret_refs: A set of dictionaries containing references to secrets. The structure is described
               below.
        :param pulumi.Input[str] type: Used to indicate the type of container. Must be one of `generic`, `rsa` or `certificate`.
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            __props__['acl'] = acl
            __props__['name'] = name
            __props__['region'] = region
            __props__['secret_refs'] = secret_refs
            if type is None:
                raise TypeError("Missing required property 'type'")
            __props__['type'] = type
            __props__['consumers'] = None
            __props__['container_ref'] = None
            __props__['created_at'] = None
            __props__['creator_id'] = None
            __props__['status'] = None
            __props__['updated_at'] = None
        super(ContainerV1, __self__).__init__(
            'openstack:keymanager/containerV1:ContainerV1',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            acl: Optional[pulumi.Input[pulumi.InputType['ContainerV1AclArgs']]] = None,
            consumers: Optional[pulumi.Input[List[pulumi.Input[pulumi.InputType['ContainerV1ConsumerArgs']]]]] = None,
            container_ref: Optional[pulumi.Input[str]] = None,
            created_at: Optional[pulumi.Input[str]] = None,
            creator_id: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            region: Optional[pulumi.Input[str]] = None,
            secret_refs: Optional[pulumi.Input[List[pulumi.Input[pulumi.InputType['ContainerV1SecretRefArgs']]]]] = None,
            status: Optional[pulumi.Input[str]] = None,
            type: Optional[pulumi.Input[str]] = None,
            updated_at: Optional[pulumi.Input[str]] = None) -> 'ContainerV1':
        """
        Get an existing ContainerV1 resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['ContainerV1AclArgs']] acl: Allows to control an access to a container. Currently only
               the `read` operation is supported. If not specified, the container is
               accessible project wide. The `read` structure is described below.
        :param pulumi.Input[List[pulumi.Input[pulumi.InputType['ContainerV1ConsumerArgs']]]] consumers: The list of the container consumers. The structure is described below.
        :param pulumi.Input[str] container_ref: The container reference / where to find the container.
        :param pulumi.Input[str] created_at: The date the container ACL was created.
        :param pulumi.Input[str] creator_id: The creator of the container.
        :param pulumi.Input[str] name: The name of the secret reference. The reference names must correspond the container type, more details are available [here](https://docs.openstack.org/barbican/stein/api/reference/containers.html).
        :param pulumi.Input[str] region: The region in which to obtain the V1 KeyManager client.
               A KeyManager client is needed to create a container. If omitted, the
               `region` argument of the provider is used. Changing this creates a new
               V1 container.
        :param pulumi.Input[List[pulumi.Input[pulumi.InputType['ContainerV1SecretRefArgs']]]] secret_refs: A set of dictionaries containing references to secrets. The structure is described
               below.
        :param pulumi.Input[str] status: The status of the container.
        :param pulumi.Input[str] type: Used to indicate the type of container. Must be one of `generic`, `rsa` or `certificate`.
        :param pulumi.Input[str] updated_at: The date the container ACL was last updated.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["acl"] = acl
        __props__["consumers"] = consumers
        __props__["container_ref"] = container_ref
        __props__["created_at"] = created_at
        __props__["creator_id"] = creator_id
        __props__["name"] = name
        __props__["region"] = region
        __props__["secret_refs"] = secret_refs
        __props__["status"] = status
        __props__["type"] = type
        __props__["updated_at"] = updated_at
        return ContainerV1(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def acl(self) -> 'outputs.ContainerV1Acl':
        """
        Allows to control an access to a container. Currently only
        the `read` operation is supported. If not specified, the container is
        accessible project wide. The `read` structure is described below.
        """
        return pulumi.get(self, "acl")

    @property
    @pulumi.getter
    def consumers(self) -> List['outputs.ContainerV1Consumer']:
        """
        The list of the container consumers. The structure is described below.
        """
        return pulumi.get(self, "consumers")

    @property
    @pulumi.getter(name="containerRef")
    def container_ref(self) -> str:
        """
        The container reference / where to find the container.
        """
        return pulumi.get(self, "container_ref")

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> str:
        """
        The date the container ACL was created.
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="creatorId")
    def creator_id(self) -> str:
        """
        The creator of the container.
        """
        return pulumi.get(self, "creator_id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the secret reference. The reference names must correspond the container type, more details are available [here](https://docs.openstack.org/barbican/stein/api/reference/containers.html).
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def region(self) -> str:
        """
        The region in which to obtain the V1 KeyManager client.
        A KeyManager client is needed to create a container. If omitted, the
        `region` argument of the provider is used. Changing this creates a new
        V1 container.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="secretRefs")
    def secret_refs(self) -> Optional[List['outputs.ContainerV1SecretRef']]:
        """
        A set of dictionaries containing references to secrets. The structure is described
        below.
        """
        return pulumi.get(self, "secret_refs")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The status of the container.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Used to indicate the type of container. Must be one of `generic`, `rsa` or `certificate`.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> str:
        """
        The date the container ACL was last updated.
        """
        return pulumi.get(self, "updated_at")

    def translate_output_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return _tables.SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

