import * as ec2 from '@aws-cdk/aws-ec2';
import * as ecr from '@aws-cdk/aws-ecr';
import { DockerImageAssetProps } from '@aws-cdk/aws-ecr-assets';
import * as iam from '@aws-cdk/aws-iam';
import * as kms from '@aws-cdk/aws-kms';
import * as s3 from '@aws-cdk/aws-s3';
import * as sfn from '@aws-cdk/aws-stepfunctions';
import { Duration, Size } from '@aws-cdk/core';
import { Construct } from 'constructs';
/**
 * (experimental) Task to train a machine learning model using Amazon SageMaker.
 *
 * @experimental
 */
export interface ISageMakerTask extends iam.IGrantable {
}
/**
 * (experimental) Specify the training algorithm and algorithm-specific metadata.
 *
 * @experimental
 */
export interface AlgorithmSpecification {
    /**
     * (experimental) Name of the algorithm resource to use for the training job.
     *
     * This must be an algorithm resource that you created or subscribe to on AWS Marketplace.
     * If you specify a value for this parameter, you can't specify a value for TrainingImage.
     *
     * @default - No algorithm is specified
     * @experimental
     */
    readonly algorithmName?: string;
    /**
     * (experimental) List of metric definition objects.
     *
     * Each object specifies the metric name and regular expressions used to parse algorithm logs.
     *
     * @default - No metrics
     * @experimental
     */
    readonly metricDefinitions?: MetricDefinition[];
    /**
     * (experimental) Registry path of the Docker image that contains the training algorithm.
     *
     * @default - No Docker image is specified
     * @experimental
     */
    readonly trainingImage?: DockerImage;
    /**
     * (experimental) Input mode that the algorithm supports.
     *
     * @default 'File' mode
     * @experimental
     */
    readonly trainingInputMode?: InputMode;
}
/**
 * (experimental) Describes the training, validation or test dataset and the Amazon S3 location where it is stored.
 *
 * @experimental
 */
export interface Channel {
    /**
     * (experimental) Name of the channel.
     *
     * @experimental
     */
    readonly channelName: string;
    /**
     * (experimental) Compression type if training data is compressed.
     *
     * @default - None
     * @experimental
     */
    readonly compressionType?: CompressionType;
    /**
     * (experimental) The MIME type of the data.
     *
     * @default - None
     * @experimental
     */
    readonly contentType?: string;
    /**
     * (experimental) Location of the channel data.
     *
     * @experimental
     */
    readonly dataSource: DataSource;
    /**
     * (experimental) Input mode to use for the data channel in a training job.
     *
     * @default - None
     * @experimental
     */
    readonly inputMode?: InputMode;
    /**
     * (experimental) Specify RecordIO as the value when input data is in raw format but the training algorithm requires the RecordIO format.
     *
     * In this case, Amazon SageMaker wraps each individual S3 object in a RecordIO record.
     * If the input data is already in RecordIO format, you don't need to set this attribute.
     *
     * @default - None
     * @experimental
     */
    readonly recordWrapperType?: RecordWrapperType;
    /**
     * (experimental) Shuffle config option for input data in a channel.
     *
     * @default - None
     * @experimental
     */
    readonly shuffleConfig?: ShuffleConfig;
}
/**
 * (experimental) Configuration for a shuffle option for input data in a channel.
 *
 * @experimental
 */
export interface ShuffleConfig {
    /**
     * (experimental) Determines the shuffling order.
     *
     * @experimental
     */
    readonly seed: number;
}
/**
 * (experimental) Location of the channel data.
 *
 * @experimental
 */
export interface DataSource {
    /**
     * (experimental) S3 location of the data source that is associated with a channel.
     *
     * @experimental
     */
    readonly s3DataSource: S3DataSource;
}
/**
 * (experimental) S3 location of the channel data.
 *
 * @see https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_S3DataSource.html
 * @experimental
 */
export interface S3DataSource {
    /**
     * (experimental) List of one or more attribute names to use that are found in a specified augmented manifest file.
     *
     * @default - No attribute names
     * @experimental
     */
    readonly attributeNames?: string[];
    /**
     * (experimental) S3 Data Distribution Type.
     *
     * @default - None
     * @experimental
     */
    readonly s3DataDistributionType?: S3DataDistributionType;
    /**
     * (experimental) S3 Data Type.
     *
     * @default S3_PREFIX
     * @experimental
     */
    readonly s3DataType?: S3DataType;
    /**
     * (experimental) S3 Uri.
     *
     * @experimental
     */
    readonly s3Location: S3Location;
}
/**
 * (experimental) Configures the S3 bucket where SageMaker will save the result of model training.
 *
 * @experimental
 */
export interface OutputDataConfig {
    /**
     * (experimental) Optional KMS encryption key that Amazon SageMaker uses to encrypt the model artifacts at rest using Amazon S3 server-side encryption.
     *
     * @default - Amazon SageMaker uses the default KMS key for Amazon S3 for your role's account
     * @experimental
     */
    readonly encryptionKey?: kms.IKey;
    /**
     * (experimental) Identifies the S3 path where you want Amazon SageMaker to store the model artifacts.
     *
     * @experimental
     */
    readonly s3OutputLocation: S3Location;
}
/**
 * (experimental) Specifies a limit to how long a model training job can run.
 *
 * When the job reaches the time limit, Amazon SageMaker ends the training job.
 *
 * @experimental
 */
export interface StoppingCondition {
    /**
     * (experimental) The maximum length of time, in seconds, that the training or compilation job can run.
     *
     * @default - 1 hour
     * @experimental
     */
    readonly maxRuntime?: Duration;
}
/**
 * (experimental) Specifies the resources, ML compute instances, and ML storage volumes to deploy for model training.
 *
 * @experimental
 */
export interface ResourceConfig {
    /**
     * (experimental) The number of ML compute instances to use.
     *
     * @default 1 instance.
     * @experimental
     */
    readonly instanceCount: number;
    /**
     * (experimental) ML compute instance type.
     *
     * @default is the 'm4.xlarge' instance type.
     * @experimental
     */
    readonly instanceType: ec2.InstanceType;
    /**
     * (experimental) KMS key that Amazon SageMaker uses to encrypt data on the storage volume attached to the ML compute instance(s) that run the training job.
     *
     * @default - Amazon SageMaker uses the default KMS key for Amazon S3 for your role's account
     * @experimental
     */
    readonly volumeEncryptionKey?: kms.IKey;
    /**
     * (experimental) Size of the ML storage volume that you want to provision.
     *
     * @default 10 GB EBS volume.
     * @experimental
     */
    readonly volumeSize: Size;
}
/**
 * (experimental) Specifies the VPC that you want your Amazon SageMaker training job to connect to.
 *
 * @experimental
 */
export interface VpcConfig {
    /**
     * (experimental) VPC.
     *
     * @experimental
     */
    readonly vpc: ec2.IVpc;
    /**
     * (experimental) VPC subnets.
     *
     * @default - Private Subnets are selected
     * @experimental
     */
    readonly subnets?: ec2.SubnetSelection;
}
/**
 * (experimental) Specifies the metric name and regular expressions used to parse algorithm logs.
 *
 * @experimental
 */
export interface MetricDefinition {
    /**
     * (experimental) Name of the metric.
     *
     * @experimental
     */
    readonly name: string;
    /**
     * (experimental) Regular expression that searches the output of a training job and gets the value of the metric.
     *
     * @experimental
     */
    readonly regex: string;
}
/**
 * (experimental) Stores information about the location of an object in Amazon S3.
 *
 * @experimental
 */
export interface S3LocationConfig {
    /**
     * (experimental) Uniquely identifies the resource in Amazon S3.
     *
     * @experimental
     */
    readonly uri: string;
}
/**
 * (experimental) Constructs `IS3Location` objects.
 *
 * @experimental
 */
export declare abstract class S3Location {
    /**
     * (experimental) An `IS3Location` built with a determined bucket and key prefix.
     *
     * @param bucket is the bucket where the objects are to be stored.
     * @param keyPrefix is the key prefix used by the location.
     * @experimental
     */
    static fromBucket(bucket: s3.IBucket, keyPrefix: string): S3Location;
    /**
     * (experimental) An `IS3Location` determined fully by a JSON Path from the task input.
     *
     * Due to the dynamic nature of those locations, the IAM grants that will be set by `grantRead` and `grantWrite`
     * apply to the `*` resource.
     *
     * @param expression the JSON expression resolving to an S3 location URI.
     * @experimental
     */
    static fromJsonExpression(expression: string): S3Location;
    /**
     * (experimental) Called when the S3Location is bound to a StepFunctions task.
     *
     * @experimental
     */
    abstract bind(task: ISageMakerTask, opts: S3LocationBindOptions): S3LocationConfig;
}
/**
 * (experimental) Options for binding an S3 Location.
 *
 * @experimental
 */
export interface S3LocationBindOptions {
    /**
     * (experimental) Allow reading from the S3 Location.
     *
     * @default false
     * @experimental
     */
    readonly forReading?: boolean;
    /**
     * (experimental) Allow writing to the S3 Location.
     *
     * @default false
     * @experimental
     */
    readonly forWriting?: boolean;
}
/**
 * (experimental) Configuration for a using Docker image.
 *
 * @experimental
 */
export interface DockerImageConfig {
    /**
     * (experimental) The fully qualified URI of the Docker image.
     *
     * @experimental
     */
    readonly imageUri: string;
}
/**
 * (experimental) Creates `IDockerImage` instances.
 *
 * @experimental
 */
export declare abstract class DockerImage {
    /**
     * (experimental) Reference a Docker image stored in an ECR repository.
     *
     * @param repository the ECR repository where the image is hosted.
     * @param tag an optional `tag`.
     * @experimental
     */
    static fromEcrRepository(repository: ecr.IRepository, tag?: string): DockerImage;
    /**
     * (experimental) Reference a Docker image which URI is obtained from the task's input.
     *
     * @param expression the JSON path expression with the task input.
     * @param allowAnyEcrImagePull whether ECR access should be permitted (set to `false` if the image will never be in ECR).
     * @experimental
     */
    static fromJsonExpression(expression: string, allowAnyEcrImagePull?: boolean): DockerImage;
    /**
     * (experimental) Reference a Docker image by it's URI.
     *
     * When referencing ECR images, prefer using `inEcr`.
     *
     * @param imageUri the URI to the docker image.
     * @experimental
     */
    static fromRegistry(imageUri: string): DockerImage;
    /**
     * (experimental) Reference a Docker image that is provided as an Asset in the current app.
     *
     * @param scope the scope in which to create the Asset.
     * @param id the ID for the asset in the construct tree.
     * @param props the configuration props of the asset.
     * @experimental
     */
    static fromAsset(scope: Construct, id: string, props: DockerImageAssetProps): DockerImage;
    /**
     * (experimental) Called when the image is used by a SageMaker task.
     *
     * @experimental
     */
    abstract bind(task: ISageMakerTask): DockerImageConfig;
}
/**
 * (experimental) S3 Data Type.
 *
 * @experimental
 */
export declare enum S3DataType {
    /**
     * (experimental) Manifest File Data Type.
     *
     * @experimental
     */
    MANIFEST_FILE = "ManifestFile",
    /**
     * (experimental) S3 Prefix Data Type.
     *
     * @experimental
     */
    S3_PREFIX = "S3Prefix",
    /**
     * (experimental) Augmented Manifest File Data Type.
     *
     * @experimental
     */
    AUGMENTED_MANIFEST_FILE = "AugmentedManifestFile"
}
/**
 * (experimental) S3 Data Distribution Type.
 *
 * @experimental
 */
export declare enum S3DataDistributionType {
    /**
     * (experimental) Fully replicated S3 Data Distribution Type.
     *
     * @experimental
     */
    FULLY_REPLICATED = "FullyReplicated",
    /**
     * (experimental) Sharded By S3 Key Data Distribution Type.
     *
     * @experimental
     */
    SHARDED_BY_S3_KEY = "ShardedByS3Key"
}
/**
 * (experimental) Define the format of the input data.
 *
 * @experimental
 */
export declare enum RecordWrapperType {
    /**
     * (experimental) None record wrapper type.
     *
     * @experimental
     */
    NONE = "None",
    /**
     * (experimental) RecordIO record wrapper type.
     *
     * @experimental
     */
    RECORD_IO = "RecordIO"
}
/**
 * (experimental) Input mode that the algorithm supports.
 *
 * @experimental
 */
export declare enum InputMode {
    /**
     * (experimental) Pipe mode.
     *
     * @experimental
     */
    PIPE = "Pipe",
    /**
     * (experimental) File mode.
     *
     * @experimental
     */
    FILE = "File"
}
/**
 * (experimental) Compression type of the data.
 *
 * @experimental
 */
export declare enum CompressionType {
    /**
     * (experimental) None compression type.
     *
     * @experimental
     */
    NONE = "None",
    /**
     * (experimental) Gzip compression type.
     *
     * @experimental
     */
    GZIP = "Gzip"
}
/**
 * (experimental) Configures the timeout and maximum number of retries for processing a transform job invocation.
 *
 * @experimental
 */
export interface ModelClientOptions {
    /**
     * (experimental) The maximum number of retries when invocation requests are failing.
     *
     * @default 0
     * @experimental
     */
    readonly invocationsMaxRetries?: number;
    /**
     * (experimental) The timeout duration for an invocation request.
     *
     * @default Duration.minutes(1)
     * @experimental
     */
    readonly invocationsTimeout?: Duration;
}
/**
 * (experimental) Dataset to be transformed and the Amazon S3 location where it is stored.
 *
 * @experimental
 */
export interface TransformInput {
    /**
     * (experimental) The compression type of the transform data.
     *
     * @default NONE
     * @experimental
     */
    readonly compressionType?: CompressionType;
    /**
     * (experimental) Multipurpose internet mail extension (MIME) type of the data.
     *
     * @default - None
     * @experimental
     */
    readonly contentType?: string;
    /**
     * (experimental) S3 location of the channel data.
     *
     * @experimental
     */
    readonly transformDataSource: TransformDataSource;
    /**
     * (experimental) Method to use to split the transform job's data files into smaller batches.
     *
     * @default NONE
     * @experimental
     */
    readonly splitType?: SplitType;
}
/**
 * (experimental) S3 location of the input data that the model can consume.
 *
 * @experimental
 */
export interface TransformDataSource {
    /**
     * (experimental) S3 location of the input data.
     *
     * @experimental
     */
    readonly s3DataSource: TransformS3DataSource;
}
/**
 * (experimental) Location of the channel data.
 *
 * @experimental
 */
export interface TransformS3DataSource {
    /**
     * (experimental) S3 Data Type.
     *
     * @default 'S3Prefix'
     * @experimental
     */
    readonly s3DataType?: S3DataType;
    /**
     * (experimental) Identifies either a key name prefix or a manifest.
     *
     * @experimental
     */
    readonly s3Uri: string;
}
/**
 * (experimental) S3 location where you want Amazon SageMaker to save the results from the transform job.
 *
 * @experimental
 */
export interface TransformOutput {
    /**
     * (experimental) MIME type used to specify the output data.
     *
     * @default - None
     * @experimental
     */
    readonly accept?: string;
    /**
     * (experimental) Defines how to assemble the results of the transform job as a single S3 object.
     *
     * @default - None
     * @experimental
     */
    readonly assembleWith?: AssembleWith;
    /**
     * (experimental) AWS KMS key that Amazon SageMaker uses to encrypt the model artifacts at rest using Amazon S3 server-side encryption.
     *
     * @default - default KMS key for Amazon S3 for your role's account.
     * @experimental
     */
    readonly encryptionKey?: kms.IKey;
    /**
     * (experimental) S3 path where you want Amazon SageMaker to store the results of the transform job.
     *
     * @experimental
     */
    readonly s3OutputPath: string;
}
/**
 * (experimental) ML compute instances for the transform job.
 *
 * @experimental
 */
export interface TransformResources {
    /**
     * (experimental) Number of ML compute instances to use in the transform job.
     *
     * @experimental
     */
    readonly instanceCount: number;
    /**
     * (experimental) ML compute instance type for the transform job.
     *
     * @experimental
     */
    readonly instanceType: ec2.InstanceType;
    /**
     * (experimental) AWS KMS key that Amazon SageMaker uses to encrypt data on the storage volume attached to the ML compute instance(s).
     *
     * @default - None
     * @experimental
     */
    readonly volumeEncryptionKey?: kms.IKey;
}
/**
 * (experimental) Properties to define a ContainerDefinition.
 *
 * @see https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_ContainerDefinition.html
 * @experimental
 */
export interface ContainerDefinitionOptions {
    /**
     * (experimental) The Amazon EC2 Container Registry (Amazon ECR) path where inference code is stored.
     *
     * @default - None
     * @experimental
     */
    readonly image?: DockerImage;
    /**
     * (experimental) The environment variables to set in the Docker container.
     *
     * @default - No variables
     * @experimental
     */
    readonly environmentVariables?: sfn.TaskInput;
    /**
     * (experimental) The name or Amazon Resource Name (ARN) of the model package to use to create the model.
     *
     * @default - None
     * @experimental
     */
    readonly modelPackageName?: string;
    /**
     * (experimental) Defines how many models the container hosts.
     *
     * @default - Mode.SINGLE_MODEL
     * @experimental
     */
    readonly mode?: Mode;
    /**
     * (experimental) This parameter is ignored for models that contain only a PrimaryContainer.
     *
     * When a ContainerDefinition is part of an inference pipeline,
     * the value of the parameter uniquely identifies the container for the purposes of logging and metrics.
     *
     * @default - None
     * @experimental
     */
    readonly containerHostName?: string;
    /**
     * (experimental) The S3 path where the model artifacts, which result from model training, are stored.
     *
     * This path must point to a single gzip compressed tar archive (.tar.gz suffix).
     * The S3 path is required for Amazon SageMaker built-in algorithms, but not if you use your own algorithms.
     *
     * @default - None
     * @experimental
     */
    readonly modelS3Location?: S3Location;
}
/**
 * (experimental) Describes the container, as part of model definition.
 *
 * @see https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_ContainerDefinition.html
 * @experimental
 */
export declare class ContainerDefinition implements IContainerDefinition {
    private readonly options;
    /**
     * @experimental
     */
    constructor(options: ContainerDefinitionOptions);
    /**
     * (experimental) Called when the ContainerDefinition type configured on Sagemaker Task.
     *
     * @experimental
     */
    bind(task: ISageMakerTask): ContainerDefinitionConfig;
}
/**
 * (experimental) Configuration of the container used to host the model.
 *
 * @see https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_ContainerDefinition.html
 * @experimental
 */
export interface IContainerDefinition {
    /**
     * (experimental) Called when the ContainerDefinition is used by a SageMaker task.
     *
     * @experimental
     */
    bind(task: ISageMakerTask): ContainerDefinitionConfig;
}
/**
 * Configuration options for the ContainerDefinition.
 *
 * @stability stable
 */
export interface ContainerDefinitionConfig {
    /**
     * Additional parameters to pass to the base task.
     *
     * @default - No additional parameters passed
     * @stability stable
     */
    readonly parameters?: {
        [key: string]: any;
    };
}
/**
 * (experimental) Specifies how many models the container hosts.
 *
 * @experimental
 */
export declare enum Mode {
    /**
     * (experimental) Container hosts a single model.
     *
     * @experimental
     */
    SINGLE_MODEL = "SingleModel",
    /**
     * (experimental) Container hosts multiple models.
     *
     * @see https://docs.aws.amazon.com/sagemaker/latest/dg/multi-model-endpoints.html
     * @experimental
     */
    MULTI_MODEL = "MultiModel"
}
/**
 * (experimental) Identifies a model that you want to host and the resources to deploy for hosting it.
 *
 * @see https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_ProductionVariant.html
 * @experimental
 */
export interface ProductionVariant {
    /**
     * (experimental) The size of the Elastic Inference (EI) instance to use for the production variant.
     *
     * @default - None
     * @experimental
     */
    readonly acceleratorType?: AcceleratorType;
    /**
     * (experimental) Number of instances to launch initially.
     *
     * @default - 1
     * @experimental
     */
    readonly initialInstanceCount?: number;
    /**
     * (experimental) Determines initial traffic distribution among all of the models that you specify in the endpoint configuration.
     *
     * @default - 1.0
     * @experimental
     */
    readonly initialVariantWeight?: number;
    /**
     * (experimental) The ML compute instance type.
     *
     * @experimental
     */
    readonly instanceType: ec2.InstanceType;
    /**
     * (experimental) The name of the production variant.
     *
     * @experimental
     */
    readonly variantName: string;
    /**
     * (experimental) The name of the model that you want to host.
     *
     * This is the name that you specified when creating the model.
     *
     * @experimental
     */
    readonly modelName: string;
}
/**
 * (experimental) The generation of Elastic Inference (EI) instance.
 *
 * @see https://docs.aws.amazon.com/sagemaker/latest/dg/ei.html
 * @experimental
 */
export declare class AcceleratorClass {
    readonly version: string;
    /**
     * (experimental) Elastic Inference accelerator 1st generation.
     *
     * @experimental
     */
    static readonly EIA1: AcceleratorClass;
    /**
     * (experimental) Elastic Inference accelerator 2nd generation.
     *
     * @experimental
     */
    static readonly EIA2: AcceleratorClass;
    /**
     * (experimental) Custom AcceleratorType.
     *
     * @param version - Elastic Inference accelerator generation.
     * @experimental
     */
    static of(version: string): AcceleratorClass;
    /**
     * @param version - Elastic Inference accelerator generation
     */
    private constructor();
}
/**
 * (experimental) The size of the Elastic Inference (EI) instance to use for the production variant.
 *
 * EI instances provide on-demand GPU computing for inference
 *
 * @see https://docs.aws.amazon.com/sagemaker/latest/dg/ei.html
 * @experimental
 */
export declare class AcceleratorType {
    private readonly instanceTypeIdentifier;
    /**
     * (experimental) AcceleratorType.
     *
     * This class takes a combination of a class and size.
     *
     * @experimental
     */
    static of(acceleratorClass: AcceleratorClass, instanceSize: ec2.InstanceSize): AcceleratorType;
    /**
     * @experimental
     */
    constructor(instanceTypeIdentifier: string);
    /**
     * (experimental) Return the accelerator type as a dotted string.
     *
     * @experimental
     */
    toString(): string;
}
/**
 * (experimental) Specifies the number of records to include in a mini-batch for an HTTP inference request.
 *
 * @experimental
 */
export declare enum BatchStrategy {
    /**
     * (experimental) Fits multiple records in a mini-batch.
     *
     * @experimental
     */
    MULTI_RECORD = "MultiRecord",
    /**
     * (experimental) Use a single record when making an invocation request.
     *
     * @experimental
     */
    SINGLE_RECORD = "SingleRecord"
}
/**
 * (experimental) Method to use to split the transform job's data files into smaller batches.
 *
 * @experimental
 */
export declare enum SplitType {
    /**
     * (experimental) Input data files are not split,.
     *
     * @experimental
     */
    NONE = "None",
    /**
     * (experimental) Split records on a newline character boundary.
     *
     * @experimental
     */
    LINE = "Line",
    /**
     * (experimental) Split using MXNet RecordIO format.
     *
     * @experimental
     */
    RECORD_IO = "RecordIO",
    /**
     * (experimental) Split using TensorFlow TFRecord format.
     *
     * @experimental
     */
    TF_RECORD = "TFRecord"
}
/**
 * (experimental) How to assemble the results of the transform job as a single S3 object.
 *
 * @experimental
 */
export declare enum AssembleWith {
    /**
     * (experimental) Concatenate the results in binary format.
     *
     * @experimental
     */
    NONE = "None",
    /**
     * (experimental) Add a newline character at the end of every transformed record.
     *
     * @experimental
     */
    LINE = "Line"
}
