import * as iam from '@aws-cdk/aws-iam';
import * as sfn from '@aws-cdk/aws-stepfunctions';
import { Duration } from '@aws-cdk/core';
import { Construct } from 'constructs';
import { EmrCreateCluster } from './emr-create-cluster';
/**
 * (experimental) Properties for EmrModifyInstanceGroupByName.
 *
 * @experimental
 */
export interface EmrModifyInstanceGroupByNameProps extends sfn.TaskStateBaseProps {
    /**
     * (experimental) The ClusterId to update.
     *
     * @experimental
     */
    readonly clusterId: string;
    /**
     * (experimental) The InstanceGroupName to update.
     *
     * @experimental
     */
    readonly instanceGroupName: string;
    /**
     * (experimental) The JSON that you want to provide to your ModifyInstanceGroup call as input.
     *
     * This uses the same syntax as the ModifyInstanceGroups API.
     *
     * @see https://docs.aws.amazon.com/emr/latest/APIReference/API_ModifyInstanceGroups.html
     * @experimental
     */
    readonly instanceGroup: EmrModifyInstanceGroupByName.InstanceGroupModifyConfigProperty;
}
/**
 * (experimental) A Step Functions Task to to modify an InstanceGroup on an EMR Cluster.
 *
 * @experimental
 */
export declare class EmrModifyInstanceGroupByName extends sfn.TaskStateBase {
    private readonly props;
    /**
     * @experimental
     */
    protected readonly taskPolicies?: iam.PolicyStatement[];
    /**
     * @experimental
     */
    protected readonly taskMetrics?: sfn.TaskMetricsConfig;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: EmrModifyInstanceGroupByNameProps);
    /**
     * @internal
     */
    protected _renderTask(): any;
}
/**
 * (experimental) A Step Functions Task to to modify an InstanceGroup on an EMR Cluster.
 *
 * @experimental
 */
export declare namespace EmrModifyInstanceGroupByName {
    /**
     * (experimental) Custom policy for requesting termination protection or termination of specific instances when shrinking an instance group.
     *
     * @see https://docs.aws.amazon.com/emr/latest/APIReference/API_InstanceResizePolicy.html
     * @experimental
     */
    interface InstanceResizePolicyProperty {
        /**
         * (experimental) Specific list of instances to be protected when shrinking an instance group.
         *
         * @default - No instances will be protected when shrinking an instance group
         * @experimental
         */
        readonly instancesToProtect?: string[];
        /**
         * (experimental) Specific list of instances to be terminated when shrinking an instance group.
         *
         * @default - No instances will be terminated when shrinking an instance group.
         * @experimental
         */
        readonly instancesToTerminate?: string[];
        /**
         * (experimental) Decommissioning timeout override for the specific list of instances to be terminated.
         *
         * @default cdk.Duration.seconds
         * @experimental
         */
        readonly instanceTerminationTimeout?: Duration;
    }
    /**
     * (experimental) Policy for customizing shrink operations.
     *
     * Allows configuration of decommissioning timeout and targeted instance shrinking.
     *
     * @see https://docs.aws.amazon.com/emr/latest/APIReference/API_ShrinkPolicy.html
     * @experimental
     */
    interface ShrinkPolicyProperty {
        /**
         * (experimental) The desired timeout for decommissioning an instance.
         *
         * Overrides the default YARN decommissioning timeout.
         *
         * @default - EMR selected default
         * @experimental
         */
        readonly decommissionTimeout?: Duration;
        /**
         * (experimental) Custom policy for requesting termination protection or termination of specific instances when shrinking an instance group.
         *
         * @default - None
         * @experimental
         */
        readonly instanceResizePolicy?: InstanceResizePolicyProperty;
    }
    /**
     * (experimental) Modify the size or configurations of an instance group.
     *
     * @see https://docs.aws.amazon.com/emr/latest/APIReference/API_InstanceGroupModifyConfig.html
     * @experimental
     */
    interface InstanceGroupModifyConfigProperty {
        /**
         * (experimental) A list of new or modified configurations to apply for an instance group.
         *
         * @default - None
         * @experimental
         */
        readonly configurations?: EmrCreateCluster.ConfigurationProperty[];
        /**
         * (experimental) The EC2 InstanceIds to terminate.
         *
         * After you terminate the instances, the instance group will not return to its original requested size.
         *
         * @default - None
         * @experimental
         */
        readonly eC2InstanceIdsToTerminate?: string[];
        /**
         * (experimental) Target size for the instance group.
         *
         * @default - None
         * @experimental
         */
        readonly instanceCount?: number;
        /**
         * (experimental) Policy for customizing shrink operations.
         *
         * @default - None
         * @see https://docs.aws.amazon.com/emr/latest/APIReference/API_ShrinkPolicy.html
         * @experimental
         */
        readonly shrinkPolicy?: ShrinkPolicyProperty;
    }
}
