The static-website module is able to deploy your pre-packaged static website content into an S3 Bucket, fronted by Cloudfront. This module uses an Origin Access Identity to ensure your Bucket can only be accessed via Cloudfront and is configured to only allow HTTPS requests by default. Custom runtime configurations can also be specified which will emit a runtime-config.json file along with your website content. Typically this includes resource Arns, Id's etc which may need to be referenced from your website. This package uses sane defaults and at a minimum only requires the path to your website assets.

Below is a conceptual view of the default architecture this module creates:

```
Cloudfront Distribution (HTTPS only) -> S3 Bucket (Private via OAI)
|_ WAF V2 ACL                                |_ index.html (+ other website files and assets)
                                             |_ runtime-config.json
```

A typical use case is to create a static website with AuthN. To accomplish this, we can leverage the UserIdentity to create the User Pool (Cognito by default) and Identity Pool. We can then pipe the respective pool id's as runtimeOptions into the StaticWebsite. After the website is deployed, these values can be interrogated from the runtime-config.json deployed alongside the website in order to perform authentication within the app using something like the [Amplify Auth API](https://docs.amplify.aws/lib/client-configuration/configuring-amplify-categories/q/platform/js/#authentication-amazon-cognito).

```java
// Example automatically generated from non-compiling source. May contain errors.
Object userIdentity = new UserIdentity(this, "UserIdentity");
StaticWebsite.Builder.create(this, "StaticWebsite")
        .websiteContentPath("<relative>/<path>/<to>/<built>/<website>")
        .runtimeOptions(Map.of(
                "jsonPayload", Map.of(
                        "region", Stack.of(this).getRegion(),
                        "identityPoolId", userIdentity.getIdentityPool().getIdentityPoolId(),
                        "userPoolId", userIdentity.getUserPool().getUserPoolId(),
                        "userPoolWebClientId", userIdentity.getUserPoolClient().getUserPoolClientId())))
        .build();
```
# API Reference <a name="API Reference" id="api-reference"></a>

## Constructs <a name="Constructs" id="Constructs"></a>

### CloudfrontWebAcl <a name="CloudfrontWebAcl" id="@aws-prototyping-sdk/static-website.CloudfrontWebAcl"></a>

This construct creates a WAFv2 Web ACL for cloudfront in the us-east-1 region (required for cloudfront) no matter the region of the parent cdk stack.

#### Initializers <a name="Initializers" id="@aws-prototyping-sdk/static-website.CloudfrontWebAcl.Initializer"></a>

```java
import software.aws.awsprototypingsdk.staticwebsite.CloudfrontWebAcl;

CloudfrontWebAcl.Builder.create(Construct scope, java.lang.String id)
//  .cidrAllowList(CidrAllowList)
//  .managedRules(java.util.List<ManagedRule>)
    .build();
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/static-website.CloudfrontWebAcl.Initializer.parameter.scope">scope</a></code> | <code>software.constructs.Construct</code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/static-website.CloudfrontWebAcl.Initializer.parameter.id">id</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/static-website.CloudfrontWebAcl.Initializer.parameter.cidrAllowList">cidrAllowList</a></code> | <code><a href="#@aws-prototyping-sdk/static-website.CidrAllowList">CidrAllowList</a></code> | List of cidr ranges to allow. |
| <code><a href="#@aws-prototyping-sdk/static-website.CloudfrontWebAcl.Initializer.parameter.managedRules">managedRules</a></code> | <code>java.util.List<<a href="#@aws-prototyping-sdk/static-website.ManagedRule">ManagedRule</a>></code> | List of managed rules to apply to the web acl. |

---

##### `scope`<sup>Required</sup> <a name="scope" id="@aws-prototyping-sdk/static-website.CloudfrontWebAcl.Initializer.parameter.scope"></a>

- *Type:* software.constructs.Construct

---

##### `id`<sup>Required</sup> <a name="id" id="@aws-prototyping-sdk/static-website.CloudfrontWebAcl.Initializer.parameter.id"></a>

- *Type:* java.lang.String

---

##### `cidrAllowList`<sup>Optional</sup> <a name="cidrAllowList" id="@aws-prototyping-sdk/static-website.CloudfrontWebAcl.Initializer.parameter.cidrAllowList"></a>

- *Type:* <a href="#@aws-prototyping-sdk/static-website.CidrAllowList">CidrAllowList</a>
- *Default:* undefined

List of cidr ranges to allow.

---

##### `managedRules`<sup>Optional</sup> <a name="managedRules" id="@aws-prototyping-sdk/static-website.CloudfrontWebAcl.Initializer.parameter.managedRules"></a>

- *Type:* java.util.List<<a href="#@aws-prototyping-sdk/static-website.ManagedRule">ManagedRule</a>>
- *Default:* [{ vendor: "AWS", name: "AWSManagedRulesCommonRuleSet" }]

List of managed rules to apply to the web acl.

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@aws-prototyping-sdk/static-website.CloudfrontWebAcl.toString">toString</a></code> | Returns a string representation of this construct. |

---

##### `toString` <a name="toString" id="@aws-prototyping-sdk/static-website.CloudfrontWebAcl.toString"></a>

```java
public java.lang.String toString()
```

Returns a string representation of this construct.

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@aws-prototyping-sdk/static-website.CloudfrontWebAcl.isConstruct">isConstruct</a></code> | Checks if `x` is a construct. |

---

##### `isConstruct` <a name="isConstruct" id="@aws-prototyping-sdk/static-website.CloudfrontWebAcl.isConstruct"></a>

```java
import software.aws.awsprototypingsdk.staticwebsite.CloudfrontWebAcl;

CloudfrontWebAcl.isConstruct(java.lang.Object x)
```

Checks if `x` is a construct.

Use this method instead of `instanceof` to properly detect `Construct`
instances, even when the construct library is symlinked.

Explanation: in JavaScript, multiple copies of the `constructs` library on
disk are seen as independent, completely different libraries. As a
consequence, the class `Construct` in each copy of the `constructs` library
is seen as a different class, and an instance of one class will not test as
`instanceof` the other class. `npm install` will not create installations
like this, but users may manually symlink construct libraries together or
use a monorepo tool: in those cases, multiple copies of the `constructs`
library can be accidentally installed, and `instanceof` will behave
unpredictably. It is safest to avoid using `instanceof`, and using
this type-testing method instead.

###### `x`<sup>Required</sup> <a name="x" id="@aws-prototyping-sdk/static-website.CloudfrontWebAcl.isConstruct.parameter.x"></a>

- *Type:* java.lang.Object

Any object.

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/static-website.CloudfrontWebAcl.property.node">node</a></code> | <code>software.constructs.Node</code> | The tree node. |
| <code><a href="#@aws-prototyping-sdk/static-website.CloudfrontWebAcl.property.webAclArn">webAclArn</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/static-website.CloudfrontWebAcl.property.webAclId">webAclId</a></code> | <code>java.lang.String</code> | *No description.* |

---

##### `node`<sup>Required</sup> <a name="node" id="@aws-prototyping-sdk/static-website.CloudfrontWebAcl.property.node"></a>

```java
public Node getNode();
```

- *Type:* software.constructs.Node

The tree node.

---

##### `webAclArn`<sup>Required</sup> <a name="webAclArn" id="@aws-prototyping-sdk/static-website.CloudfrontWebAcl.property.webAclArn"></a>

```java
public java.lang.String getWebAclArn();
```

- *Type:* java.lang.String

---

##### `webAclId`<sup>Required</sup> <a name="webAclId" id="@aws-prototyping-sdk/static-website.CloudfrontWebAcl.property.webAclId"></a>

```java
public java.lang.String getWebAclId();
```

- *Type:* java.lang.String

---


### StaticWebsite <a name="StaticWebsite" id="@aws-prototyping-sdk/static-website.StaticWebsite"></a>

Deploys a Static Website using by default a private S3 bucket as an origin and Cloudfront as the entrypoint.

This construct configures a webAcl containing rules that are generally applicable to web applications. This
provides protection against exploitation of a wide range of vulnerabilities, including some of the high risk
and commonly occurring vulnerabilities described in OWASP publications such as OWASP Top 10.

#### Initializers <a name="Initializers" id="@aws-prototyping-sdk/static-website.StaticWebsite.Initializer"></a>

```java
import software.aws.awsprototypingsdk.staticwebsite.StaticWebsite;

StaticWebsite.Builder.create(Construct scope, java.lang.String id)
    .websiteContentPath(java.lang.String)
//  .defaultWebsiteBucketEncryption(BucketEncryption)
//  .defaultWebsiteBucketEncryptionKey(Key)
//  .distributionProps(DistributionProps)
//  .runtimeOptions(RuntimeOptions)
//  .webAclProps(CloudFrontWebAclProps)
//  .websiteBucket(IBucket)
    .build();
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/static-website.StaticWebsite.Initializer.parameter.scope">scope</a></code> | <code>software.constructs.Construct</code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/static-website.StaticWebsite.Initializer.parameter.id">id</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/static-website.StaticWebsite.Initializer.parameter.websiteContentPath">websiteContentPath</a></code> | <code>java.lang.String</code> | Path to the directory containing the static website files and assets. |
| <code><a href="#@aws-prototyping-sdk/static-website.StaticWebsite.Initializer.parameter.defaultWebsiteBucketEncryption">defaultWebsiteBucketEncryption</a></code> | <code>software.amazon.awscdk.services.s3.BucketEncryption</code> | Bucket encryption to use for the default bucket. |
| <code><a href="#@aws-prototyping-sdk/static-website.StaticWebsite.Initializer.parameter.defaultWebsiteBucketEncryptionKey">defaultWebsiteBucketEncryptionKey</a></code> | <code>software.amazon.awscdk.services.kms.Key</code> | A predefined KMS customer encryption key to use for the default bucket that gets created. |
| <code><a href="#@aws-prototyping-sdk/static-website.StaticWebsite.Initializer.parameter.distributionProps">distributionProps</a></code> | <code>software.amazon.awscdk.services.cloudfront.DistributionProps</code> | Custom distribution properties. |
| <code><a href="#@aws-prototyping-sdk/static-website.StaticWebsite.Initializer.parameter.runtimeOptions">runtimeOptions</a></code> | <code><a href="#@aws-prototyping-sdk/static-website.RuntimeOptions">RuntimeOptions</a></code> | Dynamic configuration which gets resolved only during deployment. |
| <code><a href="#@aws-prototyping-sdk/static-website.StaticWebsite.Initializer.parameter.webAclProps">webAclProps</a></code> | <code><a href="#@aws-prototyping-sdk/static-website.CloudFrontWebAclProps">CloudFrontWebAclProps</a></code> | Limited configuration settings for the generated webAcl. |
| <code><a href="#@aws-prototyping-sdk/static-website.StaticWebsite.Initializer.parameter.websiteBucket">websiteBucket</a></code> | <code>software.amazon.awscdk.services.s3.IBucket</code> | Predefined bucket to deploy the website into. |

---

##### `scope`<sup>Required</sup> <a name="scope" id="@aws-prototyping-sdk/static-website.StaticWebsite.Initializer.parameter.scope"></a>

- *Type:* software.constructs.Construct

---

##### `id`<sup>Required</sup> <a name="id" id="@aws-prototyping-sdk/static-website.StaticWebsite.Initializer.parameter.id"></a>

- *Type:* java.lang.String

---

##### `websiteContentPath`<sup>Required</sup> <a name="websiteContentPath" id="@aws-prototyping-sdk/static-website.StaticWebsite.Initializer.parameter.websiteContentPath"></a>

- *Type:* java.lang.String

Path to the directory containing the static website files and assets.

This directory must contain an index.html file.

---

##### `defaultWebsiteBucketEncryption`<sup>Optional</sup> <a name="defaultWebsiteBucketEncryption" id="@aws-prototyping-sdk/static-website.StaticWebsite.Initializer.parameter.defaultWebsiteBucketEncryption"></a>

- *Type:* software.amazon.awscdk.services.s3.BucketEncryption
- *Default:* "S3MANAGED"

Bucket encryption to use for the default bucket.

Supported options are KMS or S3MANAGED.

Note: If planning to use KMS, ensure you associate a Lambda Edge function to sign requests to S3 as OAI does not currently support KMS encryption. Refer to {@link https://aws.amazon.com/blogs/networking-and-content-delivery/serving-sse-kms-encrypted-content-from-s3-using-cloudfront/}

---

##### `defaultWebsiteBucketEncryptionKey`<sup>Optional</sup> <a name="defaultWebsiteBucketEncryptionKey" id="@aws-prototyping-sdk/static-website.StaticWebsite.Initializer.parameter.defaultWebsiteBucketEncryptionKey"></a>

- *Type:* software.amazon.awscdk.services.kms.Key

A predefined KMS customer encryption key to use for the default bucket that gets created.

Note: This is only used if the websiteBucket is left undefined, otherwise all settings from the provided websiteBucket will be used.

---

##### `distributionProps`<sup>Optional</sup> <a name="distributionProps" id="@aws-prototyping-sdk/static-website.StaticWebsite.Initializer.parameter.distributionProps"></a>

- *Type:* software.amazon.awscdk.services.cloudfront.DistributionProps

Custom distribution properties.

Note: defaultBehaviour.origin is a required parameter, however it will not be used as this construct will wire it on your behalf.
You will need to pass in an instance of StaticWebsiteOrigin (NoOp) to keep the compiler happy.

---

##### `runtimeOptions`<sup>Optional</sup> <a name="runtimeOptions" id="@aws-prototyping-sdk/static-website.StaticWebsite.Initializer.parameter.runtimeOptions"></a>

- *Type:* <a href="#@aws-prototyping-sdk/static-website.RuntimeOptions">RuntimeOptions</a>

Dynamic configuration which gets resolved only during deployment.

---

##### `webAclProps`<sup>Optional</sup> <a name="webAclProps" id="@aws-prototyping-sdk/static-website.StaticWebsite.Initializer.parameter.webAclProps"></a>

- *Type:* <a href="#@aws-prototyping-sdk/static-website.CloudFrontWebAclProps">CloudFrontWebAclProps</a>

Limited configuration settings for the generated webAcl.

For more advanced settings, create your own ACL and pass in the webAclId as a param to distributionProps.

Note: If pass in your own ACL, make sure the SCOPE is CLOUDFRONT and it is created in us-east-1.

---

##### `websiteBucket`<sup>Optional</sup> <a name="websiteBucket" id="@aws-prototyping-sdk/static-website.StaticWebsite.Initializer.parameter.websiteBucket"></a>

- *Type:* software.amazon.awscdk.services.s3.IBucket

Predefined bucket to deploy the website into.

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@aws-prototyping-sdk/static-website.StaticWebsite.toString">toString</a></code> | Returns a string representation of this construct. |

---

##### `toString` <a name="toString" id="@aws-prototyping-sdk/static-website.StaticWebsite.toString"></a>

```java
public java.lang.String toString()
```

Returns a string representation of this construct.

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@aws-prototyping-sdk/static-website.StaticWebsite.isConstruct">isConstruct</a></code> | Checks if `x` is a construct. |

---

##### `isConstruct` <a name="isConstruct" id="@aws-prototyping-sdk/static-website.StaticWebsite.isConstruct"></a>

```java
import software.aws.awsprototypingsdk.staticwebsite.StaticWebsite;

StaticWebsite.isConstruct(java.lang.Object x)
```

Checks if `x` is a construct.

Use this method instead of `instanceof` to properly detect `Construct`
instances, even when the construct library is symlinked.

Explanation: in JavaScript, multiple copies of the `constructs` library on
disk are seen as independent, completely different libraries. As a
consequence, the class `Construct` in each copy of the `constructs` library
is seen as a different class, and an instance of one class will not test as
`instanceof` the other class. `npm install` will not create installations
like this, but users may manually symlink construct libraries together or
use a monorepo tool: in those cases, multiple copies of the `constructs`
library can be accidentally installed, and `instanceof` will behave
unpredictably. It is safest to avoid using `instanceof`, and using
this type-testing method instead.

###### `x`<sup>Required</sup> <a name="x" id="@aws-prototyping-sdk/static-website.StaticWebsite.isConstruct.parameter.x"></a>

- *Type:* java.lang.Object

Any object.

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/static-website.StaticWebsite.property.node">node</a></code> | <code>software.constructs.Node</code> | The tree node. |
| <code><a href="#@aws-prototyping-sdk/static-website.StaticWebsite.property.bucketDeployment">bucketDeployment</a></code> | <code>software.amazon.awscdk.services.s3.deployment.BucketDeployment</code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/static-website.StaticWebsite.property.cloudFrontDistribution">cloudFrontDistribution</a></code> | <code>software.amazon.awscdk.services.cloudfront.Distribution</code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/static-website.StaticWebsite.property.websiteBucket">websiteBucket</a></code> | <code>software.amazon.awscdk.services.s3.IBucket</code> | *No description.* |

---

##### `node`<sup>Required</sup> <a name="node" id="@aws-prototyping-sdk/static-website.StaticWebsite.property.node"></a>

```java
public Node getNode();
```

- *Type:* software.constructs.Node

The tree node.

---

##### `bucketDeployment`<sup>Required</sup> <a name="bucketDeployment" id="@aws-prototyping-sdk/static-website.StaticWebsite.property.bucketDeployment"></a>

```java
public BucketDeployment getBucketDeployment();
```

- *Type:* software.amazon.awscdk.services.s3.deployment.BucketDeployment

---

##### `cloudFrontDistribution`<sup>Required</sup> <a name="cloudFrontDistribution" id="@aws-prototyping-sdk/static-website.StaticWebsite.property.cloudFrontDistribution"></a>

```java
public Distribution getCloudFrontDistribution();
```

- *Type:* software.amazon.awscdk.services.cloudfront.Distribution

---

##### `websiteBucket`<sup>Required</sup> <a name="websiteBucket" id="@aws-prototyping-sdk/static-website.StaticWebsite.property.websiteBucket"></a>

```java
public IBucket getWebsiteBucket();
```

- *Type:* software.amazon.awscdk.services.s3.IBucket

---


## Structs <a name="Structs" id="Structs"></a>

### CidrAllowList <a name="CidrAllowList" id="@aws-prototyping-sdk/static-website.CidrAllowList"></a>

Representation of a CIDR range.

#### Initializer <a name="Initializer" id="@aws-prototyping-sdk/static-website.CidrAllowList.Initializer"></a>

```java
import software.aws.awsprototypingsdk.staticwebsite.CidrAllowList;

CidrAllowList.builder()
    .cidrRanges(java.util.List<java.lang.String>)
    .cidrType(java.lang.String)
    .build();
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/static-website.CidrAllowList.property.cidrRanges">cidrRanges</a></code> | <code>java.util.List<java.lang.String></code> | Specify an IPv4 address by using CIDR notation. |
| <code><a href="#@aws-prototyping-sdk/static-website.CidrAllowList.property.cidrType">cidrType</a></code> | <code>java.lang.String</code> | Type of CIDR range. |

---

##### `cidrRanges`<sup>Required</sup> <a name="cidrRanges" id="@aws-prototyping-sdk/static-website.CidrAllowList.property.cidrRanges"></a>

```java
public java.util.List<java.lang.String> getCidrRanges();
```

- *Type:* java.util.List<java.lang.String>

Specify an IPv4 address by using CIDR notation.

For example:
To configure AWS WAF to allow, block, or count requests that originated from the IP address 192.0.2.44, specify 192.0.2.44/32 .
To configure AWS WAF to allow, block, or count requests that originated from IP addresses from 192.0.2.0 to 192.0.2.255, specify 192.0.2.0/24 .

For more information about CIDR notation, see the Wikipedia entry Classless Inter-Domain Routing .

Specify an IPv6 address by using CIDR notation. For example:
To configure AWS WAF to allow, block, or count requests that originated from the IP address 1111:0000:0000:0000:0000:0000:0000:0111, specify 1111:0000:0000:0000:0000:0000:0000:0111/128 .
To configure AWS WAF to allow, block, or count requests that originated from IP addresses 1111:0000:0000:0000:0000:0000:0000:0000 to 1111:0000:0000:0000:ffff:ffff:ffff:ffff, specify 1111:0000:0000:0000:0000:0000:0000:0000/64 .

---

##### `cidrType`<sup>Required</sup> <a name="cidrType" id="@aws-prototyping-sdk/static-website.CidrAllowList.property.cidrType"></a>

```java
public java.lang.String getCidrType();
```

- *Type:* java.lang.String

Type of CIDR range.

---

### CloudFrontWebAclProps <a name="CloudFrontWebAclProps" id="@aws-prototyping-sdk/static-website.CloudFrontWebAclProps"></a>

Properties to configure the web acl.

#### Initializer <a name="Initializer" id="@aws-prototyping-sdk/static-website.CloudFrontWebAclProps.Initializer"></a>

```java
import software.aws.awsprototypingsdk.staticwebsite.CloudFrontWebAclProps;

CloudFrontWebAclProps.builder()
//  .cidrAllowList(CidrAllowList)
//  .managedRules(java.util.List<ManagedRule>)
    .build();
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/static-website.CloudFrontWebAclProps.property.cidrAllowList">cidrAllowList</a></code> | <code><a href="#@aws-prototyping-sdk/static-website.CidrAllowList">CidrAllowList</a></code> | List of cidr ranges to allow. |
| <code><a href="#@aws-prototyping-sdk/static-website.CloudFrontWebAclProps.property.managedRules">managedRules</a></code> | <code>java.util.List<<a href="#@aws-prototyping-sdk/static-website.ManagedRule">ManagedRule</a>></code> | List of managed rules to apply to the web acl. |

---

##### `cidrAllowList`<sup>Optional</sup> <a name="cidrAllowList" id="@aws-prototyping-sdk/static-website.CloudFrontWebAclProps.property.cidrAllowList"></a>

```java
public CidrAllowList getCidrAllowList();
```

- *Type:* <a href="#@aws-prototyping-sdk/static-website.CidrAllowList">CidrAllowList</a>
- *Default:* undefined

List of cidr ranges to allow.

---

##### `managedRules`<sup>Optional</sup> <a name="managedRules" id="@aws-prototyping-sdk/static-website.CloudFrontWebAclProps.property.managedRules"></a>

```java
public java.util.List<ManagedRule> getManagedRules();
```

- *Type:* java.util.List<<a href="#@aws-prototyping-sdk/static-website.ManagedRule">ManagedRule</a>>
- *Default:* [{ vendor: "AWS", name: "AWSManagedRulesCommonRuleSet" }]

List of managed rules to apply to the web acl.

---

### ManagedRule <a name="ManagedRule" id="@aws-prototyping-sdk/static-website.ManagedRule"></a>

Represents a WAF V2 managed rule.

#### Initializer <a name="Initializer" id="@aws-prototyping-sdk/static-website.ManagedRule.Initializer"></a>

```java
import software.aws.awsprototypingsdk.staticwebsite.ManagedRule;

ManagedRule.builder()
    .name(java.lang.String)
    .vendor(java.lang.String)
    .build();
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/static-website.ManagedRule.property.name">name</a></code> | <code>java.lang.String</code> | The name of the managed rule group. |
| <code><a href="#@aws-prototyping-sdk/static-website.ManagedRule.property.vendor">vendor</a></code> | <code>java.lang.String</code> | The name of the managed rule group vendor. |

---

##### `name`<sup>Required</sup> <a name="name" id="@aws-prototyping-sdk/static-website.ManagedRule.property.name"></a>

```java
public java.lang.String getName();
```

- *Type:* java.lang.String

The name of the managed rule group.

You use this, along with the vendor name, to identify the rule group.

---

##### `vendor`<sup>Required</sup> <a name="vendor" id="@aws-prototyping-sdk/static-website.ManagedRule.property.vendor"></a>

```java
public java.lang.String getVendor();
```

- *Type:* java.lang.String

The name of the managed rule group vendor.

You use this, along with the rule group name, to identify the rule group.

---

### RuntimeOptions <a name="RuntimeOptions" id="@aws-prototyping-sdk/static-website.RuntimeOptions"></a>

Dynamic configuration which gets resolved only during deployment.

*Example*

```java
// Example automatically generated from non-compiling source. May contain errors.
// Will store a JSON file called runtime-config.json in the root of the StaticWebsite S3 bucket containing any
// and all resolved values.
Map<String, Map<String, Object>> runtimeConfig = Map.of("jsonPayload", Map.of("bucketArn", s3Bucket.getBucketArn()));
StaticWebsite.Builder.create(scope, "StaticWebsite").websiteContentPath("path/to/website").runtimeConfig(runtimeConfig).build();
```


#### Initializer <a name="Initializer" id="@aws-prototyping-sdk/static-website.RuntimeOptions.Initializer"></a>

```java
import software.aws.awsprototypingsdk.staticwebsite.RuntimeOptions;

RuntimeOptions.builder()
    .jsonPayload(java.lang.Object)
//  .jsonFileName(java.lang.String)
    .build();
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/static-website.RuntimeOptions.property.jsonPayload">jsonPayload</a></code> | <code>java.lang.Object</code> | Arbitrary JSON payload containing runtime values to deploy. |
| <code><a href="#@aws-prototyping-sdk/static-website.RuntimeOptions.property.jsonFileName">jsonFileName</a></code> | <code>java.lang.String</code> | File name to store runtime configuration (jsonPayload). |

---

##### `jsonPayload`<sup>Required</sup> <a name="jsonPayload" id="@aws-prototyping-sdk/static-website.RuntimeOptions.property.jsonPayload"></a>

```java
public java.lang.Object getJsonPayload();
```

- *Type:* java.lang.Object

Arbitrary JSON payload containing runtime values to deploy.

Typically this contains resourceArns, etc which
are only known at deploy time.

---

*Example*

```java
// Example automatically generated from non-compiling source. May contain errors.
{userPoolId: some.userPool.userPoolId, someResourceArnsome.getResource().getArn();
}
```


##### `jsonFileName`<sup>Optional</sup> <a name="jsonFileName" id="@aws-prototyping-sdk/static-website.RuntimeOptions.property.jsonFileName"></a>

```java
public java.lang.String getJsonFileName();
```

- *Type:* java.lang.String
- *Default:* "runtime-config.json"

File name to store runtime configuration (jsonPayload).

Must follow pattern: '*.json'

---

### StaticWebsiteProps <a name="StaticWebsiteProps" id="@aws-prototyping-sdk/static-website.StaticWebsiteProps"></a>

Properties for configuring the StaticWebsite.

#### Initializer <a name="Initializer" id="@aws-prototyping-sdk/static-website.StaticWebsiteProps.Initializer"></a>

```java
import software.aws.awsprototypingsdk.staticwebsite.StaticWebsiteProps;

StaticWebsiteProps.builder()
    .websiteContentPath(java.lang.String)
//  .defaultWebsiteBucketEncryption(BucketEncryption)
//  .defaultWebsiteBucketEncryptionKey(Key)
//  .distributionProps(DistributionProps)
//  .runtimeOptions(RuntimeOptions)
//  .webAclProps(CloudFrontWebAclProps)
//  .websiteBucket(IBucket)
    .build();
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/static-website.StaticWebsiteProps.property.websiteContentPath">websiteContentPath</a></code> | <code>java.lang.String</code> | Path to the directory containing the static website files and assets. |
| <code><a href="#@aws-prototyping-sdk/static-website.StaticWebsiteProps.property.defaultWebsiteBucketEncryption">defaultWebsiteBucketEncryption</a></code> | <code>software.amazon.awscdk.services.s3.BucketEncryption</code> | Bucket encryption to use for the default bucket. |
| <code><a href="#@aws-prototyping-sdk/static-website.StaticWebsiteProps.property.defaultWebsiteBucketEncryptionKey">defaultWebsiteBucketEncryptionKey</a></code> | <code>software.amazon.awscdk.services.kms.Key</code> | A predefined KMS customer encryption key to use for the default bucket that gets created. |
| <code><a href="#@aws-prototyping-sdk/static-website.StaticWebsiteProps.property.distributionProps">distributionProps</a></code> | <code>software.amazon.awscdk.services.cloudfront.DistributionProps</code> | Custom distribution properties. |
| <code><a href="#@aws-prototyping-sdk/static-website.StaticWebsiteProps.property.runtimeOptions">runtimeOptions</a></code> | <code><a href="#@aws-prototyping-sdk/static-website.RuntimeOptions">RuntimeOptions</a></code> | Dynamic configuration which gets resolved only during deployment. |
| <code><a href="#@aws-prototyping-sdk/static-website.StaticWebsiteProps.property.webAclProps">webAclProps</a></code> | <code><a href="#@aws-prototyping-sdk/static-website.CloudFrontWebAclProps">CloudFrontWebAclProps</a></code> | Limited configuration settings for the generated webAcl. |
| <code><a href="#@aws-prototyping-sdk/static-website.StaticWebsiteProps.property.websiteBucket">websiteBucket</a></code> | <code>software.amazon.awscdk.services.s3.IBucket</code> | Predefined bucket to deploy the website into. |

---

##### `websiteContentPath`<sup>Required</sup> <a name="websiteContentPath" id="@aws-prototyping-sdk/static-website.StaticWebsiteProps.property.websiteContentPath"></a>

```java
public java.lang.String getWebsiteContentPath();
```

- *Type:* java.lang.String

Path to the directory containing the static website files and assets.

This directory must contain an index.html file.

---

##### `defaultWebsiteBucketEncryption`<sup>Optional</sup> <a name="defaultWebsiteBucketEncryption" id="@aws-prototyping-sdk/static-website.StaticWebsiteProps.property.defaultWebsiteBucketEncryption"></a>

```java
public BucketEncryption getDefaultWebsiteBucketEncryption();
```

- *Type:* software.amazon.awscdk.services.s3.BucketEncryption
- *Default:* "S3MANAGED"

Bucket encryption to use for the default bucket.

Supported options are KMS or S3MANAGED.

Note: If planning to use KMS, ensure you associate a Lambda Edge function to sign requests to S3 as OAI does not currently support KMS encryption. Refer to {@link https://aws.amazon.com/blogs/networking-and-content-delivery/serving-sse-kms-encrypted-content-from-s3-using-cloudfront/}

---

##### `defaultWebsiteBucketEncryptionKey`<sup>Optional</sup> <a name="defaultWebsiteBucketEncryptionKey" id="@aws-prototyping-sdk/static-website.StaticWebsiteProps.property.defaultWebsiteBucketEncryptionKey"></a>

```java
public Key getDefaultWebsiteBucketEncryptionKey();
```

- *Type:* software.amazon.awscdk.services.kms.Key

A predefined KMS customer encryption key to use for the default bucket that gets created.

Note: This is only used if the websiteBucket is left undefined, otherwise all settings from the provided websiteBucket will be used.

---

##### `distributionProps`<sup>Optional</sup> <a name="distributionProps" id="@aws-prototyping-sdk/static-website.StaticWebsiteProps.property.distributionProps"></a>

```java
public DistributionProps getDistributionProps();
```

- *Type:* software.amazon.awscdk.services.cloudfront.DistributionProps

Custom distribution properties.

Note: defaultBehaviour.origin is a required parameter, however it will not be used as this construct will wire it on your behalf.
You will need to pass in an instance of StaticWebsiteOrigin (NoOp) to keep the compiler happy.

---

##### `runtimeOptions`<sup>Optional</sup> <a name="runtimeOptions" id="@aws-prototyping-sdk/static-website.StaticWebsiteProps.property.runtimeOptions"></a>

```java
public RuntimeOptions getRuntimeOptions();
```

- *Type:* <a href="#@aws-prototyping-sdk/static-website.RuntimeOptions">RuntimeOptions</a>

Dynamic configuration which gets resolved only during deployment.

---

##### `webAclProps`<sup>Optional</sup> <a name="webAclProps" id="@aws-prototyping-sdk/static-website.StaticWebsiteProps.property.webAclProps"></a>

```java
public CloudFrontWebAclProps getWebAclProps();
```

- *Type:* <a href="#@aws-prototyping-sdk/static-website.CloudFrontWebAclProps">CloudFrontWebAclProps</a>

Limited configuration settings for the generated webAcl.

For more advanced settings, create your own ACL and pass in the webAclId as a param to distributionProps.

Note: If pass in your own ACL, make sure the SCOPE is CLOUDFRONT and it is created in us-east-1.

---

##### `websiteBucket`<sup>Optional</sup> <a name="websiteBucket" id="@aws-prototyping-sdk/static-website.StaticWebsiteProps.property.websiteBucket"></a>

```java
public IBucket getWebsiteBucket();
```

- *Type:* software.amazon.awscdk.services.s3.IBucket

Predefined bucket to deploy the website into.

---

## Classes <a name="Classes" id="Classes"></a>

### StaticWebsiteOrigin <a name="StaticWebsiteOrigin" id="@aws-prototyping-sdk/static-website.StaticWebsiteOrigin"></a>

- *Implements:* software.amazon.awscdk.services.cloudfront.IOrigin

If passing in distributionProps, the default behaviour.origin is a required parameter. An instance of this class can be passed in to make the compiler happy.

#### Initializers <a name="Initializers" id="@aws-prototyping-sdk/static-website.StaticWebsiteOrigin.Initializer"></a>

```java
import software.aws.awsprototypingsdk.staticwebsite.StaticWebsiteOrigin;

new StaticWebsiteOrigin();
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@aws-prototyping-sdk/static-website.StaticWebsiteOrigin.bind">bind</a></code> | The method called when a given Origin is added (for the first time) to a Distribution. |

---

##### `bind` <a name="bind" id="@aws-prototyping-sdk/static-website.StaticWebsiteOrigin.bind"></a>

```java
public OriginBindConfig bind(Construct _scope, OriginBindOptions _options)
```

The method called when a given Origin is added (for the first time) to a Distribution.

###### `_scope`<sup>Required</sup> <a name="_scope" id="@aws-prototyping-sdk/static-website.StaticWebsiteOrigin.bind.parameter._scope"></a>

- *Type:* software.constructs.Construct

---

###### `_options`<sup>Required</sup> <a name="_options" id="@aws-prototyping-sdk/static-website.StaticWebsiteOrigin.bind.parameter._options"></a>

- *Type:* software.amazon.awscdk.services.cloudfront.OriginBindOptions

---





