/*
 * Decompiled with CFR 0.152.
 */
package org.agreement_technologies.service.tools;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;

public class Graph<N, E> {
    public static final int INFINITE = 0x1FFFFFFF;
    private final ArrayList<GraphNode<N, E>> nodes = new ArrayList();
    private final HashMap<N, Integer> labels = new HashMap();
    private boolean[] visited;
    private int count;

    public int addNode(N data) {
        Integer index = this.labels.get(data);
        if (index == null) {
            GraphNode n = new GraphNode(data);
            index = this.nodes.size();
            this.nodes.add(n);
            this.labels.put(data, index);
        }
        return index;
    }

    public void addEdge(N node1, N node2, E label) {
        int n1 = this.addNode(node1);
        int n2 = this.addNode(node2);
        this.nodes.get(n1).add(n2, label);
    }

    public N getNode(int index) {
        return this.nodes.get((int)index).data;
    }

    public int numNodes() {
        return this.nodes.size();
    }

    public int numEdges() {
        int n = 0;
        for (GraphNode<N, E> gn : this.nodes) {
            n += gn.adjacents.size();
        }
        return n;
    }

    public ArrayList<Adjacent<E>> getAdjacents(int index) {
        return this.nodes.get((int)index).adjacents;
    }

    public int[] sortNodesByIndegree() {
        int[] inDegree = new int[this.nodes.size()];
        int[] res = new int[this.nodes.size()];
        for (GraphNode<N, E> n : this.nodes) {
            for (Adjacent adj : n.adjacents) {
                int n2 = adj.dst;
                inDegree[n2] = inDegree[n2] + 1;
            }
        }
        for (int i = 0; i < res.length; ++i) {
            res[i] = i;
        }
        Graph.sort(inDegree, res);
        return res;
    }

    public static void sort(int[] key, int[] values) {
        for (int i = 1; i < key.length; ++i) {
            int elem = key[i];
            int val = values[i];
            for (int pos = i; pos > 0 && elem < key[pos - 1]; --pos) {
                key[pos] = key[pos - 1];
                values[pos] = values[pos - 1];
            }
            key[pos] = elem;
            values[pos] = val;
        }
    }

    public int maxDistance(int vOrigen, int vDestino) {
        int[] distanciaMax = new int[this.nodes.size()];
        for (int i = 0; i < this.nodes.size(); ++i) {
            distanciaMax[i] = -1;
        }
        distanciaMax[vOrigen] = 0;
        ArrayDeque<Integer> q = new ArrayDeque<Integer>();
        q.add(vOrigen);
        while (!q.isEmpty()) {
            int vActual = (Integer)q.poll();
            ArrayList aux = this.nodes.get((int)vActual).adjacents;
            for (int i = 0; i < aux.size(); ++i) {
                int vSiguiente = aux.get((int)i).dst;
                if (distanciaMax[vSiguiente] > distanciaMax[vActual]) continue;
                distanciaMax[vSiguiente] = distanciaMax[vActual] + 1;
                if (distanciaMax[vSiguiente] > this.nodes.size()) {
                    return 0x1FFFFFFF;
                }
                q.add(vSiguiente);
            }
        }
        return distanciaMax[vDestino];
    }

    public int maxDistanceWithCycles(int orig, int dst) {
        this.visited = new boolean[this.nodes.size()];
        this.count = 0;
        return this.maxDistanceWithCyclesRec(orig, dst);
    }

    private int maxDistanceWithCyclesRec(int orig, int dst) {
        if (orig == dst) {
            return 0;
        }
        this.visited[orig] = true;
        ++this.count;
        if (this.count > 10000) {
            return this.maxDistance(orig, dst);
        }
        int max = 0;
        for (Adjacent actual : this.nodes.get((int)orig).adjacents) {
            if (this.visited[actual.dst]) continue;
            int dist = this.maxDistanceWithCyclesRec(actual.dst, dst);
            if (dist != 0x1FFFFFFF && ++dist > max) {
                max = dist;
            }
            this.visited[actual.dst] = false;
        }
        if (max == 0) {
            max = 0x1FFFFFFF;
        }
        return max;
    }

    public boolean isRoot(int node) {
        for (GraphNode<N, E> n : this.nodes) {
            for (Adjacent adj : n.adjacents) {
                if (adj.dst != node) continue;
                return false;
            }
        }
        return true;
    }

    public int inDegree(int node) {
        int d = 0;
        for (GraphNode<N, E> n : this.nodes) {
            for (Adjacent adj : n.adjacents) {
                if (adj.dst != node) continue;
                ++d;
            }
        }
        return d;
    }

    public int getNodeIndex(N node) {
        Integer index = this.labels.get(node);
        return index != null ? index : -1;
    }

    public int minDistance(int vOrig, int vDst) {
        int[] distanceMin = new int[this.nodes.size()];
        for (int i = 0; i < this.nodes.size(); ++i) {
            distanceMin[i] = 0x1FFFFFFF;
        }
        ArrayDeque<Integer> q = new ArrayDeque<Integer>();
        q.add(vOrig);
        distanceMin[vOrig] = 0;
        while (!q.isEmpty()) {
            int v = (Integer)q.poll();
            for (Adjacent a : this.nodes.get((int)vOrig).adjacents) {
                int w = a.dst;
                if (distanceMin[w] != 0x1FFFFFFF) continue;
                distanceMin[w] = distanceMin[v] + 1;
                q.add(w);
            }
        }
        return distanceMin[vDst];
    }

    public boolean isAcyclic() {
        int[] marks = new int[this.nodes.size()];
        for (int i = 0; i < this.nodes.size(); ++i) {
            if (marks[i] != 0 || this.isAcyclic(i, marks)) continue;
            return false;
        }
        return true;
    }

    private boolean isAcyclic(int orig, int[] marks) {
        marks[orig] = 2;
        for (Adjacent a : this.nodes.get((int)orig).adjacents) {
            if (!(marks[a.dst] == 0 ? !this.isAcyclic(a.dst, marks) : marks[a.dst] == 2)) continue;
            return false;
        }
        marks[orig] = 1;
        return true;
    }

    public void removeEdge(int orig, int dst) {
        this.nodes.get(orig).removeAdjacent(dst);
    }

    private static class GraphNode<N, E> {
        N data;
        ArrayList<Adjacent<E>> adjacents;

        public GraphNode(N data) {
            this.data = data;
            this.adjacents = new ArrayList();
        }

        public void add(int nextNode, E label) {
            Adjacent<E> a = new Adjacent<E>(nextNode, label);
            if (!this.adjacents.contains(a)) {
                this.adjacents.add(a);
            }
        }

        public void removeAdjacent(int dst) {
            for (int i = 0; i < this.adjacents.size(); ++i) {
                Adjacent<E> a = this.adjacents.get(i);
                if (a.dst != dst) continue;
                this.adjacents.remove(i);
                break;
            }
        }
    }

    public static class Adjacent<E> {
        public int dst;
        public E label;

        public Adjacent(int dst, E label) {
            this.dst = dst;
            this.label = label;
        }

        public boolean equals(Object x) {
            return this.dst == ((Adjacent)x).dst;
        }
    }
}

