/*
 * Decompiled with CFR 0.152.
 */
package org.agreement_technologies.service.map_planner;

import java.util.HashMap;
import org.agreement_technologies.common.map_planner.IPlan;
import org.agreement_technologies.service.map_planner.POPAction;
import org.agreement_technologies.service.map_planner.POPIncrementalPlan;
import org.agreement_technologies.service.map_planner.POPPrecEff;

public class StateMemoization {
    private static final int MAP_SIZE = 65537;
    private final HashEntry<Integer, POPIncrementalPlan>[] entrySet = new HashEntry[65537];
    private final int numVars;

    public StateMemoization(int numVars) {
        this.numVars = numVars;
    }

    public void add(POPIncrementalPlan p) {
        int code = this.getPlanCode(p);
        int pos = this.position(code);
        this.entrySet[pos] = new HashEntry<Integer, POPIncrementalPlan>(code, p, this.entrySet[pos]);
    }

    public IPlan search(POPIncrementalPlan p) {
        int code = this.getPlanCode(p);
        int pos = this.position(code);
        HashEntry<Integer, POPIncrementalPlan> e = this.entrySet[pos];
        while (e != null) {
            if ((Integer)e.key == code && this.equalPlans(p, (POPIncrementalPlan)e.value)) {
                return (IPlan)e.value;
            }
            e = e.next;
        }
        return null;
    }

    private boolean equalPlans(POPIncrementalPlan p1, POPIncrementalPlan p2) {
        int[] order1 = p1.linearization();
        int[] order2 = p2.linearization();
        int[] s1 = p1.computeCodeState(order1, this.numVars);
        int[] s2 = p2.computeCodeState(order2, this.numVars);
        for (int v = 0; v < this.numVars; ++v) {
            if (s2[v] == s1[v]) continue;
            return false;
        }
        return true;
    }

    private boolean equalPlans(int[] s1, POPIncrementalPlan p2) {
        int[] order2 = p2.linearization();
        int[] s2 = p2.computeCodeState(order2, this.numVars);
        for (int v = 0; v < this.numVars; ++v) {
            if (s1[v] == s2[v]) continue;
            return false;
        }
        return true;
    }

    private int position(int code) {
        int index = code % this.entrySet.length;
        if (index < 0) {
            index += this.entrySet.length;
        }
        return index;
    }

    private int getPlanCode(POPIncrementalPlan p) {
        if (p.isSolution()) {
            return 0;
        }
        int[] order = p.linearization();
        int[] state = p.computeCodeState(order, this.numVars);
        StringBuilder s = new StringBuilder(this.numVars << 2);
        for (int v = 0; v < this.numVars; ++v) {
            s.append(state[v]);
        }
        return s.toString().hashCode();
    }

    public IPlan search(POPIncrementalPlan p, POPAction a) {
        int code;
        int[] order = p.linearization();
        int[] s = p.computeCodeState(order, this.numVars);
        if (p.isSolution()) {
            code = 0;
        } else {
            for (POPPrecEff eff : a.getEffects()) {
                s[eff.getVarCode()] = eff.getValueCode();
            }
            code = this.getPlanCode(s);
        }
        int pos = this.position(code);
        HashEntry<Integer, POPIncrementalPlan> e = this.entrySet[pos];
        while (e != null) {
            if ((Integer)e.key == code && this.equalPlans(s, (POPIncrementalPlan)e.value)) {
                return (IPlan)e.value;
            }
            e = e.next;
        }
        return null;
    }

    private int getPlanCode(int[] state) {
        StringBuilder s = new StringBuilder(this.numVars << 2);
        for (int v = 0; v < this.numVars; ++v) {
            s.append(state[v]);
        }
        return s.toString().hashCode();
    }

    public void histogram() {
        int i;
        int max = 0;
        HashMap<Integer, Integer> h = new HashMap<Integer, Integer>();
        for (i = 0; i < this.entrySet.length; ++i) {
            int length = this.listLength(this.entrySet[i]);
            int value = h.containsKey(length) ? (Integer)h.get(length) : 0;
            h.put(length, ++value);
            if (length <= max) continue;
            max = length;
        }
        System.out.println("HISTOGRAM:");
        for (i = 0; i <= max; ++i) {
            if (!h.containsKey(i)) continue;
            System.out.println(i + "\t" + h.get(i));
        }
    }

    private int listLength(HashEntry<Integer, POPIncrementalPlan> hashEntry) {
        int n = 0;
        while (hashEntry != null) {
            ++n;
            hashEntry = hashEntry.next;
        }
        return n;
    }

    private static class HashEntry<K, V> {
        K key;
        V value;
        HashEntry<K, V> next;

        public HashEntry(K key, V value, HashEntry<K, V> next) {
            this.key = key;
            this.value = value;
            this.next = next;
        }
    }
}

