/*
 * Decompiled with CFR 0.152.
 */
package org.agreement_technologies.service.map_planner;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import org.agreement_technologies.common.map_communication.AgentCommunication;
import org.agreement_technologies.common.map_communication.PlanningAgentListener;
import org.agreement_technologies.common.map_grounding.Action;
import org.agreement_technologies.common.map_grounding.GroundedCond;
import org.agreement_technologies.common.map_grounding.GroundedEff;
import org.agreement_technologies.common.map_grounding.GroundedTask;
import org.agreement_technologies.common.map_grounding.GroundedVar;
import org.agreement_technologies.common.map_heuristic.Heuristic;
import org.agreement_technologies.common.map_negotiation.NegotiationFactory;
import org.agreement_technologies.common.map_planner.CausalLink;
import org.agreement_technologies.common.map_planner.Condition;
import org.agreement_technologies.common.map_planner.ExtendedPlanner;
import org.agreement_technologies.common.map_planner.OpenCondition;
import org.agreement_technologies.common.map_planner.Ordering;
import org.agreement_technologies.common.map_planner.Planner;
import org.agreement_technologies.common.map_planner.PlannerFactory;
import org.agreement_technologies.common.map_planner.Step;
import org.agreement_technologies.service.map_negotiation.NegotiationFactoryImp;
import org.agreement_technologies.service.map_planner.GlobalIndexVarValueInfo;
import org.agreement_technologies.service.map_planner.MessageContentEncodedVarsValues;
import org.agreement_technologies.service.map_planner.POP;
import org.agreement_technologies.service.map_planner.POPAction;
import org.agreement_technologies.service.map_planner.POPCausalLink;
import org.agreement_technologies.service.map_planner.POPCondition;
import org.agreement_technologies.service.map_planner.POPFunction;
import org.agreement_technologies.service.map_planner.POPMultiThread;
import org.agreement_technologies.service.map_planner.POPOpenCondition;
import org.agreement_technologies.service.map_planner.POPOrdering;
import org.agreement_technologies.service.map_planner.POPPrecEff;
import org.agreement_technologies.service.map_planner.POPSolutionCheckerCooperative;
import org.agreement_technologies.service.map_planner.POPSolutionCheckerPrivateGoals;
import org.agreement_technologies.service.map_planner.POPStep;
import org.agreement_technologies.service.map_planner.SolutionChecker;
import org.agreement_technologies.service.tools.CustomArrayList;

public class PlannerFactoryImp
extends PlannerFactory {
    public static final int EQUAL = 1;
    public static final int DISTINCT = 2;
    private ArrayList<OpenCondition> openConditions;
    private ArrayList<POPPrecEff> goals;
    private String myAgent;
    private ExtendedPlanner planner;
    private GroundedTask task;
    private ArrayList<POPPrecEff> initialState;
    private ArrayList<POPFunction> functions;
    private ArrayList<POPAction> actions;
    private Hashtable<String, POPFunction> hashVars;
    private Hashtable<String, POPPrecEff> hashPrecEffs;
    private Hashtable<String, ArrayList<InternalAction>> hashRequirers;
    private GroundedEff[] groundedInitialState;
    private int totalThreads;
    private NegotiationFactory negotiationFactory;
    private SolutionChecker solutionChecker;
    private int numGlobalVariables;
    private Hashtable<String, Integer> hashGlobalIndexesVarCode;
    private Hashtable<String, Integer> hashGlobalIndexesValueCode;
    private Hashtable<Integer, String> hashGlobalIndexesCodeVar;
    private Hashtable<Integer, String> hashGlobalIndexesCodeValue;

    public PlannerFactoryImp(GroundedTask task, AgentCommunication comm) {
        Hashtable<String, InternalCondition> hashPrecEffs = new Hashtable<String, InternalCondition>();
        ArrayList<InternalCondition> goals = new ArrayList<InternalCondition>();
        ArrayList<InternalCondition> initialState = new ArrayList<InternalCondition>();
        ArrayList<InternalOpenCondition> openConditions = new ArrayList<InternalOpenCondition>();
        ArrayList<InternalAction> actions = new ArrayList<InternalAction>();
        this.initializeParameters(task, hashPrecEffs, goals, initialState, openConditions, actions);
        this.assignGlobalIndexes(comm);
        this.translateDataToAttributes(hashPrecEffs, goals, initialState, openConditions, actions);
    }

    public int getTotalThreads() {
        return this.totalThreads;
    }

    public int getNumGlobalVariables() {
        return this.numGlobalVariables;
    }

    private void translateDataToAttributes(Hashtable<String, InternalCondition> hashPrecEffs, ArrayList<InternalCondition> goals, ArrayList<InternalCondition> initialState, ArrayList<InternalOpenCondition> openConditions, ArrayList<InternalAction> actions) {
        this.hashPrecEffs = new Hashtable(hashPrecEffs.size());
        Set<String> keys = hashPrecEffs.keySet();
        for (String string : keys) {
            InternalCondition condition = hashPrecEffs.get(string);
            POPPrecEff eff = condition.toPOPPrecEff(this);
            this.hashPrecEffs.put(eff.toKey(), eff);
        }
        this.goals = new ArrayList(goals.size());
        for (InternalCondition internalCondition : goals) {
            this.goals.add(internalCondition.toPOPPrecEff(this));
        }
        this.initialState = new ArrayList(initialState.size());
        for (InternalCondition internalCondition : initialState) {
            this.initialState.add(internalCondition.toPOPPrecEff(this));
        }
        this.openConditions = new ArrayList(openConditions.size());
        for (InternalOpenCondition internalOpenCondition : openConditions) {
            this.openConditions.add(internalOpenCondition.toPOPPrecEff(this));
        }
        this.actions = new ArrayList(actions.size());
        for (InternalAction internalAction : actions) {
            this.actions.add(internalAction.toPOPAction(this));
        }
    }

    public NegotiationFactory getNegotiationFactory() {
        return this.negotiationFactory;
    }

    public SolutionChecker getSolutionChecker() {
        return this.solutionChecker;
    }

    public ArrayList<POPAction> getActions() {
        return this.actions;
    }

    public String getAgent() {
        return this.myAgent;
    }

    public GroundedTask getGroundedTask() {
        return this.task;
    }

    private void initializeParameters(GroundedTask gTask, Hashtable<String, InternalCondition> hashPrecEffs, ArrayList<InternalCondition> goals, ArrayList<InternalCondition> initialState, ArrayList<InternalOpenCondition> openConditions, ArrayList<InternalAction> actions) {
        InternalCondition pe;
        String key;
        int i;
        this.task = gTask;
        this.myAgent = this.task.getAgentName();
        this.hashVars = new Hashtable(gTask.getVars().length);
        this.functions = new ArrayList();
        CustomArrayList<InternalCondition> effects = new CustomArrayList<InternalCondition>();
        ArrayList<GroundedCond> groundedGoals = new ArrayList<GroundedCond>();
        for (i = 0; i < gTask.getVars().length; ++i) {
            POPFunction func = new POPFunction(gTask.getVars()[i]);
            this.functions.add(func);
            this.hashVars.put(func.toKey(), func);
        }
        for (i = 0; i < gTask.getActions().size(); ++i) {
            int j;
            ArrayList<InternalCondition> precs = new ArrayList<InternalCondition>();
            ArrayList<InternalCondition> effs = new ArrayList<InternalCondition>();
            Action action = gTask.getActions().get(i);
            for (j = 0; j < action.getPrecs().length; ++j) {
                GroundedCond prec = action.getPrecs()[j];
                key = this.groundedCondToKey(prec);
                if (hashPrecEffs.get(key) == null) {
                    pe = new InternalCondition(prec, this.hashVars.get(this.groundedVarToKey(prec.getVar())), prec.getValue(), prec.getCondition());
                    hashPrecEffs.put(key, pe);
                    precs.add(pe);
                    continue;
                }
                pe = hashPrecEffs.get(key);
                precs.add(pe);
                if (pe.prec != null) continue;
                pe.prec = prec;
            }
            for (j = 0; j < action.getEffs().length; ++j) {
                GroundedEff eff = action.getEffs()[j];
                key = this.groundedEffToKey(eff);
                if (hashPrecEffs.get(key) == null) {
                    pe = new InternalCondition(gTask.createGroundedCondition(1, eff.getVar(), eff.getValue()), this.hashVars.get(this.groundedVarToKey(eff.getVar())), eff.getValue(), 1);
                    hashPrecEffs.put(key, pe);
                    effects.addNotRepeated(pe);
                    effs.add(pe);
                    continue;
                }
                pe = hashPrecEffs.get(key);
                effs.add(pe);
                effects.addNotRepeated(pe);
            }
            InternalAction act = new InternalAction(gTask.getActions().get(i), precs, effs);
            actions.add(act);
        }
        for (GroundedCond c : gTask.getGlobalGoals()) {
            groundedGoals.add(c);
        }
        for (GroundedCond c : groundedGoals) {
            key = this.groundedCondToKey(c);
            if (hashPrecEffs.get(key) == null) {
                pe = new InternalCondition(c, this.hashVars.get(this.groundedVarToKey(c.getVar())), c.getValue(), c.getCondition());
                hashPrecEffs.put(key, pe);
                openConditions.add(new InternalOpenCondition(pe, null, false));
                continue;
            }
            openConditions.add(new InternalOpenCondition(hashPrecEffs.get(key), null, false));
        }
        for (POPFunction f : this.functions) {
            if (f.getInitialTrueValue() != null) {
                key = f.toKey() + " = " + f.getInitialTrueValue();
                if (hashPrecEffs.get(key) == null) {
                    pe = new InternalCondition(gTask.createGroundedCondition(1, f.getVariable(), f.getInitialTrueValue()), f, f.getInitialTrueValue(), 1);
                    initialState.add(pe);
                    effects.addNotRepeated(pe);
                    hashPrecEffs.put(pe.toKey(), pe);
                    continue;
                }
                initialState.add(hashPrecEffs.get(key));
                continue;
            }
            boolean valueReceived = false;
            GroundedVar v = f.getVariable();
            for (String value : v.getReachableValues()) {
                if (v.getMinTime(value) != 0) continue;
                valueReceived = true;
                key = f.toKey() + " = " + value;
                if (hashPrecEffs.get(key) == null) {
                    pe = new InternalCondition(gTask.createGroundedCondition(1, f.getVariable(), value), f, value, 1);
                    initialState.add(pe);
                    effects.addNotRepeated(pe);
                    hashPrecEffs.put(pe.toKey(), pe);
                    break;
                }
                initialState.add(hashPrecEffs.get(key));
                break;
            }
            if (valueReceived) continue;
            for (i = 0; i < f.getInitialFalseValues().size(); ++i) {
                pe = new InternalCondition(gTask.createGroundedCondition(1, f.getVariable(), null), f, f.getInitialFalseValues().get(i), 2);
                initialState.add(pe);
                hashPrecEffs.put(pe.toKey(), pe);
            }
        }
        ArrayList<GroundedEff> initialStateEffs = new ArrayList<GroundedEff>();
        for (InternalCondition ppe : initialState) {
            initialStateEffs.add(this.task.createGroundedEffect(ppe.prec.getVar(), ppe.prec.getValue()));
        }
        this.groundedInitialState = new GroundedEff[initialStateEffs.size()];
        initialStateEffs.toArray(this.groundedInitialState);
        for (InternalOpenCondition oc : openConditions) {
            goals.add(oc.condition);
        }
        for (i = 0; i < effects.size(); ++i) {
            ((InternalCondition)effects.get(i)).setIndex(i);
        }
        this.hashRequirers = new Hashtable();
        for (String spe : hashPrecEffs.keySet()) {
            pe = hashPrecEffs.get(spe);
            ArrayList<InternalAction> requirers = new ArrayList<InternalAction>();
            for (InternalAction ac : actions) {
                for (InternalCondition pre : ac.precs) {
                    if (!pre.toKey().equals(pe.toKey())) continue;
                    requirers.add(ac);
                }
            }
            this.hashRequirers.put(pe.toKey(), requirers);
        }
    }

    @Override
    public int getCodeFromVarName(String var) {
        Integer code = this.hashGlobalIndexesVarCode.get(var);
        return code != null ? code : -1;
    }

    @Override
    public String getVarNameFromCode(int code) {
        return this.hashGlobalIndexesCodeVar.get(code);
    }

    @Override
    public int getCodeFromVar(GroundedVar var) {
        return this.getCodeFromVarName(var.toString());
    }

    @Override
    public int getCodeFromValue(String val) {
        Integer code = this.hashGlobalIndexesValueCode.get(val);
        return code != null ? code : -1;
    }

    @Override
    public String getValueFromCode(int code) {
        return this.hashGlobalIndexesCodeValue.get(code);
    }

    private void assignGlobalIndexes(AgentCommunication comm) {
        int globalIdVars = 0;
        int globalIdValues = 0;
        this.hashGlobalIndexesVarCode = new Hashtable();
        this.hashGlobalIndexesValueCode = new Hashtable();
        this.hashGlobalIndexesCodeVar = new Hashtable();
        this.hashGlobalIndexesCodeValue = new Hashtable();
        ArrayList<ArrayList<GlobalIndexVarValueInfo>> globalIndexesToSend = new ArrayList<ArrayList<GlobalIndexVarValueInfo>>();
        for (int iter = 0; iter < comm.getAgentList().size(); ++iter) {
            if (comm.batonAgent()) {
                for (String string : this.task.getObjects()) {
                    if (this.hashGlobalIndexesValueCode.get(string) != null) continue;
                    this.hashGlobalIndexesValueCode.put(string, globalIdValues);
                    this.hashGlobalIndexesCodeValue.put(globalIdValues, string);
                    ++globalIdValues;
                }
                for (GroundedVar groundedVar : this.task.getVars()) {
                    String name = groundedVar.toString();
                    if (this.hashGlobalIndexesVarCode.get(name) != null) continue;
                    this.hashGlobalIndexesVarCode.put(name, globalIdVars);
                    this.hashGlobalIndexesCodeVar.put(globalIdVars, name);
                    ++globalIdVars;
                }
                ArrayList<GlobalIndexVarValueInfo> vars = new ArrayList<GlobalIndexVarValueInfo>();
                ArrayList<GlobalIndexVarValueInfo> values = new ArrayList<GlobalIndexVarValueInfo>();
                for (Map.Entry entry : this.hashGlobalIndexesCodeVar.entrySet()) {
                    vars.add(new GlobalIndexVarValueInfo((Integer)entry.getKey(), (String)entry.getValue()));
                }
                for (Map.Entry entry : this.hashGlobalIndexesCodeValue.entrySet()) {
                    values.add(new GlobalIndexVarValueInfo((Integer)entry.getKey(), (String)entry.getValue()));
                }
                globalIndexesToSend.add(vars);
                globalIndexesToSend.add(values);
                comm.sendMessage(new MessageContentEncodedVarsValues(globalIndexesToSend, globalIdVars, globalIdValues), false);
            } else {
                MessageContentEncodedVarsValues msg = (MessageContentEncodedVarsValues)comm.receiveMessage(comm.getBatonAgent(), false);
                globalIdVars = msg.getCurrentGlobalIndexVars();
                globalIdValues = msg.getCurrentGlobalIndexValues();
                ArrayList<ArrayList<GlobalIndexVarValueInfo>> indexes = msg.getGlobalIndexes();
                for (GlobalIndexVarValueInfo globalIndexVarValueInfo : indexes.get(0)) {
                    if (this.hashVars.get(globalIndexVarValueInfo.getItem()) == null || this.hashGlobalIndexesVarCode.get(globalIndexVarValueInfo.getItem()) != null) continue;
                    this.hashGlobalIndexesVarCode.put(globalIndexVarValueInfo.getItem(), globalIndexVarValueInfo.getGlobalIndex());
                    this.hashGlobalIndexesCodeVar.put(globalIndexVarValueInfo.getGlobalIndex(), globalIndexVarValueInfo.getItem());
                }
                for (GlobalIndexVarValueInfo globalIndexVarValueInfo : indexes.get(1)) {
                    boolean found = false;
                    for (String s : this.task.getObjects()) {
                        if (!s.equals(globalIndexVarValueInfo.getItem())) continue;
                        found = true;
                        break;
                    }
                    if (!found || this.hashGlobalIndexesValueCode.get(globalIndexVarValueInfo.getItem()) != null) continue;
                    this.hashGlobalIndexesValueCode.put(globalIndexVarValueInfo.getItem(), globalIndexVarValueInfo.getGlobalIndex());
                    this.hashGlobalIndexesCodeValue.put(globalIndexVarValueInfo.getGlobalIndex(), globalIndexVarValueInfo.getItem());
                }
            }
            comm.passBaton();
        }
        this.numGlobalVariables = globalIdVars;
    }

    private String groundedVarToKey(GroundedVar v) {
        String res = v.getFuctionName();
        for (String s : v.getParams()) {
            res = res + " " + s;
        }
        return res;
    }

    private String groundedCondToKey(GroundedCond c) {
        String res = "(" + this.groundedVarToKey(c.getVar());
        if (c.getCondition() == 1) {
            res = res + ") = ";
        }
        if (c.getCondition() == 2) {
            res = res + ") <> ";
        }
        return res + c.getValue();
    }

    private String groundedEffToKey(GroundedEff e) {
        int n = 0;
        String res = e.getVar().getFuctionName() + "(";
        for (String s : e.getVar().getParams()) {
            if (n == 0) {
                ++n;
            } else {
                res = res + ", ";
            }
            res = res + s;
        }
        res = res + ") = ";
        res = res + e.getValue();
        return res;
    }

    @Override
    public Ordering createOrdering(int stepIndex1, int stepIndex2) {
        return new POPOrdering(stepIndex1, stepIndex2);
    }

    @Override
    public CausalLink createCausalLink(Condition condition, Step step1, Step step2) {
        POPPrecEff cond = this.condToPrecEff(condition);
        return new POPCausalLink((POPStep)step1, cond, (POPStep)step2);
    }

    private POPPrecEff condToPrecEff(Condition condition) {
        GroundedVar gv;
        String value = this.getValueFromCode(condition.getValueCode());
        String varName = this.getVarNameFromCode(condition.getVarCode());
        POPFunction f = null;
        if (varName != null && (gv = this.task.getVarByName(varName)) != null) {
            f = new POPFunction(gv);
        }
        if (value == null) {
            value = "?";
        }
        return new POPPrecEff(condition, f, value, condition.getType());
    }

    @Override
    public Step createStep(int stepIndex, String agent, String actionName, Condition[] prec, Condition[] eff) {
        ArrayList<POPPrecEff> precs = new ArrayList<POPPrecEff>();
        ArrayList<POPPrecEff> effs = new ArrayList<POPPrecEff>();
        for (Condition c : prec) {
            precs.add(this.condToPrecEff(c));
        }
        for (Condition c : eff) {
            effs.add(this.condToPrecEff(c));
        }
        POPAction a = new POPAction(actionName, precs, effs);
        return new POPStep(a, stepIndex, agent);
    }

    public void synchronizeStep(Step st) {
        int j;
        POPStep stp = (POPStep)st;
        if (stp.getAction().getPrecs() != null) {
            for (j = 0; j < stp.getAction().getPrecs().size(); ++j) {
                if (this.hashPrecEffs.get(stp.getAction().getPrecs().get(j).toKey()) != null) {
                    stp.getAction().getPrecs().set(j, this.hashPrecEffs.get(stp.getAction().getPrecs().get(j).toKey()));
                    continue;
                }
                if (this.hashVars.get(stp.getAction().getPrecs().get(j).getFunction().toKey()) == null) continue;
                stp.getAction().getPrecs().get(j).setFunction(this.hashVars.get(stp.getAction().getPrecs().get(j).getFunction().toKey()));
            }
        }
        if (stp.getAction().getEffects() != null) {
            for (j = 0; j < stp.getAction().getEffects().size(); ++j) {
                if (this.hashPrecEffs.get(stp.getAction().getEffects().get(j).toKey()) != null) {
                    stp.getAction().getEffects().set(j, this.hashPrecEffs.get(stp.getAction().getEffects().get(j).toKey()));
                    continue;
                }
                if (this.hashVars.get(stp.getAction().getEffects().get(j).getFunction().toKey()) == null) continue;
                stp.getAction().getEffects().get(j).setFunction(this.hashVars.get(stp.getAction().getEffects().get(j).getFunction().toKey()));
            }
        }
    }

    @Override
    public Planner createPlanner(GroundedTask gTask, Heuristic h, AgentCommunication comm, PlanningAgentListener agentListener, int searchType) {
        ArrayList<POPPrecEff> precs = new ArrayList<POPPrecEff>();
        for (POPPrecEff p : this.goals) {
            precs.add(p);
        }
        String[] params = new String[]{};
        Action a = this.task.createAction("Initial", params, new GroundedCond[0], this.groundedInitialState);
        POPAction pa = new POPAction(a, new ArrayList<POPPrecEff>(), this.initialState);
        POPStep initial = new POPStep(pa, 0, null);
        ArrayList<GroundedCond> goalsArray = this.task.getGlobalGoals();
        a = this.task.createAction("Final", params, goalsArray.toArray(new GroundedCond[goalsArray.size()]), new GroundedEff[0]);
        pa = new POPAction(a, precs, null);
        POPStep last = new POPStep(pa, 1, null);
        for (OpenCondition oc : this.openConditions) {
            if (oc.getStep() != null) continue;
            ((POPOpenCondition)oc).setStep(last);
        }
        this.totalThreads = Runtime.getRuntime().availableProcessors() / comm.numAgents();
        if (this.totalThreads <= 0) {
            this.totalThreads = 1;
        }
        if (agentListener != null) {
            agentListener.trace(0, "Using " + this.totalThreads + " thread(s) per agent");
        }
        this.negotiationFactory = new NegotiationFactoryImp(0);
        switch (this.negotiationFactory.getNegotiationType()) {
            case 1: {
                this.solutionChecker = new POPSolutionCheckerPrivateGoals(comm, this.task);
                break;
            }
            default: {
                this.solutionChecker = new POPSolutionCheckerCooperative();
            }
        }
        this.planner = this.totalThreads == 1 ? new POP(this, initial, last, this.openConditions, h, comm, agentListener, searchType) : new POPMultiThread(this, initial, last, this.openConditions, h, comm, agentListener, searchType);
        return this.planner;
    }

    private class InternalOpenCondition {
        InternalCondition condition;
        POPStep step;
        boolean isGoal;

        public InternalOpenCondition(InternalCondition pe, POPStep step, boolean isGoal) {
            this.condition = pe;
            this.step = step;
            this.isGoal = isGoal;
        }

        public POPOpenCondition toPOPPrecEff(PlannerFactoryImp pf) {
            POPPrecEff cond = this.condition.toPOPPrecEff(pf);
            return new POPOpenCondition(cond, this.step, this.isGoal);
        }
    }

    private class InternalAction {
        Action action;
        ArrayList<InternalCondition> precs;
        ArrayList<InternalCondition> effs;

        public InternalAction(Action action, ArrayList<InternalCondition> precs, ArrayList<InternalCondition> effs) {
            this.action = action;
            this.precs = precs;
            this.effs = effs;
        }

        public POPAction toPOPAction(PlannerFactoryImp pf) {
            ArrayList<POPPrecEff> precs = new ArrayList<POPPrecEff>(this.precs.size());
            for (InternalCondition c : this.precs) {
                precs.add(c.toPOPPrecEff(pf));
            }
            ArrayList<POPPrecEff> effs = new ArrayList<POPPrecEff>(this.effs.size());
            for (InternalCondition c : this.effs) {
                effs.add(c.toPOPPrecEff(pf));
            }
            return new POPAction(this.action, precs, effs);
        }
    }

    private static class InternalCondition {
        GroundedCond prec;
        POPFunction popFunction;
        String value;
        int condition;
        int index;

        public InternalCondition(GroundedCond prec, POPFunction popFunction, String value, int condition) {
            this.prec = prec;
            this.popFunction = popFunction;
            this.value = value;
            this.condition = condition;
            this.index = -1;
        }

        public POPPrecEff toPOPPrecEff(PlannerFactory pf) {
            POPCondition pCond = new POPCondition(this.condition, pf.getCodeFromVar(this.prec.getVar()), pf.getCodeFromValue(this.prec.getValue()));
            return new POPPrecEff(pCond, this.popFunction, this.value, this.condition);
        }

        public void setIndex(int i) {
            this.index = i;
        }

        public String toKey() {
            String res = this.prec.getCondition() == 1 ? "=" : (this.prec.getCondition() == 2 ? "<>" : "?");
            return this.prec.getVar().toString() + res + this.prec.getValue();
        }
    }
}

