/*
 * Decompiled with CFR 0.152.
 */
package org.agreement_technologies.service.map_planner;

import java.util.ArrayList;
import org.agreement_technologies.common.map_planner.CausalLink;
import org.agreement_technologies.common.map_planner.IPlan;
import org.agreement_technologies.common.map_planner.OpenCondition;
import org.agreement_technologies.common.map_planner.Ordering;
import org.agreement_technologies.common.map_planner.Step;
import org.agreement_technologies.service.map_planner.POPAction;
import org.agreement_technologies.service.map_planner.POPIncrementalPlan;
import org.agreement_technologies.service.map_planner.POPInternalPlan;
import org.agreement_technologies.service.map_planner.POPInternalSearchTree;
import org.agreement_technologies.service.map_planner.POPMatrix;
import org.agreement_technologies.service.map_planner.POPMultiThread;
import org.agreement_technologies.service.map_planner.POPStep;
import org.agreement_technologies.service.map_planner.Planner;
import org.agreement_technologies.service.map_planner.PlannerFactoryImp;
import org.agreement_technologies.service.tools.CustomArrayList;

public class POPThread
extends Planner
implements Runnable {
    private final ArrayList<POPAction> threadActions;
    private ArrayList<IPlan> threadRefinements;

    public POPThread(ArrayList<POPAction> actions, PlannerFactoryImp conf, ArrayList<OpenCondition> goals, Step initial, Step last, POPMultiThread planner) {
        super(planner.comm);
        this.parent = planner;
        this.solutionChecker = ((POPMultiThread)this.parent).getSolutionChecker();
        this.threadActions = actions;
        this.myAgent = conf.getAgent();
        this.initialStep = initial;
        this.finalStep = last;
        this.initialInternalPlan = new POPInternalPlan(null, null, null, null, goals, null, null, false, this);
        this.initialIncrementalPlan = new POPIncrementalPlan(this.initialInternalPlan, null, this);
        this.successors = new ArrayList();
        this.initialIncrementalPlan.setName(0, null);
        this.initializeArrays();
        this.matrix = new POPMatrix(20);
    }

    @Override
    public void run() {
        this.threadRefinements = this.POPForwardLoop();
    }

    public void setCurrentInternalPlan(POPInternalPlan p) {
        this.currentInternal = p;
    }

    @Override
    public ArrayList<IPlan> POPForwardLoop() {
        ArrayList<IPlan> refinements = new ArrayList<IPlan>();
        this.hashEffects = null;
        POPInternalPlan auxInternal = this.currentInternal = new POPInternalPlan(this.currentInternal, this);
        this.initialInternalPlan.setNumSteps(-1);
        this.initialInternalPlan.setNumSteps(this.antecessors.length);
        this.calculateCausalLinks(((POPMultiThread)this.parent).getBasePlan(), this.antecessors);
        this.calculateOrderings(((POPMultiThread)this.parent).getBasePlan(), this.antecessors);
        for (POPAction act : this.threadActions) {
            this.currentInternal = auxInternal;
            if (!this.internalSearchTree.isEmpty()) {
                this.internalSearchTree.getNextPlan();
            }
            this.internalSearchTree.addPlan(this.currentInternal);
            POPStep step = new POPStep(act, this.currentInternal.numSteps(), this.myAgent);
            ArrayList<IPlan> succ = this.solveAction(step);
            if (succ.size() <= 0) continue;
            for (IPlan s : succ) {
                refinements.add(s);
            }
            succ.clear();
        }
        this.restoreCausalLinks();
        this.restoreOrderings();
        return refinements;
    }

    public void initializeSearchTree(POPInternalPlan p) {
        this.internalSearchTree = new POPInternalSearchTree(p);
    }

    public void setAntecessors(POPIncrementalPlan[] ant) {
        this.antecessors = new POPIncrementalPlan[ant.length];
        for (int i = 0; i < ant.length; ++i) {
            this.antecessors[i] = ant[i];
        }
    }

    public ArrayList<IPlan> getRefinements() {
        return this.threadRefinements;
    }

    public final void initializeArrays() {
        this.totalCausalLinks = new CustomArrayList(50);
        this.totalOrderings = new CustomArrayList(50);
    }

    public void calculateCausalLinks(POPIncrementalPlan base, POPIncrementalPlan[] antecessors) {
        this.getTotalCausalLinks().clear();
        if (!base.isRoot()) {
            POPIncrementalPlan aux = base;
            while (!aux.isRoot()) {
                for (CausalLink c : aux.getCausalLinks()) {
                    this.getTotalCausalLinks().add(c);
                }
                aux = aux.getFather();
            }
        }
        this.setNumCausalLinks(this.getTotalCausalLinks().size());
        this.setModifiedCausalLinks(false);
    }

    public void calculateOrderings(POPIncrementalPlan base, POPIncrementalPlan[] antecessors) {
        this.getTotalOrderings().clear();
        if (!base.isRoot()) {
            POPIncrementalPlan aux = base;
            while (!aux.isRoot()) {
                for (Ordering o : aux.getOrderings()) {
                    this.getTotalOrderings().add(o);
                }
                aux = aux.getFather();
            }
        }
        this.setNumOrderings(this.getTotalOrderings().size());
        this.setModifiedOrderings(false);
    }

    void clearThreadActions() {
        this.threadActions.clear();
    }

    void addApplicableAction(POPAction pa) {
        this.threadActions.add(pa);
    }

    @Override
    public IPlan sendProposalsMonoagent(ArrayList<IPlan> proposals, IPlan basePlan) {
        return null;
    }

    @Override
    public void evaluatePlan(IPlan plan, ArrayList<Planner.EvaluationThread> evThreads) {
    }

    @Override
    public void setAntecessors(POPIncrementalPlan nextPlan) {
    }
}

