/*
 * Decompiled with CFR 0.152.
 */
package org.agreement_technologies.service.map_planner;

import org.agreement_technologies.common.map_planner.Condition;
import org.agreement_technologies.common.map_planner.Step;
import org.agreement_technologies.service.map_planner.POPAction;
import org.agreement_technologies.service.map_planner.POPPrecEff;

public class POPStep
implements Step {
    private final POPAction action;
    private final String agent;
    private final int index;
    private int timeStep;

    POPStep(POPAction act, int i, String ag) {
        this.action = act;
        this.agent = ag;
        this.index = i;
        this.timeStep = -1;
    }

    public POPAction getAction() {
        return this.action;
    }

    @Override
    public String getAgent() {
        return this.agent;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    public String getName() {
        return this.action.getName();
    }

    public POPPrecEff[] getPreconditions() {
        POPPrecEff[] precs = new POPPrecEff[this.getAction().getPrecs().size()];
        for (int i = 0; i < this.getAction().getPrecs().size(); ++i) {
            precs[i] = this.getAction().getPrecs().get(i);
        }
        return precs;
    }

    public POPPrecEff[] getEffects() {
        POPPrecEff[] effs = new POPPrecEff[this.getAction().getEffects().size()];
        for (int i = 0; i < this.getAction().getEffects().size(); ++i) {
            effs[i] = this.getAction().getEffects().get(i);
        }
        return effs;
    }

    public String toString() {
        String res = this.index == 0 ? "Initial" : (this.index == 1 ? "Last" : this.action.toString());
        return res;
    }

    @Override
    public int getTimeStep() {
        return this.timeStep;
    }

    @Override
    public void setTimeStep(int ts) {
        this.timeStep = ts;
    }

    @Override
    public String getActionName() {
        return this.action.getName();
    }

    @Override
    public Condition[] getPrecs() {
        return this.action.getPrecConditions();
    }

    @Override
    public Condition[] getEffs() {
        return this.action.getEffConditions();
    }
}

