/*
 * Decompiled with CFR 0.152.
 */
package org.agreement_technologies.service.map_planner;

import java.util.ArrayList;
import java.util.Hashtable;
import org.agreement_technologies.common.map_planner.IPlan;
import org.agreement_technologies.common.map_planner.POPSearchMethod;
import org.agreement_technologies.service.map_planner.POPIncrementalPlan;

public class POPSearchMethodTwoQueues
implements POPSearchMethod {
    private static final int INITIAL_SIZE = 10000;
    private IPlan[] dtgQueue = new IPlan[10000];
    private IPlan[] prefQueue = new IPlan[10000];
    private Hashtable<String, Integer> dtgPlanPosition = new Hashtable(10000);
    private Hashtable<String, Integer> prefPlanPosition = new Hashtable(10000);
    private boolean firstQueue = true;
    private int dtgSize = 0;
    private int prefSize = 0;
    private final PlanComparator dtgComparator = new DTGComparator();
    private final PlanComparator prefComparator = new PrefComparator();

    public POPSearchMethodTwoQueues(POPIncrementalPlan initialIncrementalPlan) {
        this.addToQueue(initialIncrementalPlan);
    }

    @Override
    public IPlan getNextPlan() {
        if (this.dtgSize == 0 && this.prefSize == 0) {
            return null;
        }
        if (this.dtgSize == 0 && this.firstQueue) {
            this.firstQueue = false;
        }
        if (this.prefSize == 0 && !this.firstQueue) {
            this.firstQueue = true;
        }
        IPlan min = this.firstQueue ? this.dtgQueue[1] : this.prefQueue[1];
        this.dtgSize = this.removePlan(min.getName(), this.dtgQueue, this.dtgSize, this.dtgPlanPosition, this.dtgComparator);
        this.prefSize = this.removePlan(min.getName(), this.prefQueue, this.prefSize, this.prefPlanPosition, this.prefComparator);
        this.firstQueue = !this.firstQueue;
        return min;
    }

    private int removePlan(String name, IPlan[] queue, int size, Hashtable<String, Integer> planPosition, PlanComparator comp) {
        IPlan ult;
        Integer k = planPosition.get(name);
        if (k == null) {
            return size;
        }
        IPlan plan = queue[k];
        if (comp.compare(ult = queue[size--], plan) < 0) {
            while (k > 1 && comp.compare(ult, queue[k >> 1]) < 0) {
                int parent = k >> 1;
                planPosition.put(queue[parent].getName(), k);
                queue[k.intValue()] = queue[parent];
                k = parent;
            }
            queue[k.intValue()] = ult;
            planPosition.put(ult.getName(), k);
        } else {
            queue[k.intValue()] = ult;
            planPosition.put(ult.getName(), k);
            this.sink(k, queue, size, planPosition, comp);
        }
        return size;
    }

    private void sink(int gap, IPlan[] queue, int size, Hashtable<String, Integer> planPosition, PlanComparator comp) {
        IPlan aux = queue[gap];
        int child = gap << 1;
        boolean ok = false;
        while (child <= size && !ok) {
            if (child != size && comp.compare(queue[child + 1], queue[child]) < 0) {
                ++child;
            }
            if (comp.compare(queue[child], aux) < 0) {
                planPosition.put(queue[child].getName(), gap);
                queue[gap] = queue[child];
                gap = child;
                child = gap << 1;
                continue;
            }
            ok = true;
        }
        queue[gap] = aux;
        planPosition.put(aux.getName(), gap);
    }

    @Override
    public IPlan getNextPlanResume() {
        return this.checkNextPlan();
    }

    @Override
    public IPlan checkNextPlan() {
        if (this.dtgSize == 0 && this.prefSize == 0) {
            return null;
        }
        if (this.dtgSize == 0 && this.firstQueue) {
            this.firstQueue = false;
        }
        if (this.prefSize == 0 && !this.firstQueue) {
            this.firstQueue = true;
        }
        IPlan min = this.firstQueue ? this.dtgQueue[1] : this.prefQueue[1];
        return min;
    }

    @Override
    public void addSuccessors(ArrayList<IPlan> successors) {
        for (IPlan s : successors) {
            this.addToQueue(s);
        }
    }

    @Override
    public void addPlan(IPlan plan) {
        this.addToQueue(plan);
    }

    @Override
    public boolean isEmpty() {
        return this.dtgSize > 0 || this.prefSize > 0;
    }

    @Override
    public int size() {
        return this.dtgSize + this.prefSize;
    }

    @Override
    public void addSolution(IPlan solution) {
    }

    @Override
    public IPlan removePlan(String planName) {
        IPlan plan = this.getPlanByName(planName);
        if (plan != null) {
            this.dtgSize = this.removePlan(planName, this.dtgQueue, this.dtgSize, this.dtgPlanPosition, this.dtgComparator);
            this.prefSize = this.removePlan(planName, this.prefQueue, this.prefSize, this.prefPlanPosition, this.prefComparator);
        }
        return plan;
    }

    @Override
    public IPlan[] getFirstPlans(int n) {
        return null;
    }

    @Override
    public IPlan getPlanByName(String planName) {
        IPlan plan;
        Integer pos = this.dtgPlanPosition.get(planName);
        if (pos != null) {
            plan = this.dtgQueue[pos];
        } else {
            pos = this.prefPlanPosition.get(planName);
            if (pos != null) {
                plan = this.prefQueue[pos];
            } else {
                return null;
            }
        }
        return plan;
    }

    @Override
    public int getPublicValue(IPlan p) {
        return p.getG() + 2 * p.getH();
    }

    private void addToQueue(IPlan x) {
        if (x.getName() == null) {
            throw new RuntimeException("Cannot add a plan without name");
        }
        this.dtgSize = this.addToQueue(x, this.dtgQueue, this.dtgSize, this.dtgPlanPosition, this.dtgComparator);
        if (x.getFather() != null && x.getFather().getHLan() > x.getHLan()) {
            this.prefSize = this.addToQueue(x, this.prefQueue, this.prefSize, this.prefPlanPosition, this.prefComparator);
        }
    }

    private int addToQueue(IPlan x, IPlan[] queue, int size, Hashtable<String, Integer> planPosition, PlanComparator comp) {
        int gap = ++size;
        if (size >= queue.length) {
            if (queue == this.dtgQueue) {
                this.dtgQueue = this.growQueue(queue);
                queue = this.dtgQueue;
            } else {
                this.prefQueue = this.growQueue(queue);
                queue = this.prefQueue;
            }
        }
        while (gap > 1 && comp.compare(x, queue[gap >> 1]) < 0) {
            int parent = gap >> 1;
            planPosition.put(queue[parent].getName(), gap);
            queue[gap] = queue[parent];
            gap = parent;
        }
        queue[gap] = x;
        planPosition.put(x.getName(), gap);
        return size;
    }

    private IPlan[] growQueue(IPlan[] queue) {
        IPlan[] newQueue = new IPlan[2 * queue.length];
        System.arraycopy(queue, 0, newQueue, 0, queue.length);
        return newQueue;
    }

    private class PrefComparator
    implements PlanComparator {
        private PrefComparator() {
        }

        @Override
        public int compare(IPlan p1, IPlan p2) {
            return p1.getHLan() - p2.getHLan();
        }
    }

    private class DTGComparator
    implements PlanComparator {
        private DTGComparator() {
        }

        @Override
        public int compare(IPlan p1, IPlan p2) {
            int f1 = (p1.getH() << 1) + p1.getG();
            int f2 = (p2.getH() << 1) + p2.getG();
            return f1 - f2;
        }
    }

    private static interface PlanComparator {
        public int compare(IPlan var1, IPlan var2);
    }
}

