/*
 * Decompiled with CFR 0.152.
 */
package org.agreement_technologies.service.map_planner;

import java.util.Iterator;
import org.agreement_technologies.common.map_planner.CausalLink;
import org.agreement_technologies.common.map_planner.Ordering;
import org.agreement_technologies.service.map_planner.OrderingManager;
import org.agreement_technologies.service.map_planner.POPInternalPlan;
import org.agreement_technologies.service.tools.CustomArrayList;

public class POPOrderingManagerNoMemorization
implements OrderingManager {
    private int indexT;
    private int indexF;
    private int size;
    private int[][] matrix;
    private CustomArrayList<CustomArrayList<Integer>> list;

    public POPOrderingManagerNoMemorization(int x) {
        this.matrix = new int[x][x];
        this.indexT = -1;
        this.indexF = 0;
        this.size = 0;
        this.list = new CustomArrayList(x);
        for (int i = 0; i < x; ++i) {
            this.list.insert(new CustomArrayList(x));
            for (int j = 0; j < x; ++j) {
                this.matrix[i][j] = 0;
            }
        }
    }

    public POPOrderingManagerNoMemorization() {
        this(20);
    }

    @Override
    public void rebuild(POPInternalPlan plan) {
        this.newPlan();
        this.setSize(plan.numSteps());
        if (!plan.getTotalOrderings().isEmpty()) {
            for (Ordering o : plan.getTotalOrderings()) {
                this.addOrdering(o.getIndex1(), o.getIndex2());
            }
        }
        if (!plan.getTotalCausalLinks().isEmpty()) {
            for (CausalLink l : plan.getTotalCausalLinks()) {
                this.addOrdering(l.getIndex1(), l.getIndex2());
            }
        }
    }

    @Override
    public boolean checkOrdering(int i, int j) {
        if (i >= this.matrix[0].length || j >= this.matrix[0].length) {
            this.resize();
        }
        if (i == 0 || j == 1) {
            return true;
        }
        if (i == 1 || j == 0) {
            return false;
        }
        if (i > this.size) {
            return false;
        }
        if (this.matrix[i][j] == this.indexT) {
            return true;
        }
        if (this.matrix[i][j] == this.indexF) {
            return false;
        }
        return this.findAntecessors(j, i);
    }

    private Boolean findAntecessors(int node, int target) {
        CustomArrayList<Integer> nodes = new CustomArrayList<Integer>();
        nodes.add(node);
        while (!nodes.isEmpty()) {
            int aux = (Integer)nodes.retrieve();
            if (this.matrix[target][aux] == this.indexT) {
                return true;
            }
            if (this.list.get(aux).contains(target)) {
                return true;
            }
            nodes.append(this.list.get(aux));
        }
        return false;
    }

    @Override
    public void update(POPInternalPlan p) {
        POPInternalPlan iter = p;
        this.indexF += 2;
        this.indexT += 2;
        this.size = 0;
        while (this.size == 0) {
            if (this.size == 0 && iter.getStep() != null) {
                this.resize();
                this.size = iter.getStep().getIndex() + 1;
            }
            iter = iter.getFather();
        }
        for (iter = p; iter != null; iter = iter.getFather()) {
            if (iter.getOrdering() != null) {
                this.list.get(iter.getOrdering().getIndex2()).addNotRepeated(iter.getOrdering().getIndex1());
                this.matrix[iter.getOrdering().getIndex1()][iter.getOrdering().getIndex2()] = this.indexT;
                this.matrix[iter.getOrdering().getIndex2()][iter.getOrdering().getIndex1()] = this.indexF;
            }
            if (iter.getCausalLink() == null) continue;
            this.list.get(iter.getCausalLink().getIndex2()).addNotRepeated(iter.getCausalLink().getIndex1());
            this.matrix[iter.getCausalLink().getIndex1()][iter.getCausalLink().getIndex2()] = this.indexT;
            this.matrix[iter.getCausalLink().getIndex2()][iter.getCausalLink().getIndex1()] = this.indexF;
        }
    }

    @Override
    public void removeOrdering(int i1, int i2) {
        this.matrix[i1][i2] = this.indexT - 1;
        this.matrix[i2][i1] = this.indexT - 1;
        for (int i = 0; i < this.list.get(i2).size(); ++i) {
            if (this.list.get(i2).get(i) != i1) continue;
            this.list.get(i2).removePosition(i);
        }
    }

    @Override
    public void newPlan() {
        this.indexF += 2;
        this.indexT += 2;
        for (int i = 0; i < this.list.size(); ++i) {
            this.list.get(i).clear();
        }
    }

    @Override
    public void setSize(int size) {
        if (this.size < size) {
            this.size = size;
        }
    }

    @Override
    public int getSize() {
        return this.size;
    }

    public void resize() {
        int i;
        int newSize = this.matrix.length + (this.matrix.length >> 1);
        int[][] aux = new int[newSize][newSize];
        for (i = this.matrix[0].length; i < newSize; ++i) {
            this.list.add(new CustomArrayList(newSize));
        }
        for (i = 0; i < newSize; ++i) {
            for (int j = 0; j < newSize; ++j) {
                aux[i][j] = i < this.matrix[0].length && j < this.matrix[0].length ? this.matrix[i][j] : 0;
            }
        }
        this.matrix = aux;
    }

    public void printMatrix() {
        String res = "[0]\n";
        res = res + "[1]\n";
        res = res + "[2] ";
        for (int i = 2; i < this.size; ++i) {
            for (int j = 2; j < this.size; ++j) {
                if (this.matrix[i][j] == this.indexT) {
                    res = res + "1 ";
                    continue;
                }
                if (this.matrix[i][j] != this.indexF) continue;
                res = res + "0 ";
            }
            if (i + 1 >= this.size) continue;
            res = res + "\n[" + (i + 1) + "] ";
        }
        System.out.print(res + "\n");
    }

    public String toString() {
        int i;
        String res = "[0]\n";
        res = res + "[1]\n";
        res = res + "[2] ";
        for (i = 2; i < this.size; ++i) {
            for (int j = 2; j < this.size; ++j) {
                if (this.matrix[i][j] == this.indexT) {
                    res = res + "1 ";
                    continue;
                }
                if (this.matrix[i][j] != this.indexF) continue;
                res = res + "0 ";
            }
            if (i + 1 >= this.size) continue;
            res = res + "\n[" + (i + 1) + "] ";
        }
        res = res + "\nList: \n";
        for (i = 0; i < this.size; ++i) {
            res = res + "[" + i + "]";
            Iterator i$ = this.list.get(i).iterator();
            while (i$.hasNext()) {
                int v = (Integer)i$.next();
                res = res + " -> " + v;
            }
            res = res + "\n";
        }
        return res;
    }

    @Override
    public void addOrdering(int o1, int o2) {
        if (o1 >= this.matrix[0].length || o2 >= this.matrix[0].length) {
            this.resize();
        }
        if (o1 == 11 && o2 == 21 && this.matrix[0].length == 30) {
            System.out.println();
        }
        try {
            this.list.get(o2).addNotRepeated(o1);
        }
        catch (Exception e) {
            System.out.println(o1);
            System.out.println(o2);
            System.out.println(this.matrix[0].length);
        }
        this.matrix[o1][o2] = this.indexT;
        this.matrix[o2][o1] = this.indexF;
    }

    @Override
    public void computeAccessibilityMatrix() {
    }
}

