/*
 * Decompiled with CFR 0.152.
 */
package org.agreement_technologies.service.map_planner;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.PriorityQueue;
import org.agreement_technologies.common.map_planner.OpenCondition;
import org.agreement_technologies.service.map_planner.POPOpenCondition;
import org.agreement_technologies.service.map_planner.POPOpenConditionManager;

public class POPOpenConditionManagerQueue
implements POPOpenConditionManager {
    PriorityQueue<OpenCondition> queue;
    ArrayList<OpenCondition> initialOpenConditions = new ArrayList();

    POPOpenConditionManagerQueue(Comparator<OpenCondition> comp) {
        this.queue = new PriorityQueue<OpenCondition>(30, comp);
    }

    @Override
    public POPOpenCondition getNextOpenCondition() {
        return (POPOpenCondition)this.queue.poll();
    }

    @Override
    public POPOpenCondition checkNextOpenCondition() {
        return (POPOpenCondition)this.queue.peek();
    }

    @Override
    public void addOpenConditions(ArrayList<OpenCondition> precs) {
        for (OpenCondition p : precs) {
            this.queue.add(p);
        }
    }

    @Override
    public void restoreOpenConditions() {
        this.queue.clear();
        for (OpenCondition o : this.initialOpenConditions) {
            this.queue.add(o);
        }
    }

    @Override
    public void clearOpenConditions() {
        this.queue.clear();
    }

    @Override
    public Iterator<OpenCondition> getIterator() {
        return this.queue.iterator();
    }

    @Override
    public int size() {
        return this.queue.size();
    }

    @Override
    public ArrayList<OpenCondition> getList() {
        ArrayList<OpenCondition> precs = new ArrayList<OpenCondition>(this.queue.size());
        Iterator<OpenCondition> it = this.queue.iterator();
        while (it.hasNext()) {
            precs.add((POPOpenCondition)it.next());
        }
        return precs;
    }

    @Override
    public void addInitialOpenConditions(ArrayList<OpenCondition> precs) {
        for (OpenCondition p : precs) {
            this.queue.add(p);
        }
        this.initialOpenConditions = precs;
    }

    @Override
    public void update() {
        ArrayList<POPOpenCondition> precs = new ArrayList<POPOpenCondition>();
        while (!this.queue.isEmpty()) {
            precs.add((POPOpenCondition)this.queue.poll());
        }
        this.queue.clear();
        for (POPOpenCondition p : precs) {
            this.queue.add(p);
        }
    }

    @Override
    public OpenCondition[] getOpenConditions() {
        return (OpenCondition[])this.queue.toArray();
    }
}

