/*
 * Decompiled with CFR 0.152.
 */
package org.agreement_technologies.service.map_planner;

import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.agreement_technologies.common.map_communication.AgentCommunication;
import org.agreement_technologies.common.map_communication.PlanningAgentListener;
import org.agreement_technologies.common.map_heuristic.Heuristic;
import org.agreement_technologies.common.map_planner.IPlan;
import org.agreement_technologies.common.map_planner.OpenCondition;
import org.agreement_technologies.service.map_planner.POPAction;
import org.agreement_technologies.service.map_planner.POPIncrementalPlan;
import org.agreement_technologies.service.map_planner.POPInternalPlan;
import org.agreement_technologies.service.map_planner.POPMatrix;
import org.agreement_technologies.service.map_planner.POPSearchMethodTwoQueues;
import org.agreement_technologies.service.map_planner.POPStep;
import org.agreement_technologies.service.map_planner.POPThread;
import org.agreement_technologies.service.map_planner.Planner;
import org.agreement_technologies.service.map_planner.PlannerFactoryImp;
import org.agreement_technologies.service.map_planner.StateMemoization;
import org.agreement_technologies.service.tools.CustomArrayList;

public class POPMultiThread
extends Planner {
    private final int totalThreads;
    private final ArrayList<POPThread> runnables;
    private final ArrayList<Thread> threads;
    private final boolean multithreadHeuristic;

    public POPMultiThread(PlannerFactoryImp conf, POPStep initial, POPStep last, ArrayList<OpenCondition> goals, Heuristic h, AgentCommunication comm, PlanningAgentListener agentListener, int searchType) {
        super(comm);
        this.parent = this;
        this.configuration = conf;
        this.solutionChecker = this.configuration.getSolutionChecker();
        this.agentListener = agentListener;
        this.heuristic = h;
        this.comm = comm;
        this.myAgent = conf.getAgent();
        this.setInitialStep(initial);
        this.setFinalStep(last);
        this.initialInternalPlan = new POPInternalPlan(null, null, null, null, goals, null, null, false, this);
        this.initialIncrementalPlan = new POPIncrementalPlan(this.initialInternalPlan, null, this);
        if (agentListener != null) {
            agentListener.newPlan(this.initialIncrementalPlan, this.configuration);
        }
        this.successors = new ArrayList();
        this.initialIncrementalPlan.setName(0, null);
        this.searchTree = new POPSearchMethodTwoQueues(this.initialIncrementalPlan);
        this.planSelection = this.configuration.getNegotiationFactory().getNegotiationMethod(comm, this.searchTree);
        this.totalCausalLinks = new CustomArrayList(50);
        this.totalOrderings = new CustomArrayList(50);
        this.matrix = new POPMatrix(20);
        this.memoization = new StateMemoization(this.configuration.getNumGlobalVariables());
        this.totalThreads = conf.getTotalThreads();
        this.runnables = new ArrayList(this.totalThreads);
        this.threads = new ArrayList(this.totalThreads);
        for (int i = 0; i < this.totalThreads; ++i) {
            ArrayList<POPAction> threadActions = new ArrayList<POPAction>();
            this.runnables.add(new POPThread(threadActions, conf, goals, initial, last, this));
        }
        this.multithreadHeuristic = h.supportsMultiThreading();
    }

    @Override
    public ArrayList<IPlan> POPForwardLoop() {
        int i;
        ArrayList<IPlan> refinements = new ArrayList<IPlan>();
        this.hashEffects = null;
        this.initialInternalPlan.setNumSteps(-1);
        for (POPThread t : this.runnables) {
            t.setCurrentInternalPlan(this.currentInternal);
            t.initializeSearchTree(this.initialInternalPlan);
        }
        int index = 0;
        for (POPThread r : this.runnables) {
            r.clearThreadActions();
        }
        ArrayList<POPAction> applicableActions = super.calculateApplicableActions();
        int actionsPerThread = applicableActions.size() / this.totalThreads;
        int remainder = applicableActions.size() % this.totalThreads;
        for (i = 0; i < this.totalThreads; ++i) {
            for (int j = actionsPerThread * index; j < actionsPerThread * (index + 1); ++j) {
                this.runnables.get(i).addApplicableAction(applicableActions.get(j));
            }
            ++index;
        }
        for (i = actionsPerThread * index; i < actionsPerThread * index + remainder; ++i) {
            this.runnables.get(this.runnables.size() - 1).addApplicableAction(applicableActions.get(i));
        }
        this.threads.clear();
        for (i = 0; i < this.totalThreads; ++i) {
            this.threads.add(new Thread(this.runnables.get(i)));
            this.threads.get(i).start();
        }
        for (i = 0; i < this.totalThreads; ++i) {
            try {
                this.threads.get(i).join();
                continue;
            }
            catch (InterruptedException ex) {
                Logger.getLogger(POPMultiThread.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        for (int t = 0; t < this.totalThreads; ++t) {
            refinements.addAll(this.runnables.get(t).getRefinements());
        }
        return refinements;
    }

    @Override
    public void setAntecessors(POPIncrementalPlan nextPlan) {
        super.setAntecessors(nextPlan);
        for (POPThread t : this.runnables) {
            t.setAntecessors(this.antecessors);
        }
    }

    @Override
    public IPlan sendProposalsMonoagent(ArrayList<IPlan> proposals, IPlan basePlan) {
        IPlan solution = null;
        ArrayList<Planner.EvaluationThread> evThreads = new ArrayList<Planner.EvaluationThread>();
        int i = 0;
        while (i < proposals.size()) {
            IPlan plan = proposals.get(i);
            if (plan.isSolution() || this.memoization.search((POPIncrementalPlan)plan) == null) {
                plan.setName(i, basePlan);
                this.evaluatePlan(plan, evThreads);
                if (!plan.isSolution()) {
                    this.memoization.add((POPIncrementalPlan)plan);
                } else {
                    solution = plan;
                }
                ++i;
                continue;
            }
            proposals.remove(i);
        }
        for (Planner.EvaluationThread ev : evThreads) {
            try {
                ev.join();
            }
            catch (InterruptedException e) {}
        }
        for (IPlan plan : proposals) {
            this.searchTree.addPlan(plan);
            if (this.agentListener == null) continue;
            this.agentListener.newPlan(plan, this.configuration);
        }
        return solution;
    }

    @Override
    public void evaluatePlan(IPlan plan, ArrayList<Planner.EvaluationThread> evThreads) {
        if (plan.isSolution()) {
            plan.setH(0, 0);
        } else if (this.multithreadHeuristic) {
            Planner.EvaluationThread t = new Planner.EvaluationThread(this, plan, evThreads.size());
            t.start();
            evThreads.add(t);
        } else {
            this.heuristic.evaluatePlan(plan, 0);
        }
    }
}

