/*
 * Decompiled with CFR 0.152.
 */
package org.agreement_technologies.service.map_planner;

import java.util.ArrayList;
import org.agreement_technologies.common.map_grounding.GroundedVar;

public class POPFunction {
    private final GroundedVar var;
    private final String name;
    private final ArrayList<String> params;
    private final ArrayList<String> types;
    private final String initialTrueValue;
    private final ArrayList<String> initialFalseValues;
    private final ArrayList<String> reachableValues;
    private String key = null;

    public POPFunction(GroundedVar variable) {
        int i;
        this.var = variable;
        this.name = this.var.getFuctionName();
        this.initialTrueValue = this.var.initialTrueValue();
        this.params = new ArrayList(this.var.getParams().length);
        for (i = 0; i < this.var.getParams().length; ++i) {
            this.params.add(this.var.getParams()[i]);
        }
        this.types = new ArrayList(this.var.getDomainTypes().length);
        for (i = 0; i < this.var.getDomainTypes().length; ++i) {
            this.types.add(this.var.getDomainTypes()[i]);
        }
        this.initialFalseValues = new ArrayList(this.var.initialFalseValues().length);
        for (i = 0; i < this.var.initialFalseValues().length; ++i) {
            this.initialFalseValues.add(this.var.initialFalseValues()[i]);
        }
        this.reachableValues = new ArrayList(this.var.getReachableValues().length);
        for (i = 0; i < this.var.getReachableValues().length; ++i) {
            this.reachableValues.add(this.var.getReachableValues()[i]);
        }
    }

    public GroundedVar getVariable() {
        return this.var;
    }

    public String getName() {
        return this.name;
    }

    public ArrayList<String> getParams() {
        return this.params;
    }

    public ArrayList<String> getTypes() {
        return this.types;
    }

    public String getInitialTrueValue() {
        return this.initialTrueValue;
    }

    public ArrayList<String> getInitialFalseValues() {
        return this.initialFalseValues;
    }

    public ArrayList<String> getReachableValues() {
        return this.reachableValues;
    }

    public String toKey() {
        if (this.key == null) {
            this.key = this.name;
            for (String param : this.params) {
                this.key = this.key + " " + param;
            }
        }
        return this.key;
    }

    public String toString() {
        String res = this.name;
        for (String param : this.params) {
            res = res + " " + param;
        }
        return res;
    }
}

