/*
 * Decompiled with CFR 0.152.
 */
package org.agreement_technologies.service.map_planner;

import org.agreement_technologies.common.map_grounding.GroundedCond;
import org.agreement_technologies.common.map_grounding.GroundedEff;
import org.agreement_technologies.common.map_planner.Condition;
import org.agreement_technologies.common.map_planner.PlannerFactory;
import org.agreement_technologies.service.map_planner.PlannerFactoryImp;

public class POPCondition
implements Condition {
    private final int type;
    private final int var;
    private final int value;

    public POPCondition(GroundedCond c, PlannerFactory pf) {
        this.type = c.getCondition();
        this.var = pf.getCodeFromVar(c.getVar());
        this.value = pf.getCodeFromValue(c.getValue());
    }

    public POPCondition(int type, int var, int value) {
        this.type = type;
        this.var = var;
        this.value = value;
    }

    public POPCondition(GroundedEff e, PlannerFactoryImp pf) {
        this.type = 1;
        this.var = pf.getCodeFromVar(e.getVar());
        this.value = pf.getCodeFromValue(e.getValue());
    }

    @Override
    public int getType() {
        return this.type;
    }

    @Override
    public int getVarCode() {
        return this.var;
    }

    @Override
    public int getValueCode() {
        return this.value;
    }

    @Override
    public String toKey() {
        if (this.type == 1) {
            return this.var + "=" + this.value;
        }
        return this.var + "<>" + this.value;
    }

    public String toString() {
        return this.toKey();
    }

    @Override
    public String labeled(PlannerFactory pf) {
        if (pf == null) {
            return this.toKey();
        }
        String varName = pf.getVarNameFromCode(this.var);
        String valueName = pf.getValueFromCode(this.value);
        if (varName == null) {
            varName = "" + this.var;
        }
        if (valueName == null) {
            valueName = "" + this.value;
        }
        if (this.type == 1) {
            return varName + "=" + valueName;
        }
        return varName + "<>" + valueName;
    }
}

