/*
 * Decompiled with CFR 0.152.
 */
package org.agreement_technologies.service.map_planner;

import java.util.ArrayList;
import org.agreement_technologies.common.map_grounding.Action;
import org.agreement_technologies.common.map_planner.Condition;
import org.agreement_technologies.service.map_planner.POPPrecEff;

public class POPAction {
    private String actionName;
    private ArrayList<POPPrecEff> precs;
    private ArrayList<POPPrecEff> effects;
    private Condition[] precConds;
    private Condition[] effConds;
    private boolean[] effectInVariable;

    public POPAction(String actionName, ArrayList<POPPrecEff> precs, ArrayList<POPPrecEff> effs) {
        POPPrecEff p;
        int i;
        this.actionName = actionName;
        if (precs != null) {
            this.precs = new ArrayList(precs.size());
            this.precConds = new Condition[precs.size()];
            for (i = 0; i < precs.size(); ++i) {
                p = precs.get(i);
                this.precs.add(p);
                this.precConds[i] = p.getCondition();
            }
        } else {
            this.precs = new ArrayList(0);
            this.precConds = new Condition[0];
        }
        if (effs != null) {
            this.effects = new ArrayList(effs.size());
            this.effConds = new Condition[effs.size()];
            for (i = 0; i < effs.size(); ++i) {
                POPPrecEff e = effs.get(i);
                this.effects.add(e);
                this.effConds[i] = e.getCondition();
            }
        } else {
            this.effects = new ArrayList(0);
            this.effConds = new Condition[0];
        }
        if (this.actionName.equals("Initial") || this.actionName.equals("Final")) {
            this.effectInVariable = new boolean[0];
        } else {
            this.effectInVariable = new boolean[this.precs.size()];
            for (i = 0; i < this.effectInVariable.length; ++i) {
                this.effectInVariable[i] = false;
            }
            block3: for (i = 0; i < this.precs.size(); ++i) {
                p = this.precs.get(i);
                for (POPPrecEff e : this.effects) {
                    if (e.getVarCode() != p.getVarCode()) continue;
                    this.effectInVariable[i] = true;
                    continue block3;
                }
            }
        }
    }

    public POPAction(Action act, ArrayList<POPPrecEff> precs, ArrayList<POPPrecEff> effs) {
        POPPrecEff p;
        int i;
        if (act != null) {
            this.actionName = act.getOperatorName();
            for (i = 0; i < act.getParams().length; ++i) {
                this.actionName = this.actionName + " " + act.getParams()[i];
            }
        } else {
            this.actionName = null;
        }
        if (precs != null) {
            this.precs = new ArrayList(precs.size());
            this.precConds = new Condition[precs.size()];
            for (i = 0; i < precs.size(); ++i) {
                p = precs.get(i);
                this.precs.add(p);
                this.precConds[i] = p.getCondition();
            }
        } else {
            this.precs = new ArrayList(0);
            this.precConds = new Condition[0];
        }
        if (effs != null) {
            this.effects = new ArrayList(effs.size());
            this.effConds = new Condition[effs.size()];
            for (i = 0; i < effs.size(); ++i) {
                POPPrecEff e = effs.get(i);
                this.effects.add(e);
                this.effConds[i] = e.getCondition();
            }
        } else {
            this.effects = new ArrayList(0);
            this.effConds = new Condition[0];
        }
        if (this.actionName.equals("Initial") || this.actionName.equals("Final")) {
            this.effectInVariable = new boolean[0];
        } else {
            this.effectInVariable = new boolean[this.precs.size()];
            for (i = 0; i < this.effectInVariable.length; ++i) {
                this.effectInVariable[i] = false;
            }
            block4: for (i = 0; i < this.precs.size(); ++i) {
                p = this.precs.get(i);
                for (POPPrecEff e : this.effects) {
                    if (e.getVarCode() != p.getVarCode()) continue;
                    this.effectInVariable[i] = true;
                    continue block4;
                }
            }
        }
    }

    public boolean hasEffectInVariable(int index) {
        return this.effectInVariable[index];
    }

    public String getName() {
        return this.actionName;
    }

    public ArrayList<POPPrecEff> getPrecs() {
        return this.precs;
    }

    public ArrayList<POPPrecEff> getEffects() {
        return this.effects;
    }

    public void setName(String name) {
        this.actionName = name;
    }

    public String toString() {
        return this.actionName;
    }

    public Condition[] getPrecConditions() {
        return this.precConds;
    }

    public Condition[] getEffConditions() {
        return this.effConds;
    }
}

