/*
 * Decompiled with CFR 0.152.
 */
package org.agreement_technologies.service.map_planner;

import java.io.Serializable;
import org.agreement_technologies.common.map_communication.AgentCommunication;
import org.agreement_technologies.common.map_planner.Plan;
import org.agreement_technologies.service.map_planner.POPIncrementalPlan;

public class MetricChecker {
    double bestMetric = Double.MAX_VALUE;
    private final AgentCommunication comm;

    public MetricChecker(AgentCommunication c) {
        this.comm = c;
    }

    public boolean isBestSolution(Plan solution, int type) {
        boolean isBest;
        if (type == 0) {
            return true;
        }
        double avgMetric = solution.getMetric();
        if (this.comm.batonAgent()) {
            for (int i = 0; i < this.comm.getOtherAgents().size(); ++i) {
                String agentMetric = (String)((Object)this.comm.receiveMessage(true));
                avgMetric += Double.parseDouble(agentMetric);
            }
            avgMetric /= (double)this.comm.getAgentList().size();
            this.comm.sendMessage((Serializable)((Object)Double.toString(avgMetric += ((POPIncrementalPlan)solution).computeMakespan())), true);
        } else {
            String agentMetric = Double.toString(avgMetric);
            this.comm.sendMessage(this.comm.getBatonAgent(), (Serializable)((Object)agentMetric), true);
            agentMetric = (String)((Object)this.comm.receiveMessage(this.comm.getBatonAgent(), true));
            avgMetric = Double.parseDouble(agentMetric);
        }
        boolean bl = isBest = avgMetric < this.bestMetric;
        if (isBest) {
            this.bestMetric = avgMetric;
        }
        return isBest;
    }

    public double getBestMetric() {
        return this.bestMetric;
    }
}

