/*
 * Decompiled with CFR 0.152.
 */
package org.agreement_technologies.service.map_planner;

import java.util.ArrayList;
import org.agreement_technologies.common.map_planner.CausalLink;
import org.agreement_technologies.common.map_planner.IPlan;
import org.agreement_technologies.common.map_planner.Ordering;
import org.agreement_technologies.common.map_planner.Step;
import org.agreement_technologies.service.map_planner.POPIncrementalPlan;

public class Memoization {
    private static final int MAP_SIZE = 65537;
    private final HashEntry<Integer, POPIncrementalPlan>[] entrySet = new HashEntry[65537];

    public void add(POPIncrementalPlan p) {
        int code = this.getPlanCode(p);
        int pos = this.position(code);
        this.entrySet[pos] = new HashEntry<Integer, POPIncrementalPlan>(code, p, this.entrySet[pos]);
    }

    public IPlan search(POPIncrementalPlan p) {
        int code = this.getPlanCode(p);
        int pos = this.position(code);
        HashEntry<Integer, POPIncrementalPlan> e = this.entrySet[pos];
        while (e != null) {
            if ((Integer)e.key == code && Memoization.equalPlans(p, (POPIncrementalPlan)e.value)) {
                return (IPlan)e.value;
            }
            e = e.next;
        }
        return null;
    }

    private static boolean equalPlans(POPIncrementalPlan p1, POPIncrementalPlan p2) {
        int numSteps = p1.numSteps();
        if (numSteps != p2.numSteps()) {
            return false;
        }
        ArrayList[] nextSteps1 = new ArrayList[numSteps];
        ArrayList[] nextSteps2 = new ArrayList[numSteps];
        for (int i = 0; i < numSteps; ++i) {
            nextSteps1[i] = new ArrayList();
            nextSteps2[i] = new ArrayList();
        }
        String[] stepNames1 = new String[numSteps];
        String[] stepNames2 = new String[numSteps];
        int n = numSteps;
        while (p2.getFather() != null) {
            stepNames2[--n] = p2.getStep().toString();
            for (CausalLink c : p2.getCausalLinks()) {
                if (nextSteps2[c.getIndex1()].contains(c.getIndex2())) continue;
                nextSteps2[c.getIndex1()].add(c.getIndex2());
            }
            for (Ordering o : p2.getOrderings()) {
                if (nextSteps2[o.getIndex1()].contains(o.getIndex2())) continue;
                nextSteps2[o.getIndex1()].add(o.getIndex2());
            }
            p2 = p2.getFather();
        }
        n = numSteps;
        while (p1.getFather() != null) {
            stepNames1[--n] = p1.getStep().toString();
            for (CausalLink c : p1.getCausalLinks()) {
                if (nextSteps1[c.getIndex1()].contains(c.getIndex2())) continue;
                nextSteps1[c.getIndex1()].add(c.getIndex2());
            }
            for (Ordering o : p1.getOrderings()) {
                if (nextSteps1[o.getIndex1()].contains(o.getIndex2())) continue;
                nextSteps1[o.getIndex1()].add(o.getIndex2());
            }
            p1 = p1.getFather();
        }
        boolean[] checked = new boolean[numSteps];
        return Memoization.checkStep(0, 0, stepNames1, stepNames2, nextSteps1, nextSteps2, checked);
    }

    private static boolean checkStep(int s1, int s2, String[] stepNames1, String[] stepNames2, ArrayList<Integer>[] nextSteps1, ArrayList<Integer>[] nextSteps2, boolean[] checked) {
        if (checked[s1]) {
            return true;
        }
        checked[s1] = true;
        for (int next1 : nextSteps1[s1]) {
            int next2 = -1;
            for (int aux : nextSteps2[s2]) {
                if (!stepNames1[next1].equals(stepNames2[aux])) continue;
                next2 = aux;
                break;
            }
            if (next2 != -1 && Memoization.checkStep(next1, next2, stepNames1, stepNames2, nextSteps1, nextSteps2, checked)) continue;
            return false;
        }
        return true;
    }

    private int position(int code) {
        int index = code % this.entrySet.length;
        if (index < 0) {
            index += this.entrySet.length;
        }
        return index;
    }

    private int getPlanCode(POPIncrementalPlan p) {
        int code = 0;
        while (p.getFather() != null) {
            Step s = p.getStep();
            code += s.getActionName().hashCode();
            if (s.getAgent() != null) {
                code += s.getAgent().hashCode();
            }
            p = p.getFather();
        }
        return code;
    }

    private static class HashEntry<K, V> {
        K key;
        V value;
        HashEntry<K, V> next;

        public HashEntry(K key, V value, HashEntry<K, V> next) {
            this.key = key;
            this.value = value;
            this.next = next;
        }
    }
}

