/*
 * Decompiled with CFR 0.152.
 */
package org.agreement_technologies.service.map_parser;

import org.agreement_technologies.common.map_parser.Condition;
import org.agreement_technologies.common.map_parser.CongestionFluent;
import org.agreement_technologies.common.map_parser.Fact;
import org.agreement_technologies.common.map_parser.Function;
import org.agreement_technologies.common.map_parser.NumericEffect;
import org.agreement_technologies.common.map_parser.NumericExpression;
import org.agreement_technologies.common.map_parser.Operator;
import org.agreement_technologies.common.map_parser.Parameter;
import org.agreement_technologies.common.map_parser.SharedData;

public class TaskTypes {

    public static class FactImp
    implements Fact {
        String name;
        String[] parameters;
        String[] values;
        boolean neg;

        public FactImp(String name, boolean neg) {
            this.name = name;
            this.neg = neg;
        }

        @Override
        public String getFunctionName() {
            return this.name;
        }

        @Override
        public String[] getParameters() {
            return this.parameters;
        }

        @Override
        public String[] getValues() {
            return this.values;
        }

        public String toString() {
            String res = this.neg ? "(not (= (" + this.name : "(= (" + this.name;
            for (String p : this.parameters) {
                res = res + " " + p;
            }
            res = res + ") ";
            if (this.values.length != 1) {
                res = res + "{";
            }
            for (int i = 0; i < this.values.length; ++i) {
                res = i == 0 ? res + this.values[i] : res + " " + this.values[i];
            }
            if (this.values.length != 1) {
                res = res + "}";
            }
            if (this.neg) {
                res = res + ")";
            }
            return res + ")";
        }

        @Override
        public boolean negated() {
            return this.neg;
        }
    }

    public static class SharedDataImp
    implements SharedData {
        FunctionImp fnc;
        String[] agents;

        @Override
        public Function getFunction() {
            return this.fnc;
        }

        @Override
        public String[] getAgents() {
            return this.agents;
        }

        public String toString() {
            String res = "(" + this.fnc + " -";
            for (String ag : this.agents) {
                res = res + " " + ag;
            }
            return res + ")";
        }
    }

    public static class OperatorImp
    implements Operator {
        String name;
        ParameterImp[] parameters;
        ConditionImp[] prec;
        ConditionImp[] eff;
        NumericEffectImp[] numEff;
        int preference;

        public OperatorImp(String name, int preference) {
            this.name = name;
            this.preference = preference;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public Parameter[] getParameters() {
            return this.parameters;
        }

        @Override
        public Condition[] getPrecondition() {
            return this.prec;
        }

        @Override
        public Condition[] getEffect() {
            return this.eff;
        }

        public String toString() {
            String res = "(" + this.name;
            if (this.parameters.length > 0) {
                res = res + "(";
                for (int i = 0; i < this.parameters.length; ++i) {
                    res = i == 0 ? res + this.parameters[i] : res + " " + this.parameters[i];
                }
                res = res + ")";
            }
            if (this.prec.length > 0) {
                res = res + "\n\tPrec: (and";
                for (ConditionImp c : this.prec) {
                    res = res + " " + c;
                }
                res = res + ")";
            }
            if (this.eff.length > 0) {
                res = res + "\n\tEff: (and";
                for (ConditionImp c : this.eff) {
                    res = res + " " + c;
                }
                res = res + ")";
            }
            return res;
        }

        @Override
        public int getPreferenceValue() {
            return this.preference;
        }

        @Override
        public NumericEffect[] getNumericEffects() {
            return this.numEff;
        }
    }

    public static class NumericEffectImp
    implements NumericEffect {
        int type;
        FunctionImp var;
        NumericExpressionImp exp;
        private static final String[] typeName = new String[]{"increase"};

        NumericEffectImp(int type) {
            this.type = type;
        }

        public String toString() {
            return "(" + typeName[this.type] + " " + this.var + " " + this.exp + ")";
        }

        @Override
        public int getType() {
            return this.type;
        }

        @Override
        public Function getNumericVariable() {
            return this.var;
        }

        @Override
        public NumericExpression getNumericExpression() {
            return this.exp;
        }
    }

    public static class NumericExpressionImp
    implements NumericExpression {
        int type;
        double value;
        FunctionImp var;
        NumericExpressionImp left;
        NumericExpressionImp right;

        NumericExpressionImp(int type) {
            this.type = type;
        }

        public String toString() {
            String res;
            switch (this.type) {
                case 0: {
                    res = "" + this.value;
                    break;
                }
                case 1: {
                    res = this.var.toString();
                    break;
                }
                case 6: {
                    res = "(usage)";
                    break;
                }
                case 2: {
                    res = "(+ " + this.left + " " + this.right + ")";
                    break;
                }
                case 3: {
                    res = "(- " + this.left + " " + this.right + ")";
                    break;
                }
                case 4: {
                    res = "(* " + this.left + " " + this.right + ")";
                    break;
                }
                case 5: {
                    res = "(/ " + this.left + " " + this.right + ")";
                    break;
                }
                default: {
                    res = "<error>";
                }
            }
            return res;
        }

        @Override
        public int getType() {
            return this.type;
        }

        @Override
        public double getValue() {
            return this.value;
        }

        @Override
        public Function getNumericVariable() {
            return this.var;
        }

        @Override
        public NumericExpression getLeftExp() {
            return this.left;
        }

        @Override
        public NumericExpression getRightExp() {
            return this.right;
        }

        @Override
        public CongestionFluent getCongestionFluent() {
            return null;
        }
    }

    public static class ConditionImp
    implements Condition {
        int type;
        FunctionImp fnc;
        String value;
        private static final String[] typeName = new String[]{"=", "<>", "member", "not member", "assign", "add", "del"};

        @Override
        public int getType() {
            return this.type;
        }

        @Override
        public Function getFunction() {
            return this.fnc;
        }

        @Override
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return "(" + typeName[this.type] + " " + this.fnc + " " + this.value + ")";
        }
    }

    public static class FunctionImp
    implements Function {
        String name;
        boolean multifunction;
        ParameterImp[] parameters;
        String[] domain;

        public FunctionImp(String name, boolean multifunction) {
            this.name = name;
            this.multifunction = multifunction;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public Parameter[] getParameters() {
            return this.parameters;
        }

        @Override
        public String[] getDomain() {
            return this.domain;
        }

        @Override
        public boolean isMultifunction() {
            return this.multifunction;
        }

        public String toString() {
            String res = "((" + this.name;
            for (ParameterImp p : this.parameters) {
                res = res + " " + p;
            }
            res = res + ")";
            if (this.domain.length > 0) {
                res = res + " -";
                for (String d : this.domain) {
                    res = res + " " + (String)d;
                }
            }
            if (this.multifunction) {
                res = res + "*";
            }
            return res + ")";
        }
    }

    public static class ParameterImp
    implements Parameter {
        String name;
        String[] types;

        public ParameterImp(String name) {
            this.name = name;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String[] getTypes() {
            return this.types;
        }

        public String toString() {
            String res = this.name;
            if (this.types.length > 0) {
                res = res + " -";
                for (String t : this.types) {
                    res = res + " " + t;
                }
            }
            return res;
        }
    }
}

