/*
 * Decompiled with CFR 0.152.
 */
package org.agreement_technologies.service.map_parser;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.text.ParseException;
import java.util.ArrayList;
import org.agreement_technologies.common.map_parser.AgentList;
import org.agreement_technologies.common.map_parser.PDDLParser;
import org.agreement_technologies.common.map_parser.Task;
import org.agreement_technologies.service.map_parser.AgentListImp;
import org.agreement_technologies.service.map_parser.SynAnalyzer;
import org.agreement_technologies.service.map_parser.TaskImp;

public class ParserImp
implements PDDLParser {
    public Task parseDomain(Reader source) throws ParseException, IOException {
        String content = this.readToString(source);
        SynAnalyzer syn = new SynAnalyzer(content);
        TaskImp task = new TaskImp();
        syn.openPar();
        syn.readSym(SynAnalyzer.Symbol.SS_DEFINE);
        syn.openPar();
        syn.readSym(SynAnalyzer.Symbol.SS_DOMAIN);
        task.domainName = syn.readId();
        syn.closePar();
        SynAnalyzer.Token token = syn.readSym(SynAnalyzer.Symbol.SS_OPEN_PAR, SynAnalyzer.Symbol.SS_CLOSE_PAR);
        while (token.isSym(SynAnalyzer.Symbol.SS_OPEN_PAR)) {
            syn.colon();
            token = syn.readSym(SynAnalyzer.Symbol.SS_REQUIREMENTS, SynAnalyzer.Symbol.SS_TYPES, SynAnalyzer.Symbol.SS_CONSTANTS, SynAnalyzer.Symbol.SS_PREDICATES, SynAnalyzer.Symbol.SS_FUNCTIONS, SynAnalyzer.Symbol.SS_MULTI_FUNCTIONS, SynAnalyzer.Symbol.SS_ACTION, SynAnalyzer.Symbol.SS_CONGESTION);
            switch (token.getSym()) {
                case SS_REQUIREMENTS: {
                    this.parseRequirements(syn, task);
                    break;
                }
                case SS_TYPES: {
                    this.parseTypes(syn, task);
                    break;
                }
                case SS_CONSTANTS: {
                    this.parseObjects(syn, task);
                    break;
                }
                case SS_PREDICATES: {
                    this.parsePredicates(syn, task);
                    break;
                }
                case SS_FUNCTIONS: {
                    this.parseFunctions(syn, task, false);
                    break;
                }
                case SS_MULTI_FUNCTIONS: {
                    this.parseFunctions(syn, task, true);
                    break;
                }
                case SS_ACTION: {
                    this.parseAction(syn, task);
                    break;
                }
                case SS_CONGESTION: {
                    this.parseCongestion(syn, task);
                }
            }
            token = syn.readSym(SynAnalyzer.Symbol.SS_OPEN_PAR, SynAnalyzer.Symbol.SS_CLOSE_PAR);
        }
        return task;
    }

    public Task parseDomain(File source) throws ParseException, IOException {
        return this.parseDomain(new FileReader(source));
    }

    public Task parseDomain(URL source) throws ParseException, IOException {
        return this.parseDomain(new InputStreamReader(source.openStream()));
    }

    public void parseProblem(Reader source, Task task) throws ParseException, IOException {
        String content = this.readToString(source);
        SynAnalyzer syn = new SynAnalyzer(content);
        TaskImp taskImp = (TaskImp)task;
        syn.openPar();
        syn.readSym(SynAnalyzer.Symbol.SS_DEFINE);
        syn.openPar();
        syn.readSym(SynAnalyzer.Symbol.SS_PROBLEM);
        taskImp.problemName = syn.readId();
        syn.closePar();
        SynAnalyzer.Token token = syn.readSym(SynAnalyzer.Symbol.SS_OPEN_PAR, SynAnalyzer.Symbol.SS_CLOSE_PAR);
        while (token.isSym(SynAnalyzer.Symbol.SS_OPEN_PAR)) {
            syn.colon();
            token = syn.readSym(SynAnalyzer.Symbol.SS_DOMAIN, SynAnalyzer.Symbol.SS_OBJECTS, SynAnalyzer.Symbol.SS_SHARED_DATA, SynAnalyzer.Symbol.SS_INIT, SynAnalyzer.Symbol.SS_BELIEFS, SynAnalyzer.Symbol.SS_GLOBAL_GOAL, SynAnalyzer.Symbol.SS_GOAL, SynAnalyzer.Symbol.SS_ACTION_PREF, SynAnalyzer.Symbol.SS_CONSTRAINTS, SynAnalyzer.Symbol.SS_METRIC, SynAnalyzer.Symbol.SS_BEHAVIOUR);
            switch (token.getSym()) {
                case SS_DOMAIN: {
                    String domainName = syn.readId();
                    if (!taskImp.domainName.equalsIgnoreCase(domainName)) {
                        syn.notifyError("Wrong domain name");
                    }
                    syn.closePar();
                    break;
                }
                case SS_OBJECTS: {
                    this.parseObjects(syn, taskImp);
                    break;
                }
                case SS_SHARED_DATA: {
                    this.parseSharedData(syn, taskImp);
                    break;
                }
                case SS_INIT: {
                    this.parseInit(syn, taskImp);
                    break;
                }
                case SS_BELIEFS: {
                    this.parseBeliefs(syn, taskImp);
                    break;
                }
                case SS_GOAL: 
                case SS_GLOBAL_GOAL: {
                    this.parseGoal(syn, taskImp);
                    break;
                }
                case SS_ACTION_PREF: {
                    this.parseActionPreferences(syn, taskImp);
                    break;
                }
                case SS_CONSTRAINTS: {
                    this.parsePreferences(syn, taskImp);
                    break;
                }
                case SS_METRIC: {
                    this.parseMetric(syn, taskImp);
                    break;
                }
                case SS_BEHAVIOUR: {
                    this.parseBehaviour(syn, taskImp);
                }
            }
            token = syn.readSym(SynAnalyzer.Symbol.SS_OPEN_PAR, SynAnalyzer.Symbol.SS_CLOSE_PAR);
        }
    }

    private void parseBehaviour(SynAnalyzer syn, TaskImp task) throws ParseException {
        SynAnalyzer.Token token = syn.readSym(SynAnalyzer.Symbol.SS_OPEN_PAR, SynAnalyzer.Symbol.SS_CLOSE_PAR);
        while (token.isSym(SynAnalyzer.Symbol.SS_OPEN_PAR)) {
            token = syn.readSym(SynAnalyzer.Symbol.SS_SELF_INTEREST, SynAnalyzer.Symbol.SS_METRIC_THRESHOLD);
            if (token.isSym(SynAnalyzer.Symbol.SS_SELF_INTEREST)) {
                try {
                    token = syn.readSym(SynAnalyzer.Symbol.SS_NUMBER);
                    task.selfInterest = Double.parseDouble(token.getDesc());
                    if (task.selfInterest < 0.0 || task.selfInterest > 1.0) {
                        syn.notifyError("Self-interest level must be defined bewteen 0 and 1");
                    }
                }
                catch (NumberFormatException e) {
                    syn.notifyError("Invalid number format for self-interest level: " + token.getDesc());
                }
            } else if (token.isSym(SynAnalyzer.Symbol.SS_METRIC_THRESHOLD)) {
                try {
                    token = syn.readSym(SynAnalyzer.Symbol.SS_NUMBER);
                    task.metricThreshold = Double.parseDouble(token.getDesc());
                }
                catch (NumberFormatException e) {
                    syn.notifyError("Invalid number format for metric threshold: " + token.getDesc());
                }
            }
            syn.closePar();
            token = syn.readSym(SynAnalyzer.Symbol.SS_OPEN_PAR, SynAnalyzer.Symbol.SS_CLOSE_PAR);
        }
    }

    private void parseMetric(SynAnalyzer syn, TaskImp task) throws ParseException {
        syn.readSym(SynAnalyzer.Symbol.SS_MINIMIZE);
        SynAnalyzer.Token token = syn.readSym(SynAnalyzer.Symbol.SS_OPEN_PAR, SynAnalyzer.Symbol.SS_CLOSE_PAR, SynAnalyzer.Symbol.SS_TOTAL_TIME);
        if (token.isSym(SynAnalyzer.Symbol.SS_TOTAL_TIME)) {
            syn.restoreLastToken();
            task.metric = this.parseMetricTerm(syn, task);
        } else {
            while (token.isSym(SynAnalyzer.Symbol.SS_OPEN_PAR)) {
                task.metric = this.parseMetricTerm(syn, task);
                token = syn.readSym(SynAnalyzer.Symbol.SS_OPEN_PAR, SynAnalyzer.Symbol.SS_CLOSE_PAR);
            }
        }
    }

    private TaskImp.MetricImp parseMetricTerm(SynAnalyzer syn, TaskImp task) throws ParseException {
        TaskImp.MetricImp m = null;
        SynAnalyzer.Token token = syn.readSym(SynAnalyzer.Symbol.SS_IS_VIOLATED, SynAnalyzer.Symbol.SS_PLUS, SynAnalyzer.Symbol.SS_MULT, SynAnalyzer.Symbol.SS_TOTAL_TIME);
        if (token.isSym(SynAnalyzer.Symbol.SS_IS_VIOLATED)) {
            TaskImp taskImp = task;
            taskImp.getClass();
            m = new TaskImp.MetricImp(taskImp, syn.readId(), syn);
            syn.closePar();
        } else if (token.isSym(SynAnalyzer.Symbol.SS_TOTAL_TIME)) {
            m = new TaskImp.MetricImp(task);
            syn.closePar();
        } else {
            TaskImp taskImp = task;
            taskImp.getClass();
            m = new TaskImp.MetricImp(taskImp, token.getSym());
            token = syn.readSym(SynAnalyzer.Symbol.SS_OPEN_PAR, SynAnalyzer.Symbol.SS_CLOSE_PAR, SynAnalyzer.Symbol.SS_NUMBER);
            while (!token.isSym(SynAnalyzer.Symbol.SS_CLOSE_PAR)) {
                if (token.isSym(SynAnalyzer.Symbol.SS_OPEN_PAR)) {
                    m.term.add(this.parseMetricTerm(syn, task));
                } else {
                    try {
                        ArrayList<TaskImp.MetricImp> arrayList = m.term;
                        TaskImp taskImp2 = task;
                        taskImp2.getClass();
                        arrayList.add(new TaskImp.MetricImp(taskImp2, Double.parseDouble(token.getDesc())));
                    }
                    catch (NumberFormatException e) {
                        syn.notifyError("Invalid number format in metric: " + token.getDesc());
                    }
                }
                token = syn.readSym(SynAnalyzer.Symbol.SS_OPEN_PAR, SynAnalyzer.Symbol.SS_CLOSE_PAR, SynAnalyzer.Symbol.SS_NUMBER);
            }
        }
        return m;
    }

    private void parsePreferences(SynAnalyzer syn, TaskImp task) throws ParseException {
        syn.openPar();
        SynAnalyzer.Token token = syn.readSym(SynAnalyzer.Symbol.SS_AND, SynAnalyzer.Symbol.SS_PREFERENCE);
        if (token.isSym(SynAnalyzer.Symbol.SS_AND)) {
            do {
                if (!(token = syn.readSym(SynAnalyzer.Symbol.SS_OPEN_PAR, SynAnalyzer.Symbol.SS_CLOSE_PAR)).isSym(SynAnalyzer.Symbol.SS_OPEN_PAR)) continue;
                syn.readSym(SynAnalyzer.Symbol.SS_PREFERENCE);
                String name = syn.readId();
                TaskImp.Assignment a = this.parseAssignment(syn, task, true);
                task.addPreference(name, a, syn);
                syn.closePar();
            } while (!token.isSym(SynAnalyzer.Symbol.SS_CLOSE_PAR));
            syn.closePar();
        } else {
            String name = syn.readId();
            TaskImp.Assignment a = this.parseAssignment(syn, task, false);
            task.addPreference(name, a, syn);
            syn.closePar();
        }
    }

    public void parseProblem(File source, Task task) throws ParseException, IOException {
        this.parseProblem(new FileReader(source), task);
    }

    public void parseProblem(URL source, Task task) throws ParseException, IOException {
        this.parseProblem(new InputStreamReader(source.openStream()), task);
    }

    private String readToString(Reader source) throws IOException {
        StringBuffer buf = new StringBuffer();
        try {
            int c22 = source.read();
            while (c22 != -1) {
                buf.append((char)c22);
                c22 = source.read();
            }
            String c22 = buf.toString();
            return c22;
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            try {
                source.close();
            }
            catch (Exception e) {}
        }
    }

    private void parseRequirements(SynAnalyzer syn, TaskImp task) throws ParseException {
        SynAnalyzer.Token token;
        do {
            if (!(token = syn.readSym(SynAnalyzer.Symbol.SS_COLON, SynAnalyzer.Symbol.SS_CLOSE_PAR)).isSym(SynAnalyzer.Symbol.SS_COLON)) continue;
            String req = syn.readId().toUpperCase();
            if (!(req.equals("STRIPS") || req.equals("TYPING") || req.equals("FLUENTS") || req.equals("MULTI-AGENT") || req.equals("EQUALITY") || req.equals("NEGATIVE-PRECONDITIONS"))) {
                syn.notifyError("Requirement '" + req + "' not supported");
            }
            task.addRequirement(req);
        } while (!token.isSym(SynAnalyzer.Symbol.SS_CLOSE_PAR));
    }

    private void parseTypeList(SynAnalyzer syn, ArrayList<TaskImp.Type> parentTypes, TaskImp task) throws ParseException {
        SynAnalyzer.Token token = syn.readSym(SynAnalyzer.Symbol.SS_OPEN_PAR, SynAnalyzer.Symbol.SS_ID);
        if (token.isSym(SynAnalyzer.Symbol.SS_ID)) {
            TaskImp taskImp = task;
            taskImp.getClass();
            TaskImp.Type type = new TaskImp.Type(taskImp, token.getDescLower());
            int typeIndex = task.types.indexOf(type);
            if (typeIndex == -1) {
                syn.notifyError("Type '" + type.name + "' undefined");
            }
            parentTypes.add(task.types.get(typeIndex));
        } else {
            syn.readSym(SynAnalyzer.Symbol.SS_EITHER);
            do {
                if (!(token = syn.readSym(SynAnalyzer.Symbol.SS_ID, SynAnalyzer.Symbol.SS_CLOSE_PAR)).isSym(SynAnalyzer.Symbol.SS_ID)) continue;
                TaskImp taskImp = task;
                taskImp.getClass();
                TaskImp.Type type = new TaskImp.Type(taskImp, token.getDescLower());
                int typeIndex = task.types.indexOf(type);
                if (typeIndex == -1) {
                    syn.notifyError("Type '" + type.name + "' undefined");
                }
                parentTypes.add(task.types.get(typeIndex));
            } while (!token.isSym(SynAnalyzer.Symbol.SS_CLOSE_PAR));
        }
    }

    private TaskImp.Type addNewType(SynAnalyzer syn, String typeName, TaskImp task) throws ParseException {
        TaskImp taskImp = task;
        taskImp.getClass();
        TaskImp.Type type = new TaskImp.Type(taskImp, typeName);
        int pos = task.types.indexOf(type);
        if (pos == -1) {
            task.types.add(type);
        } else if (pos > 2) {
            syn.notifyError("Type '" + typeName + "' redefined");
        } else {
            type = task.types.get(pos);
        }
        return type;
    }

    private void parseTypes(SynAnalyzer syn, TaskImp task) throws ParseException {
        SynAnalyzer.Token token = syn.readSym(SynAnalyzer.Symbol.SS_ID, SynAnalyzer.Symbol.SS_CLOSE_PAR);
        while (!token.isSym(SynAnalyzer.Symbol.SS_CLOSE_PAR)) {
            ArrayList<String> typeNames = new ArrayList<String>();
            while (token.isSym(SynAnalyzer.Symbol.SS_ID)) {
                typeNames.add(token.getDescLower());
                token = syn.readSym(SynAnalyzer.Symbol.SS_ID, SynAnalyzer.Symbol.SS_DASH, SynAnalyzer.Symbol.SS_CLOSE_PAR);
            }
            ArrayList<TaskImp.Type> parentTypes = new ArrayList<TaskImp.Type>();
            if (token.isSym(SynAnalyzer.Symbol.SS_DASH)) {
                this.parseTypeList(syn, parentTypes, task);
                token = syn.readSym(SynAnalyzer.Symbol.SS_ID, SynAnalyzer.Symbol.SS_CLOSE_PAR);
            } else {
                parentTypes.add(task.types.get(0));
            }
            for (String typeName : typeNames) {
                TaskImp.Type type = this.addNewType(syn, typeName, task);
                for (TaskImp.Type parent : parentTypes) {
                    type.addParentType(parent, syn);
                }
            }
        }
    }

    private void parseObjects(SynAnalyzer syn, TaskImp task) throws ParseException {
        SynAnalyzer.Token token = syn.readSym(SynAnalyzer.Symbol.SS_ID, SynAnalyzer.Symbol.SS_CLOSE_PAR);
        while (!token.isSym(SynAnalyzer.Symbol.SS_CLOSE_PAR)) {
            ArrayList<String> objNames = new ArrayList<String>();
            ArrayList<TaskImp.Type> parentTypes = new ArrayList<TaskImp.Type>();
            while (token.isSym(SynAnalyzer.Symbol.SS_ID)) {
                objNames.add(token.getDescLower());
                token = syn.readSym(SynAnalyzer.Symbol.SS_ID, SynAnalyzer.Symbol.SS_CLOSE_PAR, SynAnalyzer.Symbol.SS_DASH);
            }
            if (token.isSym(SynAnalyzer.Symbol.SS_DASH)) {
                this.parseTypeList(syn, parentTypes, task);
            } else {
                parentTypes.add(task.types.get(0));
            }
            for (String objName : objNames) {
                TaskImp.Value obj = this.addNewObject(syn, objName, task);
                for (TaskImp.Type parent : parentTypes) {
                    obj.addType(parent, syn);
                }
            }
            token = syn.readSym(SynAnalyzer.Symbol.SS_ID, SynAnalyzer.Symbol.SS_CLOSE_PAR);
        }
    }

    private TaskImp.Value addNewObject(SynAnalyzer syn, String objName, TaskImp task) throws ParseException {
        TaskImp taskImp = task;
        taskImp.getClass();
        TaskImp.Value v = new TaskImp.Value(taskImp, objName);
        if (task.values.contains(v)) {
            syn.notifyError("Object '" + objName + "' redefined");
        }
        task.values.add(v);
        return v;
    }

    private void parsePredicates(SynAnalyzer syn, TaskImp task) throws ParseException {
        SynAnalyzer.Token token;
        do {
            if (!(token = syn.readSym(SynAnalyzer.Symbol.SS_OPEN_PAR, SynAnalyzer.Symbol.SS_CLOSE_PAR)).isSym(SynAnalyzer.Symbol.SS_OPEN_PAR)) continue;
            syn.restoreLastToken();
            TaskImp.Variable v = this.parsePredicate(syn, task, false, true);
            task.predicates.add(v);
        } while (!token.isSym(SynAnalyzer.Symbol.SS_CLOSE_PAR));
    }

    private TaskImp.Variable parsePredicate(SynAnalyzer syn, TaskImp task, boolean allowDuplicates, boolean readPar) throws ParseException {
        if (readPar) {
            syn.openPar();
        }
        TaskImp taskImp = task;
        taskImp.getClass();
        TaskImp.Variable v = new TaskImp.Variable(taskImp, syn.readId());
        if (!allowDuplicates && task.existVariable(v)) {
            syn.notifyError("Predicate '" + v.name + "' redefined");
        }
        ArrayList<TaskImp.Value> params = this.parseParameters(syn, task);
        for (TaskImp.Value p : params) {
            v.params.add(p);
        }
        if (readPar) {
            syn.closePar();
        }
        return v;
    }

    private void parseFunctions(SynAnalyzer syn, TaskImp task, boolean multi) throws ParseException {
        SynAnalyzer.Token token;
        do {
            if (!(token = syn.readSym(SynAnalyzer.Symbol.SS_OPEN_PAR, SynAnalyzer.Symbol.SS_CLOSE_PAR)).isSym(SynAnalyzer.Symbol.SS_OPEN_PAR)) continue;
            ArrayList<TaskImp.Variable> functionList = new ArrayList<TaskImp.Variable>();
            ArrayList<TaskImp.Type> domain = new ArrayList<TaskImp.Type>();
            do {
                syn.restoreLastToken();
                functionList.add(this.parsePredicate(syn, task, false, true));
            } while ((token = syn.readSym(SynAnalyzer.Symbol.SS_OPEN_PAR, SynAnalyzer.Symbol.SS_DASH)).isSym(SynAnalyzer.Symbol.SS_OPEN_PAR));
            this.parseTypeList(syn, domain, task);
            for (TaskImp.Variable v : functionList) {
                if (task.existVariable(v)) {
                    syn.notifyError("Function '" + v.name + "' redefined");
                }
                TaskImp taskImp = task;
                taskImp.getClass();
                TaskImp.Function f = new TaskImp.Function(taskImp, v, multi);
                f.setDomain(domain);
                task.functions.add(f);
            }
        } while (!token.isSym(SynAnalyzer.Symbol.SS_CLOSE_PAR));
    }

    private void parseAction(SynAnalyzer syn, TaskImp task) throws ParseException {
        TaskImp taskImp = task;
        taskImp.getClass();
        TaskImp.Operator op = new TaskImp.Operator(taskImp, syn.readId());
        if (task.operators.contains(op)) {
            syn.notifyError("Operator '" + op.name + "' redefined");
        }
        task.operators.add(op);
        syn.colon();
        boolean precRead = false;
        boolean effRead = false;
        SynAnalyzer.Token token = syn.readSym(SynAnalyzer.Symbol.SS_PARAMS, SynAnalyzer.Symbol.SS_PREC, SynAnalyzer.Symbol.SS_EFF);
        do {
            switch (token.getSym()) {
                case SS_PARAMS: {
                    syn.openPar();
                    ArrayList<TaskImp.Value> params = this.parseParameters(syn, task);
                    for (TaskImp.Value p : params) {
                        op.params.add(p);
                    }
                    syn.closePar();
                    break;
                }
                case SS_PREC: {
                    this.parseOperatorCondition(syn, task, op, true);
                    precRead = true;
                    break;
                }
                case SS_EFF: {
                    this.parseOperatorCondition(syn, task, op, false);
                    effRead = true;
                }
            }
            token = syn.readSym(SynAnalyzer.Symbol.SS_OPEN_PAR, SynAnalyzer.Symbol.SS_COLON, SynAnalyzer.Symbol.SS_CLOSE_PAR);
            if (!token.isSym(SynAnalyzer.Symbol.SS_COLON)) continue;
            if (!precRead) {
                token = syn.readSym(SynAnalyzer.Symbol.SS_PREC, SynAnalyzer.Symbol.SS_EFF);
                continue;
            }
            if (!effRead) {
                token = syn.readSym(SynAnalyzer.Symbol.SS_EFF);
                continue;
            }
            syn.notifyError("Unexpected colon");
        } while (!token.isSym(SynAnalyzer.Symbol.SS_CLOSE_PAR) && !token.isSym(SynAnalyzer.Symbol.SS_OPEN_PAR));
        if (token.isSym(SynAnalyzer.Symbol.SS_OPEN_PAR)) {
            syn.restoreLastToken();
        }
    }

    private ArrayList<TaskImp.Value> parseParameters(SynAnalyzer syn, TaskImp task) throws ParseException {
        SynAnalyzer.Token token;
        ArrayList<TaskImp.Value> res = new ArrayList<TaskImp.Value>();
        do {
            if ((token = syn.readSym(SynAnalyzer.Symbol.SS_VAR, SynAnalyzer.Symbol.SS_CLOSE_PAR)).isSym(SynAnalyzer.Symbol.SS_CLOSE_PAR)) continue;
            String desc = token.getDescLower();
            ArrayList<String> paramList = new ArrayList<String>();
            ArrayList<TaskImp.Type> typeList = new ArrayList<TaskImp.Type>();
            do {
                paramList.add(desc);
                token = syn.readSym(SynAnalyzer.Symbol.SS_VAR, SynAnalyzer.Symbol.SS_DASH, SynAnalyzer.Symbol.SS_CLOSE_PAR);
                desc = token.getDescLower();
            } while (token.isSym(SynAnalyzer.Symbol.SS_VAR));
            if (token.isSym(SynAnalyzer.Symbol.SS_DASH)) {
                this.parseTypeList(syn, typeList, task);
            } else {
                typeList.add(task.types.get(0));
            }
            for (String paramName : paramList) {
                TaskImp taskImp = task;
                taskImp.getClass();
                TaskImp.Value v = new TaskImp.Value(taskImp, paramName);
                v.isVariable = true;
                if (res.contains(v)) {
                    syn.notifyError("Parameter '" + paramName + "' redefined");
                }
                for (TaskImp.Type t : typeList) {
                    v.addType(t, syn);
                }
                res.add(v);
            }
        } while (!token.isSym(SynAnalyzer.Symbol.SS_CLOSE_PAR));
        syn.restoreLastToken();
        return res;
    }

    private void parseOperatorCondition(SynAnalyzer syn, TaskImp task, TaskImp.Operator op, boolean isPrec) throws ParseException {
        syn.openPar();
        SynAnalyzer.Token token = syn.readSym(SynAnalyzer.Symbol.SS_AND, SynAnalyzer.Symbol.SS_ID, SynAnalyzer.Symbol.SS_EQUAL);
        if (token.isSym(SynAnalyzer.Symbol.SS_AND)) {
            do {
                if (!(token = syn.readSym(SynAnalyzer.Symbol.SS_OPEN_PAR, SynAnalyzer.Symbol.SS_CLOSE_PAR)).isSym(SynAnalyzer.Symbol.SS_OPEN_PAR)) continue;
                TaskImp.OperatorCondition cond = this.parseSingleOperatorCondition(syn, task, op, isPrec);
                syn.closePar();
                if (isPrec) {
                    op.prec.add(cond);
                    continue;
                }
                op.eff.add(cond);
            } while (!token.isSym(SynAnalyzer.Symbol.SS_CLOSE_PAR));
        } else {
            syn.restoreLastToken();
            TaskImp.OperatorCondition cond = this.parseSingleOperatorCondition(syn, task, op, isPrec);
            syn.closePar();
            if (isPrec) {
                op.prec.add(cond);
            } else {
                op.eff.add(cond);
            }
        }
    }

    private TaskImp.OperatorCondition parseSingleOperatorCondition(SynAnalyzer syn, TaskImp task, TaskImp.Operator op, boolean isPrec) throws ParseException {
        TaskImp.OperatorCondition cond;
        SynAnalyzer.Token token = isPrec ? syn.readSym(SynAnalyzer.Symbol.SS_NOT, SynAnalyzer.Symbol.SS_EQUAL, SynAnalyzer.Symbol.SS_MEMBER, SynAnalyzer.Symbol.SS_ID) : syn.readSym(SynAnalyzer.Symbol.SS_NOT, SynAnalyzer.Symbol.SS_ASSIGN, SynAnalyzer.Symbol.SS_ADD, SynAnalyzer.Symbol.SS_DEL, SynAnalyzer.Symbol.SS_INCREASE, SynAnalyzer.Symbol.SS_ID);
        if (token.isSym(SynAnalyzer.Symbol.SS_NOT)) {
            syn.openPar();
            cond = this.parseSingleOperatorCondition(syn, task, op, isPrec);
            syn.closePar();
            cond.neg = !cond.neg;
        } else if (token.isSym(SynAnalyzer.Symbol.SS_INCREASE)) {
            TaskImp taskImp = task;
            taskImp.getClass();
            cond = new TaskImp.OperatorCondition(taskImp, TaskImp.OperatorConditionType.CT_INCREASE);
            syn.openPar();
            cond.var = this.parseOperatorVariable(syn, task, op);
            syn.closePar();
            TaskImp.Function function = this.checkFunction(cond.var, syn, task);
            if (!function.isNumeric()) {
                syn.notifyError("Function '" + cond.var.name + "' is not numeric");
            }
            cond.exp = this.parseNumericExpression(syn, task, op, null);
        } else if (token.isSym(SynAnalyzer.Symbol.SS_ID)) {
            syn.restoreLastToken();
            TaskImp taskImp = task;
            taskImp.getClass();
            cond = new TaskImp.OperatorCondition(taskImp, TaskImp.OperatorConditionType.CT_NONE);
            cond.var = this.parseOperatorVariable(syn, task, op);
            this.checkPredicate(cond.var, syn, task);
        } else {
            TaskImp.OperatorConditionType type = null;
            switch (token.getSym()) {
                case SS_EQUAL: {
                    type = TaskImp.OperatorConditionType.CT_EQUAL;
                    break;
                }
                case SS_MEMBER: {
                    type = TaskImp.OperatorConditionType.CT_MEMBER;
                    break;
                }
                case SS_ASSIGN: {
                    type = TaskImp.OperatorConditionType.CT_ASSIGN;
                    break;
                }
                case SS_ADD: {
                    type = TaskImp.OperatorConditionType.CT_ADD;
                    break;
                }
                case SS_DEL: {
                    type = TaskImp.OperatorConditionType.CT_DEL;
                    break;
                }
                default: {
                    syn.notifyError("Unknown condition type");
                }
            }
            TaskImp taskImp = task;
            taskImp.getClass();
            cond = new TaskImp.OperatorCondition(taskImp, type);
            syn.openPar();
            cond.var = this.parseOperatorVariable(syn, task, op);
            syn.closePar();
            cond.value = this.parseOperatorValue(syn, task, op);
            this.checkFunction(cond, syn, task);
        }
        return cond;
    }

    private void checkFunction(TaskImp.OperatorCondition cond, SynAnalyzer syn, TaskImp task) throws ParseException {
        ArrayList<TaskImp.Function> arrayList = task.functions;
        TaskImp taskImp = task;
        taskImp.getClass();
        int fIndex = arrayList.indexOf(new TaskImp.Function(taskImp, cond.var, false));
        if (fIndex == -1) {
            syn.notifyError("Function '" + cond.var.name + "' undefined");
        }
        TaskImp.Function fnc = task.functions.get(fIndex);
        switch (cond.type) {
            case CT_EQUAL: {
                if (!fnc.multiFunction) break;
                syn.notifyError("Operator '=' not valid for multi-functions");
                break;
            }
            case CT_MEMBER: {
                if (fnc.multiFunction) break;
                syn.notifyError("Operator 'member' not valid for functions");
                break;
            }
            case CT_ASSIGN: {
                if (!fnc.multiFunction) break;
                syn.notifyError("Operator 'assign' not valid for multi-functions");
                break;
            }
            case CT_ADD: {
                if (fnc.multiFunction) break;
                syn.notifyError("Operator 'add' not valid for functions");
                break;
            }
            case CT_DEL: {
                if (fnc.multiFunction) break;
                syn.notifyError("Operator 'del' not valid for functions");
                break;
            }
            case CT_NONE: {
                syn.notifyError("Operator expected");
            }
        }
        if (cond.var.params.size() != fnc.var.params.size()) {
            syn.notifyError("Wrong number of parameters in function '" + cond.var.name + "'");
        }
        for (int i = 0; i < cond.var.params.size(); ++i) {
            TaskImp.Value fncParam = fnc.var.params.get(i);
            TaskImp.Value varParam = cond.var.params.get(i);
            if (varParam.isCompatible(fncParam)) continue;
            syn.notifyError("Invalid parameter '" + varParam.name + "' in function '" + cond.var.name + "'");
        }
        if (!cond.value.isCompatible(fnc.domain)) {
            syn.notifyError("Wrong value '" + cond.value.name + "' for function '" + cond.var.name + "'");
        }
    }

    private TaskImp.Function checkFunction(TaskImp.Variable var, SynAnalyzer syn, TaskImp task) throws ParseException {
        ArrayList<TaskImp.Function> arrayList = task.functions;
        TaskImp taskImp = task;
        taskImp.getClass();
        int fIndex = arrayList.indexOf(new TaskImp.Function(taskImp, var, false));
        if (fIndex == -1) {
            syn.notifyError("Function '" + var.name + "' undefined");
        }
        TaskImp.Function fnc = task.functions.get(fIndex);
        if (var.params.size() != fnc.var.params.size()) {
            syn.notifyError("Wrong number of parameters in function '" + var.name + "'");
        }
        for (int i = 0; i < var.params.size(); ++i) {
            TaskImp.Value fncParam = fnc.var.params.get(i);
            TaskImp.Value varParam = var.params.get(i);
            if (varParam.isCompatible(fncParam)) continue;
            syn.notifyError("Invalid parameter '" + varParam.name + "' in function '" + var.name + "'");
        }
        return fnc;
    }

    private void checkPredicate(TaskImp.Variable var, SynAnalyzer syn, TaskImp task) throws ParseException {
        int vIndex = task.predicates.indexOf(var);
        if (vIndex == -1) {
            syn.notifyError("Predicate '" + var.name + "' undefined");
        }
        TaskImp.Variable pred = task.predicates.get(vIndex);
        if (var.params.size() != pred.params.size()) {
            syn.notifyError("Wrong number of parameters in predicate '" + var.name + "'");
        }
        for (int i = 0; i < pred.params.size(); ++i) {
            TaskImp.Value predParam = pred.params.get(i);
            TaskImp.Value varParam = var.params.get(i);
            if (varParam.isCompatible(predParam)) continue;
            syn.notifyError("Invalid parameter '" + varParam.name + "' in predicate '" + var.name + "'");
        }
    }

    private TaskImp.Variable parseOperatorVariable(SynAnalyzer syn, TaskImp task, TaskImp.Operator op) throws ParseException {
        SynAnalyzer.Token token;
        TaskImp taskImp = task;
        taskImp.getClass();
        TaskImp.Variable v = new TaskImp.Variable(taskImp, syn.readId());
        do {
            if ((token = syn.readSym(SynAnalyzer.Symbol.SS_VAR, SynAnalyzer.Symbol.SS_CLOSE_PAR, SynAnalyzer.Symbol.SS_ID)).isSym(SynAnalyzer.Symbol.SS_CLOSE_PAR)) continue;
            syn.restoreLastToken();
            v.params.add(this.parseOperatorValue(syn, task, op));
        } while (!token.isSym(SynAnalyzer.Symbol.SS_CLOSE_PAR));
        syn.restoreLastToken();
        return v;
    }

    private TaskImp.Value parseOperatorValue(SynAnalyzer syn, TaskImp task, TaskImp.Operator op) throws ParseException {
        TaskImp.Value v;
        SynAnalyzer.Token token = syn.readSym(SynAnalyzer.Symbol.SS_VAR, SynAnalyzer.Symbol.SS_ID);
        if (token.isSym(SynAnalyzer.Symbol.SS_VAR)) {
            ArrayList<TaskImp.Value> arrayList = op.params;
            TaskImp taskImp = task;
            taskImp.getClass();
            int paramIndex = arrayList.indexOf(new TaskImp.Value(taskImp, token.getDescLower()));
            if (paramIndex == -1) {
                syn.notifyError("Parameter '" + token.getDesc() + "' undefined in operator '" + op.name + "'");
            }
            v = op.params.get(paramIndex);
        } else {
            ArrayList<TaskImp.Value> arrayList = task.values;
            TaskImp taskImp = task;
            taskImp.getClass();
            int objIndex = arrayList.indexOf(new TaskImp.Value(taskImp, token.getDescLower()));
            if (objIndex == -1) {
                syn.notifyError("Constant '" + token.getDesc() + "' undefined");
            }
            v = task.values.get(objIndex);
        }
        return v;
    }

    private void parseSharedData(SynAnalyzer syn, TaskImp task) throws ParseException {
        SynAnalyzer.Token token;
        ArrayList<Object> data = new ArrayList<Object>();
        ArrayList<String> agents = new ArrayList<String>();
        do {
            TaskImp.Variable v;
            if (!(token = syn.readSym(SynAnalyzer.Symbol.SS_OPEN_PAR, SynAnalyzer.Symbol.SS_CLOSE_PAR)).isSym(SynAnalyzer.Symbol.SS_OPEN_PAR)) continue;
            token = syn.readSym(SynAnalyzer.Symbol.SS_OPEN_PAR, SynAnalyzer.Symbol.SS_ID);
            syn.restoreLastToken();
            if (token.isSym(SynAnalyzer.Symbol.SS_OPEN_PAR)) {
                v = this.parsePredicate(syn, task, true, true);
                TaskImp.Function function = this.checkFunction(v, syn, task);
                TaskImp taskImp = task;
                taskImp.getClass();
                TaskImp.Function f = new TaskImp.Function(taskImp, v, function.multiFunction);
                syn.readSym(SynAnalyzer.Symbol.SS_DASH);
                token = syn.readSym(SynAnalyzer.Symbol.SS_OPEN_PAR, SynAnalyzer.Symbol.SS_ID);
                if (token.isSym(SynAnalyzer.Symbol.SS_OPEN_PAR)) {
                    syn.readSym(SynAnalyzer.Symbol.SS_EITHER);
                    do {
                        f.addDomainType(syn, syn.readId().toLowerCase());
                        token = syn.readSym(SynAnalyzer.Symbol.SS_CLOSE_PAR, SynAnalyzer.Symbol.SS_ID);
                        if (!token.isSym(SynAnalyzer.Symbol.SS_ID)) continue;
                        syn.restoreLastToken();
                    } while (!token.isSym(SynAnalyzer.Symbol.SS_CLOSE_PAR));
                } else {
                    f.addDomainType(syn, token.getDescLower());
                }
                for (TaskImp.Type t : f.domain) {
                    if (t.isCompatible(function.domain)) continue;
                    syn.notifyError("Type '" + t.name + "' is not in the function's domain");
                }
                data.add(f);
            } else {
                v = this.parsePredicate(syn, task, true, false);
                this.checkPredicate(v, syn, task);
                data.add(v);
            }
            syn.closePar();
            token = syn.readSym(SynAnalyzer.Symbol.SS_OPEN_PAR, SynAnalyzer.Symbol.SS_DASH);
            if (token.isSym(SynAnalyzer.Symbol.SS_OPEN_PAR)) {
                syn.restoreLastToken();
                continue;
            }
            token = syn.readSym(SynAnalyzer.Symbol.SS_OPEN_PAR, SynAnalyzer.Symbol.SS_ID);
            if (token.isSym(SynAnalyzer.Symbol.SS_OPEN_PAR)) {
                syn.readSym(SynAnalyzer.Symbol.SS_EITHER);
                do {
                    agents.add(syn.readId());
                    token = syn.readSym(SynAnalyzer.Symbol.SS_CLOSE_PAR, SynAnalyzer.Symbol.SS_ID);
                    if (!token.isSym(SynAnalyzer.Symbol.SS_ID)) continue;
                    syn.restoreLastToken();
                } while (!token.isSym(SynAnalyzer.Symbol.SS_CLOSE_PAR));
                token.set(SynAnalyzer.Symbol.SS_UNDEFINED, "");
            } else {
                agents.add(token.getDescLower());
            }
            for (Object e : data) {
                this.addSharedData(syn, task, e, agents);
            }
            data.clear();
            agents.clear();
        } while (!token.isSym(SynAnalyzer.Symbol.SS_CLOSE_PAR));
        if (!data.isEmpty()) {
            syn.notifyError("Expected agent list");
        }
    }

    private void addSharedData(SynAnalyzer syn, TaskImp task, Object data, ArrayList<String> agents) throws ParseException {
        TaskImp.SharedData sd;
        TaskImp.Type agType = task.getAgentType();
        if (agType == null) {
            syn.notifyError("Agent type is not defined");
        }
        if (data instanceof TaskImp.Variable) {
            TaskImp taskImp = task;
            taskImp.getClass();
            sd = new TaskImp.SharedData(taskImp, (TaskImp.Variable)data);
        } else {
            TaskImp taskImp = task;
            taskImp.getClass();
            sd = new TaskImp.SharedData(taskImp, (TaskImp.Function)data);
        }
        for (String agName : agents) {
            ArrayList<TaskImp.Value> arrayList = task.values;
            TaskImp taskImp = task;
            taskImp.getClass();
            int objIndex = arrayList.indexOf(new TaskImp.Value(taskImp, agName.toLowerCase()));
            if (objIndex == -1) {
                syn.notifyError("Agent '" + agName + "' undefined");
            }
            TaskImp.Value v = task.values.get(objIndex);
            boolean isAgent = false;
            for (TaskImp.Type t : v.types) {
                if (!t.isCompatible(agType)) continue;
                isAgent = true;
                break;
            }
            if (!isAgent) {
                syn.notifyError("Object '" + agName + "' is not an agent");
            }
            sd.agents.add(v);
        }
        task.sharedData.add(sd);
    }

    private void parseInit(SynAnalyzer syn, TaskImp task) throws ParseException {
        SynAnalyzer.Token token;
        do {
            if (!(token = syn.readSym(SynAnalyzer.Symbol.SS_OPEN_PAR, SynAnalyzer.Symbol.SS_CLOSE_PAR)).isSym(SynAnalyzer.Symbol.SS_OPEN_PAR)) continue;
            syn.restoreLastToken();
            TaskImp.Assignment a = this.parseAssignment(syn, task, true);
            task.init.add(a);
        } while (!token.isSym(SynAnalyzer.Symbol.SS_CLOSE_PAR));
    }

    private TaskImp.Assignment parseAssignment(SynAnalyzer syn, TaskImp task, boolean readPar) throws ParseException {
        TaskImp.Assignment a;
        SynAnalyzer.Token token;
        if (readPar) {
            syn.openPar();
        }
        if ((token = syn.readSym(SynAnalyzer.Symbol.SS_EQUAL, SynAnalyzer.Symbol.SS_NOT, SynAnalyzer.Symbol.SS_PREFERENCE, SynAnalyzer.Symbol.SS_ID)).isSym(SynAnalyzer.Symbol.SS_PREFERENCE)) {
            String name = syn.readId();
            TaskImp.Assignment a2 = this.parseAssignment(syn, task, true);
            task.addPreference(name, a2, syn);
            syn.closePar();
            return null;
        }
        boolean isLiteral = !token.isSym(SynAnalyzer.Symbol.SS_EQUAL);
        boolean neg = token.isSym(SynAnalyzer.Symbol.SS_NOT);
        if (!neg) {
            if (isLiteral) {
                syn.restoreLastToken();
            } else {
                syn.openPar();
            }
        } else {
            syn.openPar();
            token = syn.readSym(SynAnalyzer.Symbol.SS_EQUAL, SynAnalyzer.Symbol.SS_ID);
            boolean bl = isLiteral = !token.isSym(SynAnalyzer.Symbol.SS_EQUAL);
            if (isLiteral) {
                syn.restoreLastToken();
            } else {
                syn.openPar();
            }
        }
        String varName = syn.readId();
        if (isLiteral) {
            ArrayList<TaskImp.Variable> arrayList = task.predicates;
            TaskImp taskImp = task;
            taskImp.getClass();
            int index = arrayList.indexOf(new TaskImp.Variable(taskImp, varName));
            if (index == -1) {
                syn.notifyError("Predicate '" + varName + "' undefined");
            }
            TaskImp taskImp2 = task;
            taskImp2.getClass();
            a = new TaskImp.Assignment(taskImp2, task.predicates.get(index), neg);
        } else {
            ArrayList<TaskImp.Function> arrayList = task.functions;
            TaskImp taskImp = task;
            taskImp.getClass();
            TaskImp taskImp3 = task;
            taskImp3.getClass();
            int index = arrayList.indexOf(new TaskImp.Function(taskImp, new TaskImp.Variable(taskImp3, varName), false));
            if (index == -1) {
                syn.notifyError("Function '" + varName + "' undefined");
            }
            TaskImp taskImp4 = task;
            taskImp4.getClass();
            a = new TaskImp.Assignment(taskImp4, task.functions.get(index), neg);
        }
        do {
            if (!(token = syn.readSym(SynAnalyzer.Symbol.SS_CLOSE_PAR, SynAnalyzer.Symbol.SS_ID)).isSym(SynAnalyzer.Symbol.SS_ID)) continue;
            syn.restoreLastToken();
            TaskImp.Value param = this.parseAssignmentValue(syn, task);
            a.params.add(param);
        } while (!token.isSym(SynAnalyzer.Symbol.SS_CLOSE_PAR));
        if (isLiteral) {
            a.values.add(task.values.get(0));
        } else {
            if (a.fnc.multiFunction) {
                syn.readSym(SynAnalyzer.Symbol.SS_OPEN_SET);
                do {
                    if (!(token = syn.readSym(SynAnalyzer.Symbol.SS_CLOSE_SET, SynAnalyzer.Symbol.SS_ID)).isSym(SynAnalyzer.Symbol.SS_ID)) continue;
                    syn.restoreLastToken();
                    a.values.add(this.parseAssignmentValue(syn, task));
                } while (!token.isSym(SynAnalyzer.Symbol.SS_CLOSE_SET));
            } else {
                token = syn.readSym(SynAnalyzer.Symbol.SS_NUMBER, SynAnalyzer.Symbol.SS_ID);
                if (token.isSym(SynAnalyzer.Symbol.SS_NUMBER)) {
                    a.isNumeric = true;
                    try {
                        a.value = Double.parseDouble(token.getDesc());
                    }
                    catch (NumberFormatException e) {
                        syn.notifyError("'" + token.getDesc() + "' is not a valid number");
                    }
                } else {
                    syn.restoreLastToken();
                    a.values.add(this.parseAssignmentValue(syn, task));
                }
            }
            syn.closePar();
        }
        if (neg) {
            syn.closePar();
        }
        this.checkAssignment(syn, task, a);
        if (!readPar) {
            syn.restoreLastToken();
        }
        return a;
    }

    private void checkAssignment(SynAnalyzer syn, TaskImp task, TaskImp.Assignment a) throws ParseException {
        TaskImp.Variable var;
        boolean isLiteral = a.var != null;
        TaskImp.Variable variable = var = isLiteral ? a.var : a.fnc.var;
        if (var.params.size() != a.params.size()) {
            syn.notifyError("Wrong number of parameters for literal '" + var.name + "'");
        }
        for (int i = 0; i < a.params.size(); ++i) {
            TaskImp.Value predParam = var.params.get(i);
            TaskImp.Value varParam = a.params.get(i);
            if (varParam.isCompatible(predParam)) continue;
            syn.notifyError("Invalid parameter '" + varParam.name + "' for literal '" + var.name + "'");
        }
        if (!isLiteral) {
            if (!a.isNumeric) {
                for (TaskImp.Value v : a.values) {
                    if (v.isCompatible(a.fnc.domain)) continue;
                    syn.notifyError("Wrong value '" + v.name + "' for function '" + var.name + "'");
                }
            } else {
                TaskImp.Function fn = this.checkFunction(var, syn, task);
                if (!fn.isNumeric()) {
                    syn.notifyError("Function '" + var.name + "' is not numeric");
                }
                if (a.neg) {
                    syn.notifyError("Cannot negate a numeric function");
                }
            }
        }
    }

    private TaskImp.Value parseAssignmentValue(SynAnalyzer syn, TaskImp task) throws ParseException {
        String valueName = syn.readId().toLowerCase();
        ArrayList<TaskImp.Value> arrayList = task.values;
        TaskImp taskImp = task;
        taskImp.getClass();
        int valueIndex = arrayList.indexOf(new TaskImp.Value(taskImp, valueName));
        if (valueIndex == -1) {
            syn.notifyError("Object '" + valueName + "' undefined");
        }
        return task.values.get(valueIndex);
    }

    private void parseGoal(SynAnalyzer syn, TaskImp task) throws ParseException {
        syn.openPar();
        SynAnalyzer.Token token = syn.readSym(SynAnalyzer.Symbol.SS_AND, SynAnalyzer.Symbol.SS_EQUAL, SynAnalyzer.Symbol.SS_ID, SynAnalyzer.Symbol.SS_PREFERENCE);
        if (token.isSym(SynAnalyzer.Symbol.SS_AND)) {
            do {
                if (!(token = syn.readSym(SynAnalyzer.Symbol.SS_OPEN_PAR, SynAnalyzer.Symbol.SS_CLOSE_PAR)).isSym(SynAnalyzer.Symbol.SS_OPEN_PAR)) continue;
                syn.restoreLastToken();
                TaskImp.Assignment a = this.parseAssignment(syn, task, true);
                if (a == null) continue;
                task.gGoals.add(a);
            } while (!token.isSym(SynAnalyzer.Symbol.SS_CLOSE_PAR));
            syn.closePar();
        } else if (token.isSym(SynAnalyzer.Symbol.SS_PREFERENCE)) {
            String name = syn.readId();
            TaskImp.Assignment a = this.parseAssignment(syn, task, true);
            task.addPreference(name, a, syn);
            syn.closePar();
        } else {
            syn.restoreLastToken();
            TaskImp.Assignment a = this.parseAssignment(syn, task, false);
            task.gGoals.add(a);
        }
    }

    private void parseActionPreferences(SynAnalyzer syn, TaskImp task) throws ParseException {
        SynAnalyzer.Token token = syn.readSym(SynAnalyzer.Symbol.SS_OPEN_PAR, SynAnalyzer.Symbol.SS_CLOSE_PAR);
        while (token.isSym(SynAnalyzer.Symbol.SS_OPEN_PAR)) {
            String opName = syn.readId();
            String value = syn.readId();
            int v = -1;
            try {
                v = Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                syn.notifyError("Preference value '" + value + "' is not a valid integer value");
            }
            boolean opFound = false;
            for (TaskImp.Operator op : task.operators) {
                if (!op.name.equalsIgnoreCase(opName)) continue;
                opFound = true;
                if (op.preference != -1) {
                    syn.notifyError("Preference for operator '" + opName + "' already set");
                }
                op.preference = v;
                break;
            }
            if (!opFound) {
                syn.notifyError("Operator '" + opName + "' undefined");
            }
            syn.closePar();
            token = syn.readSym(SynAnalyzer.Symbol.SS_OPEN_PAR, SynAnalyzer.Symbol.SS_CLOSE_PAR);
        }
    }

    private void parseBeliefs(SynAnalyzer syn, TaskImp task) throws ParseException {
        SynAnalyzer.Token token = syn.readSym(SynAnalyzer.Symbol.SS_OPEN_PAR, SynAnalyzer.Symbol.SS_CLOSE_PAR);
        while (token.isSym(SynAnalyzer.Symbol.SS_OPEN_PAR)) {
            this.parseRule(syn, task);
            token = syn.readSym(SynAnalyzer.Symbol.SS_OPEN_PAR, SynAnalyzer.Symbol.SS_CLOSE_PAR);
        }
    }

    private void parseRule(SynAnalyzer syn, TaskImp task) throws ParseException {
        String name;
        syn.colon();
        syn.readSym(SynAnalyzer.Symbol.SS_DEF_RULE);
        SynAnalyzer.Token token = syn.readSym(SynAnalyzer.Symbol.SS_COLON, SynAnalyzer.Symbol.SS_ID);
        if (token.isSym(SynAnalyzer.Symbol.SS_COLON)) {
            name = "R" + task.beliefs.size();
        } else {
            name = token.getDesc();
            syn.colon();
        }
        TaskImp taskImp = task;
        taskImp.getClass();
        TaskImp.Operator op = new TaskImp.Operator(taskImp, name);
        task.beliefs.add(op);
        boolean precRead = false;
        boolean effRead = false;
        token = syn.readSym(SynAnalyzer.Symbol.SS_PARAMS, SynAnalyzer.Symbol.SS_BODY, SynAnalyzer.Symbol.SS_HEAD);
        do {
            switch (token.getSym()) {
                case SS_PARAMS: {
                    syn.openPar();
                    ArrayList<TaskImp.Value> params = this.parseParameters(syn, task);
                    for (TaskImp.Value p : params) {
                        op.params.add(p);
                    }
                    syn.closePar();
                    break;
                }
                case SS_BODY: {
                    this.parseOperatorCondition(syn, task, op, true);
                    precRead = true;
                    break;
                }
                case SS_HEAD: {
                    this.parseOperatorCondition(syn, task, op, false);
                    effRead = true;
                }
            }
            token = syn.readSym(SynAnalyzer.Symbol.SS_OPEN_PAR, SynAnalyzer.Symbol.SS_COLON, SynAnalyzer.Symbol.SS_CLOSE_PAR);
            if (!token.isSym(SynAnalyzer.Symbol.SS_COLON)) continue;
            if (!precRead) {
                token = syn.readSym(SynAnalyzer.Symbol.SS_BODY, SynAnalyzer.Symbol.SS_HEAD);
                continue;
            }
            if (!effRead) {
                token = syn.readSym(SynAnalyzer.Symbol.SS_HEAD);
                continue;
            }
            syn.notifyError("Unexpected colon");
        } while (!token.isSym(SynAnalyzer.Symbol.SS_CLOSE_PAR) && !token.isSym(SynAnalyzer.Symbol.SS_OPEN_PAR));
        if (token.isSym(SynAnalyzer.Symbol.SS_OPEN_PAR)) {
            syn.restoreLastToken();
        }
    }

    private TaskImp.NumericExpressionImp parseNumericExpression(SynAnalyzer syn, TaskImp task, TaskImp.Operator op, TaskImp.CongestionImp congestion) throws ParseException {
        SynAnalyzer.Token token = syn.readSym(SynAnalyzer.Symbol.SS_OPEN_PAR, SynAnalyzer.Symbol.SS_NUMBER);
        TaskImp.NumericExpressionImp exp = null;
        if (token.isSym(SynAnalyzer.Symbol.SS_NUMBER)) {
            try {
                double value = Double.parseDouble(token.getDesc());
                TaskImp taskImp = task;
                taskImp.getClass();
                exp = new TaskImp.NumericExpressionImp(taskImp, value);
            }
            catch (NumberFormatException e) {
                syn.notifyError("Invalid number: " + token.getDesc());
            }
        } else {
            token = syn.readSym(SynAnalyzer.Symbol.SS_PLUS, SynAnalyzer.Symbol.SS_DASH, SynAnalyzer.Symbol.SS_MULT, SynAnalyzer.Symbol.SS_DIV, SynAnalyzer.Symbol.SS_NUMBER, SynAnalyzer.Symbol.SS_ID);
            if (token.isSym(SynAnalyzer.Symbol.SS_NUMBER)) {
                syn.restoreLastToken();
                exp = this.parseNumericExpression(syn, task, op, congestion);
            } else if (token.isSym(SynAnalyzer.Symbol.SS_ID)) {
                if (token.getDesc().equalsIgnoreCase("usage")) {
                    TaskImp taskImp = task;
                    taskImp.getClass();
                    exp = new TaskImp.NumericExpressionImp(taskImp, TaskImp.NumericExpressionType.NET_USAGE);
                } else {
                    syn.restoreLastToken();
                    TaskImp.Variable v = op != null ? this.parseOperatorVariable(syn, task, op) : this.parseCongestionVariable(syn, task, congestion);
                    TaskImp.Function function = this.checkFunction(v, syn, task);
                    if (!function.isNumeric()) {
                        syn.notifyError("Function '" + v.name + "' is not numeric");
                    }
                    TaskImp taskImp = task;
                    taskImp.getClass();
                    exp = new TaskImp.NumericExpressionImp(taskImp, v);
                }
            } else {
                switch (token.getSym()) {
                    case SS_PLUS: {
                        TaskImp taskImp = task;
                        taskImp.getClass();
                        exp = new TaskImp.NumericExpressionImp(taskImp, TaskImp.NumericExpressionType.NET_ADD);
                        break;
                    }
                    case SS_DASH: {
                        TaskImp taskImp = task;
                        taskImp.getClass();
                        exp = new TaskImp.NumericExpressionImp(taskImp, TaskImp.NumericExpressionType.NET_DEL);
                        break;
                    }
                    case SS_MULT: {
                        TaskImp taskImp = task;
                        taskImp.getClass();
                        exp = new TaskImp.NumericExpressionImp(taskImp, TaskImp.NumericExpressionType.NET_PROD);
                        break;
                    }
                    case SS_DIV: {
                        TaskImp taskImp = task;
                        taskImp.getClass();
                        exp = new TaskImp.NumericExpressionImp(taskImp, TaskImp.NumericExpressionType.NET_DIV);
                    }
                }
                exp.left = this.parseNumericExpression(syn, task, op, congestion);
                exp.right = this.parseNumericExpression(syn, task, op, congestion);
            }
            syn.closePar();
        }
        return exp;
    }

    private void parseCongestion(SynAnalyzer syn, TaskImp task) throws ParseException {
        TaskImp taskImp = task;
        taskImp.getClass();
        TaskImp.CongestionImp congestion = new TaskImp.CongestionImp(taskImp, syn.readId());
        if (task.congestions.contains(congestion)) {
            syn.notifyError("Congestion '" + congestion.name + "' redefined");
        }
        task.congestions.add(congestion);
        syn.colon();
        boolean usageRead = false;
        boolean penaltyRead = false;
        SynAnalyzer.Token token = syn.readSym(SynAnalyzer.Symbol.SS_PARAMS, SynAnalyzer.Symbol.SS_VARIABLES, SynAnalyzer.Symbol.SS_USAGE, SynAnalyzer.Symbol.SS_PENALTY);
        do {
            switch (token.getSym()) {
                case SS_PARAMS: 
                case SS_VARIABLES: {
                    syn.openPar();
                    ArrayList<TaskImp.Value> params = this.parseParameters(syn, task);
                    for (TaskImp.Value p : params) {
                        if (token.isSym(SynAnalyzer.Symbol.SS_PARAMS)) {
                            congestion.addParameter(p, syn);
                            continue;
                        }
                        congestion.addVariable(p, syn);
                    }
                    syn.closePar();
                    break;
                }
                case SS_USAGE: {
                    if (usageRead) {
                        syn.notifyError("Usage duplicated in congestion");
                    }
                    usageRead = true;
                    congestion.usage = this.parseCongestionUsage(syn, task, congestion);
                    break;
                }
                case SS_PENALTY: {
                    if (penaltyRead) {
                        syn.notifyError("Penalty duplicated in congestion");
                    }
                    penaltyRead = true;
                    this.parseCongestionPenalty(syn, task, congestion);
                }
            }
            token = syn.readSym(SynAnalyzer.Symbol.SS_OPEN_PAR, SynAnalyzer.Symbol.SS_COLON, SynAnalyzer.Symbol.SS_CLOSE_PAR);
            if (!token.isSym(SynAnalyzer.Symbol.SS_COLON)) continue;
            token = syn.readSym(SynAnalyzer.Symbol.SS_PARAMS, SynAnalyzer.Symbol.SS_VARIABLES, SynAnalyzer.Symbol.SS_USAGE, SynAnalyzer.Symbol.SS_PENALTY);
        } while (!token.isSym(SynAnalyzer.Symbol.SS_CLOSE_PAR) && !token.isSym(SynAnalyzer.Symbol.SS_OPEN_PAR));
        if (token.isSym(SynAnalyzer.Symbol.SS_OPEN_PAR)) {
            syn.restoreLastToken();
        }
    }

    private TaskImp.CongestionUsageImp parseCongestionUsage(SynAnalyzer syn, TaskImp task, TaskImp.CongestionImp congestion) throws ParseException {
        TaskImp.CongestionUsageImp usage;
        syn.openPar();
        SynAnalyzer.Token token = syn.readSym(SynAnalyzer.Symbol.SS_OR, SynAnalyzer.Symbol.SS_AND, SynAnalyzer.Symbol.SS_ID);
        if (token.isSym(SynAnalyzer.Symbol.SS_OR) || token.isSym(SynAnalyzer.Symbol.SS_AND)) {
            if (token.isSym(SynAnalyzer.Symbol.SS_OR)) {
                TaskImp taskImp = task;
                taskImp.getClass();
                usage = new TaskImp.CongestionUsageImp(taskImp, TaskImp.CongestionUsageType.CUT_OR);
            } else {
                TaskImp taskImp = task;
                taskImp.getClass();
                usage = new TaskImp.CongestionUsageImp(taskImp, TaskImp.CongestionUsageType.CUT_AND);
            }
            do {
                if (!(token = syn.readSym(SynAnalyzer.Symbol.SS_OPEN_PAR, SynAnalyzer.Symbol.SS_CLOSE_PAR)).isSym(SynAnalyzer.Symbol.SS_OPEN_PAR)) continue;
                syn.restoreLastToken();
                usage.addCondition(this.parseCongestionUsage(syn, task, congestion));
            } while (!token.isSym(SynAnalyzer.Symbol.SS_CLOSE_PAR));
        } else {
            syn.restoreLastToken();
            TaskImp.CongestionAction action = this.parseCongestionAction(syn, task, congestion);
            TaskImp taskImp = task;
            taskImp.getClass();
            usage = new TaskImp.CongestionUsageImp(taskImp, action);
        }
        return usage;
    }

    private void parseCongestionPenalty(SynAnalyzer syn, TaskImp task, TaskImp.CongestionImp congestion) throws ParseException {
        syn.openPar();
        syn.readSym(SynAnalyzer.Symbol.SS_AND);
        SynAnalyzer.Token token = syn.readSym(SynAnalyzer.Symbol.SS_OPEN_PAR, SynAnalyzer.Symbol.SS_CLOSE_PAR);
        while (token.isSym(SynAnalyzer.Symbol.SS_OPEN_PAR)) {
            syn.restoreLastToken();
            TaskImp.CongestionPenaltyImp penalty = this.parseCongestionPenaltyExpression(syn, task, congestion);
            congestion.addPenalty(penalty);
            token = syn.readSym(SynAnalyzer.Symbol.SS_OPEN_PAR, SynAnalyzer.Symbol.SS_CLOSE_PAR);
        }
    }

    private TaskImp.CongestionAction parseCongestionAction(SynAnalyzer syn, TaskImp task, TaskImp.CongestionImp congestion) throws ParseException {
        String name = syn.readId();
        ArrayList<TaskImp.Operator> arrayList = task.operators;
        TaskImp taskImp = task;
        taskImp.getClass();
        int opIndex = arrayList.indexOf(new TaskImp.Operator(taskImp, name));
        if (opIndex < 0) {
            syn.notifyError("Operator '" + name + "' undefined");
        }
        TaskImp taskImp2 = task;
        taskImp2.getClass();
        TaskImp.CongestionAction action = new TaskImp.CongestionAction(taskImp2, task.operators.get(opIndex));
        for (int i = 0; i < action.op.params.size(); ++i) {
            TaskImp.Value value;
            SynAnalyzer.Token token = syn.readSym(SynAnalyzer.Symbol.SS_VAR, SynAnalyzer.Symbol.SS_ID);
            name = token.getDesc();
            if (token.isSym(SynAnalyzer.Symbol.SS_VAR)) {
                value = congestion.getParamOrVar(name);
                if (value == null) {
                    syn.notifyError("Parameter '" + name + "' undefined");
                }
                if (!value.isCompatible(action.op.params.get((int)i).types)) {
                    syn.notifyError("Invalid type of parameter '" + name + "'");
                }
            } else {
                ArrayList<TaskImp.Value> arrayList2 = task.values;
                TaskImp taskImp3 = task;
                taskImp3.getClass();
                int objIndex = arrayList2.indexOf(new TaskImp.Value(taskImp3, name));
                if (objIndex < 0) {
                    syn.notifyError("Constant '" + name + "' undefined");
                }
                value = task.values.get(objIndex);
            }
            action.addParameter(value);
        }
        syn.closePar();
        return action;
    }

    private TaskImp.CongestionPenaltyImp parseCongestionPenaltyExpression(SynAnalyzer syn, TaskImp task, TaskImp.CongestionImp congestion) throws ParseException {
        syn.openPar();
        syn.readSym(SynAnalyzer.Symbol.SS_WHEN);
        syn.openPar();
        SynAnalyzer.Token token = syn.readSym(SynAnalyzer.Symbol.SS_EQUAL, SynAnalyzer.Symbol.SS_GREATER, SynAnalyzer.Symbol.SS_GREATER_EQ, SynAnalyzer.Symbol.SS_LESS, SynAnalyzer.Symbol.SS_LESS_EQ, SynAnalyzer.Symbol.SS_DISTINCT);
        TaskImp.CongestionPenaltyImp penalty = null;
        switch (token.getSym()) {
            case SS_EQUAL: {
                TaskImp taskImp = task;
                taskImp.getClass();
                penalty = new TaskImp.CongestionPenaltyImp(taskImp, TaskImp.ConditionType.CT_EQUAL);
                break;
            }
            case SS_GREATER: {
                TaskImp taskImp = task;
                taskImp.getClass();
                penalty = new TaskImp.CongestionPenaltyImp(taskImp, TaskImp.ConditionType.CT_GREATER);
                break;
            }
            case SS_GREATER_EQ: {
                TaskImp taskImp = task;
                taskImp.getClass();
                penalty = new TaskImp.CongestionPenaltyImp(taskImp, TaskImp.ConditionType.CT_GREATER_EQ);
                break;
            }
            case SS_LESS: {
                TaskImp taskImp = task;
                taskImp.getClass();
                penalty = new TaskImp.CongestionPenaltyImp(taskImp, TaskImp.ConditionType.CT_LESS);
                break;
            }
            case SS_LESS_EQ: {
                TaskImp taskImp = task;
                taskImp.getClass();
                penalty = new TaskImp.CongestionPenaltyImp(taskImp, TaskImp.ConditionType.CT_LESS_EQ);
                break;
            }
            case SS_DISTINCT: {
                TaskImp taskImp = task;
                taskImp.getClass();
                penalty = new TaskImp.CongestionPenaltyImp(taskImp, TaskImp.ConditionType.CT_DISTINCT);
            }
        }
        syn.openPar();
        String id = syn.readId();
        if (!id.equalsIgnoreCase("usage")) {
            syn.notifyError(id + " found, but 'usage' expected");
        }
        syn.closePar();
        token = syn.readSym(SynAnalyzer.Symbol.SS_NUMBER);
        try {
            penalty.conditionValue = Double.parseDouble(token.getDesc());
        }
        catch (NumberFormatException e) {
            syn.notifyError("'" + token.getDesc() + "' is not a valid number");
        }
        syn.closePar();
        syn.openPar();
        syn.readSym(SynAnalyzer.Symbol.SS_INCREASE);
        syn.openPar();
        penalty.setVariable(this.parseCongestionVariable(syn, task, congestion));
        penalty.setIncrement(this.parseNumericExpression(syn, task, null, congestion));
        syn.closePar();
        return penalty;
    }

    private TaskImp.Variable parseCongestionVariable(SynAnalyzer syn, TaskImp task, TaskImp.CongestionImp congestion) throws ParseException {
        TaskImp taskImp = task;
        taskImp.getClass();
        TaskImp.Variable v = new TaskImp.Variable(taskImp, syn.readId());
        ArrayList<TaskImp.Function> arrayList = task.functions;
        TaskImp taskImp2 = task;
        taskImp2.getClass();
        int fnIndex = arrayList.indexOf(new TaskImp.Function(taskImp2, v, false));
        TaskImp.Function fn = task.functions.get(fnIndex);
        if (!fn.isNumeric()) {
            syn.notifyError("Function '" + v.name + "' is not numeric");
        }
        for (int i = 0; i < fn.var.params.size(); ++i) {
            SynAnalyzer.Token token = syn.readSym(SynAnalyzer.Symbol.SS_VAR);
            String name = token.getDesc();
            TaskImp.Value value = congestion.getParamOrVar(name);
            if (value == null) {
                syn.notifyError("Parameter '" + name + "' undefined");
            }
            if (!value.isCompatible(fn.var.params.get((int)i).types)) {
                syn.notifyError("Invalid type of parameter '" + name + "'");
            }
            v.params.add(value);
        }
        syn.closePar();
        return v;
    }

    @Override
    public Task parseDomain(String domainFile) throws ParseException, IOException {
        return this.parseDomain(new File(domainFile));
    }

    @Override
    public void parseProblem(String problemFile, Task planningTask, AgentList agList, String agentName) throws ParseException, IOException {
        this.parseProblem(new File(problemFile), planningTask);
    }

    @Override
    public AgentList createEmptyAgentList() {
        return new AgentListImp();
    }

    @Override
    public boolean isMAPDDL(String domainFile) throws IOException {
        String content = this.readToString(new FileReader(new File(domainFile))).toLowerCase();
        return content.contains(":factored");
    }

    @Override
    public AgentList parseAgentList(String agentsFile) throws ParseException, IOException {
        SynAnalyzer.Token t;
        String content = this.readToString(new FileReader(new File(agentsFile)));
        SynAnalyzer syn = new SynAnalyzer(content);
        AgentListImp agList = new AgentListImp();
        do {
            if ((t = syn.readSym(SynAnalyzer.Symbol.SS_ID, SynAnalyzer.Symbol.SS_UNDEFINED)).undefined()) continue;
            String agName = t.getDesc();
            t = syn.readSym(SynAnalyzer.Symbol.SS_NUMBER);
            String ip = t.getDesc();
            agList.addAgent(agName, ip);
        } while (!t.undefined());
        if (agList.isEmpty()) {
            throw new ParseException("No agents defined in the file", 1);
        }
        return agList;
    }
}

