/*
 * Decompiled with CFR 0.152.
 */
package org.agreement_technologies.service.map_negotiation;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import org.agreement_technologies.common.map_communication.AgentCommunication;
import org.agreement_technologies.common.map_negotiation.PlanSelection;
import org.agreement_technologies.common.map_planner.IPlan;
import org.agreement_technologies.common.map_planner.POPSearchMethod;
import org.agreement_technologies.common.map_planner.Plan;
import org.agreement_technologies.service.map_planner.POPIncrementalPlan;

public class CustomBordaNegotiation
implements PlanSelection {
    private final AgentCommunication comm;
    private final int numProposals;
    private final POPSearchMethod searchTree;

    public CustomBordaNegotiation(AgentCommunication c, POPSearchMethod pst, int n) {
        this.comm = c;
        this.searchTree = pst;
        this.numProposals = n;
    }

    @Override
    public Plan selectNextPlan() {
        POPIncrementalPlan plan;
        if (this.comm.numAgents() == 1) {
            return (POPIncrementalPlan)this.searchTree.getNextPlan();
        }
        if (this.comm.batonAgent()) {
            int value;
            Hashtable<String, Integer> votes = new Hashtable<String, Integer>();
            for (int i = 0; i < this.comm.getOtherAgents().size(); ++i) {
                String[] agentVotes = (String[])this.comm.receiveMessage(true);
                value = agentVotes.length;
                for (String v : agentVotes) {
                    if (votes.contains(v)) {
                        votes.put(v, (Integer)votes.get(v) + value);
                    } else {
                        votes.put(v, value);
                    }
                    --value;
                }
            }
            IPlan[] plans = this.searchTree.getFirstPlans(this.numProposals);
            value = plans.length;
            for (IPlan p : plans) {
                if (votes.containsKey(p.getName())) {
                    votes.put(p.getName(), (Integer)votes.get(p.getName()) + value);
                } else {
                    votes.put(p.getName(), value);
                }
                --value;
            }
            Set voteSet = votes.entrySet();
            int nVotes = 0;
            ArrayList<String> planNames = new ArrayList<String>();
            for (Map.Entry pv : voteSet) {
                if ((Integer)pv.getValue() > nVotes) {
                    nVotes = (Integer)pv.getValue();
                    planNames.clear();
                    planNames.add((String)pv.getKey());
                    continue;
                }
                if ((Integer)pv.getValue() != nVotes) continue;
                planNames.add((String)pv.getKey());
            }
            plan = planNames.size() == 1 ? (POPIncrementalPlan)this.searchTree.removePlan((String)planNames.get(0)) : (POPIncrementalPlan)this.searchTree.removePlan(this.tieBreak(planNames).getName());
            if (plan != null) {
                this.comm.sendMessage((Serializable)((Object)plan.getName()), true);
            } else {
                this.comm.sendMessage((Serializable)((Object)"<NOPLAN>"), true);
            }
        } else {
            IPlan[] plans = this.searchTree.getFirstPlans(this.numProposals);
            String[] names = new String[plans.length];
            for (int i = 0; i < plans.length; ++i) {
                names[i] = plans[i].getName();
            }
            this.comm.sendMessage(this.comm.getBatonAgent(), (Serializable)names, true);
            String planName = (String)((Object)this.comm.receiveMessage(this.comm.getBatonAgent(), true));
            plan = planName.equals("<NOPLAN>") ? null : (POPIncrementalPlan)this.searchTree.removePlan(planName);
        }
        return plan;
    }

    private IPlan tieBreak(ArrayList<String> planNames) {
        IPlan bestPlan = null;
        int bestValue = Integer.MAX_VALUE;
        for (String n : planNames) {
            IPlan current = this.searchTree.getPlanByName(n);
            int publicValue = this.searchTree.getPublicValue(current);
            if (publicValue >= bestValue) continue;
            bestValue = publicValue;
            bestPlan = current;
        }
        return bestPlan;
    }
}

