/*
 * Decompiled with CFR 0.152.
 */
package org.agreement_technologies.service.map_negotiation;

import java.io.Serializable;
import org.agreement_technologies.common.map_communication.AgentCommunication;
import org.agreement_technologies.common.map_negotiation.PlanSelection;
import org.agreement_technologies.common.map_planner.POPSearchMethod;
import org.agreement_technologies.common.map_planner.Plan;
import org.agreement_technologies.service.map_planner.POPIncrementalPlan;

public class CooperativePlanSelection
implements PlanSelection {
    private final AgentCommunication comm;
    private final POPSearchMethod searchTree;

    public CooperativePlanSelection(AgentCommunication c, POPSearchMethod st) {
        this.comm = c;
        this.searchTree = st;
    }

    @Override
    public Plan selectNextPlan() {
        POPIncrementalPlan plan;
        if (this.comm.numAgents() == 1) {
            return (POPIncrementalPlan)this.searchTree.getNextPlan();
        }
        if (this.comm.batonAgent()) {
            plan = (POPIncrementalPlan)this.searchTree.getNextPlan();
            if (plan != null) {
                this.comm.sendMessage((Serializable)((Object)plan.getName()), true);
            } else {
                this.comm.sendMessage((Serializable)((Object)"<NOPLAN>"), true);
            }
        } else {
            String planName = (String)((Object)this.comm.receiveMessage(this.comm.getBatonAgent(), true));
            plan = planName.equals("<NOPLAN>") ? null : (POPIncrementalPlan)this.searchTree.removePlan(planName);
        }
        return plan;
    }
}

