/*
 * Decompiled with CFR 0.152.
 */
package org.agreement_technologies.service.map_landmarks;

import java.util.ArrayList;
import java.util.Hashtable;
import org.agreement_technologies.common.map_grounding.GroundedTask;
import org.agreement_technologies.common.map_landmarks.LandmarkAction;
import org.agreement_technologies.common.map_landmarks.LandmarkFluent;
import org.agreement_technologies.common.map_landmarks.LandmarkGraph;
import org.agreement_technologies.common.map_landmarks.LandmarkNode;
import org.agreement_technologies.common.map_landmarks.LandmarkOrdering;
import org.agreement_technologies.common.map_landmarks.LandmarkSet;
import org.agreement_technologies.service.map_landmarks.LGNode;
import org.agreement_technologies.service.map_landmarks.LMLiteral;
import org.agreement_technologies.service.map_landmarks.LMOrdering;
import org.agreement_technologies.service.map_landmarks.RPG;
import org.agreement_technologies.service.map_landmarks.uSet;

public class SALandmarkGraph
implements LandmarkGraph {
    private final ArrayList<LandmarkNode> nodes;
    private final ArrayList<LandmarkOrdering> edges;
    private final RPG r;
    private final Boolean[][] matrix;
    private final ArrayList<Integer> literalNode;
    private final ArrayList<ArrayList<LandmarkFluent>> objs;
    private final ArrayList<ArrayList<LandmarkSet>> disjObjs;
    private boolean[][] mutexMatrix;
    private boolean[][] reasonableOrderings;
    private ArrayList<LandmarkOrdering> reasonableOrderingsList;
    private ArrayList<LandmarkOrdering> reasonableOrderingsGoalsList;
    private final GroundedTask groundedTask;

    public SALandmarkGraph(GroundedTask gt, RPG r, ArrayList<LandmarkFluent> g) {
        int i;
        this.groundedTask = gt;
        this.nodes = new ArrayList();
        this.edges = new ArrayList();
        this.r = r;
        this.literalNode = new ArrayList(r.getLiterals().size());
        for (i = 0; i < r.getLiterals().size(); ++i) {
            this.literalNode.add(-1);
        }
        this.objs = new ArrayList(r.getLitLevels().size());
        for (i = 0; i < r.getLitLevels().size(); ++i) {
            this.objs.add(new ArrayList());
        }
        this.disjObjs = new ArrayList(r.getLitLevels().size());
        for (i = 0; i < r.getLitLevels().size(); ++i) {
            this.disjObjs.add(new ArrayList());
        }
        for (LandmarkFluent goal : g) {
            this.nodes.add(new LGNode(goal));
            this.nodes.get(this.nodes.size() - 1).setIndex(this.nodes.size() - 1);
            this.literalNode.set(goal.getIndex(), this.nodes.size() - 1);
            this.objs.get(goal.getLevel()).add(goal);
        }
        for (int level = r.getLitLevels().size() - 1; level > 0; --level) {
            ArrayList<LandmarkAction> A;
            if (this.objs.get(level).size() > 0) {
                for (int i2 = 0; i2 < this.objs.get(level).size(); ++i2) {
                    LandmarkFluent obj = this.objs.get(level).get(i2);
                    A = obj.getProducers();
                    if (A.size() <= 0) continue;
                    this.actionProcessing(A, this.nodes.get(this.literalNode.get(obj.getIndex())), level);
                }
            }
            if (this.disjObjs.get(level).size() <= 0) continue;
            for (LandmarkSet disjObj : this.disjObjs.get(level)) {
                A = new ArrayList();
                for (LandmarkFluent obj : disjObj.getElements()) {
                    for (LandmarkAction pa : obj.getProducers()) {
                        if (A.contains(pa)) continue;
                        A.add(pa);
                    }
                }
                this.actionProcessing(A, disjObj.getLTNode(), level);
            }
        }
        this.matrix = new Boolean[this.nodes.size()][this.nodes.size()];
        for (int i3 = 0; i3 < this.nodes.size(); ++i3) {
            for (int j = 0; j < this.nodes.size(); ++j) {
                this.matrix[i3][j] = false;
            }
        }
        for (LandmarkOrdering o : this.edges) {
            this.matrix[o.getNode1().getIndex()][o.getNode2().getIndex()] = true;
        }
        this.postProcessing();
    }

    @Override
    public ArrayList<LandmarkNode> getNodes() {
        return this.nodes;
    }

    private void postProcessing() {
        ArrayList P = new ArrayList();
        for (int i = 0; i < this.nodes.size(); ++i) {
            if (!this.nodes.get(i).isSingleLiteral()) continue;
            for (int j = 0; j < this.nodes.size(); ++j) {
                ArrayList<LandmarkAction> A;
                if (!this.matrix[j][i].booleanValue() || !this.nodes.get(j).isSingleLiteral() || this.r.verify(A = this.getActions(this.nodes.get(j).getLiteral(), this.nodes.get(i).getLiteral()))) continue;
                this.matrix[j][i] = false;
                for (int ord = 0; ord < this.edges.size(); ++ord) {
                    LandmarkOrdering e = this.edges.get(ord);
                    if (!e.getNode1().isSingleLiteral() || !e.getNode2().isSingleLiteral() || e.getNode1().getIndex() != j || e.getNode2().getIndex() != i) continue;
                    this.edges.remove(ord);
                    --ord;
                }
            }
        }
    }

    private ArrayList<LandmarkAction> getActions(LandmarkFluent l1, LandmarkFluent l2) {
        ArrayList<LandmarkAction> A = new ArrayList<LandmarkAction>();
        for (LandmarkAction a : this.r.getActions()) {
            for (LandmarkFluent pre : a.getPreconditions()) {
                if (l1 != pre || !l2.getTotalProducers().contains(a)) continue;
                A.add(a);
            }
        }
        return A;
    }

    private void actionProcessing(ArrayList<LandmarkAction> A, LandmarkNode g, int level) {
        ArrayList<LMLiteral> I = new ArrayList<LMLiteral>();
        ArrayList<LandmarkFluent> U = new ArrayList<LandmarkFluent>();
        int[] common = new int[this.r.getLiterals().size()];
        for (int i = 0; i < common.length; ++i) {
            common[i] = 0;
        }
        for (LandmarkAction landmarkAction : A) {
            for (LandmarkFluent l : landmarkAction.getPreconditions()) {
                common[l.getIndex()] = common[l.getIndex()] + 1;
            }
        }
        if (A.size() > 0) {
            for (int i = 0; i < common.length; ++i) {
                if (common[i] == A.size()) {
                    I.add(this.r.getIndexLiterals().get(i));
                    continue;
                }
                if (common[i] <= 0) continue;
                U.add(this.r.getIndexLiterals().get(i));
            }
        }
        for (LandmarkFluent landmarkFluent : I) {
            if (!this.r.verify(landmarkFluent)) continue;
            if (this.literalNode.get(landmarkFluent.getIndex()) == -1) {
                this.nodes.add(new LGNode(landmarkFluent));
                this.nodes.get(this.nodes.size() - 1).setIndex(this.nodes.size() - 1);
                this.literalNode.set(landmarkFluent.getIndex(), this.nodes.size() - 1);
            }
            this.edges.add(new LMOrdering(this.nodes.get(this.literalNode.get(landmarkFluent.getIndex())), g, 1));
            if (this.objs.get(landmarkFluent.getLevel()).contains(landmarkFluent)) continue;
            this.objs.get(landmarkFluent.getLevel()).add(landmarkFluent);
        }
        ArrayList<LandmarkSet> D = this.groupLandmarkSet(U, A);
        for (LandmarkSet landmarkSet : D) {
            LandmarkSet d1 = this.findDisjObject(landmarkSet, level);
            if (d1 == null) {
                this.nodes.add(new LGNode(landmarkSet));
                landmarkSet.setLGNode(this.nodes.get(this.nodes.size() - 1));
                this.nodes.get(this.nodes.size() - 1).setIndex(this.nodes.size() - 1);
                this.edges.add(new LMOrdering(this.nodes.get(this.nodes.size() - 1), g, 1));
                this.disjObjs.get(level - 1).add(landmarkSet);
                continue;
            }
            this.edges.add(new LMOrdering(d1.getLTNode(), g, 1));
        }
    }

    private LandmarkSet findDisjObject(LandmarkSet u, int level) {
        for (int i = this.disjObjs.size() - 1; i >= level - 1; --i) {
            for (LandmarkSet obj : this.disjObjs.get(i)) {
                if (u.compareTo(obj) != 0) continue;
                return obj;
            }
        }
        return null;
    }

    private ArrayList<LandmarkSet> groupLandmarkSet(ArrayList<LandmarkFluent> u, ArrayList<LandmarkAction> A) {
        ArrayList<uSet> U = new ArrayList<uSet>();
        Hashtable hashU = new Hashtable();
        for (LandmarkFluent l : u) {
            if (hashU.get(l.getVar().getFuctionName()) == null) {
                U.add(new uSet(l));
                hashU.put(l.getVar().getFuctionName(), U.get(U.size() - 1));
                continue;
            }
            ((LandmarkSet)hashU.get(l.getVar().getFuctionName())).addElement(l);
        }
        ArrayList<LandmarkSet> U1 = new ArrayList<LandmarkSet>(U.size());
        for (LandmarkSet landmarkSet : U) {
            int instances = 0;
            int actions = 0;
            if (landmarkSet.getElements().size() == 1) continue;
            for (LandmarkAction a : A) {
                boolean visited = false;
                for (LandmarkFluent p : a.getPreconditions()) {
                    if (!landmarkSet.match(p)) continue;
                    ++instances;
                    if (visited) continue;
                    ++actions;
                    visited = true;
                }
            }
            if (actions == A.size() && instances == A.size()) {
                U1.add(landmarkSet);
                continue;
            }
            if (actions != A.size() || instances <= A.size()) continue;
            this.analyzeSet(landmarkSet, A, U1);
        }
        return U1;
    }

    private void analyzeSet(LandmarkSet s, ArrayList<LandmarkAction> A, ArrayList<LandmarkSet> U1) {
        int i;
        ArrayList literalProducers = new ArrayList(A.size());
        for (i = 0; i < A.size(); ++i) {
            literalProducers.add(new ArrayList());
        }
        for (i = 0; i < A.size(); ++i) {
            LandmarkAction a = A.get(i);
            for (LandmarkFluent p : a.getPreconditions()) {
                if (!p.getVar().getFuctionName().equals(s.identify()) || !s.getElements().contains(p)) continue;
                ((ArrayList)literalProducers.get(i)).add(p);
            }
        }
        boolean finish = false;
        for (LandmarkFluent l : (ArrayList)literalProducers.get(0)) {
            boolean add = true;
            if (finish) break;
            uSet u = new uSet(l);
            for (i = 1; i < literalProducers.size(); ++i) {
                if (((ArrayList)literalProducers.get(i)).isEmpty()) {
                    finish = true;
                    add = false;
                    break;
                }
                ArrayList actionLiterals = (ArrayList)literalProducers.get(i);
                LandmarkFluent similar = this.equalParameters(l, actionLiterals);
                if (similar == null) {
                    add = false;
                    break;
                }
                actionLiterals.remove(similar);
                u.addElement(similar);
            }
            if (!add) continue;
            U1.add(u);
        }
    }

    private LandmarkFluent equalParameters(LandmarkFluent l, ArrayList<LandmarkFluent> actionLiterals) {
        ArrayList<LandmarkFluent> candidates = new ArrayList<LandmarkFluent>(actionLiterals.size());
        ArrayList<LandmarkFluent> auxCandidates = new ArrayList<LandmarkFluent>(actionLiterals.size());
        String[] p1 = l.getVar().getParams();
        int equalParameters = 0;
        for (LandmarkFluent al : actionLiterals) {
            candidates.add(al);
        }
        for (LandmarkFluent c : candidates) {
            String[] p2 = c.getVar().getParams();
            boolean equal = true;
            for (int i = 0; i < p1.length; ++i) {
                if (p1[i].equals(p2[i])) continue;
                equal = false;
                break;
            }
            if (!equal) continue;
            auxCandidates.add(c);
        }
        if (auxCandidates.size() == 1) {
            return (LandmarkFluent)auxCandidates.get(0);
        }
        if (auxCandidates.size() > 1) {
            candidates = auxCandidates;
        }
        int min = Integer.MAX_VALUE;
        LandmarkFluent candidate = (LandmarkFluent)candidates.get(0);
        for (LandmarkFluent c : candidates) {
            equalParameters = 0;
            for (int i = 0; i < c.getVar().getParams().length; ++i) {
                int j;
                String[] ct = this.groundedTask.getObjectTypes(c.getVar().getParams()[i]);
                String[] lt = this.groundedTask.getObjectTypes(l.getVar().getParams()[i]);
                for (j = 0; j < ct.length && ct[j].equals(lt[j]); ++j) {
                }
                if (j != ct.length - 1) continue;
                ++equalParameters;
            }
            if (min <= equalParameters) continue;
            min = equalParameters;
            candidate = c;
        }
        if (equalParameters == 0) {
            return null;
        }
        return candidate;
    }

    public LandmarkNode getNode(LandmarkFluent l) {
        if (this.literalNode.get(l.getIndex()) != -1) {
            return this.nodes.get(this.literalNode.get(l.getIndex()));
        }
        return null;
    }

    public boolean getReasonableOrdering(LandmarkNode n1, LandmarkNode n2) {
        return this.reasonableOrderings[n1.getIndex()][n2.getIndex()];
    }

    @Override
    public ArrayList<LandmarkOrdering> getReasonableOrderingList() {
        return this.reasonableOrderingsList;
    }

    public ArrayList<LandmarkOrdering> getReasonableGoalOrderingList() {
        return this.reasonableOrderingsGoalsList;
    }

    public String toString() {
        int i;
        String res = "";
        for (LandmarkOrdering o : this.edges) {
            res = res + o.getNode1().toString() + " -> " + o.getNode2().toString() + "\n";
        }
        for (i = 0; i < this.nodes.size(); ++i) {
            for (int j = 0; j < this.nodes.size(); ++j) {
                res = this.matrix[i][j] == true ? res + "1 " : res + "0 ";
            }
            res = res + "\n";
        }
        res = res + "\nMutex matrix: \n";
        for (i = 0; i < this.r.getLiterals().size(); ++i) {
            for (int j = 0; j < this.r.getLiterals().size(); ++j) {
                if (!this.mutexMatrix[i][j]) continue;
                res = res + this.r.getLiterals().get(i) + " <-> " + this.r.getLiterals().get(j) + "\n";
            }
        }
        res = res + "\nReasonable orderings: \n";
        for (i = 0; i < this.nodes.size(); ++i) {
            for (int j = 0; j < this.nodes.size(); ++j) {
                if (!this.reasonableOrderings[i][j]) continue;
                res = res + this.nodes.get(i) + " -> " + this.nodes.get(j) + "\n";
            }
        }
        return res;
    }

    public ArrayList<LandmarkOrdering> getNeccessaryGoalOrderingList() {
        ArrayList<LandmarkOrdering> res = new ArrayList<LandmarkOrdering>();
        for (LandmarkOrdering o : this.edges) {
            if (!o.getNode1().isSingleLiteral() || !o.getNode2().isSingleLiteral() || !o.getNode1().getLiteral().isGoal() || !o.getNode2().getLiteral().isGoal()) continue;
            res.add(o);
        }
        return res;
    }

    @Override
    public ArrayList<LandmarkOrdering> getNeccessaryOrderingList() {
        return this.edges;
    }

    @Override
    public int numGlobalNodes() {
        return this.nodes.size();
    }

    @Override
    public int numTotalNodes() {
        return this.nodes.size();
    }
}

