/*
 * Decompiled with CFR 0.152.
 */
package org.agreement_technologies.service.map_landmarks;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import org.agreement_technologies.common.map_communication.AgentCommunication;
import org.agreement_technologies.common.map_grounding.Action;
import org.agreement_technologies.common.map_grounding.GroundedCond;
import org.agreement_technologies.common.map_grounding.GroundedTask;
import org.agreement_technologies.common.map_grounding.GroundedVar;
import org.agreement_technologies.common.map_landmarks.LandmarkAction;
import org.agreement_technologies.common.map_landmarks.LandmarkFluent;
import org.agreement_technologies.service.map_landmarks.LMAction;
import org.agreement_technologies.service.map_landmarks.LMLiteral;
import org.agreement_technologies.service.map_landmarks.MessageContentRPG;
import org.agreement_technologies.service.map_landmarks.RPGMessageContent;

public class RPG {
    private GroundedTask groundedTask;
    private AgentCommunication comm;
    private ArrayList<LMLiteral> literals;
    private ArrayList<ArrayList<LMLiteral>> litLevels;
    private ArrayList<ArrayList<LandmarkAction>> actLevels;
    private ArrayList<LandmarkFluent> goals;
    private ArrayList<LandmarkAction> actions;
    private Hashtable<String, GroundedVar> vars;
    private Hashtable<String, LMLiteral> hashLiterals;
    private Hashtable<Integer, LMLiteral> indexLiterals;
    private Hashtable<String, Integer> hashAgents;
    private Hashtable<Integer, Integer> RPG;

    public RPG(GroundedTask gt, AgentCommunication c) {
        this.groundedTask = gt;
        this.comm = c;
        this.vars = new Hashtable();
        this.hashLiterals = new Hashtable();
        this.indexLiterals = new Hashtable();
        int maxRPGLevel = 0;
        this.goals = new ArrayList();
        for (GroundedCond gg : gt.getGlobalGoals()) {
            LMLiteral l = new LMLiteral(gg.getVar(), gg.getValue(), gg.getVar().getMinTime(gg.getValue()), gt.getAgentNames(), true);
            if (this.vars.get(l.getVar().toString()) == null) {
                this.vars.put(l.getVar().toString(), l.getVar());
            }
            this.hashLiterals.put(l.toString(), l);
            this.goals.add(l);
            if (gg.getVar().getMinTime(gg.getValue()) <= maxRPGLevel) continue;
            maxRPGLevel = gg.getVar().getMinTime(gg.getValue());
        }
        this.actions = new ArrayList();
        for (Action a : gt.getActions()) {
            this.actions.add(new LMAction(a, this.vars, this.hashLiterals, this));
        }
        this.literals = new ArrayList();
        this.litLevels = new ArrayList(maxRPGLevel + 1);
        for (int i = 0; i < maxRPGLevel + 1; ++i) {
            this.litLevels.add(new ArrayList());
        }
        for (GroundedVar v : gt.getVars()) {
            for (String val : v.getReachableValues()) {
                if (v.getMinTime(val) == -1) continue;
                this.addLiteral(v, val, v.getMinTime(val));
            }
        }
        this.actLevels = new ArrayList(maxRPGLevel);
        for (int i = 0; i < maxRPGLevel; ++i) {
            this.actLevels.add(new ArrayList());
        }
        for (LandmarkAction a : this.actions) {
            if (a.getLevel() == -1 || a.getLevel() >= maxRPGLevel) continue;
            this.addAction(a, a.getLevel());
        }
        for (int i = 0; i < this.literals.size(); ++i) {
            this.literals.get(i).setIndex(i);
            this.indexLiterals.put(i, this.literals.get(i));
        }
        for (LMLiteral prl : this.literals) {
            ArrayList<LandmarkAction> producers = new ArrayList<LandmarkAction>();
            ArrayList<LandmarkAction> totalProducers = new ArrayList<LandmarkAction>();
            block9: for (LandmarkAction pra : this.actions) {
                for (LandmarkFluent eff : pra.getEffects()) {
                    if (prl.getVar() != eff.getVar() || !prl.getValue().equals(eff.getValue())) continue;
                    if (pra.getLevel() < prl.getLevel()) {
                        producers.add(pra);
                    }
                    totalProducers.add(pra);
                    continue block9;
                }
            }
            prl.setProducers(producers);
            prl.setTotalProducers(totalProducers);
        }
        if (this.groundedTask.getAgentNames().length > 1) {
            this.arrangeRPG();
        }
    }

    private void arrangeRPG() {
        this.RPG = new Hashtable();
        int level = 0;
        ArrayList<Object> receivedData = new ArrayList();
        ArrayList<MessageContentRPG> totalReceivedData = new ArrayList<MessageContentRPG>();
        Hashtable<String, Integer> hashReceivedData = new Hashtable<String, Integer>();
        this.hashAgents = new Hashtable();
        ArrayList<LMLiteral> fluentsNoProducers = new ArrayList<LMLiteral>();
        for (LMLiteral l : this.literals) {
            if (!l.getProducers().isEmpty()) continue;
            fluentsNoProducers.add(l);
        }
        ArrayList act = new ArrayList();
        ArrayList<LandmarkAction> auxAct = new ArrayList<LandmarkAction>();
        boolean stop = false;
        int unchangedAgents = 0;
        int i = 0;
        for (String ag : this.comm.getOtherAgents()) {
            this.hashAgents.put(ag, i);
            ++i;
        }
        ArrayList dataToSend = new ArrayList();
        for (i = 0; i < this.groundedTask.getAgentNames().length - 1; ++i) {
            dataToSend.add(new ArrayList());
        }
        while (!stop) {
            if (this.comm.batonAgent()) {
                boolean changed = false;
                for (LMLiteral lMLiteral : this.litLevels.get(0)) {
                    this.RPG.put(lMLiteral.getIndex(), level);
                }
                for (LMLiteral lMLiteral : fluentsNoProducers) {
                    if (this.RPG.get(lMLiteral.getIndex()) != null && this.RPG.get(lMLiteral.getIndex()) <= lMLiteral.getLevel()) continue;
                    this.RPG.put(lMLiteral.getIndex(), lMLiteral.getLevel());
                }
                for (LandmarkAction landmarkAction : this.actions) {
                    auxAct.add(landmarkAction);
                }
                boolean moreLiterals = false;
                level = 0;
                while (act.size() != auxAct.size() || moreLiterals) {
                    ++level;
                    act = auxAct;
                    auxAct = new ArrayList();
                    moreLiterals = false;
                    for (LandmarkAction landmarkAction : act) {
                        int maxLevel = 0;
                        boolean reached = true;
                        for (LandmarkFluent pre : landmarkAction.getPreconditions()) {
                            if (this.RPG.get(pre.getIndex()) != null && this.RPG.get(pre.getIndex()) >= level) {
                                moreLiterals = true;
                            }
                            if (this.RPG.get(pre.getIndex()) == null || this.RPG.get(pre.getIndex()) >= level) {
                                reached = false;
                                break;
                            }
                            if (this.RPG.get(pre.getIndex()) <= maxLevel) continue;
                            maxLevel = this.RPG.get(pre.getIndex());
                        }
                        if (reached) {
                            landmarkAction.setLevel(maxLevel);
                            for (LandmarkFluent eff : landmarkAction.getEffects()) {
                                Integer effLevel = this.RPG.get(eff.getIndex());
                                if (effLevel != null && effLevel <= maxLevel + 1) continue;
                                this.RPG.put(eff.getIndex(), maxLevel + 1);
                                ArrayList<String> fluentAgents = eff.getAgents();
                                if (fluentAgents.size() <= 1) continue;
                                if (!changed) {
                                    changed = true;
                                }
                                for (String ag : fluentAgents) {
                                    if (ag.equals(this.groundedTask.getAgentName())) continue;
                                    ((ArrayList)dataToSend.get(this.hashAgents.get(ag))).add(new MessageContentRPG(eff.getVar().toString(), eff.getValue(), maxLevel + 1));
                                }
                            }
                            continue;
                        }
                        auxAct.add(landmarkAction);
                    }
                }
                unchangedAgents = changed ? 0 : ++unchangedAgents;
                if (unchangedAgents == this.groundedTask.getAgentNames().length) {
                    stop = true;
                }
                for (String string : this.comm.getOtherAgents()) {
                    this.comm.sendMessage(string, new RPGMessageContent((ArrayList)dataToSend.get(this.hashAgents.get(string)), changed), false);
                }
            } else {
                RPGMessageContent content = (RPGMessageContent)this.comm.receiveMessage(this.comm.getBatonAgent(), false);
                unchangedAgents = content.isRPGChanged() ? 0 : ++unchangedAgents;
                if (unchangedAgents == this.groundedTask.getAgentNames().length) {
                    stop = true;
                }
                if ((receivedData = content.getData()).size() > 0) {
                    for (MessageContentRPG messageContentRPG : receivedData) {
                        if (hashReceivedData.get(messageContentRPG.getFluent()) == null) {
                            totalReceivedData.add(messageContentRPG);
                            hashReceivedData.put(messageContentRPG.getFluent(), totalReceivedData.size() - 1);
                            continue;
                        }
                        MessageContentRPG oldData = (MessageContentRPG)totalReceivedData.get((Integer)hashReceivedData.get(messageContentRPG.getFluent()));
                        if (messageContentRPG.getLevel() >= oldData.getLevel()) continue;
                        oldData.setLevel(messageContentRPG.getLevel());
                    }
                }
                for (MessageContentRPG messageContentRPG : receivedData) {
                    if (this.RPG.get(this.hashLiterals.get(messageContentRPG.getFluent()).getIndex()) != null && this.RPG.get(this.hashLiterals.get(messageContentRPG.getFluent()).getIndex()) <= messageContentRPG.getLevel()) continue;
                    this.RPG.put(this.hashLiterals.get(messageContentRPG.getFluent()).getIndex(), messageContentRPG.getLevel());
                }
            }
            this.comm.passBaton();
        }
        for (ArrayList<LMLiteral> arrayList : this.litLevels) {
            arrayList.clear();
        }
        for (ArrayList<Object> arrayList : this.actLevels) {
            arrayList.clear();
        }
        for (LMLiteral lMLiteral : this.literals) {
            if (this.RPG.get(lMLiteral.getIndex()) == null) {
                System.out.println("Agent " + this.comm.getThisAgentName() + " does not have an assigned RPG level for literal " + lMLiteral.toString());
            }
            if (this.RPG.get(lMLiteral.getIndex()) < this.litLevels.size()) {
                this.litLevels.get(this.RPG.get(lMLiteral.getIndex())).add(lMLiteral);
            }
            lMLiteral.setLevel(this.RPG.get(lMLiteral.getIndex()));
            ArrayList<LandmarkAction> producers = lMLiteral.getProducers();
            producers.clear();
            for (LandmarkAction prod : lMLiteral.getTotalProducers()) {
                if (prod.getLevel() >= lMLiteral.getLevel()) continue;
                producers.add(prod);
            }
        }
        for (LandmarkAction landmarkAction : this.actions) {
            if (landmarkAction.getLevel() >= this.actLevels.size()) continue;
            this.actLevels.get(landmarkAction.getLevel()).add(landmarkAction);
        }
    }

    public Hashtable<String, LMLiteral> getHashLiterals() {
        return this.hashLiterals;
    }

    private void addLiteral(GroundedVar v, String val, int t) {
        LMLiteral l;
        String[] agents = this.getAgents(v, val);
        if (this.hashLiterals.get(v.toString() + " " + val) == null) {
            l = new LMLiteral(v, val, t, agents, false);
            this.hashLiterals.put(l.toString(), l);
        } else {
            l = this.hashLiterals.get(v.toString() + " " + val);
        }
        this.literals.add(l);
        if (t < this.litLevels.size()) {
            if (this.litLevels.get(t) == null) {
                this.litLevels.add(t, new ArrayList());
            }
            this.litLevels.get(t).add(l);
        }
    }

    public String[] getAgents(GroundedVar v, String val) {
        ArrayList<String> agents = new ArrayList<String>();
        for (int i = 0; i < this.groundedTask.getAgentNames().length; ++i) {
            if (this.groundedTask.getAgentNames()[i].equals(this.groundedTask.getAgentName())) {
                agents.add(this.groundedTask.getAgentNames()[i]);
                continue;
            }
            if (!v.shareable(val, this.groundedTask.getAgentNames()[i])) continue;
            agents.add(this.groundedTask.getAgentNames()[i]);
        }
        String[] agentsArray = new String[agents.size()];
        int pos = 0;
        Iterator i$ = agents.iterator();
        while (i$.hasNext()) {
            String ag;
            agentsArray[pos] = ag = (String)i$.next();
            ++pos;
        }
        return agentsArray;
    }

    private void addAction(LandmarkAction a, int t) {
        if (this.actLevels.get(t) == null) {
            this.actLevels.add(t, new ArrayList());
        }
        this.actLevels.get(t).add(a);
    }

    public boolean verify(LandmarkFluent p) {
        boolean found;
        if (p.getLevel() == 0) {
            return true;
        }
        Hashtable<Integer, Boolean> RPGp = new Hashtable<Integer, Boolean>();
        Hashtable<Integer, Boolean> hashGoals = new Hashtable<Integer, Boolean>();
        int pendingGoals = this.goals.size();
        for (LandmarkFluent g : this.goals) {
            hashGoals.put(g.getIndex(), Boolean.TRUE);
        }
        for (LMLiteral il : this.litLevels.get(0)) {
            RPGp.put(il.getIndex(), Boolean.TRUE);
        }
        ArrayList Ap = new ArrayList();
        ArrayList<LandmarkAction> auxAp = new ArrayList<LandmarkAction>();
        for (LandmarkAction a : this.actions) {
            found = false;
            for (LandmarkFluent eff : a.getEffects()) {
                if (eff != p) continue;
                found = true;
            }
            if (found) continue;
            auxAp.add(a);
        }
        while (pendingGoals > 0 && Ap.size() != auxAp.size()) {
            Ap = auxAp;
            auxAp = new ArrayList();
            for (LandmarkAction a : Ap) {
                found = true;
                for (LandmarkFluent pre : a.getPreconditions()) {
                    if (RPGp.get(pre.getIndex()) != null) continue;
                    found = false;
                    break;
                }
                if (found) {
                    for (LandmarkFluent eff : a.getEffects()) {
                        if (hashGoals.get(eff.getIndex()) != null && hashGoals.get(eff.getIndex()) == Boolean.TRUE) {
                            hashGoals.put(eff.getIndex(), Boolean.FALSE);
                            --pendingGoals;
                        }
                        RPGp.put(eff.getIndex(), Boolean.TRUE);
                    }
                    continue;
                }
                auxAp.add(a);
            }
        }
        return pendingGoals != 0;
    }

    public boolean verify(ArrayList<LandmarkAction> ac) {
        Hashtable<Integer, Boolean> RPGp = new Hashtable<Integer, Boolean>();
        Hashtable<Integer, Boolean> hashGoals = new Hashtable<Integer, Boolean>();
        int pendingGoals = this.goals.size();
        for (LandmarkFluent g : this.goals) {
            hashGoals.put(g.getIndex(), Boolean.TRUE);
        }
        for (LMLiteral il : this.litLevels.get(0)) {
            RPGp.put(il.getIndex(), Boolean.TRUE);
        }
        ArrayList Aac = new ArrayList();
        ArrayList<LandmarkAction> auxAac = new ArrayList<LandmarkAction>();
        for (LandmarkAction a : this.actions) {
            if (ac.contains(a)) continue;
            auxAac.add(a);
        }
        while (pendingGoals > 0 && Aac.size() != auxAac.size()) {
            Aac = auxAac;
            auxAac = new ArrayList();
            for (LandmarkAction a : Aac) {
                boolean found = true;
                for (LandmarkFluent pre : a.getPreconditions()) {
                    if (RPGp.get(pre.getIndex()) != null) continue;
                    found = false;
                    break;
                }
                if (found) {
                    for (LandmarkFluent eff : a.getEffects()) {
                        if (hashGoals.get(eff.getIndex()) != null && hashGoals.get(eff.getIndex()) == Boolean.TRUE) {
                            hashGoals.put(eff.getIndex(), Boolean.FALSE);
                            --pendingGoals;
                        }
                        RPGp.put(eff.getIndex(), Boolean.TRUE);
                    }
                    continue;
                }
                auxAac.add(a);
            }
        }
        return pendingGoals != 0;
    }

    public boolean verifySingleLandmark(LMLiteral p) {
        ArrayList<LandmarkAction> ap = new ArrayList<LandmarkAction>();
        if (p != null) {
            if (p.getTotalProducers().isEmpty()) {
                ap.addAll(this.actions);
            } else {
                for (LandmarkAction a : this.actions) {
                    if (p.getTotalProducers().contains(a)) continue;
                    ap.add(a);
                }
            }
        } else {
            ap.addAll(this.actions);
        }
        return this.verifyMA(ap);
    }

    public boolean verifyDisjunctiveLandmark(ArrayList<LMLiteral> disj) {
        ArrayList<LandmarkAction> ap = new ArrayList<LandmarkAction>();
        ArrayList<LandmarkAction> producers = new ArrayList<LandmarkAction>();
        for (LMLiteral p : disj) {
            for (LandmarkAction prod : p.getTotalProducers()) {
                if (producers.contains(prod)) continue;
                producers.add(prod);
            }
        }
        if (producers.size() == 0) {
            ap.addAll(this.actions);
        } else {
            for (LandmarkAction a : this.actions) {
                if (producers.contains(a)) continue;
                ap.add(a);
            }
        }
        return this.verifyMA(ap);
    }

    public boolean verifyEdge(ArrayList<LandmarkAction> A) {
        ArrayList<LandmarkAction> ap = new ArrayList<LandmarkAction>();
        for (LandmarkAction act : this.actions) {
            boolean found = false;
            for (LandmarkAction a : A) {
                if (!a.getName().equals(act.getName())) continue;
                found = true;
                break;
            }
            if (found) continue;
            ap.add(act);
        }
        return this.verifyMA(ap);
    }

    /*
     * Exception decompiling
     */
    public boolean verifyMA(ArrayList<LandmarkAction> act) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [7[DOLOOP]], but top level block is 24[UNCONDITIONALDOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public ArrayList<ArrayList<LMLiteral>> getLitLevels() {
        return this.litLevels;
    }

    public ArrayList<ArrayList<LandmarkAction>> getActLevels() {
        return this.actLevels;
    }

    public ArrayList<LandmarkAction> getActions() {
        return this.actions;
    }

    public ArrayList<LandmarkFluent> getGoals() {
        return this.goals;
    }

    public ArrayList<LMLiteral> getLiterals() {
        return this.literals;
    }

    public LMLiteral getLiteral(String id) {
        return this.hashLiterals.get(id);
    }

    public Hashtable<Integer, LMLiteral> getIndexLiterals() {
        return this.indexLiterals;
    }

    public ArrayList<LMLiteral> getInitialState() {
        return this.litLevels.get(0);
    }

    public String toString() {
        int i;
        String res = new String();
        for (i = 0; i < this.litLevels.size(); ++i) {
            int c = 0;
            for (int key : this.RPG.keySet()) {
                if (this.RPG.get(key) != i) continue;
                ++c;
            }
            res = res + c + " ";
        }
        res = res + "\nLiteral list:";
        res = res + "\n-------------\n";
        for (i = 0; i < this.litLevels.size(); ++i) {
            for (int key : this.RPG.keySet()) {
                if (this.RPG.get(key) != i) continue;
                res = res + "[" + i + "] " + this.literals.get(key).toString() + "\n";
            }
        }
        return res;
    }
}

