/*
 * Decompiled with CFR 0.152.
 */
package org.agreement_technologies.service.map_landmarks;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Hashtable;
import org.agreement_technologies.common.map_communication.AgentCommunication;
import org.agreement_technologies.common.map_grounding.GroundedTask;
import org.agreement_technologies.common.map_landmarks.LandmarkAction;
import org.agreement_technologies.common.map_landmarks.LandmarkFluent;
import org.agreement_technologies.common.map_landmarks.LandmarkGraph;
import org.agreement_technologies.common.map_landmarks.LandmarkNode;
import org.agreement_technologies.common.map_landmarks.LandmarkOrdering;
import org.agreement_technologies.common.map_landmarks.LandmarkSet;
import org.agreement_technologies.service.map_landmarks.GlobalIdInfo;
import org.agreement_technologies.service.map_landmarks.LGNode;
import org.agreement_technologies.service.map_landmarks.LMLiteral;
import org.agreement_technologies.service.map_landmarks.LMLiteralInfo;
import org.agreement_technologies.service.map_landmarks.LMOrdering;
import org.agreement_technologies.service.map_landmarks.MessageContentGlobalId;
import org.agreement_technologies.service.map_landmarks.MessageContentLandmarkGraph;
import org.agreement_technologies.service.map_landmarks.MessageContentLandmarkSharing;
import org.agreement_technologies.service.map_landmarks.MessageContentPostProcessing;
import org.agreement_technologies.service.map_landmarks.RPG;
import org.agreement_technologies.service.map_landmarks.uSet;

public class MALandmarkGraph
implements LandmarkGraph {
    private ArrayList<LandmarkNode> nodes;
    private ArrayList<LandmarkOrdering> edges;
    private RPG RPG;
    private final Boolean[][] matrix;
    private ArrayList<Integer> literalNode;
    private ArrayList<ArrayList<LandmarkNode>> objs;
    private boolean[][] reasonableOrderings;
    private ArrayList<LandmarkOrdering> reasonableOrderingsList;
    private ArrayList<LandmarkOrdering> reasonableOrderingsGoalsList;
    private final GroundedTask groundedTask;
    private final AgentCommunication comm;
    private ArrayList<LandmarkFluent> I;
    private ArrayList<LandmarkFluent> U;
    private ArrayList<LandmarkSet> D;
    private ArrayList<LMLiteralInfo> commonToSend;
    private ArrayList<LMLiteralInfo> nonCommonToSend;
    private final Hashtable<String, LandmarkNode> hashLGNodes;
    private Hashtable<String, Integer> hashAgents;
    private ArrayList<LandmarkAction> A;
    public int totalLandmarks;
    private Hashtable<Integer, ArrayList<String>> otherAgentsLandmarks;
    private int globalIndex = 0;

    public MALandmarkGraph(GroundedTask gt, AgentCommunication c, RPG r, ArrayList<LandmarkFluent> g) {
        this.groundedTask = gt;
        this.comm = c;
        this.nodes = new ArrayList();
        this.edges = new ArrayList();
        this.RPG = r;
        this.D = new ArrayList();
        int i = 0;
        this.hashAgents = new Hashtable();
        for (String ag : this.groundedTask.getAgentNames()) {
            this.hashAgents.put(ag, i);
            ++i;
        }
        ArrayList<MessageContentLandmarkGraph> received = new ArrayList<MessageContentLandmarkGraph>();
        this.literalNode = new ArrayList(r.getLiterals().size());
        for (i = 0; i < r.getLiterals().size(); ++i) {
            this.literalNode.add(-1);
        }
        this.objs = new ArrayList(r.getLitLevels().size());
        for (i = 0; i < r.getLitLevels().size(); ++i) {
            this.objs.add(new ArrayList());
        }
        for (LandmarkFluent goal : g) {
            LGNode gn = new LGNode(goal);
            this.globalIndex = gn.setGlobalId(this.globalIndex);
            this.nodes.add(gn);
            this.nodes.get(this.nodes.size() - 1).setIndex(this.nodes.size() - 1);
            this.literalNode.set(goal.getIndex(), this.nodes.size() - 1);
            if (goal.getLevel() < 0) {
                throw new AssertionError((Object)("Goal not achieved: " + goal));
            }
            this.objs.get(goal.getLevel()).add(gn);
        }
        int level = r.getLitLevels().size() - 1;
        this.I = new ArrayList();
        this.U = new ArrayList();
        this.commonToSend = new ArrayList();
        this.nonCommonToSend = new ArrayList();
        int remainingObjects = this.objs.get(level).size();
        block4: while (level > 0) {
            if (this.comm.batonAgent()) {
                if (this.objs.get(level).size() > 0) {
                    for (i = 0; i < this.objs.get(level).size(); ++i) {
                        LandmarkNode obj = this.objs.get(level).get(i);
                        if (obj.getAgents().size() > 1) {
                            for (String ag : obj.getAgents()) {
                                if (ag.equals(this.groundedTask.getAgentName())) continue;
                                this.comm.sendMessage(ag, new MessageContentLandmarkGraph(null, obj.identify(), null, null, null, null, this.groundedTask.getAgentName(), null, 0), false);
                            }
                        }
                        this.getProducers(obj, null);
                        this.I.clear();
                        this.U.clear();
                        this.D.clear();
                        if (this.A.size() > 0) {
                            this.groupCommonNonCommonPrecs(this.A);
                        }
                        received.clear();
                        for (int j = 0; j < obj.getAgents().size() - 1; ++j) {
                            received.add((MessageContentLandmarkGraph)this.comm.receiveMessage(false));
                        }
                        this.groupMACommonNonCommonPrecs(received, this.A.size() != 0, obj.getAgents());
                        for (String ag : obj.getAgents()) {
                            if (ag.equals(this.groundedTask.getAgentName())) continue;
                            this.comm.sendMessage(ag, new MessageContentLandmarkGraph(this.globalIndex, null, this.commonToSend, this.nonCommonToSend, null, null, this.groundedTask.getAgentName(), null, 0), false);
                        }
                        for (String ag : this.comm.getOtherAgents()) {
                            if (obj.getAgents().contains(ag)) continue;
                            this.comm.sendMessage(ag, new MessageContentLandmarkGraph(this.globalIndex, obj.identify(), this.commonToSend, this.nonCommonToSend, null, null, this.groundedTask.getAgentName(), null, 1), false);
                        }
                        for (LMLiteralInfo cp : this.commonToSend) {
                            this.verifyCommonPrec(cp, obj);
                        }
                        for (LMLiteralInfo ncp : this.nonCommonToSend) {
                            this.verifyNonCommonPrec(ncp, this.commonToSend, obj, level);
                        }
                    }
                    this.objs.get(level).clear();
                }
            } else if (remainingObjects > 0) {
                for (i = remainingObjects; i > 0; --i) {
                    LandmarkNode newNode;
                    ArrayList<LMLiteralInfo> nonCommonPrecs;
                    ArrayList<LMLiteralInfo> commonPrecs;
                    MessageContentLandmarkGraph m = (MessageContentLandmarkGraph)this.comm.receiveMessage(this.comm.getBatonAgent(), false);
                    if (m.getMessageType() == 0) {
                        int messageType;
                        String l = m.getLiteral();
                        LandmarkNode obj = this.locateLGNode(l, level);
                        this.getProducers(obj, l);
                        this.I.clear();
                        this.U.clear();
                        this.D.clear();
                        if (this.A.size() > 0) {
                            this.groupCommonNonCommonPrecs(this.A);
                            messageType = 0;
                        } else {
                            messageType = 5;
                        }
                        this.commonToSend.clear();
                        for (LandmarkFluent li : this.I) {
                            this.commonToSend.add(new LMLiteralInfo(li, this.groundedTask.getAgentName(), li.getAgents()));
                        }
                        this.nonCommonToSend.clear();
                        for (LandmarkSet u : this.D) {
                            this.nonCommonToSend.add(new LMLiteralInfo(u.identify(), obj.getAgents()));
                        }
                        this.comm.sendMessage(this.comm.getBatonAgent(), new MessageContentLandmarkGraph(null, null, this.commonToSend, this.nonCommonToSend, null, null, this.groundedTask.getAgentName(), null, messageType), false);
                        MessageContentLandmarkGraph precsMsg = (MessageContentLandmarkGraph)this.comm.receiveMessage(this.comm.getBatonAgent(), false);
                        this.globalIndex = precsMsg.getGlobalIndex();
                        commonPrecs = precsMsg.getLiterals();
                        nonCommonPrecs = precsMsg.getDisjunctions();
                        for (LMLiteralInfo cp : commonPrecs) {
                            this.verifyCommonPrec(cp, obj);
                        }
                        for (LMLiteralInfo ncp : nonCommonPrecs) {
                            this.verifyNonCommonPrec(ncp, commonPrecs, obj, level);
                        }
                        this.removeObject(obj, level);
                        continue;
                    }
                    if (m.getMessageType() != 1) continue;
                    this.globalIndex = m.getGlobalIndex();
                    commonPrecs = m.getLiterals();
                    nonCommonPrecs = m.getDisjunctions();
                    for (LMLiteralInfo cp : commonPrecs) {
                        LMLiteral p = r.getLiteral(cp.getLiteral());
                        if (cp.getLevel() != 0 && !cp.isGoal() && !r.verifySingleLandmark(p) || p == null) continue;
                        if (this.literalNode.get(p.getIndex()) == -1) {
                            this.nodes.add(new LGNode(p));
                            this.nodes.get(this.nodes.size() - 1).setIndex(this.nodes.size() - 1);
                            this.literalNode.set(p.getIndex(), this.nodes.size() - 1);
                            newNode = this.nodes.get(this.nodes.size() - 1);
                        } else {
                            newNode = this.nodes.get(this.literalNode.get(p.getIndex()));
                        }
                        if (this.objs.get(p.getLevel()).contains(newNode)) continue;
                        this.objs.get(p.getLevel()).add(newNode);
                    }
                    for (LMLiteralInfo ncp : nonCommonPrecs) {
                        String func = ncp.getFunction();
                        LandmarkSet d = this.locateDisjunction(func, commonPrecs);
                        ArrayList<LandmarkFluent> dlc = d != null ? d.getElements() : new ArrayList();
                        if (d == null || !ncp.getAgents().contains(this.groundedTask.getAgentName())) continue;
                        newNode = this.findDisjunctiveLandmarkNode(d);
                        if (newNode == null) {
                            newNode = new LGNode(d);
                            this.nodes.add(newNode);
                            d.setLGNode(newNode);
                            newNode.setIndex(this.nodes.size() - 1);
                            newNode.setAgents(ncp.getAgents());
                            newNode = this.nodes.get(this.nodes.size() - 1);
                        }
                        if (this.objs.get(level - 1).contains(newNode)) continue;
                        this.objs.get(level - 1).add(newNode);
                    }
                }
            }
            this.comm.passBaton();
            int visited = 1;
            while (true) {
                if (this.comm.batonAgent()) {
                    if (this.objs.get(level).size() > 0) {
                        for (String ag : this.comm.getOtherAgents()) {
                            this.comm.sendMessage(ag, new MessageContentLandmarkGraph(null, null, null, null, null, null, null, this.objs.get(level).size(), 0), false);
                        }
                        continue block4;
                    }
                    if (visited < this.groundedTask.getAgentNames().length) {
                        for (String ag : this.comm.getOtherAgents()) {
                            this.comm.sendMessage(ag, new MessageContentLandmarkGraph(null, null, null, null, null, null, null, this.objs.get(level).size(), 7), false);
                        }
                        ++visited;
                        this.comm.passBaton();
                        continue;
                    }
                    if (level > 0) {
                        for (String ag : this.comm.getOtherAgents()) {
                            this.comm.sendMessage(ag, new MessageContentLandmarkGraph(null, null, null, null, null, null, null, this.objs.get(level - 1).size(), 6), false);
                        }
                        if (this.objs.get(--level).size() > 0) continue block4;
                        visited = 1;
                        this.comm.passBaton();
                        continue;
                    }
                    for (String ag : this.comm.getOtherAgents()) {
                        this.comm.sendMessage(ag, new MessageContentLandmarkGraph(null, null, null, null, null, null, null, null, 8), false);
                    }
                    continue block4;
                }
                MessageContentLandmarkGraph remainingObjectsMsg = (MessageContentLandmarkGraph)this.comm.receiveMessage(this.comm.getBatonAgent(), false);
                if (remainingObjectsMsg.getMessageType() == 8) continue block4;
                remainingObjects = remainingObjectsMsg.getNextLevelSize();
                if (remainingObjectsMsg.getMessageType() == 7) {
                    ++visited;
                    this.comm.passBaton();
                    continue;
                }
                if (remainingObjectsMsg.getMessageType() != 6) continue block4;
                --level;
                if (remainingObjects > 0) continue block4;
                visited = 1;
                this.comm.passBaton();
            }
        }
        this.hashLGNodes = new Hashtable();
        this.matrix = new Boolean[this.nodes.size()][this.nodes.size()];
        for (i = 0; i < this.nodes.size(); ++i) {
            if (this.nodes.get(i).isSingleLiteral()) {
                this.hashLGNodes.put(this.nodes.get(i).getLiteral().toString(), this.nodes.get(i));
            }
            for (int j = 0; j < this.nodes.size(); ++j) {
                this.matrix[i][j] = false;
            }
        }
        for (LandmarkOrdering o : this.edges) {
            this.matrix[o.getNode1().getIndex()][o.getNode2().getIndex()] = true;
        }
        this.MAPostProcessing();
        this.computeAccessibilityMatrix();
        this.setGlobalIndexes();
        this.setAntecessorLandmarks();
        this.sharePrivateLandmarks();
        int count = 0;
        for (LandmarkNode n : this.nodes) {
            if (!n.isSingleLiteral() || n.getLiteral().isGoal() || n.getLiteral().getLevel() == 0) continue;
            ++count;
        }
    }

    private void setAntecessorLandmarks() {
        for (LandmarkNode n : this.nodes) {
            if (!n.isSingleLiteral() || n.getLiteral().getLevel() == 0) continue;
            ArrayList<Integer> antecessors = new ArrayList<Integer>();
            for (int i = 0; i < this.nodes.size(); ++i) {
                if (!this.matrix[i][n.getIndex()].booleanValue() || !this.nodes.get(i).isSingleLiteral()) continue;
                antecessors.add(i);
            }
            n.setAntecessors(antecessors);
        }
    }

    private void setGlobalIndexes() {
        for (int iter = 0; iter < this.comm.getAgentList().size(); ++iter) {
            if (this.comm.batonAgent()) {
                ArrayList<MessageContentGlobalId> messages = new ArrayList<MessageContentGlobalId>();
                ArrayList contents = new ArrayList();
                for (int i = 0; i < this.comm.numAgents(); ++i) {
                    contents.add(new ArrayList());
                }
                for (LandmarkNode landmarkNode : this.nodes) {
                    if (landmarkNode.getGlobalId() != -1 || !landmarkNode.isSingleLiteral()) continue;
                    this.globalIndex = landmarkNode.setGlobalId(this.globalIndex);
                    if (landmarkNode.getAgents().size() <= 1) continue;
                    for (String name : landmarkNode.getAgents()) {
                        if (name.equals(this.comm.getThisAgentName())) continue;
                        ((ArrayList)contents.get(this.comm.getAgentIndex(name))).add(new GlobalIdInfo(landmarkNode.getLiteral().toString(), this.globalIndex - 1));
                    }
                }
                for (ArrayList arrayList : contents) {
                    messages.add(new MessageContentGlobalId(arrayList));
                }
                for (MessageContentGlobalId messageContentGlobalId : messages) {
                    messageContentGlobalId.setCurrentGlobalIndex(this.globalIndex);
                }
                for (String string : this.comm.getOtherAgents()) {
                    this.comm.sendMessage(string, (Serializable)messages.get(this.comm.getAgentIndex(string)), false);
                }
            } else {
                MessageContentGlobalId indexes = (MessageContentGlobalId)this.comm.receiveMessage(this.comm.getBatonAgent(), false);
                for (GlobalIdInfo m : indexes.getLiterals()) {
                    this.hashLGNodes.get(m.getLiteral()).setGlobalId(m.getGlobalId());
                }
                this.globalIndex = indexes.getCurrentGlobalIndex();
            }
            this.comm.passBaton();
        }
    }

    private void sharePrivateLandmarks() {
        int agentsDone = 0;
        boolean[] batonAgents = new boolean[this.comm.getAgentList().size()];
        for (int i = 0; i < batonAgents.length; ++i) {
            batonAgents[i] = false;
        }
        ArrayList receivedLandmarks = new ArrayList();
        ArrayList dataToSend = new ArrayList();
        for (String ag : this.comm.getAgentList()) {
            dataToSend.add(new ArrayList());
        }
        while (agentsDone < this.comm.getAgentList().size()) {
            if (this.comm.batonAgent()) {
                for (LandmarkNode n : this.nodes) {
                    if (!n.isSingleLiteral() || n.getLiteral().getLevel() == 0 || n.getLiteral().isGoal()) continue;
                    boolean alreadySent = false;
                    for (String label : n.getLiteral().getAgents()) {
                        if (!batonAgents[this.comm.getAgentIndex(label)]) continue;
                        alreadySent = true;
                        break;
                    }
                    if (alreadySent) continue;
                    for (String ag : this.comm.getOtherAgents()) {
                        if (n.getLiteral().getAgents().contains(ag)) continue;
                        ((ArrayList)dataToSend.get(this.comm.getAgentIndex(ag))).add(new MessageContentLandmarkSharing(n.getGlobalId(), n.getLiteral().getAgents()));
                    }
                }
                for (String ag : this.comm.getOtherAgents()) {
                    this.comm.sendMessage(ag, (Serializable)dataToSend.get(this.comm.getAgentIndex(ag)), false);
                }
            } else {
                ArrayList received = (ArrayList)this.comm.receiveMessage(this.comm.getBatonAgent(), false);
                receivedLandmarks.addAll(received);
            }
            batonAgents[this.comm.getAgentIndex((String)this.comm.getBatonAgent())] = true;
            this.comm.passBaton();
            ++agentsDone;
        }
        this.otherAgentsLandmarks = new Hashtable();
        for (MessageContentLandmarkSharing m : receivedLandmarks) {
            this.otherAgentsLandmarks.put(m.getLiteralId(), m.getAgents());
        }
        this.totalLandmarks = 0;
        for (LandmarkNode n : this.nodes) {
            if (!n.isSingleLiteral() || n.getLiteral().getLevel() == 0) continue;
            ++this.totalLandmarks;
        }
        this.totalLandmarks += this.otherAgentsLandmarks.keySet().size();
    }

    private void verifyCommonPrec(LMLiteralInfo commonPrec, LandmarkNode obj) {
        LMLiteral p = this.RPG.getLiteral(commonPrec.getLiteral());
        if ((commonPrec.getLevel() == 0 || commonPrec.isGoal() || this.RPG.verifySingleLandmark(p)) && p != null) {
            LandmarkNode newNode;
            if (this.literalNode.get(p.getIndex()) == -1) {
                this.nodes.add(new LGNode(p));
                this.nodes.get(this.nodes.size() - 1).setIndex(this.nodes.size() - 1);
                this.literalNode.set(p.getIndex(), this.nodes.size() - 1);
                newNode = this.nodes.get(this.nodes.size() - 1);
            } else {
                newNode = this.nodes.get(this.literalNode.get(p.getIndex()));
            }
            if (obj != null) {
                this.edges.add(new LMOrdering(newNode, this.nodes.get(obj.getIndex()), 1));
            }
            if (!this.objs.get(p.getLevel()).contains(newNode)) {
                this.objs.get(p.getLevel()).add(newNode);
            }
        }
    }

    private void verifyNonCommonPrec(LMLiteralInfo nonCommonPrec, ArrayList<LMLiteralInfo> commonPrecs, LandmarkNode obj, int level) {
        LandmarkSet d = this.locateDisjunction(nonCommonPrec.getFunction(), commonPrecs);
        if (d != null) {
            LandmarkNode newNode = this.findDisjunctiveLandmarkNode(d);
            if (newNode == null) {
                newNode = new LGNode(d);
                this.nodes.add(newNode);
                d.setLGNode(newNode);
                newNode.setIndex(this.nodes.size() - 1);
                newNode.setAgents(obj.getAgents());
                newNode = this.nodes.get(this.nodes.size() - 1);
                this.edges.add(new LMOrdering(newNode, this.nodes.get(obj.getIndex()), 1));
            } else {
                boolean valid = true;
                for (LandmarkOrdering o : this.edges) {
                    if (o.getNode1().getIndex() != obj.getIndex() || o.getNode2().getIndex() != newNode.getIndex()) continue;
                    valid = false;
                    break;
                }
                if (valid) {
                    this.edges.add(new LMOrdering(newNode, this.nodes.get(obj.getIndex()), 1));
                }
            }
            if (!this.objs.get(level - 1).contains(newNode)) {
                this.objs.get(level - 1).add(newNode);
            }
        }
    }

    private LandmarkNode locateLGNode(String id, int level) {
        for (LandmarkNode l : this.objs.get(level)) {
            if (!l.identify().equals(id)) continue;
            return l;
        }
        return null;
    }

    private LandmarkSet locateDisjunction(String var, ArrayList<LMLiteralInfo> common) {
        for (LandmarkSet u : this.D) {
            if (!u.identify().equals(var)) continue;
            return u;
        }
        boolean found = false;
        for (LandmarkFluent l : this.I) {
            if (!l.getVar().getFuctionName().equals(var)) continue;
            for (LMLiteralInfo li : common) {
                if (!l.toString().equals(li.getLiteral())) continue;
                found = true;
                break;
            }
            if (found) continue;
            return new uSet(l);
        }
        return null;
    }

    private void removeObject(LandmarkNode obj, int level) {
        this.objs.get(level).remove(obj);
    }

    private LandmarkNode findDisjunctiveLandmarkNode(LandmarkSet u) {
        if (u == null) {
            return null;
        }
        for (LandmarkNode n : this.nodes) {
            if (n.isSingleLiteral() || !n.getDisjunction().identify().equals(u.identify())) continue;
            if (n.getDisjunction().getElements().size() != u.getElements().size()) {
                return null;
            }
            int found = 0;
            block1: for (LandmarkFluent ln : n.getDisjunction().getElements()) {
                for (LandmarkFluent lu : u.getElements()) {
                    if (!ln.toString().equals(lu.toString())) continue;
                    ++found;
                    continue block1;
                }
            }
            if (found != u.getElements().size()) continue;
            return n;
        }
        return null;
    }

    private void groupCommonNonCommonPrecs(ArrayList<LandmarkAction> A) {
        int i;
        int[] common = new int[this.RPG.getLiterals().size()];
        int[] nonCommon = new int[this.RPG.getLiterals().size()];
        ArrayList<ArrayList<LandmarkAction>> producers = new ArrayList<ArrayList<LandmarkAction>>();
        Hashtable prods = new Hashtable();
        for (int i2 = 0; i2 < common.length; ++i2) {
            common[i2] = 0;
        }
        for (LandmarkAction a : A) {
            for (LandmarkFluent l : a.getPreconditions()) {
                common[l.getIndex()] = common[l.getIndex()] + 1;
                if (prods.get(l.getIndex()) == null) {
                    prods.put(l.getIndex(), new ArrayList());
                }
                ((ArrayList)prods.get(l.getIndex())).add(a);
            }
        }
        for (i = 0; i < common.length; ++i) {
            if (common[i] != A.size()) continue;
            boolean valid = true;
            for (LandmarkAction a : A) {
                if (((ArrayList)prods.get(i)).contains(a)) continue;
                valid = false;
                break;
            }
            if (!valid) continue;
            this.I.add(this.RPG.getIndexLiterals().get(i));
        }
        for (i = 0; i < nonCommon.length; ++i) {
            if (nonCommon[i] <= 0 || nonCommon[i] >= A.size()) continue;
            this.U.add(this.RPG.getIndexLiterals().get(i));
            producers.add((ArrayList<LandmarkAction>)prods.get(i));
        }
        if (this.U.size() > 0) {
            this.D = this.groupUSet(this.U, A, producers);
        }
    }

    private ArrayList<LandmarkSet> groupUSet(ArrayList<LandmarkFluent> u, ArrayList<LandmarkAction> A, ArrayList<ArrayList<LandmarkAction>> producers) {
        ArrayList<LandmarkSet> D = new ArrayList<LandmarkSet>();
        Hashtable<String, uSet> hashU = new Hashtable<String, uSet>();
        Hashtable hashProducers = new Hashtable();
        for (int i = 0; i < u.size(); ++i) {
            LandmarkFluent l = u.get(i);
            if (hashU.get(l.getVar().getFuctionName()) == null) {
                uSet set = new uSet(l);
                hashU.put(l.getVar().getFuctionName(), set);
                hashProducers.put(l.getVar().getFuctionName(), new ArrayList());
                for (LandmarkAction p : producers.get(i)) {
                    ((ArrayList)hashProducers.get(l.getVar().getFuctionName())).add(p.toString());
                }
                continue;
            }
            ((uSet)hashU.get(l.getVar().getFuctionName())).addElement(l);
            for (LandmarkAction p : producers.get(i)) {
                if (((ArrayList)hashProducers.get(l.getVar().getFuctionName())).contains(p.toString())) continue;
                ((ArrayList)hashProducers.get(l.getVar().getFuctionName())).add(p.toString());
            }
        }
        for (String s : hashU.keySet()) {
            if (((ArrayList)hashProducers.get(s)).size() != A.size()) continue;
            D.add((LandmarkSet)hashU.get(s));
        }
        return D;
    }

    private void groupMACommonNonCommonPrecs(ArrayList<MessageContentLandmarkGraph> received, boolean batonHasCommonActions, ArrayList<String> agents) {
        Hashtable<String, Integer> hashCommonPrecs = new Hashtable<String, Integer>();
        Hashtable<String, LMLiteralInfo> hashInfo = new Hashtable<String, LMLiteralInfo>();
        Hashtable<String, Integer> hashNonCommonPrecs = new Hashtable<String, Integer>();
        int baton = 0;
        this.commonToSend = new ArrayList();
        this.nonCommonToSend = new ArrayList();
        ArrayList<ArrayList<LMLiteralInfo>> receivedLits = new ArrayList<ArrayList<LMLiteralInfo>>();
        ArrayList<ArrayList<LMLiteralInfo>> receivedDisjs = new ArrayList<ArrayList<LMLiteralInfo>>();
        for (MessageContentLandmarkGraph messageContentLandmarkGraph : received) {
            if (messageContentLandmarkGraph.getMessageType() == 5) continue;
            receivedLits.add(messageContentLandmarkGraph.getLiterals());
            receivedDisjs.add(messageContentLandmarkGraph.getDisjunctions());
        }
        if (batonHasCommonActions) {
            for (LandmarkFluent landmarkFluent : this.I) {
                hashInfo.put(landmarkFluent.toString(), new LMLiteralInfo(landmarkFluent, this.groundedTask.getAgentName(), landmarkFluent.getAgents()));
                hashCommonPrecs.put(landmarkFluent.toString(), 1);
            }
            for (LandmarkSet landmarkSet : this.D) {
                hashInfo.put(landmarkSet.identify(), new LMLiteralInfo(landmarkSet.identify(), agents));
                hashNonCommonPrecs.put(landmarkSet.identify(), 1);
            }
            baton = 1;
        }
        for (ArrayList arrayList : receivedLits) {
            for (LMLiteralInfo s : arrayList) {
                if (hashCommonPrecs.get(s.getLiteral()) == null) {
                    hashCommonPrecs.put(s.getLiteral(), 1);
                    hashInfo.put(s.getLiteral(), s);
                    continue;
                }
                hashCommonPrecs.put(s.getLiteral(), (Integer)hashCommonPrecs.get(s.getLiteral()) + 1);
            }
        }
        for (ArrayList arrayList : receivedDisjs) {
            for (LMLiteralInfo disj : arrayList) {
                String su = disj.getFunction();
                if (hashNonCommonPrecs.get(su) == null) {
                    hashInfo.put(su, disj);
                    hashNonCommonPrecs.put(su, 1);
                    continue;
                }
                hashNonCommonPrecs.put(su, (Integer)hashNonCommonPrecs.get(su) + 1);
            }
        }
        for (String string : hashCommonPrecs.keySet()) {
            if ((Integer)hashCommonPrecs.get(string) == receivedLits.size() + baton) {
                this.commonToSend.add((LMLiteralInfo)hashInfo.get(string));
                continue;
            }
            if (hashNonCommonPrecs.get(((LMLiteralInfo)hashInfo.get(string)).getFunction()) == null) {
                hashInfo.put(((LMLiteralInfo)hashInfo.get(string)).getFunction(), new LMLiteralInfo(((LMLiteralInfo)hashInfo.get(string)).getFunction(), agents));
                hashNonCommonPrecs.put(((LMLiteralInfo)hashInfo.get(string)).getFunction(), 1);
                continue;
            }
            hashNonCommonPrecs.put(((LMLiteralInfo)hashInfo.get(string)).getFunction(), (Integer)hashNonCommonPrecs.get(((LMLiteralInfo)hashInfo.get(string)).getFunction()) + 1);
        }
        for (String string : hashNonCommonPrecs.keySet()) {
            if ((Integer)hashNonCommonPrecs.get(string) != receivedLits.size() + baton) continue;
            this.nonCommonToSend.add((LMLiteralInfo)hashInfo.get(string));
        }
    }

    private void MAPostProcessing() {
        boolean finish;
        ArrayList<LandmarkAction> A = new ArrayList();
        ArrayList orderings = new ArrayList();
        boolean done = false;
        Hashtable<String, Boolean> hashEdges = new Hashtable<String, Boolean>();
        for (LandmarkOrdering e : this.edges) {
            if (!e.getNode1().isSingleLiteral() || !e.getNode2().isSingleLiteral()) continue;
            hashEdges.put(e.getNode1().getLiteral().toString() + " -> " + e.getNode2().getLiteral().toString(), false);
        }
        do {
            ArrayList<LandmarkOrdering> auxEdges = new ArrayList<LandmarkOrdering>();
            for (LandmarkOrdering e : this.edges) {
                auxEdges.add(e);
            }
            if (this.comm.batonAgent()) {
                orderings.clear();
                done = true;
                for (int i = 0; i < this.nodes.size(); ++i) {
                    if (!this.nodes.get(i).isSingleLiteral()) continue;
                    for (int j = 0; j < this.nodes.size(); ++j) {
                        if (!this.matrix[j][i].booleanValue() || !this.nodes.get(j).isSingleLiteral() || ((Boolean)hashEdges.get(this.nodes.get(j).getLiteral().toString() + " -> " + this.nodes.get(i).getLiteral().toString())).booleanValue()) continue;
                        orderings.add(new MessageContentPostProcessing(this.nodes.get(j).getLiteral().toString(), this.nodes.get(i).getLiteral().toString()));
                    }
                }
                for (String ag : this.comm.getOtherAgents()) {
                    this.comm.sendMessage(ag, orderings, false);
                }
                for (MessageContentPostProcessing o : orderings) {
                    A = this.getActions(this.RPG.getHashLiterals().get(o.getLiteral1()), this.RPG.getHashLiterals().get(o.getLiteral2()));
                    hashEdges.put(o.getLiteral1() + " -> " + o.getLiteral2(), true);
                    if (this.RPG.verifyEdge(A)) continue;
                    for (LandmarkOrdering e : this.edges) {
                        if (!e.getNode1().isSingleLiteral() || !e.getNode2().isSingleLiteral() || e.getNode1().getLiteral().getIndex() != this.RPG.getHashLiterals().get(o.getLiteral1()).getIndex() || e.getNode2().getLiteral().getIndex() != this.RPG.getHashLiterals().get(o.getLiteral2()).getIndex()) continue;
                        auxEdges.remove(e);
                    }
                }
            } else {
                orderings = (ArrayList)this.comm.receiveMessage(this.comm.getBatonAgent(), false);
                for (MessageContentPostProcessing o : orderings) {
                    A.clear();
                    boolean ordering = false;
                    if (this.RPG.getHashLiterals().get(o.getLiteral1()) != null && this.RPG.getHashLiterals().get(o.getLiteral2()) != null && this.matrix[this.hashLGNodes.get(o.getLiteral1()).getIndex()][this.hashLGNodes.get(o.getLiteral2()).getIndex()].booleanValue()) {
                        A = this.getActions(this.hashLGNodes.get(o.getLiteral1()).getLiteral(), this.hashLGNodes.get(o.getLiteral2()).getLiteral());
                        ordering = true;
                    }
                    hashEdges.put(o.getLiteral1() + " -> " + o.getLiteral2(), true);
                    if (this.RPG.verifyEdge(A) || !ordering) continue;
                    for (LandmarkOrdering e : this.edges) {
                        if (!e.getNode1().isSingleLiteral() || !e.getNode2().isSingleLiteral() || e.getNode1().getLiteral().getIndex() != this.RPG.getHashLiterals().get(o.getLiteral1()).getIndex() || e.getNode2().getLiteral().getIndex() != this.RPG.getHashLiterals().get(o.getLiteral2()).getIndex()) continue;
                        auxEdges.remove(e);
                    }
                }
            }
            this.edges = auxEdges;
            this.comm.passBaton();
            if (!this.comm.batonAgent()) continue;
            if (done) {
                for (String ag : this.comm.getOtherAgents()) {
                    this.comm.sendMessage(ag, Boolean.valueOf(true), false);
                }
                return;
            }
            for (String ag : this.comm.getOtherAgents()) {
                this.comm.sendMessage(ag, Boolean.valueOf(false), false);
            }
        } while (this.comm.batonAgent() || !(finish = ((Boolean)this.comm.receiveMessage(this.comm.getBatonAgent(), false)).booleanValue()));
    }

    private ArrayList<LandmarkAction> getActions(LandmarkFluent l1, LandmarkFluent l2) {
        ArrayList<LandmarkAction> A = new ArrayList<LandmarkAction>();
        for (LandmarkAction a : this.RPG.getActions()) {
            for (LandmarkFluent pre : a.getPreconditions()) {
                if (l1 != pre || !l2.getTotalProducers().contains(a)) continue;
                A.add(a);
            }
        }
        return A;
    }

    private void computeAccessibilityMatrix() {
        for (int k = 0; k < this.nodes.size(); ++k) {
            for (int i = 0; i < this.nodes.size(); ++i) {
                for (int j = 0; j < this.nodes.size(); ++j) {
                    if (this.matrix[i][j].booleanValue() || !this.matrix[i][k].booleanValue() || !this.matrix[k][j].booleanValue()) continue;
                    this.matrix[i][j] = true;
                }
            }
        }
    }

    public LandmarkNode getNode(LMLiteral l) {
        if (this.literalNode.get(l.getIndex()) != -1) {
            return this.nodes.get(this.literalNode.get(l.getIndex()));
        }
        return null;
    }

    public boolean getReasonableOrdering(LGNode n1, LGNode n2) {
        return this.reasonableOrderings[n1.getIndex()][n2.getIndex()];
    }

    @Override
    public ArrayList<LandmarkOrdering> getReasonableOrderingList() {
        return this.reasonableOrderingsList;
    }

    public ArrayList<LandmarkOrdering> getReasonableGoalOrderingList() {
        return this.reasonableOrderingsGoalsList;
    }

    public ArrayList<LandmarkOrdering> getNeccessaryGoalOrderingList() {
        ArrayList<LandmarkOrdering> res = new ArrayList<LandmarkOrdering>();
        for (LandmarkOrdering o : this.edges) {
            if (!o.getNode1().isSingleLiteral() || !o.getNode2().isSingleLiteral() || !o.getNode1().getLiteral().isGoal() || !o.getNode2().getLiteral().isGoal()) continue;
            res.add(o);
        }
        return res;
    }

    @Override
    public ArrayList<LandmarkOrdering> getNeccessaryOrderingList() {
        return this.edges;
    }

    private void getProducers(LandmarkNode obj, String literal) {
        if (obj != null) {
            this.A = obj.getProducers();
        } else {
            this.A = new ArrayList();
            if (this.RPG.getHashLiterals().get(literal) != null) {
                this.A = this.RPG.getHashLiterals().get(literal).getProducers();
            }
        }
    }

    @Override
    public ArrayList<LandmarkNode> getNodes() {
        return this.nodes;
    }

    @Override
    public int numGlobalNodes() {
        return this.totalLandmarks;
    }

    @Override
    public int numTotalNodes() {
        return this.globalIndex;
    }
}

