/*
 * Decompiled with CFR 0.152.
 */
package org.agreement_technologies.service.map_landmarks;

import java.util.ArrayList;
import org.agreement_technologies.common.map_communication.AgentCommunication;
import org.agreement_technologies.common.map_grounding.GroundedTask;
import org.agreement_technologies.common.map_landmarks.LandmarkGraph;
import org.agreement_technologies.common.map_landmarks.LandmarkNode;
import org.agreement_technologies.common.map_landmarks.LandmarkOrdering;
import org.agreement_technologies.common.map_landmarks.Landmarks;
import org.agreement_technologies.service.map_landmarks.MALandmarkGraph;
import org.agreement_technologies.service.map_landmarks.RPG;
import org.agreement_technologies.service.map_landmarks.SALandmarkGraph;
import org.agreement_technologies.service.tools.Graph;

public class LandmarksImp
implements Landmarks {
    private final ArrayList<LandmarkOrdering> orderings;
    private ArrayList<LandmarkNode> nodes;
    private final int numGlobalNodes;
    private final int numTotalNodes;

    public LandmarksImp(GroundedTask gt, AgentCommunication c) {
        long time = System.currentTimeMillis();
        RPG rpg = new RPG(gt, c);
        LandmarkGraph LG = gt.getAgentNames().length > 1 ? new MALandmarkGraph(gt, c, rpg, rpg.getGoals()) : new SALandmarkGraph(gt, rpg, rpg.getGoals());
        this.numGlobalNodes = LG.numGlobalNodes();
        this.numTotalNodes = LG.numTotalNodes();
        this.orderings = new ArrayList();
        if (LG.getReasonableOrderingList() != null) {
            this.orderings.addAll(LG.getReasonableOrderingList());
        }
        if (LG.getNeccessaryOrderingList() != null) {
            this.orderings.addAll(LG.getNeccessaryOrderingList());
        }
        ArrayList<LandmarkNode> allNodes = LG.getNodes();
        this.nodes = new ArrayList(allNodes.size());
        for (int i = 0; i < allNodes.size(); ++i) {
            assert (allNodes.get(i).getIndex() == i);
            this.nodes.add(allNodes.get(i));
        }
    }

    @Override
    public ArrayList<LandmarkOrdering> getOrderings(int type, boolean onlyGoals) {
        ArrayList<LandmarkOrdering> ords;
        block10: {
            block9: {
                ords = new ArrayList<LandmarkOrdering>(this.orderings.size());
                if (!onlyGoals) break block9;
                if ((type & 2) > 0) {
                    for (LandmarkOrdering o : this.orderings) {
                        if (o.getType() != 2 || !o.getNode1().isGoal() || !o.getNode2().isGoal()) continue;
                        ords.add(o);
                    }
                }
                if ((type & 1) <= 0) break block10;
                for (LandmarkOrdering o : this.orderings) {
                    if (o.getType() != 1 || !o.getNode1().isGoal() || !o.getNode2().isGoal()) continue;
                    ords.add(o);
                }
                break block10;
            }
            if (type == 3) {
                ords.addAll(this.orderings);
            } else {
                if ((type & 2) > 0) {
                    for (LandmarkOrdering o : this.orderings) {
                        if (o.getType() != 2) continue;
                        ords.add(o);
                    }
                }
                if ((type & 1) > 0) {
                    for (LandmarkOrdering o : this.orderings) {
                        if (o.getType() != 1) continue;
                        ords.add(o);
                    }
                }
            }
        }
        return ords;
    }

    @Override
    public ArrayList<LandmarkNode> getNodes() {
        return this.nodes;
    }

    public void setNodes(ArrayList<LandmarkNode> nodes) {
        this.nodes = nodes;
    }

    @Override
    public void filterTransitiveOrders() {
        Graph<LandmarkNode, LandmarkOrdering> g = new Graph<LandmarkNode, LandmarkOrdering>();
        for (LandmarkOrdering o : this.orderings) {
            g.addEdge(o.getNode1(), o.getNode2(), o);
        }
        int numOrd = 0;
        while (numOrd < this.orderings.size()) {
            LandmarkOrdering o;
            o = this.orderings.get(numOrd);
            int n1 = g.getNodeIndex(o.getNode1());
            int n2 = g.getNodeIndex(o.getNode2());
            boolean remove = false;
            for (Graph.Adjacent a : g.getAdjacents(n1)) {
                int dst;
                if (a.dst == n2 || (dst = g.minDistance(a.dst, n2)) == 0x1FFFFFFF) continue;
                remove = true;
                break;
            }
            if (remove) {
                this.orderings.remove(numOrd);
                continue;
            }
            ++numOrd;
        }
    }

    @Override
    public void removeCycles() {
        Graph<LandmarkNode, LandmarkOrdering> g = new Graph<LandmarkNode, LandmarkOrdering>();
        for (LandmarkOrdering o : this.orderings) {
            g.addEdge(o.getNode1(), o.getNode2(), o);
        }
        int[] marks = new int[this.nodes.size()];
        int[] nodeOrder = g.sortNodesByIndegree();
        for (int i = 0; i < nodeOrder.length; ++i) {
            int orig = this.nodes.get(nodeOrder[i]).getIndex();
            if (marks[orig] != 0) continue;
            this.removeCycles(orig, marks, g);
        }
    }

    private void removeCycles(int orig, int[] marks, Graph<LandmarkNode, LandmarkOrdering> g) {
        marks[orig] = 2;
        ArrayList<Graph.Adjacent<LandmarkOrdering>> adj = g.getAdjacents(orig);
        int i = 0;
        while (i < adj.size()) {
            int dst = adj.get((int)i).dst;
            if (marks[dst] == 0) {
                this.removeCycles(dst, marks, g);
                ++i;
                continue;
            }
            if (marks[dst] == 2) {
                this.orderings.remove(adj.get((int)i).label);
                adj.remove(i);
                continue;
            }
            ++i;
        }
        marks[orig] = 1;
    }

    @Override
    public int numGlobalNodes() {
        return this.numGlobalNodes;
    }

    @Override
    public int numTotalNodes() {
        return this.numTotalNodes;
    }
}

