/*
 * Decompiled with CFR 0.152.
 */
package org.agreement_technologies.service.map_landmarks;

import java.io.Serializable;
import java.util.ArrayList;
import org.agreement_technologies.common.map_landmarks.LandmarkFluent;

public class LMLiteralInfo
implements Serializable {
    private static final long serialVersionUID = 5010121211010241301L;
    private final String literal;
    private final String var;
    private final String value;
    private final String function;
    private final String agent;
    private final ArrayList<String> agents;
    private int level;
    private boolean isGoal;

    public LMLiteralInfo(LandmarkFluent l, String ag, ArrayList<String> ags) {
        this.literal = l.toString();
        this.var = l.getVarName();
        this.value = l.getValue();
        this.function = l.getVar().getFuctionName();
        this.agent = ag;
        this.agents = ags;
        this.level = l.getLevel();
        this.isGoal = l.isGoal();
    }

    public LMLiteralInfo(String f, ArrayList<String> ag) {
        this.literal = null;
        this.var = null;
        this.value = null;
        this.function = f;
        this.agent = null;
        this.agents = ag;
    }

    public String getLiteral() {
        return this.literal;
    }

    public int getLevel() {
        return this.level;
    }

    public boolean isGoal() {
        return this.isGoal;
    }

    public String getVariable() {
        return this.var;
    }

    public String getValue() {
        return this.value;
    }

    public String getFunction() {
        return this.function;
    }

    public String getAgent() {
        return this.agent;
    }

    public ArrayList<String> getAgents() {
        return this.agents;
    }

    public String toString() {
        return this.literal;
    }
}

