/*
 * Decompiled with CFR 0.152.
 */
package org.agreement_technologies.service.map_heuristic;

import org.agreement_technologies.common.map_communication.AgentCommunication;
import org.agreement_technologies.common.map_grounding.GroundedTask;
import org.agreement_technologies.common.map_heuristic.Heuristic;
import org.agreement_technologies.common.map_heuristic.HeuristicFactory;
import org.agreement_technologies.common.map_planner.PlannerFactory;
import org.agreement_technologies.service.map_heuristic.DTGHeuristic;
import org.agreement_technologies.service.map_heuristic.FFHeuristic;
import org.agreement_technologies.service.map_heuristic.LandmarksHeuristic;

public class HeuristicFactoryImp
extends HeuristicFactory {
    @Override
    public Heuristic getHeuristic(int heuristic, AgentCommunication comm, GroundedTask gTask, PlannerFactory pf) {
        Heuristic h;
        switch (heuristic) {
            case 0: {
                h = new FFHeuristic(comm, gTask, pf);
                break;
            }
            case 1: {
                h = new DTGHeuristic(comm, gTask, pf);
                break;
            }
            case 2: {
                h = new LandmarksHeuristic(comm, gTask, false, pf);
                break;
            }
            case 3: {
                h = new LandmarksHeuristic(comm, gTask, true, pf);
                break;
            }
            default: {
                h = null;
            }
        }
        return h;
    }
}

