/*
 * Decompiled with CFR 0.152.
 */
package org.agreement_technologies.service.map_heuristic;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.PriorityQueue;
import org.agreement_technologies.common.map_communication.AgentCommunication;
import org.agreement_technologies.common.map_grounding.Action;
import org.agreement_technologies.common.map_grounding.GroundedCond;
import org.agreement_technologies.common.map_grounding.GroundedEff;
import org.agreement_technologies.common.map_grounding.GroundedTask;
import org.agreement_technologies.common.map_grounding.GroundedVar;
import org.agreement_technologies.common.map_heuristic.HPlan;
import org.agreement_technologies.common.map_heuristic.Heuristic;
import org.agreement_technologies.common.map_planner.PlannerFactory;
import org.agreement_technologies.service.map_heuristic.GoalCondition;
import org.agreement_technologies.service.map_heuristic.HeuristicToolkit;
import org.agreement_technologies.service.map_heuristic.RPG;

public class FFHeuristic
implements Heuristic {
    private static final int PENALTY = 1000;
    protected GroundedTask groundedTask;
    protected AgentCommunication comm;
    protected ArrayList<GroundedCond> goals;
    protected ArrayList<GroundedCond> pgoals;
    protected HashMap<String, ArrayList<Action>> productors;
    protected HashMap<String, ArrayList<Action>> requirers;
    protected PlannerFactory pf;
    private int[] totalOrder;

    public FFHeuristic(AgentCommunication comm, GroundedTask gTask, PlannerFactory pf) {
        this.pf = pf;
        this.groundedTask = gTask;
        this.comm = comm;
        this.goals = new ArrayList();
        this.pgoals = this.groundedTask.getPreferences();
        ArrayList<GoalCondition> gc = HeuristicToolkit.computeTaskGoals(comm, gTask);
        for (GoalCondition g : gc) {
            GroundedVar var = null;
            for (GroundedVar v : gTask.getVars()) {
                if (!v.toString().equals(g.varName)) continue;
                var = v;
                break;
            }
            if (var == null) continue;
            this.goals.add(gTask.createGroundedCondition(1, var, g.value));
        }
        this.productors = new HashMap();
        this.requirers = new HashMap();
        for (Action a : gTask.getActions()) {
            ArrayList<Action> list;
            String desc;
            for (GroundedEff groundedEff : a.getEffs()) {
                desc = groundedEff.getVar().toString() + "=" + groundedEff.getValue();
                list = this.productors.get(desc);
                if (list == null) {
                    list = new ArrayList();
                    this.productors.put(desc, list);
                }
                list.add(a);
            }
            for (Serializable serializable : a.getPrecs()) {
                desc = serializable.getVar().toString() + "=" + serializable.getValue();
                list = this.requirers.get(desc);
                if (list == null) {
                    list = new ArrayList();
                    this.requirers.put(desc, list);
                }
                list.add(a);
            }
        }
    }

    @Override
    public void evaluatePlan(HPlan p, int threadIndex) {
        if (p.isSolution() || this.comm.numAgents() > 1) {
            p.setH(0, 0);
            for (int i = 0; i < this.pgoals.size(); ++i) {
                p.setHPriv(0, i);
            }
            return;
        }
        this.totalOrder = p.linearization();
        HashMap<String, ArrayList<String>> varValues = p.computeMultiState(this.totalOrder, this.pf);
        RPG rpg = new RPG(varValues, this.goals, this.pgoals, this.requirers);
        p.setH(this.solveGoals(rpg, this.goals), 0);
        ArrayList<GroundedCond> privateGoal = new ArrayList<GroundedCond>(1);
        for (int i = 0; i < this.pgoals.size(); ++i) {
            privateGoal.add(this.pgoals.get(i));
            p.setHPriv(this.solveGoals(rpg, privateGoal), i);
            privateGoal.clear();
        }
    }

    private int solveGoals(RPG rpg, ArrayList<GroundedCond> goals) {
        int h = 0;
        PriorityQueue<RPG.VarValue> openConditions = new PriorityQueue<RPG.VarValue>();
        for (GroundedCond g : goals) {
            RPG.VarValue vg = rpg.getVarValue(g);
            if (vg == null) {
                h = 1000;
                break;
            }
            if (vg.level <= 0) continue;
            openConditions.add(vg);
        }
        int bestCost = 0;
        if (h == 0) {
            while (!openConditions.isEmpty()) {
                RPG.VarValue v = (RPG.VarValue)openConditions.poll();
                Action bestAction = null;
                ArrayList<Action> prod = this.productors.get(v.getId());
                for (Action a : prod) {
                    if (rpg.getLevel(a) != v.level - 1) continue;
                    if (bestAction == null) {
                        bestAction = a;
                        bestCost = rpg.getDifficulty(a);
                        continue;
                    }
                    int cost = rpg.getDifficulty(a);
                    if (cost >= bestCost) continue;
                    bestAction = a;
                    bestCost = cost;
                }
                ++h;
                for (GroundedCond prec : bestAction.getPrecs()) {
                    RPG.VarValue vp = rpg.getVarValue(prec);
                    if (vp.level <= 0 || openConditions.contains(vp)) continue;
                    openConditions.add(vp);
                }
            }
        }
        return h;
    }

    @Override
    public void waitEndEvaluation() {
    }

    @Override
    public void startEvaluation(HPlan basePlan) {
    }

    @Override
    public Object getInformation(int infoFlag) {
        return null;
    }

    @Override
    public boolean supportsMultiThreading() {
        return false;
    }

    @Override
    public void evaluatePlanPrivacy(HPlan p, int threadIndex) {
        if (p.isSolution() || this.comm.numAgents() > 1 || this.pgoals.isEmpty()) {
            for (int i = 0; i < this.pgoals.size(); ++i) {
                p.setHPriv(0, i);
            }
            return;
        }
        this.totalOrder = p.linearization();
        HashMap<String, ArrayList<String>> varValues = p.computeMultiState(this.totalOrder, this.pf);
        RPG rpg = new RPG(varValues, this.goals, this.pgoals, this.requirers);
        ArrayList<GroundedCond> privateGoal = new ArrayList<GroundedCond>(1);
        for (int i = 0; i < this.pgoals.size(); ++i) {
            privateGoal.add(this.pgoals.get(i));
            p.setHPriv(this.solveGoals(rpg, privateGoal), i);
            privateGoal.clear();
        }
    }

    @Override
    public boolean requiresHLandStage() {
        return false;
    }

    @Override
    public void evaluatePlan(HPlan p, int threadIndex, ArrayList<Integer> achievedLandmarks) {
    }

    @Override
    public int numGlobalLandmarks() {
        return 0;
    }

    @Override
    public ArrayList<Integer> checkNewLandmarks(HPlan plan, BitSet achievedLandmarks) {
        return null;
    }
}

