/*
 * Decompiled with CFR 0.152.
 */
package org.agreement_technologies.service.map_grounding;

import java.io.Serializable;
import java.util.ArrayList;
import org.agreement_technologies.common.map_grounding.GroundedTask;
import org.agreement_technologies.common.map_grounding.ReachedValue;

public class RPGData
implements Serializable {
    private static final long serialVersionUID = -1957180289257722567L;
    String varName;
    String[] params;
    String[][] paramTypes;
    String value;
    String[] valueTypes;
    int[] minTime;

    public RPGData(ReachedValue v, GroundedTask gTask, ArrayList<String> agents) {
        int i;
        this.varName = v.getVar().getFuctionName();
        this.params = v.getVar().getParams();
        this.paramTypes = new String[this.params.length][];
        for (i = 0; i < this.params.length; ++i) {
            this.paramTypes[i] = v.getVar().getParamTypes(i);
        }
        this.value = v.getValue();
        this.valueTypes = gTask.getObjectTypes(this.value);
        this.minTime = new int[agents.size()];
        for (i = 0; i < this.minTime.length; ++i) {
            this.minTime[i] = v.getVar().getMinTime(this.value, agents.get(i));
        }
    }

    public String toString() {
        String res = "(= (" + this.varName;
        for (String p : this.params) {
            res = res + " " + p;
        }
        res = res + ") " + this.value + ")[" + (this.minTime[0] == -1 ? "-" : Integer.valueOf(this.minTime[0]));
        for (int i = 1; i < this.minTime.length; ++i) {
            res = res + "," + (this.minTime[i] == -1 ? "-" : Integer.valueOf(this.minTime[i]));
        }
        return res + "]";
    }
}

