/*
 * Decompiled with CFR 0.152.
 */
package org.agreement_technologies.service.map_grounding;

import java.io.Serializable;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.Hashtable;
import org.agreement_technologies.common.map_communication.AgentCommunication;
import org.agreement_technologies.common.map_grounding.GroundedNumericEff;
import org.agreement_technologies.common.map_grounding.GroundedTask;
import org.agreement_technologies.common.map_grounding.GroundedVar;
import org.agreement_technologies.common.map_grounding.Grounding;
import org.agreement_technologies.common.map_grounding.ReachedValue;
import org.agreement_technologies.common.map_parser.Condition;
import org.agreement_technologies.common.map_parser.Function;
import org.agreement_technologies.common.map_parser.NumericEffect;
import org.agreement_technologies.common.map_parser.NumericExpression;
import org.agreement_technologies.common.map_parser.Operator;
import org.agreement_technologies.common.map_parser.Parameter;
import org.agreement_technologies.common.map_parser.Task;
import org.agreement_technologies.service.map_grounding.GroundedTaskImp;
import org.agreement_technologies.service.map_grounding.RPGData;

public class GroundingImp
implements Grounding {
    private Hashtable<String, Boolean> staticFunctions = new Hashtable();
    private GroundedTaskImp gTask;
    private OpGrounding[] gOps;
    private ArrayList<OpGrounding>[] opRequireFunction;
    private ArrayList<ProgrammedValue> newTrueValues;
    private ArrayList<ProgrammedValue> auxTrueValues;
    private ArrayList<ArrayList<ProgrammedValue>> trueValuesByFunction;
    private ArrayList<ArrayList<ProgrammedValue>> falseValuesByFunction;
    private Hashtable<ProgrammedValue, Boolean> falseValueReached;
    private int currentLevel;
    private int startNewValues;
    private int currentTrueValueIndex;
    private int currentFalseValueIndex;
    private final int sameObjects;
    private boolean isReground;

    public GroundingImp(int sameObjects) {
        this.sameObjects = sameObjects;
    }

    @Override
    public void computeStaticFunctions(Task task, AgentCommunication comm) {
        String[] sf = this.getStaticFunctions(task);
        if (comm.numAgents() == 1) {
            for (String s : sf) {
                this.setStaticFunction(s);
            }
        } else if (comm.batonAgent()) {
            ArrayList<String> allSF = new ArrayList<String>();
            for (String ag : comm.getOtherAgents()) {
                String[] osf = (String[])comm.receiveMessage(ag, true);
                if (osf == null) continue;
                for (String f : osf) {
                    if (allSF.contains(f)) continue;
                    allSF.add(f);
                }
            }
            for (String f : allSF) {
                if (!this.checkStaticFunction(task, f, sf)) continue;
                comm.sendMessage((Serializable)((Object)f), true);
                boolean isStatic = true;
                for (String ag : comm.getOtherAgents()) {
                    String resp = (String)((Object)comm.receiveMessage(ag, true));
                    if (!resp.equalsIgnoreCase("no")) continue;
                    isStatic = false;
                }
                comm.sendMessage((Serializable)((Object)(isStatic ? "yes" : "no")), true);
                if (!isStatic) continue;
                this.setStaticFunction(f);
            }
            comm.sendMessage((Serializable)((Object)"<END>"), true);
        } else {
            comm.sendMessage(comm.getBatonAgent(), (Serializable)sf, true);
            String f = "";
            while (!f.equals("<END>")) {
                f = (String)((Object)comm.receiveMessage(comm.getBatonAgent(), true));
                if (f.equals("<END>")) continue;
                comm.sendMessage(comm.getBatonAgent(), (Serializable)((Object)(this.checkStaticFunction(task, f, sf) ? "yes" : "no")), true);
                String resp = (String)((Object)comm.receiveMessage(comm.getBatonAgent(), true));
                if (!resp.equalsIgnoreCase("yes")) continue;
                this.setStaticFunction(f);
            }
        }
    }

    protected boolean checkStaticFunction(Task task, String f, String[] sf) {
        Function[] func;
        for (String s : sf) {
            if (!s.equalsIgnoreCase(f)) continue;
            return true;
        }
        for (Function aux : func = task.getFunctions()) {
            if (!aux.getName().equalsIgnoreCase(f)) continue;
            return false;
        }
        return true;
    }

    private String[] getStaticFunctions(Task task) {
        ArrayList<String> sf = new ArrayList<String>();
        Function[] func = task.getFunctions();
        Operator[] ops = task.getOperators();
        for (Function f : func) {
            Condition[] effs;
            boolean isEffect = false;
            boolean isInRules = false;
            for (Operator rule : task.getBeliefs()) {
                for (Condition e : effs = rule.getEffect()) {
                    if (!e.getFunction().getName().equals(f.getName())) continue;
                    isInRules = true;
                    break;
                }
                if (!isInRules) {
                    Condition[] precs;
                    for (Condition p : precs = rule.getPrecondition()) {
                        if (!p.getFunction().getName().equals(f.getName())) continue;
                        isInRules = true;
                        break;
                    }
                }
                if (isInRules) break;
            }
            if (!isInRules) {
                for (Operator op : ops) {
                    for (Condition e : effs = op.getEffect()) {
                        if (!e.getFunction().getName().equals(f.getName())) continue;
                        isEffect = true;
                        break;
                    }
                    if (isEffect) break;
                }
            }
            if (isEffect || isInRules) continue;
            sf.add(f.getName());
        }
        String[] res = new String[sf.size()];
        for (int i = 0; i < sf.size(); ++i) {
            res[i] = (String)sf.get(i);
        }
        return res;
    }

    protected void setStaticFunction(String fnc) {
        this.staticFunctions.put(fnc, true);
    }

    protected boolean isStaticFunction(String fnc) {
        return this.staticFunctions.containsKey(fnc);
    }

    @Override
    public GroundedTask ground(Task task, AgentCommunication comm, boolean negationByFailure) {
        GroundedTask groundedTask = this.ground(task, comm.getThisAgentName(), negationByFailure);
        if (comm.numAgents() > 1) {
            boolean[] endRPG = new boolean[comm.numAgents()];
            do {
                this.sendRPGFacts(endRPG, groundedTask, comm);
                this.receiveRPGFacts(endRPG, comm);
            } while (!this.checkEndRPG(endRPG, comm));
        }
        return groundedTask;
    }

    protected void receiveRPGFacts(boolean[] endRPG, AgentCommunication comm) {
        ArrayList<ReachedValue> newData = new ArrayList<ReachedValue>();
        for (String ag : comm.getOtherAgents()) {
            Serializable data = comm.receiveMessage(ag, false);
            if (data instanceof String) {
                if (((String)((Object)data)).equals("<END>")) {
                    endRPG[comm.getAgentIndex((String)ag)] = true;
                    continue;
                }
                throw new RuntimeException("Agent " + ag + " is not following the RPG protocol");
            }
            ArrayList dataReceived = (ArrayList)data;
            endRPG[comm.getAgentIndex((String)ag)] = false;
            for (RPGData d : dataReceived) {
                newData.add(this.createReachedValue(d));
            }
        }
        this.reground(newData.toArray(new ReachedValue[newData.size()]));
    }

    protected void sendRPGFacts(boolean[] endRPG, GroundedTask gTask, AgentCommunication comm) {
        ReachedValue[] newValues = this.getNewValues();
        boolean somethingToSend = false;
        for (String ag : comm.getOtherAgents()) {
            for (ReachedValue v : newValues) {
                if (!v.shareable(ag)) continue;
                somethingToSend = true;
                break;
            }
            if (!somethingToSend) continue;
            break;
        }
        boolean bl = endRPG[comm.getThisAgentIndex()] = !somethingToSend;
        if (somethingToSend) {
            for (String ag : comm.getOtherAgents()) {
                ArrayList<RPGData> dataToSend = new ArrayList<RPGData>();
                for (ReachedValue v : newValues) {
                    if (!v.shareable(ag)) continue;
                    dataToSend.add(new RPGData(v, gTask, comm.getAgentList()));
                }
                comm.sendMessage(ag, dataToSend, false);
            }
        } else {
            comm.sendMessage((Serializable)((Object)"<END>"), false);
        }
    }

    protected boolean checkEndRPG(boolean[] endRPG, AgentCommunication comm) {
        boolean finished = true;
        for (boolean end : endRPG) {
            if (end) continue;
            finished = false;
            break;
        }
        if (!finished) {
            if (comm.batonAgent()) {
                comm.sendMessage((Serializable)((Object)"<SYNC>"), true);
            } else {
                comm.receiveMessage(comm.getBatonAgent(), true);
            }
        }
        return finished;
    }

    protected GroundedTask ground(Task task, String agentName, boolean negationByFailure) {
        this.currentLevel = 0;
        this.currentTrueValueIndex = 0;
        this.currentFalseValueIndex = 0;
        this.startNewValues = 0;
        this.isReground = false;
        this.gTask = new GroundedTaskImp(task, this.sameObjects, negationByFailure);
        this.gTask.initAgents(task, agentName);
        this.gTask.setStaticFunctions(this.staticFunctions);
        this.initOperators(task);
        this.initInitialState();
        while (this.newTrueValues.size() > 0) {
            this.auxTrueValues = new ArrayList();
            for (OpGrounding op : this.gOps) {
                if (op.numTruePrec != 0) continue;
                this.matchNegativeConditions(op, false);
            }
            for (ProgrammedValue pv : this.newTrueValues) {
                this.match(pv, false);
            }
            for (ProgrammedValue pv : this.auxTrueValues) {
                GroundedTaskImp.GroundedVarImp v = this.gTask.vars.get(pv.varIndex);
                this.trueValuesByFunction.get(v.fncIndex).add(pv);
            }
            this.startNewValues += this.newTrueValues.size();
            this.newTrueValues = this.auxTrueValues;
            ++this.currentLevel;
        }
        return this.gTask;
    }

    protected ReachedValue createReachedValue(RPGData data) {
        Integer valueIndex;
        GroundedTaskImp groundedTaskImp = this.gTask;
        groundedTaskImp.getClass();
        GroundedTaskImp.GroundedVarImp v = groundedTaskImp.new GroundedTaskImp.GroundedVarImp(data.varName, data.params.length);
        for (int i = 0; i < data.params.length; ++i) {
            Integer pIndex = this.gTask.objectIndex.get(data.params[i]);
            if (pIndex == null) {
                pIndex = this.gTask.createNewObject(data.params[i], data.paramTypes[i]);
            }
            v.paramIndex[i] = pIndex;
        }
        Integer varIndex = this.gTask.getVarIndex(v);
        if (varIndex == null) {
            varIndex = this.gTask.createNewVariable(v);
        }
        if ((valueIndex = this.gTask.objectIndex.get(data.value)) == null) {
            valueIndex = this.gTask.createNewObject(data.value, data.valueTypes);
        }
        GroundedTaskImp groundedTaskImp2 = this.gTask;
        groundedTaskImp2.getClass();
        GroundedTaskImp.GroundedValue gv = groundedTaskImp2.new GroundedTaskImp.GroundedValue(varIndex, valueIndex);
        gv.minTime = data.minTime;
        return gv;
    }

    protected void reground(ReachedValue[] newValues) {
        this.isReground = true;
        this.gTask.resetNewValues();
        this.newTrueValues = this.addNewReachedValues(newValues);
        while (this.newTrueValues.size() > 0) {
            this.auxTrueValues = new ArrayList();
            for (OpGrounding op : this.gOps) {
                if (op.numTruePrec != 0) continue;
                this.matchNegativeConditions(op, true);
            }
            for (ProgrammedValue pv : this.newTrueValues) {
                this.match(pv, true);
            }
            for (ProgrammedValue pv : this.auxTrueValues) {
                GroundedTaskImp.GroundedVarImp v = this.gTask.vars.get(pv.varIndex);
                this.trueValuesByFunction.get(v.fncIndex).add(pv);
            }
            this.newTrueValues = this.auxTrueValues;
        }
    }

    private ArrayList<ProgrammedValue> addNewReachedValues(ReachedValue[] newValues) {
        ArrayList<ProgrammedValue> res = new ArrayList<ProgrammedValue>();
        for (ReachedValue rv : newValues) {
            GroundedTaskImp.GroundedValue gv = (GroundedTaskImp.GroundedValue)rv;
            Integer rvIndex = this.gTask.valueIndex.get(gv);
            if (rvIndex == null) {
                rvIndex = this.gTask.values.size();
                this.gTask.valueIndex.put(gv, rvIndex);
                this.gTask.values.add(gv);
                ProgrammedValue pv = new ProgrammedValue(this.currentTrueValueIndex++, gv.varIndex, gv.valueIndex);
                this.trueValuesByFunction.get(gv.var().fncIndex).add(pv);
                res.add(pv);
                ArrayList<Integer> domainValues = this.gTask.getAllDomainValues(gv.var().domainIndex);
                for (Integer value : domainValues) {
                    if (value == gv.valueIndex || this.falseValueReached.containsKey(pv = new ProgrammedValue(this.currentFalseValueIndex++, gv.varIndex, value))) continue;
                    this.falseValueReached.put(pv, true);
                    this.falseValuesByFunction.get(gv.var().fncIndex).add(pv);
                }
                continue;
            }
            GroundedTaskImp.GroundedValue oldGV = this.gTask.values.get(rvIndex);
            for (int i = 0; i < oldGV.minTime.length; ++i) {
                if (gv.minTime[i] == -1) continue;
                oldGV.minTime[i] = oldGV.minTime[i] == -1 ? gv.minTime[i] : Math.min(oldGV.minTime[i], gv.minTime[i]);
            }
        }
        return res;
    }

    protected ReachedValue[] getNewValues() {
        return this.gTask.getNewValues();
    }

    private void match(ProgrammedValue pv, boolean reGround) {
        GroundedTaskImp.GroundedVarImp v = this.gTask.vars.get(pv.varIndex);
        ArrayList<OpGrounding> opList = this.opRequireFunction[v.fncIndex];
        for (OpGrounding op : opList) {
            int precIndex = -1;
            do {
                if ((precIndex = op.matches(v, pv.valueIndex, precIndex + 1)) == -1 || !op.stackParameters(precIndex, v, pv.valueIndex, true)) continue;
                op.indexFirstValue = pv.index;
                this.completeMatch(0, op, reGround);
                op.unstackParameters(precIndex, true);
            } while (precIndex != -1);
        }
    }

    private void completeMatch(int startPrec, OpGrounding op, boolean reGround) {
        if (op.numUngroundedTruePrecs == 0) {
            this.matchNegativeConditions(op, reGround);
            return;
        }
        int numPrec = startPrec;
        while (op.truePrec[numPrec].grounded) {
            ++numPrec;
        }
        OpCondGrounding p = op.truePrec[numPrec];
        ArrayList<ProgrammedValue> valueList = this.trueValuesByFunction.get(p.fncIndex);
        for (ProgrammedValue pv : valueList) {
            if (!this.isReground && pv.index >= this.startNewValues && pv.index < op.indexFirstValue || !op.precMatches(p, this.gTask.vars.get(pv.varIndex), pv.valueIndex) || !op.stackParameters(numPrec, this.gTask.vars.get(pv.varIndex), pv.valueIndex, true)) continue;
            this.completeMatch(numPrec + 1, op, reGround);
            op.unstackParameters(numPrec, true);
        }
    }

    private void matchNegativeConditions(OpGrounding op, boolean reGround) {
        if (op.numUngroundedFalsePrecs == 0) {
            this.groundRemainingParameters(op, reGround);
            return;
        }
        for (int i = 0; i < op.numFalsePrec; ++i) {
            OpCondGrounding p = op.falsePrec[i];
            if (p.grounded) continue;
            ArrayList<ProgrammedValue> valueList = this.falseValuesByFunction.get(p.fncIndex);
            for (ProgrammedValue pv : valueList) {
                if (!op.negPrecMatches(p, this.gTask.vars.get(pv.varIndex), pv.valueIndex) || !op.stackParameters(i, this.gTask.vars.get(pv.varIndex), pv.valueIndex, false)) continue;
                this.matchNegativeConditions(op, reGround);
                op.unstackParameters(i, false);
            }
        }
    }

    private void groundRemainingParameters(OpGrounding op, boolean reGround) {
        int i;
        int pIndex = -1;
        for (i = 0; i < op.numParams; ++i) {
            int objIndex;
            int n = objIndex = op.paramValues[i].isEmpty() ? -1 : op.paramValues[i].peek();
            if (objIndex != -1) continue;
            pIndex = i;
            break;
        }
        if (pIndex == -1) {
            this.groundAction(op, reGround);
        } else {
            for (i = 0; i < this.gTask.objects.size(); ++i) {
                if (!this.gTask.objectIsCompatible(i, op.paramTypes[pIndex])) continue;
                op.paramValues[pIndex].push(i);
                this.groundRemainingParameters(op, reGround);
                op.paramValues[pIndex].pop();
            }
        }
    }

    private void groundAction(OpGrounding op, boolean reGround) {
        int i;
        if (op.isRule ? this.gTask.ruleIndex.get(op.toString()) != null : this.gTask.actionIndex.get(op.toString()) != null) {
            return;
        }
        GroundedTaskImp groundedTaskImp = this.gTask;
        groundedTaskImp.getClass();
        GroundedTaskImp.ActionImp a = groundedTaskImp.new GroundedTaskImp.ActionImp(op.name, op.numParams, op.numTruePrec + op.numFalsePrec, op.eff.length);
        for (i = 0; i < op.numParams; ++i) {
            int objIndex = op.paramValues[i].peek();
            a.setParam(i, objIndex, this.gTask.objects.get(objIndex));
        }
        for (i = 0; i < op.numTruePrec; ++i) {
            GroundedTaskImp.GroundedValue gv = this.groundActionCondition(a, op.truePrec[i], false);
            a.addPrecondition(i, gv, true);
        }
        for (i = 0; i < op.numFalsePrec; ++i) {
            GroundedTaskImp.GroundedValue gv = this.groundActionCondition(a, op.truePrec[i], false);
            a.addPrecondition(i + op.numTruePrec, gv, false);
        }
        for (i = 0; i < op.eff.length; ++i) {
            GroundedTaskImp.GroundedValue gv = this.groundActionCondition(a, op.eff[i], true);
            if (a.addEffect(i, gv)) continue;
            return;
        }
        if (!this.checkContradictoryEffects(a)) {
            return;
        }
        if (reGround) {
            this.currentLevel = a.getMinTime();
        }
        for (GroundedTaskImp.ActionCondition eff : a.eff) {
            boolean newValue = !this.gTask.valueIndex.containsKey(eff.gv);
            int gvIndex = this.gTask.addValue(eff.gv.varIndex, eff.gv.valueIndex, this.currentLevel + 1);
            eff.gv = this.gTask.values.get(gvIndex);
            if (reGround && !this.gTask.newValues.contains(eff.gv)) {
                this.gTask.newValues.add(eff.gv);
            }
            if (!newValue) continue;
            this.auxTrueValues.add(new ProgrammedValue(this.currentTrueValueIndex++, eff.gv.varIndex, eff.gv.valueIndex));
            ArrayList<Integer> domainValues = this.gTask.getAllDomainValues(eff.gv.var().domainIndex);
            for (Integer value : domainValues) {
                ProgrammedValue pv;
                if (value == eff.gv.valueIndex || this.falseValueReached.containsKey(pv = new ProgrammedValue(this.currentFalseValueIndex++, eff.gv.varIndex, value))) continue;
                this.falseValueReached.put(pv, true);
                this.falseValuesByFunction.get(eff.gv.var().fncIndex).add(pv);
            }
        }
        if (op.numEff.length > 0) {
            this.groundActionNumericEffect(a, op);
        }
        if (op.isRule) {
            this.gTask.ruleIndex.put(a.toString(), this.gTask.actions.size());
            this.gTask.rules.add(a);
        } else {
            this.gTask.actionIndex.put(a.toString(), this.gTask.actions.size());
            this.gTask.actions.add(a);
        }
    }

    private GroundedTaskImp.GroundedValue groundActionCondition(GroundedTaskImp.ActionImp a, OpCondGrounding cond, boolean canAddVariable) {
        Function f = this.gTask.functions.get(cond.fncIndex);
        GroundedTaskImp groundedTaskImp = this.gTask;
        groundedTaskImp.getClass();
        GroundedTaskImp.GroundedVarImp var = groundedTaskImp.new GroundedTaskImp.GroundedVarImp(f.getName(), cond.numParams);
        for (int j = 0; j < cond.numParams; ++j) {
            var.paramIndex[j] = cond.paramConstant[j] ? cond.paramIndex[j] : a.paramIndex[cond.paramIndex[j]];
        }
        Integer varIndex = this.gTask.varIndex.get(var);
        if (varIndex != null) {
            var = this.gTask.vars.get(varIndex);
        } else if (canAddVariable) {
            var.domain = f.getDomain();
            var = this.gTask.addVariable(var);
        } else {
            throw new RuntimeException("Unknown variable in action '" + a + "'");
        }
        int valueIndex = cond.constantValue ? cond.valueIndex : a.paramIndex[cond.valueIndex];
        GroundedTaskImp groundedTaskImp2 = this.gTask;
        groundedTaskImp2.getClass();
        return groundedTaskImp2.new GroundedTaskImp.GroundedValue(var.varIndex, valueIndex);
    }

    private void initInitialState() {
        int i;
        int booleanTypeIndex = this.gTask.typeIndex.get("boolean");
        int falseObjIndex = this.gTask.objectIndex.get("false");
        this.trueValuesByFunction = new ArrayList();
        this.falseValuesByFunction = new ArrayList();
        this.falseValueReached = new Hashtable();
        for (i = 0; i < this.gTask.functions.size(); ++i) {
            this.trueValuesByFunction.add(new ArrayList());
            this.falseValuesByFunction.add(new ArrayList());
        }
        this.newTrueValues = new ArrayList();
        for (i = 0; i < this.gTask.vars.size(); ++i) {
            ProgrammedValue pv;
            GroundedTaskImp.GroundedVarImp v = this.gTask.vars.get(i);
            if (v.trueValue == -1) {
                if (v.domainIndex.length == 1 && v.domainIndex[0] == booleanTypeIndex) {
                    pv = new ProgrammedValue(this.currentTrueValueIndex++, v.varIndex, falseObjIndex);
                    this.newTrueValues.add(pv);
                    this.trueValuesByFunction.get(v.fncIndex).add(pv);
                    this.gTask.addValue(i, falseObjIndex, this.currentLevel);
                }
                for (Integer value : v.falseValues) {
                    ProgrammedValue pv2 = new ProgrammedValue(this.currentFalseValueIndex++, v.varIndex, value);
                    this.falseValuesByFunction.get(v.fncIndex).add(pv2);
                    this.falseValueReached.put(pv2, true);
                }
                continue;
            }
            pv = new ProgrammedValue(this.currentTrueValueIndex++, v.varIndex, v.trueValue);
            this.newTrueValues.add(pv);
            this.trueValuesByFunction.get(v.fncIndex).add(pv);
            this.gTask.addValue(i, v.trueValue, this.currentLevel);
            ArrayList<Integer> domainValues = this.gTask.getAllDomainValues(v.domainIndex);
            for (Integer value : domainValues) {
                if (value == v.trueValue) continue;
                pv = new ProgrammedValue(this.currentFalseValueIndex++, v.varIndex, value);
                this.falseValueReached.put(pv, true);
                this.falseValuesByFunction.get(v.fncIndex).add(pv);
                v.addFalseValue(this.gTask.objects.get(value), this.gTask.objectIndex);
            }
        }
    }

    private void initOperators(Task task) {
        int i;
        int numFnc = this.gTask.functions.size();
        this.opRequireFunction = new ArrayList[numFnc];
        for (int i2 = 0; i2 < numFnc; ++i2) {
            this.opRequireFunction[i2] = new ArrayList();
        }
        Operator[] ops = task.getOperators();
        Operator[] b = task.getBeliefs();
        this.gOps = new OpGrounding[ops.length + b.length];
        for (i = 0; i < ops.length; ++i) {
            this.gOps[i] = new OpGrounding(ops[i], i, false);
        }
        for (i = 0; i < b.length; ++i) {
            this.gOps[i + ops.length] = new OpGrounding(b[i], i, true);
        }
    }

    private void groundActionNumericEffect(GroundedTaskImp.ActionImp a, OpGrounding op) {
        a.numEff = new GroundedNumericEff[op.numEff.length];
        int i = 0;
        for (NumericEffect e : op.numEff) {
            int type = e.getType();
            GroundedTaskImp.GroundedVarImp var = this.groundNumericVariable(e.getNumericVariable(), op);
            GroundedTaskImp.GroundedNumericExpressionImp exp = this.groundNumericExpression(e.getNumericExpression(), op);
            a.numEff[i++] = new GroundedTaskImp.GroundedNumericEffImp(type, var, exp);
        }
    }

    private GroundedTaskImp.GroundedVarImp groundNumericVariable(Function var, OpGrounding op) {
        int numParams = var.getParameters().length;
        GroundedTaskImp groundedTaskImp = this.gTask;
        groundedTaskImp.getClass();
        GroundedTaskImp.GroundedVarImp gvar = groundedTaskImp.new GroundedTaskImp.GroundedVarImp(var.getName(), numParams);
        for (int i = 0; i < numParams; ++i) {
            int objIndex;
            Parameter param = var.getParameters()[i];
            if (param.getName().startsWith("?")) {
                int paramIndex = -1;
                for (int j = 0; j < op.numParams; ++j) {
                    if (!op.paramNames[j].equalsIgnoreCase(param.getName())) continue;
                    paramIndex = j;
                    break;
                }
                objIndex = op.paramValues[paramIndex].peek();
            } else {
                objIndex = this.gTask.objectIndex.get(param.getName());
            }
            gvar.paramIndex[i] = objIndex;
        }
        int varIndex = this.gTask.numericVars.indexOf(gvar);
        if (varIndex >= 0) {
            return this.gTask.numericVars.get(varIndex);
        }
        return this.gTask.createNewNumericVariable(gvar);
    }

    private GroundedTaskImp.GroundedNumericExpressionImp groundNumericExpression(NumericExpression exp, OpGrounding op) {
        GroundedTaskImp.GroundedNumericExpressionImp res;
        int type = exp.getType();
        switch (type) {
            case 0: {
                res = new GroundedTaskImp.GroundedNumericExpressionImp(type, exp.getValue());
                break;
            }
            case 1: {
                GroundedTaskImp.GroundedVarImp var = this.groundNumericVariable(exp.getNumericVariable(), op);
                res = new GroundedTaskImp.GroundedNumericExpressionImp(var);
                break;
            }
            case 6: {
                res = new GroundedTaskImp.GroundedNumericExpressionImp(type);
                break;
            }
            default: {
                GroundedTaskImp.GroundedNumericExpressionImp left = this.groundNumericExpression(exp.getLeftExp(), op);
                GroundedTaskImp.GroundedNumericExpressionImp right = this.groundNumericExpression(exp.getRightExp(), op);
                res = new GroundedTaskImp.GroundedNumericExpressionImp(type, left, right);
            }
        }
        return res;
    }

    private boolean checkContradictoryEffects(GroundedTaskImp.ActionImp a) {
        block0: for (int effIndex = 0; effIndex < a.eff.length - 1; ++effIndex) {
            GroundedVar var = a.eff[effIndex].getVar();
            int effIndex2 = effIndex + 1;
            while (effIndex2 < a.eff.length) {
                if (var.equals(a.eff[effIndex2].getVar())) {
                    int remove;
                    String v2;
                    String v1 = a.eff[effIndex].getValue();
                    if (v1.equalsIgnoreCase(v2 = a.eff[effIndex2].getValue())) {
                        remove = effIndex2;
                    } else {
                        if (!var.isBoolean()) {
                            return false;
                        }
                        remove = v1.equalsIgnoreCase("false") ? effIndex : effIndex2;
                    }
                    a.addMutexVariable(var);
                    GroundedTaskImp.ActionCondition[] v = new GroundedTaskImp.ActionCondition[a.eff.length - 1];
                    System.arraycopy(a.eff, 0, v, 0, remove);
                    for (int i = remove + 1; i < a.eff.length; ++i) {
                        v[i - 1] = a.eff[i];
                    }
                    a.eff = v;
                    if (remove != effIndex) continue;
                    --effIndex;
                    continue block0;
                }
                ++effIndex2;
            }
        }
        return true;
    }

    public class ProgrammedValue {
        int index;
        int varIndex;
        int valueIndex;

        public ProgrammedValue(int index, int varIndex, int value) {
            this.index = index;
            this.varIndex = varIndex;
            this.valueIndex = value;
        }

        public boolean equals(Object x) {
            ProgrammedValue v = (ProgrammedValue)x;
            return this.varIndex == v.varIndex && this.valueIndex == v.valueIndex;
        }

        public int hashCode() {
            return this.varIndex * 131071 + this.valueIndex;
        }
    }

    private class OpGrounding {
        int opIndex;
        String name;
        String[] paramNames;
        int[][] paramTypes;
        Deque<Integer>[] paramValues;
        int numParams;
        int numUngroundedTruePrecs;
        int numUngroundedFalsePrecs;
        int numTruePrec;
        int numFalsePrec;
        OpCondGrounding[] truePrec;
        OpCondGrounding[] falsePrec;
        OpCondGrounding[] eff;
        boolean isRule;
        int indexFirstValue;
        NumericEffect[] numEff;

        public OpGrounding(Operator op, int opIndex, boolean isRule) {
            int i;
            int i2;
            this.opIndex = opIndex;
            this.isRule = isRule;
            this.name = op.getName();
            Parameter[] params = op.getParameters();
            this.numParams = params.length;
            this.paramNames = new String[this.numParams];
            this.paramTypes = new int[this.numParams][];
            this.paramValues = new Deque[this.numParams];
            for (i2 = 0; i2 < params.length; ++i2) {
                this.paramNames[i2] = params[i2].getName();
                String[] types = params[i2].getTypes();
                this.paramTypes[i2] = new int[types.length];
                for (int j = 0; j < types.length; ++j) {
                    this.paramTypes[i2][j] = GroundingImp.this.gTask.getTypeIndex(types[j]);
                }
                this.paramValues[i2] = new ArrayDeque<Integer>();
            }
            this.numFalsePrec = 0;
            this.numTruePrec = 0;
            for (i2 = 0; i2 < op.getPrecondition().length; ++i2) {
                Condition c = op.getPrecondition()[i2];
                if (c.getType() == 0 || c.getType() == 2) {
                    ++this.numTruePrec;
                    continue;
                }
                ++this.numFalsePrec;
            }
            this.numUngroundedTruePrecs = this.numTruePrec;
            this.numUngroundedFalsePrecs = this.numFalsePrec;
            this.truePrec = new OpCondGrounding[this.numTruePrec];
            this.falsePrec = new OpCondGrounding[this.numFalsePrec];
            this.eff = new OpCondGrounding[op.getEffect().length];
            int nt = 0;
            int nf = 0;
            for (i = 0; i < op.getPrecondition().length; ++i) {
                Condition c = op.getPrecondition()[i];
                if (c.getType() == 0 || c.getType() == 2) {
                    this.truePrec[nt] = new OpCondGrounding(c, this.paramNames);
                    this.setFunctionUsage(this.truePrec[nt++]);
                    continue;
                }
                this.falsePrec[nf++] = new OpCondGrounding(c, this.paramNames);
            }
            for (i = 0; i < this.eff.length; ++i) {
                this.eff[i] = new OpCondGrounding(op.getEffect()[i], this.paramNames);
            }
            this.numEff = op.getNumericEffects();
        }

        public void unstackParameters(int precIndex, boolean isTrue) {
            OpCondGrounding p = isTrue ? this.truePrec[precIndex] : this.falsePrec[precIndex];
            for (int i = 0; i < this.numParams; ++i) {
                this.paramValues[i].pop();
            }
            p.grounded = false;
            if (isTrue) {
                ++this.numUngroundedTruePrecs;
            } else {
                ++this.numUngroundedFalsePrecs;
            }
        }

        public boolean stackParameters(int precIndex, GroundedTaskImp.GroundedVarImp v, int valueIndex, boolean isTrue) {
            int objIndex;
            int paramIndex;
            int i;
            OpCondGrounding p = isTrue ? this.truePrec[precIndex] : this.falsePrec[precIndex];
            int[] currentParams = new int[this.numParams];
            for (int i2 = 0; i2 < this.numParams; ++i2) {
                currentParams[i2] = this.paramValues[i2].isEmpty() ? -1 : this.paramValues[i2].peek();
            }
            for (i = 0; i < p.numParams; ++i) {
                if (p.paramConstant[i]) continue;
                paramIndex = p.paramIndex[i];
                objIndex = currentParams[paramIndex];
                if (objIndex == -1) {
                    currentParams[paramIndex] = v.paramIndex[i];
                    continue;
                }
                if (v.paramIndex[i] == objIndex) continue;
                return false;
            }
            if (!p.constantValue) {
                paramIndex = p.valueIndex;
                objIndex = currentParams[paramIndex];
                if (objIndex == -1) {
                    currentParams[paramIndex] = valueIndex;
                } else if (valueIndex != objIndex) {
                    return false;
                }
            }
            for (i = 0; i < this.numParams; ++i) {
                this.paramValues[i].push(currentParams[i]);
            }
            p.grounded = true;
            if (isTrue) {
                --this.numUngroundedTruePrecs;
            } else {
                --this.numUngroundedFalsePrecs;
            }
            return true;
        }

        public int matches(GroundedTaskImp.GroundedVarImp v, int valueIndex, int startPrec) {
            int precIndex = -1;
            for (int i = startPrec; i < this.numTruePrec; ++i) {
                OpCondGrounding p = this.truePrec[i];
                if (p.grounded || p.fncIndex != v.fncIndex || !this.precMatches(p, v, valueIndex)) continue;
                precIndex = i;
                break;
            }
            return precIndex;
        }

        public boolean precMatches(OpCondGrounding p, GroundedTaskImp.GroundedVarImp v, int valueIndex) {
            int objIndex;
            int paramIndex;
            boolean matches = true;
            for (int i = 0; i < p.numParams && matches; ++i) {
                paramIndex = p.paramIndex[i];
                if (p.paramConstant[i]) {
                    matches = paramIndex == v.paramIndex[i];
                    continue;
                }
                int n = objIndex = this.paramValues[paramIndex].isEmpty() ? -1 : this.paramValues[paramIndex].peek();
                matches = objIndex == -1 ? GroundingImp.this.gTask.objectIsCompatible(v.paramIndex[i], this.paramTypes[paramIndex]) : objIndex == v.paramIndex[i];
            }
            if (matches) {
                if (p.constantValue) {
                    matches = valueIndex == p.valueIndex;
                } else {
                    paramIndex = p.valueIndex;
                    int n = objIndex = this.paramValues[paramIndex].isEmpty() ? -1 : this.paramValues[paramIndex].peek();
                    matches = objIndex == -1 ? GroundingImp.this.gTask.objectIsCompatible(valueIndex, this.paramTypes[paramIndex]) : objIndex == valueIndex;
                }
            }
            return matches;
        }

        public boolean negPrecMatches(OpCondGrounding p, GroundedTaskImp.GroundedVarImp v, int valueIndex) {
            int objIndex;
            int paramIndex;
            boolean matches = true;
            for (int i = 0; i < p.numParams && matches; ++i) {
                paramIndex = p.paramIndex[i];
                if (p.paramConstant[i]) {
                    matches = paramIndex == v.paramIndex[i];
                    continue;
                }
                int n = objIndex = this.paramValues[paramIndex].isEmpty() ? -1 : this.paramValues[paramIndex].peek();
                matches = objIndex == -1 ? GroundingImp.this.gTask.objectIsCompatible(v.paramIndex[i], this.paramTypes[paramIndex]) : objIndex == v.paramIndex[i];
            }
            if (matches) {
                if (p.constantValue) {
                    matches = valueIndex != p.valueIndex;
                } else {
                    paramIndex = p.valueIndex;
                    int n = objIndex = this.paramValues[paramIndex].isEmpty() ? -1 : this.paramValues[paramIndex].peek();
                    matches = objIndex == -1 ? GroundingImp.this.gTask.objectIsCompatible(valueIndex, this.paramTypes[paramIndex]) : objIndex != valueIndex;
                }
            }
            return matches;
        }

        private void setFunctionUsage(OpCondGrounding cond) {
            ArrayList opList = GroundingImp.this.opRequireFunction[cond.fncIndex];
            if (!opList.contains(this)) {
                opList.add(this);
            }
        }

        public boolean equals(Object op) {
            return this.opIndex == ((OpGrounding)op).opIndex;
        }

        public String toString() {
            String res = this.name;
            for (int i = 0; i < this.numParams; ++i) {
                int objIndex = this.paramValues[i].isEmpty() ? -1 : this.paramValues[i].peek();
                res = objIndex == -1 ? res + " " + this.paramNames[i] : res + " " + ((GroundingImp)GroundingImp.this).gTask.objects.get(objIndex);
            }
            return res;
        }
    }

    private class OpCondGrounding {
        int fncIndex;
        int numParams;
        boolean[] paramConstant;
        int[] paramIndex;
        boolean constantValue;
        int valueIndex;
        boolean grounded;

        public OpCondGrounding(Condition cond, String[] paramNames) {
            Function fnc = cond.getFunction();
            this.fncIndex = GroundingImp.this.gTask.getFunctionIndex(fnc.getName());
            Parameter[] params = fnc.getParameters();
            this.numParams = params.length;
            if (fnc.isMultifunction()) {
                ++this.numParams;
            }
            this.paramConstant = new boolean[this.numParams];
            this.paramIndex = new int[this.numParams];
            for (int i = 0; i < params.length; ++i) {
                this.paramConstant[i] = !params[i].getName().startsWith("?");
                this.paramIndex[i] = this.getParamIndex(this.paramConstant[i], params[i].getName(), paramNames);
            }
            if (fnc.isMultifunction()) {
                this.paramConstant[this.numParams - 1] = !cond.getValue().startsWith("?");
                this.paramIndex[this.numParams - 1] = this.getParamIndex(this.paramConstant[this.numParams - 1], cond.getValue(), paramNames);
                this.constantValue = true;
                this.valueIndex = GroundingImp.this.gTask.getObjectIndex("true");
            } else {
                this.constantValue = !cond.getValue().startsWith("?");
                this.valueIndex = this.getParamIndex(this.constantValue, cond.getValue(), paramNames);
            }
            this.grounded = false;
        }

        private int getParamIndex(boolean isConstant, String name, String[] paramNames) {
            if (isConstant) {
                return GroundingImp.this.gTask.getObjectIndex(name);
            }
            int index = -1;
            for (int i = 0; i < paramNames.length && index == -1; ++i) {
                if (!paramNames[i].equalsIgnoreCase(name)) continue;
                index = i;
            }
            return index;
        }
    }
}

