/*
 * Decompiled with CFR 0.152.
 */
package org.agreement_technologies.service.map_dtg;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.PriorityQueue;
import java.util.Vector;
import org.agreement_technologies.common.map_dtg.DTG;
import org.agreement_technologies.common.map_dtg.DTGRequest;
import org.agreement_technologies.common.map_dtg.DTGSet;
import org.agreement_technologies.common.map_dtg.DTGTransition;
import org.agreement_technologies.common.map_grounding.Action;
import org.agreement_technologies.common.map_grounding.GroundedCond;
import org.agreement_technologies.common.map_grounding.GroundedEff;
import org.agreement_technologies.common.map_grounding.GroundedTask;
import org.agreement_technologies.common.map_grounding.GroundedVar;

public class DTGImp
implements DTG {
    private static final int MAX_SEARCH_NODES = 9999;
    private DTGSet dtgSet;
    private GroundedTask task;
    private GroundedVar var;
    private String[] values;
    private Hashtable<String, Integer> valueIndex;
    private ArrayList<ArrayList<Transition>> transitions;
    private Vector<Hashtable<TransitionMemo, Path>> shortestPaths;
    private Vector<Hashtable<TransitionMemo, Integer>> distances;
    private Hashtable<String, Dijkstra> shortestPathsMulti;
    private int searchNodes;

    public DTGImp(DTGSet dtgSet, GroundedVar v, GroundedTask task) {
        this.dtgSet = dtgSet;
        this.task = task;
        this.var = v;
        this.values = v.getReachableValues();
        if (v.isBoolean() && this.values.length < 2) {
            this.values = new String[2];
            this.values[0] = "true";
            this.values[1] = "false";
        }
        this.valueIndex = new Hashtable(this.values.length);
        this.transitions = new ArrayList(this.values.length);
        for (int i = 0; i < this.values.length; ++i) {
            this.valueIndex.put(this.values[i], i);
            this.transitions.add(new ArrayList());
        }
        for (Action a : task.getActions()) {
            GroundedEff eff = this.changes(a, this.var);
            if (eff == null) continue;
            this.addTransition(a, eff, task.getAgentName().toLowerCase());
        }
        this.shortestPaths = new Vector();
        this.distances = new Vector();
        this.shortestPathsMulti = new Hashtable();
    }

    @Override
    public int pathCostMulti(String initValue, String endValue) {
        Dijkstra sp = this.shortestPathsMulti.get(initValue);
        if (sp == null) {
            Integer vIndex = this.valueIndex.get(initValue);
            sp = new Dijkstra(vIndex);
        }
        return sp.getPathCost(endValue);
    }

    @Override
    public String[] getPathMulti(String initValue, String endValue) {
        Dijkstra sp = this.shortestPathsMulti.get(initValue);
        if (sp == null) {
            Integer vIndex = this.valueIndex.get(initValue);
            sp = new Dijkstra(vIndex);
        }
        return sp.getPath(endValue);
    }

    private void addTransition(Action a, GroundedEff eff, String fromAgent) {
        GroundedCond prec = this.requires(a, this.var);
        int toValue = this.valueIndex.get(eff.getValue());
        if (prec == null || prec.getCondition() == 2) {
            for (int fromValue = 0; fromValue < this.values.length; ++fromValue) {
                if (toValue == fromValue) continue;
                Transition t = this.getTransition(fromValue, toValue);
                if (t == null) {
                    t = new Transition(fromValue, toValue, a, fromAgent);
                    this.transitions.get(fromValue).add(t);
                    continue;
                }
                t.addAction(a, fromAgent);
            }
        } else {
            int fromValue = this.valueIndex.get(prec.getValue());
            Transition t = this.getTransition(fromValue, toValue);
            if (t == null) {
                t = new Transition(fromValue, toValue, a, fromAgent);
                this.transitions.get(fromValue).add(t);
            } else {
                t.addAction(a, fromAgent);
            }
        }
    }

    private Transition getTransition(int fromValue, int toValue) {
        for (Transition t : this.transitions.get(fromValue)) {
            if (t.toValue != toValue) continue;
            return t;
        }
        return null;
    }

    @Override
    public DTGTransition[] getTransitionsFrom(String fromValue) {
        Integer index = this.valueIndex.get(fromValue);
        if (index == null) {
            return null;
        }
        ArrayList<Transition> trans = this.transitions.get(index);
        DTGTransition[] res = new DTGTransition[trans.size()];
        for (int i = 0; i < res.length; ++i) {
            res[i] = trans.get(i);
        }
        return res;
    }

    @Override
    public DTGTransition[] getTransitionsTo(String toValue) {
        Integer index = this.valueIndex.get(toValue);
        if (index == null) {
            return null;
        }
        ArrayList<Transition> res = new ArrayList<Transition>();
        for (ArrayList<Transition> trans : this.transitions) {
            for (Transition t : trans) {
                if (t.toValue != index) continue;
                res.add(t);
            }
        }
        return res.toArray(new DTGTransition[res.size()]);
    }

    private GroundedEff changes(Action a, GroundedVar v) {
        for (GroundedEff eff : a.getEffs()) {
            if (!eff.getVar().equals(v)) continue;
            return eff;
        }
        return null;
    }

    private GroundedCond requires(Action a, GroundedVar v) {
        for (GroundedCond pre : a.getPrecs()) {
            if (!pre.getVar().equals(v)) continue;
            return pre;
        }
        return null;
    }

    public DTGTransition[] getNewTransitions() {
        ArrayList<Transition> tList = new ArrayList<Transition>();
        for (int i = 0; i < this.values.length; ++i) {
            ArrayList<Transition> tv = this.transitions.get(i);
            for (Transition t : tv) {
                if (!t.newTransition) continue;
                t.newTransition = false;
                tList.add(t);
            }
        }
        return tList.toArray(new DTGTransition[tList.size()]);
    }

    public void addTransition(String startValue, String finalValue, GroundedCond[] commonPrecs, GroundedEff[] commonEffs, String fromAgent) {
        int svIndex;
        int fvIndex;
        boolean newFinalValue = this.valueIndex.containsKey(finalValue);
        int n = fvIndex = newFinalValue ? this.valueIndex.get(finalValue).intValue() : this.addNewValue(finalValue);
        if (!this.valueIndex.containsKey(startValue)) {
            svIndex = this.addNewValue(startValue);
            this.transitions.get(svIndex).add(new Transition(svIndex, fvIndex, commonPrecs, commonEffs, fromAgent));
        } else {
            svIndex = this.valueIndex.get(startValue);
            ArrayList<Transition> tList = this.transitions.get(svIndex);
            Transition t = null;
            for (Transition aux : tList) {
                if (aux.toValue != fvIndex) continue;
                t = aux;
                break;
            }
            if (t == null) {
                tList.add(new Transition(svIndex, fvIndex, commonPrecs, commonEffs, fromAgent));
            } else {
                t.boundCommonPrecs(commonPrecs, fromAgent);
            }
        }
        if (newFinalValue) {
            for (Action a : this.task.getActions()) {
                GroundedEff eff;
                GroundedCond prec = this.requires(a, this.var);
                if (prec == null || !prec.getValue().equals(finalValue) || (eff = this.changes(a, this.var)) == null) continue;
                this.addTransition(a, eff, this.task.getAgentName().toLowerCase());
            }
        }
    }

    private int addNewValue(String newValue) {
        String[] auxValues = new String[this.values.length + 1];
        System.arraycopy(this.values, 0, auxValues, 0, this.values.length);
        int reachedValueIndex = this.values.length;
        auxValues[reachedValueIndex] = newValue;
        this.values = auxValues;
        this.valueIndex.put(newValue, reachedValueIndex);
        this.transitions.add(new ArrayList());
        return reachedValueIndex;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("DTG (").append(this.var.toString()).append("):\n");
        for (ArrayList<Transition> tList : this.transitions) {
            for (Transition t : tList) {
                sb.append(t.toString()).append("\n");
            }
        }
        return sb.toString();
    }

    private Path computePath(String initialValue, String endValue, HashMap<String, String> state, HashMap<String, ArrayList<String>> newValues, int threadIndex) {
        TransitionMemo tm;
        Hashtable<TransitionMemo, Path> spTable = this.getShortestPathTable(threadIndex);
        Path p = spTable.get(tm = new TransitionMemo(initialValue, endValue));
        if (p == null) {
            p = new Path(initialValue, endValue, state, newValues, threadIndex);
            spTable.put(tm, p);
        }
        return p;
    }

    private Hashtable<TransitionMemo, Path> getShortestPathTable(int threadIndex) {
        if (threadIndex < this.shortestPaths.size()) {
            return this.shortestPaths.get(threadIndex);
        }
        Hashtable<TransitionMemo, Path> table = new Hashtable<TransitionMemo, Path>();
        this.shortestPaths.add(table);
        return table;
    }

    @Override
    public String[] getPath(String initValue, String endValue, HashMap<String, String> state, HashMap<String, ArrayList<String>> newValues, int threadIndex) {
        Path p = this.computePath(initValue, endValue, state, newValues, threadIndex);
        return p.getPath();
    }

    @Override
    public boolean unknownValue(String value) {
        return value.equals("?") || !this.valueIndex.containsKey(value);
    }

    @Override
    public int pathCost(String initValue, String endValue, HashMap<String, String> state, HashMap<String, ArrayList<String>> newValues, int threadIndex) {
        Path p = this.computePath(initValue, endValue, state, newValues, threadIndex);
        return p.getCost();
    }

    @Override
    public DTGTransition getTransition(String initValue, String endValue) {
        Integer v1 = this.valueIndex.get(initValue);
        Integer v2 = this.valueIndex.get(endValue);
        if (v1 == null) {
            v1 = this.valueIndex.get("?");
        }
        if (v2 == null) {
            v2 = this.valueIndex.get("?");
        }
        return this.getTransition(v1, v2);
    }

    @Override
    public String getVarName() {
        return this.var.toString();
    }

    @Override
    public int getDistance(String initValue, String endValue, int threadIndex) {
        TransitionMemo tm;
        Hashtable<TransitionMemo, Integer> distTable = this.getDistanceTable(threadIndex);
        Integer dst = distTable.get(tm = new TransitionMemo(initValue, endValue));
        if (dst == null) {
            dst = this.computeDijkstraDistance(initValue, endValue);
            distTable.put(tm, dst);
        }
        return dst;
    }

    private Hashtable<TransitionMemo, Integer> getDistanceTable(int threadIndex) {
        if (threadIndex < this.distances.size()) {
            return this.distances.get(threadIndex);
        }
        Hashtable<TransitionMemo, Integer> dt = new Hashtable<TransitionMemo, Integer>();
        this.distances.add(dt);
        return dt;
    }

    public String[] computeDijkstraPath(String initValue, String endValue) {
        Integer init = this.valueIndex.get(initValue);
        Integer dst = this.valueIndex.get(endValue);
        if (init == null || dst == null) {
            return null;
        }
        int[] minCost = new int[this.values.length];
        int[] minPath = new int[this.values.length];
        boolean[] visited = new boolean[this.values.length];
        for (int i = 0; i < this.values.length; ++i) {
            minCost[i] = 0x2AAAAAAA;
            minPath[i] = -1;
        }
        minCost[init.intValue()] = 0;
        PriorityQueue<DistanceToV> qPrior = new PriorityQueue<DistanceToV>();
        qPrior.add(new DistanceToV(init, 0));
        while (!qPrior.isEmpty()) {
            int v = ((DistanceToV)qPrior.poll()).index;
            if (visited[v]) continue;
            visited[v] = true;
            for (Transition t : this.transitions.get(v)) {
                if (minCost[t.toValue] <= minCost[v] + t.getCost()) continue;
                minCost[t.toValue] = minCost[v] + t.getCost();
                minPath[t.toValue] = v;
                qPrior.add(new DistanceToV(t.toValue, minCost[t.toValue]));
            }
        }
        if (minCost[dst] == 0x2AAAAAAA) {
            return null;
        }
        ArrayList<String> res = new ArrayList<String>();
        res.add(this.values[dst]);
        int vAux = minPath[dst];
        while (vAux != -1) {
            res.add(0, this.values[vAux]);
            vAux = minPath[vAux];
        }
        return res.toArray(new String[res.size()]);
    }

    private int computeDijkstraDistance(String initValue, String endValue) {
        Integer init = this.valueIndex.get(initValue);
        Integer dst = this.valueIndex.get(endValue);
        if (init == null || dst == null) {
            return 0x2AAAAAAA;
        }
        int[] minCost = new int[this.values.length];
        boolean[] visited = new boolean[this.values.length];
        for (int i = 0; i < this.values.length; ++i) {
            minCost[i] = 0x2AAAAAAA;
        }
        minCost[init.intValue()] = 0;
        PriorityQueue<DistanceToV> qPrior = new PriorityQueue<DistanceToV>();
        qPrior.add(new DistanceToV(init, 0));
        while (!qPrior.isEmpty()) {
            int v = ((DistanceToV)qPrior.poll()).index;
            if (visited[v]) continue;
            visited[v] = true;
            for (Transition t : this.transitions.get(v)) {
                if (minCost[t.toValue] <= minCost[v] + t.getCost()) continue;
                minCost[t.toValue] = minCost[v] + t.getCost();
                qPrior.add(new DistanceToV(t.toValue, minCost[t.toValue]));
            }
        }
        return minCost[dst];
    }

    @Override
    public void clearCache(int threadIndex) {
        this.getShortestPathTable(threadIndex).clear();
        this.getDistanceTable(threadIndex).clear();
    }

    private class Dijkstra {
        private static final int INFINITE = 0x2AAAAAAA;
        private int initialValue;
        int[] minCost;
        int[] minPath;
        String[] agent;

        public Dijkstra(Integer vIndex) {
            this.minCost = new int[DTGImp.this.values.length];
            this.minPath = new int[DTGImp.this.values.length];
            this.agent = new String[DTGImp.this.values.length];
            boolean[] visited = new boolean[DTGImp.this.values.length];
            for (int i = 0; i < DTGImp.this.values.length; ++i) {
                this.minCost[i] = 0x2AAAAAAA;
                this.minPath[i] = -1;
            }
            if (vIndex == null) {
                return;
            }
            this.initialValue = vIndex;
            this.minCost[this.initialValue] = 0;
            PriorityQueue<DistanceToV> qPrior = new PriorityQueue<DistanceToV>();
            qPrior.add(new DistanceToV(this.initialValue, 0));
            while (!qPrior.isEmpty()) {
                int v = ((DistanceToV)qPrior.poll()).index;
                if (visited[v]) continue;
                visited[v] = true;
                for (Transition t : (ArrayList)DTGImp.this.transitions.get(v)) {
                    if (this.minCost[t.toValue] <= this.minCost[v] + t.getCost()) continue;
                    this.minCost[t.toValue] = this.minCost[v] + t.getCost();
                    this.minPath[t.toValue] = v;
                    qPrior.add(new DistanceToV(t.toValue, this.minCost[t.toValue]));
                }
            }
        }

        public String[] getPath(String value) {
            Integer vIndex = (Integer)DTGImp.this.valueIndex.get(value);
            if (vIndex == null) {
                vIndex = (Integer)DTGImp.this.valueIndex.get("?");
            }
            int length = 0;
            int index = vIndex;
            while (this.minPath[index] != -1) {
                ++length;
                index = this.minPath[index];
            }
            String[] path = new String[length + 1];
            path[length--] = value;
            while (this.minPath[vIndex] != -1) {
                path[length--] = DTGImp.this.values[this.minPath[vIndex]];
                vIndex = this.minPath[vIndex];
            }
            return path;
        }

        public String previousValue(String value) {
            Integer vIndex = (Integer)DTGImp.this.valueIndex.get(value);
            if (vIndex == null) {
                return null;
            }
            int prev = this.minPath[vIndex];
            if (prev < 0) {
                return null;
            }
            return DTGImp.this.values[prev];
        }

        public void update(DTGRequest request) {
            int reachedValueIndex = (Integer)DTGImp.this.valueIndex.get(request.reachedValue());
            if (this.minCost[reachedValueIndex] > request.reachedValueCost()) {
                int unkIndex;
                this.minCost[reachedValueIndex] = request.reachedValueCost();
                this.minPath[reachedValueIndex] = -2;
                this.agent[reachedValueIndex] = request.fromAgent();
                boolean[] visited = new boolean[DTGImp.this.values.length];
                int n = unkIndex = DTGImp.this.valueIndex.containsKey("?") ? (Integer)DTGImp.this.valueIndex.get("?") : -1;
                if (unkIndex >= 0) {
                    visited[unkIndex] = true;
                }
                PriorityQueue<DistanceToV> qPrior = new PriorityQueue<DistanceToV>();
                qPrior.add(new DistanceToV(reachedValueIndex, request.reachedValueCost()));
                while (!qPrior.isEmpty()) {
                    int v = ((DistanceToV)qPrior.poll()).index;
                    if (visited[v]) continue;
                    visited[v] = true;
                    for (Transition t : (ArrayList)DTGImp.this.transitions.get(v)) {
                        if (this.minCost[t.toValue] <= this.minCost[v] + t.getCost() && t.toValue != unkIndex || this.minCost[t.toValue] <= this.minCost[v] + t.getCost()) continue;
                        this.minCost[t.toValue] = this.minCost[v] + t.getCost();
                        this.minPath[t.toValue] = v;
                        this.agent[t.toValue] = null;
                        qPrior.add(new DistanceToV(t.toValue, this.minCost[t.toValue]));
                    }
                }
            }
        }

        public int getPathCost(String value) {
            Integer index = (Integer)DTGImp.this.valueIndex.get(value);
            if (index == null) {
                return -1;
            }
            return this.minCost[index];
        }
    }

    public class Path {
        private String[] path = null;
        private int cost = 0x2AAAAAAA;

        public Path(String initialValue, String endValue, HashMap<String, String> state, HashMap<String, ArrayList<String>> newValues, int threadIndex) {
            Integer index = (Integer)DTGImp.this.valueIndex.get(initialValue);
            if (index == null) {
                return;
            }
            int init = index;
            index = (Integer)DTGImp.this.valueIndex.get(endValue);
            if (index == null) {
                return;
            }
            int end = index;
            if (init == end) {
                this.path = new String[1];
                this.path[0] = initialValue;
                this.cost = 0;
            } else {
                this.path = DTGImp.this.computeDijkstraPath(initialValue, endValue);
                if (this.path == null) {
                    return;
                }
                this.cost = this.evaluateCost(this.path, state, newValues, threadIndex);
                this.computeShortestPath(init, end, state, newValues, threadIndex);
            }
        }

        private int evaluateCost(String[] p, HashMap<String, String> state, HashMap<String, ArrayList<String>> newValues, int threadIndex) {
            Hashtable<String, String> s = new Hashtable<String, String>();
            if (state != null) {
                s.putAll(state);
            }
            int c = 0;
            for (int i = 1; i < p.length; ++i) {
                DTGTransition t = DTGImp.this.getTransition(p[i - 1], p[i]);
                if (t == null) {
                    return 0x2AAAAAAA;
                }
                c += this.computeCost(t, s, newValues, threadIndex) + 1;
                this.updateState(t, s, null);
            }
            return c;
        }

        private void updateState(DTGTransition t, Hashtable<String, String> state, ArrayList<String> valuesBackup) {
            for (GroundedEff eff : t.getCommonEffects()) {
                String value = state.put(eff.getVar().toString(), eff.getValue());
                if (valuesBackup == null) continue;
                valuesBackup.add(value);
            }
        }

        private int computeCost(DTGTransition t, Hashtable<String, String> state, HashMap<String, ArrayList<String>> newValues, int threadIndex) {
            int res = 0;
            for (GroundedCond c : t.getCommonPreconditions()) {
                ArrayList<String> valueList;
                String varName = c.getVar().toString();
                String stateValue = state.get(varName);
                DTG dtg = DTGImp.this.dtgSet.getDTG(varName);
                int bestCost = stateValue != null && !stateValue.equals(c.getValue()) ? dtg.getDistance(stateValue, c.getValue(), threadIndex) : 0;
                if (newValues != null && (valueList = newValues.get(varName)) != null) {
                    for (String value : valueList) {
                        int auxCost = value.equals(c.getValue()) ? 0 : dtg.getDistance(value, c.getValue(), threadIndex);
                        if (auxCost >= bestCost) continue;
                        bestCost = auxCost;
                    }
                }
                res += bestCost;
            }
            return res;
        }

        private void computeShortestPath(int initValue, int endValue, HashMap<String, String> state, HashMap<String, ArrayList<String>> newValues, int threadIndex) {
            DTGImp.this.searchNodes = 0;
            Hashtable<String, String> s = new Hashtable<String, String>();
            boolean[] visited = new boolean[DTGImp.this.values.length];
            ArrayList<String> p = new ArrayList<String>();
            visited[initValue] = true;
            for (Transition t : (ArrayList)DTGImp.this.transitions.get(initValue)) {
                s.clear();
                if (state != null) {
                    s.putAll(state);
                }
                p.clear();
                p.add(DTGImp.this.values[initValue]);
                this.computeShortestPath(t, endValue, s, newValues, p, visited, 0, threadIndex);
            }
        }

        private void computeShortestPath(Transition t, int endValue, Hashtable<String, String> state, HashMap<String, ArrayList<String>> newValues, ArrayList<String> p, boolean[] visited, int currentCost, int threadIndex) {
            if (++currentCost >= this.cost) {
                return;
            }
            if ((currentCost += this.computeCost(t, state, newValues, threadIndex)) >= this.cost) {
                return;
            }
            p.add(DTGImp.this.values[t.toValue]);
            if (t.toValue == endValue) {
                if (currentCost < this.cost) {
                    this.cost = currentCost;
                    this.path = p.toArray(new String[p.size()]);
                    p.remove(p.size() - 1);
                }
                return;
            }
            ArrayList<String> valuesBackup = new ArrayList<String>();
            this.updateState(t, state, valuesBackup);
            visited[t.toValue] = true;
            if (++DTGImp.this.searchNodes < 9999) {
                for (Transition next : (ArrayList)DTGImp.this.transitions.get(t.toValue)) {
                    if (visited[next.toValue]) continue;
                    this.computeShortestPath(next, endValue, state, newValues, p, visited, currentCost, threadIndex);
                }
            }
            visited[t.toValue] = false;
            p.remove(p.size() - 1);
            int i = 0;
            for (GroundedEff eff : t.commonEffs) {
                String value;
                if ((value = valuesBackup.get(i++)) != null) {
                    state.put(eff.getVar().toString(), value);
                    continue;
                }
                state.remove(eff.getVar().toString());
            }
        }

        public int getCost() {
            return this.cost;
        }

        public String[] getPath() {
            return this.path;
        }
    }

    public class Transition
    implements DTGTransition {
        int fromValue;
        int toValue;
        ArrayList<Action> actions;
        ArrayList<GroundedCond> commonPrecs;
        ArrayList<GroundedEff> commonEffs;
        boolean newTransition;
        ArrayList<String> agents = new ArrayList();

        public Transition(int fromValue, int toValue, Action a, String agent) {
            this.agents.add(agent);
            this.fromValue = fromValue;
            this.toValue = toValue;
            this.newTransition = true;
            this.actions = new ArrayList();
            this.actions.add(a);
            this.commonPrecs = new ArrayList();
            for (GroundedCond groundedCond : a.getPrecs()) {
                this.commonPrecs.add(groundedCond);
            }
            this.commonEffs = new ArrayList();
            for (Serializable serializable : a.getEffs()) {
                this.commonEffs.add((GroundedEff)serializable);
            }
        }

        public Transition(int svIndex, int fvIndex, GroundedCond[] precs, GroundedEff[] effs, String agent) {
            this.agents.add(agent);
            this.fromValue = svIndex;
            this.toValue = fvIndex;
            this.newTransition = !DTGImp.this.values[svIndex].equals("?") && !DTGImp.this.values[fvIndex].equals("?");
            this.actions = new ArrayList();
            this.commonPrecs = new ArrayList();
            for (GroundedCond groundedCond : precs) {
                this.commonPrecs.add(groundedCond);
            }
            this.commonEffs = new ArrayList();
            for (Serializable serializable : effs) {
                this.commonEffs.add((GroundedEff)serializable);
            }
        }

        public int getCost() {
            return 1;
        }

        public void boundCommonPrecs(GroundedCond[] precs, String fromAgent) {
            int i = 0;
            while (i < this.commonPrecs.size()) {
                boolean exists = false;
                GroundedCond cPrec = this.commonPrecs.get(i);
                for (GroundedCond p : precs) {
                    if (p.getCondition() != cPrec.getCondition() || !p.getVar().equals(cPrec.getVar()) || !p.getValue().equals(cPrec.getValue())) continue;
                    exists = true;
                    break;
                }
                if (exists) {
                    ++i;
                    continue;
                }
                this.commonPrecs.remove(i);
            }
            if (!this.agents.contains(fromAgent)) {
                this.agents.add(fromAgent);
            }
        }

        public void addAction(Action a, String agent) {
            boolean newAction = true;
            if (!this.agents.contains(agent)) {
                this.agents.add(agent);
            }
            for (Action aux : this.actions) {
                if (aux != a) continue;
                newAction = false;
                break;
            }
            if (newAction) {
                this.actions.add(a);
                int i = 0;
                while (i < this.commonPrecs.size()) {
                    if (this.requires(a, this.commonPrecs.get(i))) {
                        ++i;
                        continue;
                    }
                    this.commonPrecs.remove(i);
                }
                i = 0;
                while (i < this.commonEffs.size()) {
                    if (this.changes(a, this.commonEffs.get(i))) {
                        ++i;
                        continue;
                    }
                    this.commonEffs.remove(i);
                }
            }
        }

        private boolean changes(Action a, GroundedEff eff) {
            for (GroundedEff e : a.getEffs()) {
                if (!e.getVar().equals(eff.getVar()) || !e.getValue().equals(eff.getValue())) continue;
                return true;
            }
            return false;
        }

        private boolean requires(Action a, GroundedCond prec) {
            for (GroundedCond p : a.getPrecs()) {
                if (p.getCondition() != prec.getCondition() || !p.getVar().equals(prec.getVar()) || !p.getValue().equals(prec.getValue())) continue;
                return true;
            }
            return false;
        }

        public String toString() {
            String s1 = "";
            for (GroundedCond c : this.commonPrecs) {
                if (s1.equals("")) {
                    s1 = c.toString();
                    continue;
                }
                s1 = s1 + "," + c.toString();
            }
            String s2 = "";
            for (Action a : this.actions) {
                if (s2.equals("")) {
                    s2 = a.toString();
                    continue;
                }
                s2 = s2 + "," + a.toString();
            }
            String s3 = "";
            for (GroundedEff c : this.commonEffs) {
                if (s3.equals("")) {
                    s3 = c.toString();
                    continue;
                }
                s3 = s3 + "," + c.toString();
            }
            return "[" + this.agents + "] " + DTGImp.this.values[this.fromValue] + "->" + DTGImp.this.values[this.toValue] + " [" + s1 + "]" + " {" + s2 + "}" + " [" + s3 + "]";
        }

        @Override
        public GroundedVar getVar() {
            return DTGImp.this.var;
        }

        @Override
        public String getStartValue() {
            return DTGImp.this.values[this.fromValue];
        }

        @Override
        public String getFinalValue() {
            return DTGImp.this.values[this.toValue];
        }

        @Override
        public ArrayList<GroundedCond> getCommonPreconditions() {
            return this.commonPrecs;
        }

        @Override
        public ArrayList<GroundedEff> getCommonEffects() {
            return this.commonEffs;
        }

        @Override
        public ArrayList<String> getAgents() {
            return this.agents;
        }
    }

    private static class TransitionMemo {
        String fromValue;
        String toValue;

        public TransitionMemo(String initialValue, String endValue) {
            this.fromValue = initialValue;
            this.toValue = endValue;
        }

        public boolean equals(Object x) {
            TransitionMemo tm = (TransitionMemo)x;
            return tm.fromValue.equals(this.fromValue) && tm.toValue.equals(this.toValue);
        }

        public String toString() {
            return this.fromValue + " " + this.toValue;
        }

        public int hashCode() {
            return (this.fromValue + " " + this.toValue).hashCode();
        }
    }

    private static class DistanceToV
    implements Comparable<DistanceToV> {
        int index;
        int cost;

        public DistanceToV(int index, int cost) {
            this.index = index;
            this.cost = cost;
        }

        @Override
        public int compareTo(DistanceToV dv) {
            if (this.cost < dv.cost) {
                return -1;
            }
            if (this.cost > dv.cost) {
                return 1;
            }
            return 0;
        }
    }
}

