/*
 * Decompiled with CFR 0.152.
 */
package org.agreement_technologies.service.map_dtg;

import java.io.Serializable;
import java.util.ArrayList;
import org.agreement_technologies.common.map_dtg.DTGTransition;
import org.agreement_technologies.common.map_grounding.GroundedCond;
import org.agreement_technologies.common.map_grounding.GroundedEff;
import org.agreement_technologies.common.map_grounding.GroundedTask;
import org.agreement_technologies.common.map_grounding.GroundedVar;

public class DTGData
implements Serializable {
    private static final long serialVersionUID = 6011631219080464901L;
    private final String varName;
    private final String fromValue;
    private final String toValue;
    private final ArrayList<DTGCondition> commonPrecs;
    private final ArrayList<DTGEffect> commonEffs;

    public static boolean shareable(DTGTransition t, String ag) {
        GroundedVar v = t.getVar();
        if (!v.shareable(ag)) {
            return false;
        }
        return v.shareable(t.getStartValue(), ag) || v.shareable(t.getFinalValue(), ag);
    }

    public DTGData(DTGTransition t, String ag) {
        GroundedVar v = t.getVar();
        this.varName = v.shareable(ag) ? v.toString() : "?";
        this.fromValue = v.shareable(t.getStartValue(), ag) ? t.getStartValue() : "?";
        this.toValue = v.shareable(t.getFinalValue(), ag) ? t.getFinalValue() : "?";
        this.commonPrecs = new ArrayList();
        for (GroundedCond prec : t.getCommonPreconditions()) {
            if (!prec.getVar().shareable(prec.getValue(), ag)) continue;
            this.commonPrecs.add(new DTGCondition(prec));
        }
        this.commonEffs = new ArrayList();
        for (GroundedEff eff : t.getCommonEffects()) {
            if (!eff.getVar().shareable(eff.getValue(), ag)) continue;
            this.commonEffs.add(new DTGEffect(eff));
        }
    }

    public String toString() {
        String s = "";
        for (DTGCondition prec : this.commonPrecs) {
            if (s.equals("")) {
                s = prec.toString();
                continue;
            }
            s = s + "," + prec.toString();
        }
        return this.varName + ": " + this.fromValue + "->" + this.toValue + " [" + s + "]";
    }

    public String getVarName() {
        return this.varName;
    }

    public String getStartValue() {
        return this.fromValue;
    }

    public String getFinalValue() {
        return this.toValue;
    }

    public GroundedCond[] getCommonPrecs(GroundedTask task) {
        GroundedVar[] vars = task.getVars();
        GroundedCond[] precs = new GroundedCond[this.commonPrecs.size()];
        for (int i = 0; i < this.commonPrecs.size(); ++i) {
            DTGCondition c = this.commonPrecs.get(i);
            GroundedVar v = null;
            for (GroundedVar aux : vars) {
                if (!c.varName.equals(aux.toString())) continue;
                v = aux;
                break;
            }
            if (v == null) {
                throw new RuntimeException("Unknown variable '" + c.varName + "' received during the DTG construction");
            }
            precs[i] = task.createGroundedCondition(c.condition, v, c.value);
        }
        return precs;
    }

    public GroundedEff[] getCommonEffs(GroundedTask task) {
        GroundedVar[] vars = task.getVars();
        GroundedEff[] effs = new GroundedEff[this.commonEffs.size()];
        for (int i = 0; i < this.commonEffs.size(); ++i) {
            DTGEffect c = this.commonEffs.get(i);
            GroundedVar v = null;
            for (GroundedVar aux : vars) {
                if (!c.varName.equals(aux.toString())) continue;
                v = aux;
                break;
            }
            if (v == null) {
                throw new RuntimeException("Unknown variable '" + c.varName + "' received during the DTG construction");
            }
            effs[i] = task.createGroundedEffect(v, c.value);
        }
        return effs;
    }

    private static class DTGEffect
    implements Serializable {
        private static final long serialVersionUID = -8967487407479184565L;
        private String varName;
        private String value;

        public DTGEffect(GroundedEff eff) {
            this.varName = eff.getVar().toString();
            this.value = eff.getValue();
        }

        public String toString() {
            return "(" + this.varName + "=" + this.value + ")";
        }
    }

    private static class DTGCondition
    implements Serializable {
        private static final long serialVersionUID = -8411329280671918342L;
        private int condition;
        private String varName;
        private String value;

        public DTGCondition(GroundedCond prec) {
            this.condition = prec.getCondition();
            this.varName = prec.getVar().toString();
            this.value = prec.getValue();
        }

        public String toString() {
            return "(" + this.varName + (this.condition == 1 ? "=" : "<>") + this.value + ")";
        }
    }
}

