/*
 * Decompiled with CFR 0.152.
 */
package org.agreement_technologies.service.map_communication;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Vector;
import org.agreement_technologies.common.map_communication.AgentCommunication;
import org.agreement_technologies.common.map_communication.Message;
import org.agreement_technologies.common.map_communication.MessageFilter;
import org.agreement_technologies.common.map_parser.AgentList;
import org.agreement_technologies.common.map_parser.Task;
import org.agreement_technologies.service.map_communication.CommunicationServer;
import org.agreement_technologies.service.map_communication.MessageImp;

public class AgentCommunicationImp
implements AgentCommunication {
    private static final int WAIT_TIME_MESSAGE = 1;
    private static final int WAIT_TIMEOUT_MESSAGE = 30000;
    private final String agentName;
    private final ArrayList<AgentIP> otherAgents;
    private final ArrayList<AgentIP> allAgents;
    private int batonAgent;
    private int thisAgentIndex;
    private Vector<Message> msgQueue;
    private int numMessages;
    private String senderAgent;
    private CommunicationServer server;
    private HashMap<String, String> ipAddress;
    private HashMap<String, Integer> portIndex;
    private HashMap<String, Integer> agentIndex;
    private ArrayList<String> agentNames;
    private ArrayList<String> otherAgentNames;
    private Socket[] clientSockets;

    private AgentCommunicationImp(String agentName) {
        this.agentName = agentName.toLowerCase();
        this.otherAgents = new ArrayList();
        this.allAgents = new ArrayList();
        this.msgQueue = new Vector();
        this.ipAddress = new HashMap();
        this.portIndex = new HashMap();
        this.agentIndex = new HashMap();
        this.agentNames = new ArrayList();
        this.otherAgentNames = new ArrayList();
        this.numMessages = 0;
        this.batonAgent = 0;
    }

    public AgentCommunicationImp(String agentName, Task task) throws IOException {
        this(agentName);
        int i;
        String[] objs;
        for (String obj : objs = task.getObjects()) {
            if (!this.isAgent(obj, task)) continue;
            if (!obj.equalsIgnoreCase(agentName)) {
                this.otherAgents.add(new AgentIP(obj.toLowerCase(), "127.0.0.1"));
            }
            this.allAgents.add(new AgentIP(obj.toLowerCase(), "127.0.0.1"));
        }
        Collections.sort(this.allAgents);
        Collections.sort(this.otherAgents);
        if (this.allAgents.isEmpty()) {
            this.allAgents.add(new AgentIP(this.agentName, "127.0.0.1"));
        }
        this.thisAgentIndex = this.allAgents.indexOf(new AgentIP(this.agentName));
        for (i = 0; i < this.allAgents.size(); ++i) {
            this.ipAddress.put(this.allAgents.get((int)i).name, this.allAgents.get((int)i).ip);
            this.portIndex.put(this.allAgents.get((int)i).name, 38000 + i);
            this.agentIndex.put(this.allAgents.get((int)i).name, i);
            this.agentNames.add(this.allAgents.get((int)i).name);
        }
        for (i = 0; i < this.otherAgents.size(); ++i) {
            this.otherAgentNames.add(this.otherAgents.get((int)i).name);
        }
        this.clientSockets = new Socket[this.allAgents.size()];
        this.server = new CommunicationServer(this, this.thisAgentIndex, this.otherAgentNames.size());
        this.server.start();
    }

    public AgentCommunicationImp(String agentName, AgentList agList) throws IOException {
        this(agentName);
        int i;
        for (i = 0; i < agList.numAgents(); ++i) {
            String agName = agList.getName(i).toLowerCase();
            if (!agName.equalsIgnoreCase(agentName)) {
                this.otherAgents.add(new AgentIP(agName, agList.getIP(i)));
            }
            this.allAgents.add(new AgentIP(agName, agList.getIP(i)));
        }
        Collections.sort(this.allAgents);
        Collections.sort(this.otherAgents);
        if (this.allAgents.isEmpty()) {
            this.allAgents.add(new AgentIP(this.agentName, "127.0.0.1"));
        }
        this.thisAgentIndex = this.allAgents.indexOf(new AgentIP(this.agentName));
        for (i = 0; i < this.allAgents.size(); ++i) {
            this.ipAddress.put(this.allAgents.get((int)i).name, this.allAgents.get((int)i).ip);
            this.portIndex.put(this.allAgents.get((int)i).name, 38000 + i);
            this.agentIndex.put(this.allAgents.get((int)i).name, i);
            this.agentNames.add(this.allAgents.get((int)i).name);
        }
        for (i = 0; i < this.otherAgents.size(); ++i) {
            this.otherAgentNames.add(this.otherAgents.get((int)i).name);
        }
        this.clientSockets = new Socket[this.allAgents.size()];
        this.server = new CommunicationServer(this, this.thisAgentIndex, this.otherAgentNames.size());
        this.server.start();
    }

    @Override
    public void enqueueMsg(Message message) {
        this.msgQueue.add(message);
    }

    @Override
    public boolean registeredAgent(String ag) {
        int socketIndex = this.agentIndex.get(ag);
        try {
            if (this.clientSockets[socketIndex] == null) {
                this.clientSockets[socketIndex] = new Socket(this.ipAddress.get(ag), (int)this.portIndex.get(ag));
            }
            return true;
        }
        catch (IOException ex) {
            return false;
        }
    }

    private boolean isAgent(String obj, Task task) {
        String[] types;
        for (String t : types = task.getObjectTypes(obj)) {
            if (!t.equalsIgnoreCase("agent")) continue;
            return true;
        }
        for (String t : types) {
            if (!this.isAgentType(t, task)) continue;
            return true;
        }
        return false;
    }

    private boolean isAgentType(String type, Task task) {
        String[] ptypes;
        for (String t : ptypes = task.getParentTypes(type)) {
            if (!t.equalsIgnoreCase("agent")) continue;
            return true;
        }
        for (String t : ptypes) {
            if (!this.isAgentType(t, task)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int getThisAgentIndex() {
        return this.thisAgentIndex;
    }

    @Override
    public String getThisAgentName() {
        return this.agentName;
    }

    @Override
    public ArrayList<String> getAgentList() {
        return this.agentNames;
    }

    @Override
    public int numAgents() {
        return this.allAgents.size();
    }

    @Override
    public String getSenderAgent() {
        return this.senderAgent;
    }

    @Override
    public boolean batonAgent() {
        return this.batonAgent == this.thisAgentIndex;
    }

    @Override
    public String getBatonAgent() {
        return this.agentNames.get(this.batonAgent);
    }

    @Override
    public ArrayList<String> getOtherAgents() {
        return this.otherAgentNames;
    }

    @Override
    public int getAgentIndex(String agName) {
        return this.agentNames.indexOf(agName);
    }

    @Override
    public int getNumMessages() {
        return this.numMessages;
    }

    @Override
    public void sendMessage(Serializable obj, boolean waitACK) {
        for (String toAgent : this.otherAgentNames) {
            this.sendMessage(toAgent, obj, waitACK);
        }
    }

    @Override
    public void sendMessage(String toAgent, Serializable obj, boolean waitACK) {
        int socketIndex = this.agentIndex.get(toAgent);
        try {
            if (this.clientSockets[socketIndex] == null) {
                this.clientSockets[socketIndex] = new Socket(this.ipAddress.get(toAgent), (int)this.portIndex.get(toAgent));
            }
            Socket socket = this.clientSockets[socketIndex];
            ObjectOutputStream out = new ObjectOutputStream(socket.getOutputStream());
            out.writeObject(new MessageImp(obj, this.agentName));
            out.flush();
        }
        catch (IOException ex) {
            throw new CommunicationException(ex.toString());
        }
        if (waitACK) {
            Message resp;
            int time = 0;
            do {
                resp = this.checkQueue(toAgent, (Serializable)((Object)"<ACK>"));
                this.wait(1);
                if (++time < 30000) continue;
                throw new RuntimeException("Message timeout while waiting an ACK from agent " + toAgent);
            } while (resp == null);
        }
        ++this.numMessages;
    }

    private Message checkQueue(String fromAgent, Serializable cont) {
        int index = -1;
        Message res = null;
        for (int i = 0; i < this.msgQueue.size(); ++i) {
            Message msg = this.msgQueue.get(i);
            if (!msg.sender().equalsIgnoreCase(fromAgent) || !cont.equals(msg.content())) continue;
            index = i;
            break;
        }
        if (index != -1) {
            res = this.msgQueue.get(index);
            this.msgQueue.remove(index);
        }
        return res;
    }

    private Message checkQueue(String fromAgent) {
        int index = -1;
        Message res = null;
        for (int i = 0; i < this.msgQueue.size(); ++i) {
            Message msg = this.msgQueue.get(i);
            if (!msg.sender().equalsIgnoreCase(fromAgent) || "<ACK>".equals(msg.content())) continue;
            index = i;
            break;
        }
        if (index != -1) {
            res = this.msgQueue.get(index);
            this.msgQueue.remove(index);
        }
        return res;
    }

    private Message checkQueue(MessageFilter filter) {
        int index = -1;
        Message res = null;
        for (int i = 0; i < this.msgQueue.size(); ++i) {
            Message m = this.msgQueue.get(i);
            if (!filter.validMessage(m)) continue;
            index = i;
            break;
        }
        if (index != -1) {
            res = this.msgQueue.get(index);
            this.msgQueue.remove(index);
        }
        return res;
    }

    @Override
    public Serializable receiveMessage(String fromAgent, boolean sendACK) {
        Message msg;
        int time = 0;
        do {
            if ((msg = this.checkQueue(fromAgent)) != null) continue;
            this.wait(1);
            if (++time < 30000) continue;
            throw new RuntimeException("Message timeout while waiting a message from agent " + fromAgent);
        } while (msg == null);
        this.senderAgent = fromAgent.toLowerCase();
        Serializable obj = msg.content();
        if (sendACK) {
            this.sendMessage(msg.sender(), (Serializable)((Object)"<ACK>"), false);
        }
        return obj;
    }

    @Override
    public Serializable receiveMessage(MessageFilter filter, boolean sendACK) {
        Message msg;
        int time = 0;
        do {
            if ((msg = this.checkQueue(filter)) != null) continue;
            this.wait(1);
            if (++time < 30000) continue;
            throw new RuntimeException("Message timeout while waiting a filtered message");
        } while (msg == null);
        this.senderAgent = msg.sender();
        Serializable obj = msg.content();
        if (sendACK) {
            this.sendMessage(msg.sender(), (Serializable)((Object)"<ACK>"), false);
        }
        return obj;
    }

    @Override
    public Serializable receiveMessage(boolean sendACK) {
        int time = 0;
        while (this.msgQueue.isEmpty()) {
            this.wait(1);
            if (++time < 30000) continue;
            throw new RuntimeException("Message timeout while waiting a message");
        }
        Message msg = this.msgQueue.get(0);
        this.msgQueue.remove(0);
        this.senderAgent = msg.sender();
        Serializable obj = msg.content();
        if (sendACK) {
            this.sendMessage(msg.sender(), (Serializable)((Object)"<ACK>"), false);
        }
        return obj;
    }

    @Override
    public void passBaton() {
        ++this.batonAgent;
        if (this.batonAgent >= this.numAgents()) {
            this.batonAgent = 0;
        }
    }

    private void wait(int time) {
        try {
            Thread.sleep(time);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public void sendAck(String toAgent) {
        this.sendMessage(toAgent, (Serializable)((Object)"<ACK>"), false);
    }

    @Override
    public void close() {
        for (Socket s : this.clientSockets) {
            if (s == null) continue;
            try {
                s.close();
            }
            catch (IOException ex) {
                // empty catch block
            }
        }
    }

    private static class AgentIP
    implements Comparable<AgentIP> {
        String name;
        String ip;

        private AgentIP(String name, String ip) {
            this.name = name;
            this.ip = ip;
        }

        private AgentIP(String agentName) {
            this.name = agentName;
        }

        @Override
        public int compareTo(AgentIP a) {
            return this.name.compareTo(a.name);
        }

        public boolean equals(Object x) {
            return ((AgentIP)x).name.equals(this.name);
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public String toString() {
            return this.name;
        }
    }

    public static class CommunicationException
    extends RuntimeException {
        private static final long serialVersionUID = -7439092128849900745L;

        public CommunicationException(String msg) {
            super(msg);
        }
    }
}

