/*
 * Decompiled with CFR 0.152.
 */
package org.agreement_technologies.agents;

import org.agreement_technologies.agents.AgentListener;
import org.agreement_technologies.agents.PlanningAlgorithm;
import org.agreement_technologies.common.map_communication.AgentCommunication;
import org.agreement_technologies.common.map_communication.PlanningAgentListener;
import org.agreement_technologies.common.map_grounding.GroundedTask;
import org.agreement_technologies.common.map_landmarks.Landmarks;
import org.agreement_technologies.common.map_parser.AgentList;

public class PlanningAgent
extends Thread
implements AgentListener {
    protected PlanningAlgorithm alg;
    protected String name;

    public PlanningAgent(String name, String domainFile, String problemFile, AgentList agList, boolean waitSynch, int sameObjects, boolean traceOn, int h, int searchPerformance) throws Exception {
        this.name = name.toLowerCase();
        this.alg = new PlanningAlgorithm(name, domainFile, problemFile, agList, waitSynch, sameObjects, traceOn, h, searchPerformance);
    }

    @Override
    public void run() {
        this.alg.execute();
    }

    @Override
    public String getShortName() {
        return this.name;
    }

    @Override
    public void setAgentListener(PlanningAgentListener paListener) {
        this.alg.paListener = paListener;
    }

    @Override
    public void selectPlan(String planName) {
        if (this.alg.paListener != null) {
            this.alg.paListener.selectPlan(planName);
        }
    }

    @Override
    public GroundedTask getGroundedTask() {
        return this.alg.groundedTask;
    }

    @Override
    public AgentCommunication getCommunication() {
        return this.alg.comm;
    }

    public boolean isFinished() {
        return this.alg.status == 8 || this.alg.status == 9;
    }

    public boolean isError() {
        return this.alg.status == 9;
    }

    @Override
    public Landmarks getLandmarks() {
        return this.alg.landmarks;
    }

    void shutdown() {
        try {
            if (this.alg.comm != null) {
                this.alg.comm.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

