/*
 * Decompiled with CFR 0.152.
 */
package org.agreement_technologies.agents;

import java.awt.EventQueue;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import org.agreement_technologies.agents.GUIBoot;
import org.agreement_technologies.agents.PlanningAgent;
import org.agreement_technologies.common.map_heuristic.HeuristicFactory;
import org.agreement_technologies.common.map_parser.AgentList;
import org.agreement_technologies.common.map_parser.PDDLParser;
import org.agreement_technologies.common.map_planner.PlannerFactory;
import org.agreement_technologies.service.map_parser.MAPDDLParserImp;
import org.agreement_technologies.service.map_parser.ParserImp;

public class MAPboot {
    public static ArrayList<PlanningAgent> planningAgents;

    public static void main(String[] args) {
        planningAgents = new ArrayList();
        Runtime rt = Runtime.getRuntime();
        rt.addShutdownHook(new Thread(){

            @Override
            public void run() {
                MAPboot.shutdown();
            }
        });
        if (args.length == 0) {
            MAPboot.launchGUI();
        } else {
            MAPboot.launchCommandLine(args);
        }
    }

    private static void launchGUI() {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new GUIBoot().setVisible(true);
            }
        });
    }

    private static void launchCommandLine(String[] args) {
        int searchType = PlannerFactory.getDefaultSearchMethod();
        int heuristic = 2;
        boolean ok = true;
        ArrayList<String> mandatoryArgs = new ArrayList<String>();
        int i = 0;
        while (ok && i < args.length) {
            String arg = args[i].trim().toLowerCase();
            if (arg.equals("-help")) {
                ok = false;
                continue;
            }
            if (arg.equals("-s")) {
                ok = (searchType = MAPboot.getSearchType(args, ++i)) != -1;
                ++i;
                continue;
            }
            if (arg.equals("-h")) {
                ok = (heuristic = MAPboot.getHeuristicFunction(args, ++i)) != -1;
                ++i;
                continue;
            }
            mandatoryArgs.add(args[i++]);
        }
        if (!ok || mandatoryArgs.size() < 3) {
            MAPboot.printUsage();
            return;
        }
        if (!PlannerFactory.checkSearchConstraints(searchType, heuristic)) {
            System.out.println("Error: the search method and the heuristic function are not compatible");
            return;
        }
        if (mandatoryArgs.size() <= 4) {
            String agentFile = mandatoryArgs.size() == 4 ? (String)mandatoryArgs.get(3) : null;
            MAPboot.launchAgent((String)mandatoryArgs.get(0), (String)mandatoryArgs.get(1), (String)mandatoryArgs.get(2), agentFile, searchType, heuristic);
        } else {
            if (HeuristicFactory.getHeuristicInfo(heuristic, 2).equals("no")) {
                System.out.println("The selected heuristic function is not available for multi-agent tasks");
                return;
            }
            int last = mandatoryArgs.size() - 1;
            MAPDDLParserImp p = new MAPDDLParserImp();
            try {
                int n;
                AgentList agList;
                switch (mandatoryArgs.size() % 3) {
                    case 0: {
                        agList = p.createEmptyAgentList();
                        for (n = 0; n < last; n += 3) {
                            agList.addAgent(((String)mandatoryArgs.get(n)).toLowerCase(), "127.0.0.1");
                        }
                        break;
                    }
                    case 1: {
                        agList = p.parseAgentList((String)mandatoryArgs.get(last));
                        break;
                    }
                    default: {
                        MAPboot.printUsage();
                        return;
                    }
                }
                for (n = 0; n < last; n += 3) {
                    PlanningAgent ag = new PlanningAgent(((String)mandatoryArgs.get(n)).toLowerCase(), (String)mandatoryArgs.get(n + 1), (String)mandatoryArgs.get(n + 2), agList, false, 1, false, heuristic, searchType);
                    planningAgents.add(ag);
                }
                for (PlanningAgent ag : planningAgents) {
                    ag.start();
                }
            }
            catch (ParseException ex) {
                System.out.println(ex.getMessage() + ", at line " + ex.getErrorOffset() + " (" + args[last] + ")");
            }
            catch (IOException ex) {
                System.out.println("Read error: " + ex.getMessage() + " (" + args[last] + ")");
            }
            catch (Exception ex) {
                System.out.println("Error  " + ex.getMessage());
            }
        }
    }

    private static void printUsage() {
        int i;
        System.out.println("Invalid number of parameters.");
        System.out.println("Usage:");
        System.out.println("  java -jar FMAP.jar [<agent-name> <domain-file> <problem-file>]+ <agent-list-file>");
        System.out.println("Optional parameters:");
        System.out.println("  -s N\t\tChooses the search method. Valid values of N are:");
        for (i = 0; i < PlannerFactory.SEARCH_METHODS.length; ++i) {
            System.out.println("\t\t\t" + i + ": " + PlannerFactory.SEARCH_METHODS[i] + (i == PlannerFactory.getDefaultSearchMethod() ? " -> default" : ""));
        }
        System.out.println("  -h N\t\tChooses the heuristic function. Valid values of N are:");
        for (i = 0; i < HeuristicFactory.HEURISTICS.length; ++i) {
            System.out.println("\t\t\t" + i + ": " + HeuristicFactory.HEURISTICS[i] + (i == 2 ? " -> default" : ""));
        }
        System.out.println("  -help\t\tDisplays this help and exits");
    }

    private static void launchAgent(String agentName, String domainFile, String problemFile, String agentsFile, int searchType, int heuristic) {
        try {
            AgentList agList;
            PDDLParser p;
            boolean isMAPDDL = new ParserImp().isMAPDDL(domainFile);
            PDDLParser pDDLParser = p = isMAPDDL ? new MAPDDLParserImp() : new ParserImp();
            if (agentsFile == null) {
                agList = p.createEmptyAgentList();
                agList.addAgent(agentName.toLowerCase(), "127.0.0.1");
            } else {
                agList = p.parseAgentList(agentsFile);
            }
            PlanningAgent ag = new PlanningAgent(agentName.toLowerCase(), domainFile, problemFile, agList, true, 1, false, heuristic, searchType);
            planningAgents.add(ag);
            ag.start();
        }
        catch (ParseException ex) {
            System.out.println(ex.getMessage() + ", at line " + ex.getErrorOffset() + " (" + agentsFile + ")");
        }
        catch (IOException ex) {
            System.out.println("Read error: " + ex.getMessage() + " (" + agentsFile + ")");
        }
        catch (Exception ex) {
            System.out.println("Error  " + ex.getMessage());
        }
    }

    public static void shutdown() {
        System.out.println("; Stopping...");
        for (PlanningAgent ag : planningAgents) {
            ag.shutdown();
        }
        planningAgents.clear();
    }

    private static int getSearchType(String[] args, int n) {
        if (n >= args.length) {
            return -1;
        }
        try {
            int s = Integer.parseInt(args[n]);
            return s >= 0 && s < PlannerFactory.SEARCH_METHODS.length ? s : -1;
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    private static int getHeuristicFunction(String[] args, int n) {
        if (n >= args.length) {
            return -1;
        }
        try {
            int h = Integer.parseInt(args[n]);
            return h >= 0 && h < HeuristicFactory.HEURISTICS.length ? h : -1;
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }
}

