/*
 * Decompiled with CFR 0.152.
 */
package org.agreement_technologies.agents;

import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.BadLocationException;
import org.agreement_technologies.agents.AgentListener;

public class GUITrace
extends JFrame
implements CaretListener,
MouseListener {
    private static final long serialVersionUID = 3465968268556479994L;
    private static final String[] VIGNETTE = new String[]{"", "*", "+", "-"};
    private final AgentListener ag;
    private JTextArea taTrace;
    private int lineNum;

    public GUITrace(AgentListener ag) {
        this.ag = ag;
        this.setTitle("Trace: " + this.ag.getShortName());
        this.setSize(500, 600);
        this.setLocationRelativeTo(null);
        this.initComponents();
    }

    private void initComponents() {
        this.lineNum = -1;
        this.taTrace = new JTextArea();
        this.taTrace.setEditable(false);
        this.taTrace.addCaretListener(this);
        this.taTrace.addMouseListener(this);
        JScrollPane jspScroll = new JScrollPane();
        jspScroll.setViewportView(this.taTrace);
        this.getContentPane().add(jspScroll);
    }

    public void showError(String msg) {
        this.showInfo(0, "ERROR: " + msg);
    }

    public void showInfo(int level, String msg) {
        String pre = level < VIGNETTE.length ? VIGNETTE[level] : ">";
        for (int i = 0; i < level; ++i) {
            pre = "  " + pre;
        }
        if (level != 0) {
            pre = pre + " ";
        }
        this.taTrace.append(pre + msg + "\n");
        this.taTrace.setCaretPosition(this.taTrace.getDocument().getLength());
    }

    @Override
    public void caretUpdate(CaretEvent arg0) {
        int caretPos = this.taTrace.getCaretPosition();
        try {
            this.lineNum = this.taTrace.getLineOfOffset(caretPos);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getButton() == 1 && e.getClickCount() == 2 && this.lineNum >= 0) {
            try {
                int start = this.taTrace.getLineStartOffset(this.lineNum);
                int end = this.taTrace.getLineEndOffset(this.lineNum);
                String line = this.taTrace.getText().substring(start, end).trim();
                int pos = line.indexOf("\u03a0");
                if (pos >= 0) {
                    if ((pos = (line = line.substring(pos)).indexOf(" ")) >= 0) {
                        line = line.substring(0, pos);
                    }
                    this.ag.selectPlan(line.trim());
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }
}

