/*
 * Decompiled with CFR 0.152.
 */
package org.agreement_technologies.agents;

import java.awt.Color;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.agreement_technologies.agents.AgentListener;
import org.agreement_technologies.agents.GUILandmarks;
import org.agreement_technologies.agents.GUISearchTree;
import org.agreement_technologies.agents.GUITrace;
import org.agreement_technologies.agents.GUIdisRPG;
import org.agreement_technologies.agents.PlanningAlgorithm;
import org.agreement_technologies.common.map_communication.PlanningAgentListener;
import org.agreement_technologies.common.map_planner.Plan;
import org.agreement_technologies.common.map_planner.PlannerFactory;

public class GUIPlanningAgent
extends JDialog
implements PlanningAgentListener,
ActionListener {
    private static final long serialVersionUID = -730178402960432486L;
    private static final int FORM_WIDTH = 210;
    private final AgentListener ag;
    private int status;
    private JButton btnTrace;
    private JButton btnRPG;
    private JButton btnSerachTree;
    private JButton btnLND;
    private JLabel lblStatus;
    private StatusPanel statusPanel;
    private GUITrace guiTrace;
    private GUIdisRPG guiRPG;
    private GUISearchTree guiSearchTree;
    private GUILandmarks guiLandmarks;

    public GUIPlanningAgent(AgentListener ag) {
        this.ag = ag;
        this.status = 0;
        ag.setAgentListener(this);
        this.setTitle(this.ag.getShortName());
        this.setSize(210, 200);
        this.setResizable(true);
        this.initComponents();
        this.initSubforms();
        this.setVisible(true);
    }

    private void initSubforms() {
        this.guiTrace = new GUITrace(this.ag);
        this.guiRPG = null;
        this.guiSearchTree = null;
        this.guiLandmarks = null;
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                if (GUIPlanningAgent.this.guiTrace != null && GUIPlanningAgent.this.guiTrace.isVisible()) {
                    GUIPlanningAgent.this.guiTrace.setVisible(false);
                }
                if (GUIPlanningAgent.this.guiRPG != null && GUIPlanningAgent.this.guiRPG.isVisible()) {
                    GUIPlanningAgent.this.guiRPG.setVisible(false);
                }
                if (GUIPlanningAgent.this.guiLandmarks != null && GUIPlanningAgent.this.guiLandmarks.isVisible()) {
                    GUIPlanningAgent.this.guiLandmarks.setVisible(false);
                }
                if (GUIPlanningAgent.this.guiSearchTree != null && GUIPlanningAgent.this.guiSearchTree.isVisible()) {
                    GUIPlanningAgent.this.guiSearchTree.setVisible(false);
                }
                GUIPlanningAgent.this.guiTrace = null;
                GUIPlanningAgent.this.guiRPG = null;
                GUIPlanningAgent.this.guiSearchTree = null;
                GUIPlanningAgent.this.guiLandmarks = null;
            }
        });
    }

    private void initComponents() {
        Container panel = this.getContentPane();
        panel.setLayout(new GridLayout(5, 1));
        ((GridLayout)panel.getLayout()).setVgap(1);
        this.btnTrace = new JButton("Trace");
        this.btnRPG = new JButton("disRPG");
        this.btnLND = new JButton("Landmarks");
        this.btnSerachTree = new JButton("Search tree");
        this.btnRPG.setEnabled(false);
        this.btnLND.setEnabled(false);
        this.btnSerachTree.setEnabled(false);
        panel.add(this.btnTrace);
        panel.add(this.btnRPG);
        panel.add(this.btnLND);
        panel.add(this.btnSerachTree);
        this.btnTrace.addActionListener(this);
        this.btnRPG.addActionListener(this);
        this.btnLND.addActionListener(this);
        this.btnSerachTree.addActionListener(this);
        this.statusPanel = new StatusPanel(new FlowLayout(0));
        JLabel label = new JLabel("Status: ");
        label.setFont(new Font("TimesRoman", 1, 12));
        this.statusPanel.add(label);
        this.lblStatus = new JLabel("starting");
        this.lblStatus.setFont(new Font("TimesRoman", 2, 12));
        this.statusPanel.add(this.lblStatus);
        panel.add(this.statusPanel);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.btnTrace) {
            this.guiTrace.setVisible(!this.guiTrace.isVisible());
        } else if (e.getSource() == this.btnRPG) {
            this.guiRPG.setVisible(!this.guiRPG.isVisible());
        } else if (e.getSource() == this.btnSerachTree) {
            this.guiSearchTree.setVisible(!this.guiSearchTree.isVisible());
        } else if (e.getSource() == this.btnLND) {
            this.guiLandmarks.setVisible(!this.guiLandmarks.isVisible());
        }
    }

    @Override
    public void statusChanged(int status) {
        this.lblStatus.setText(PlanningAlgorithm.getStatusDesc(status));
        switch (this.status) {
            case 2: {
                if (status == 9 || this.btnRPG.isEnabled()) break;
                this.guiRPG = new GUIdisRPG(this.ag);
                this.btnRPG.setEnabled(true);
                break;
            }
            case 4: {
                if (status == 9 || this.btnLND.isEnabled()) break;
                this.guiLandmarks = new GUILandmarks(this.ag);
                this.btnLND.setEnabled(true);
            }
        }
        this.status = status;
    }

    @Override
    public void notyfyError(String msg) {
        this.guiTrace.showError(msg);
    }

    @Override
    public void trace(int indentLevel, String msg) {
        this.guiTrace.showInfo(indentLevel, msg);
    }

    @Override
    public void newPlan(Plan plan, PlannerFactory pf) {
        if (this.guiSearchTree == null) {
            this.guiSearchTree = new GUISearchTree(this.ag);
            this.btnSerachTree.setEnabled(true);
        }
        this.guiSearchTree.newPlan(plan, pf);
        this.statusPanel.setH(plan.getH());
    }

    @Override
    public void showPlan(Plan plan, PlannerFactory pf) {
        if (this.guiSearchTree == null) {
            this.guiSearchTree = new GUISearchTree(this.ag);
            this.btnSerachTree.setEnabled(true);
        }
        this.guiSearchTree.showPlan(plan, pf);
    }

    @Override
    public void selectPlan(String planName) {
        if (this.guiSearchTree != null) {
            if (!this.guiSearchTree.isVisible()) {
                this.guiSearchTree.setVisible(true);
            }
            this.guiSearchTree.toFront();
            this.guiSearchTree.selectPlan(planName);
        }
    }

    private static class StatusPanel
    extends JPanel {
        private static final long serialVersionUID = 317308883562686365L;
        private int maxH = -1;
        private int minH = -1;
        private float blue = 255.0f;

        public StatusPanel(LayoutManager layout) {
            super(layout);
        }

        public void setH(int h) {
            if (this.maxH == -1 && h > 0) {
                this.maxH = this.minH = h;
            }
            if (h < this.minH) {
                this.minH = h;
                this.blue = 255.0f;
            } else {
                this.blue = (float)((double)this.blue - 0.25);
                if (this.blue < 0.0f) {
                    this.blue = 0.0f;
                }
            }
            this.repaint();
        }

        @Override
        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            if (this.maxH > 0 && this.minH > 0) {
                int w = this.minH * (this.getWidth() - 10) / this.maxH;
                int b = (int)this.blue;
                g.setColor(new Color(255 - b, 0, b));
                g.fillRect(5, 24, w, 6);
            }
        }
    }
}

