/*
 * Decompiled with CFR 0.152.
 */
package org.agreement_technologies.agents;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Random;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import org.agreement_technologies.agents.AgentListener;
import org.agreement_technologies.common.map_landmarks.LandmarkFluent;
import org.agreement_technologies.common.map_landmarks.LandmarkNode;
import org.agreement_technologies.common.map_landmarks.LandmarkOrdering;
import org.agreement_technologies.common.map_landmarks.Landmarks;
import org.agreement_technologies.service.map_viewer.PlanViewerImp;
import org.agreement_technologies.service.tools.Graph;

public class GUILandmarks
extends JFrame {
    private static final long serialVersionUID = 5812446400385328544L;
    private LandmarksPane landmarksPane;
    private JScrollPane jScrollPane;

    public GUILandmarks(AgentListener ag) {
        if (ag != null) {
            this.setTitle("Landmarks: " + ag.getShortName());
        }
        this.setSize(800, 600);
        this.setLocationRelativeTo(null);
        this.initComponents(ag);
    }

    private void initComponents(AgentListener ag) {
        this.getContentPane().setLayout(new BorderLayout());
        this.landmarksPane = new LandmarksPane(ag.getLandmarks());
        this.jScrollPane = new JScrollPane();
        this.jScrollPane.setHorizontalScrollBarPolicy(32);
        this.jScrollPane.setPreferredSize(new Dimension(200, 150));
        this.jScrollPane.add(this.landmarksPane);
        this.jScrollPane.setViewportView(this.landmarksPane);
        this.getContentPane().add(this.jScrollPane);
    }

    private static class LandmarksPane
    extends JPanel
    implements MouseListener,
    MouseMotionListener,
    MouseWheelListener,
    ActionListener {
        private static final long serialVersionUID = -1659156643473507799L;
        private BufferedImage back;
        private Graph<LandmarkSet, Integer> graph;
        private ArrayList<DrawNode> nodes;
        private int maxLevel;
        private int width;
        private int height;
        private int mouseX;
        private int mouseY;
        private double scale;
        private DrawNode selected;
        private PopUpMenu popUpMenu;
        private Landmarks landmarks;
        private static final int HORIZ_DST = 300;
        private static final int VERT_GAP = 60;
        private static final int HORIZ_MARGIN = 20;
        private static final int VERT_MARGIN = 20;

        public LandmarksPane(Landmarks landmarks) {
            this.setBackground(Color.WHITE);
            this.scale = 1.0;
            this.selected = null;
            this.landmarks = landmarks;
            this.generateNodes();
            this.addMouseListener(this);
            this.addMouseMotionListener(this);
            this.addMouseWheelListener(this);
            this.popUpMenu = new PopUpMenu();
            this.popUpMenu.itemTrans.addActionListener(this);
            this.popUpMenu.itemCycles.addActionListener(this);
            this.popUpMenu.itemCopy.addActionListener(this);
        }

        private void generateNodes() {
            this.graph = new Graph();
            this.nodes = new ArrayList();
            if (this.landmarks != null) {
                this.preprocessOrderings(this.landmarks);
                this.deleteEmptyLevels();
                this.locateNodes();
            }
            this.graph = null;
            this.width = 100;
            this.height = 100;
            for (DrawNode n : this.nodes) {
                if (n.x + 150 > this.width) {
                    this.width = n.x + 150 + 20;
                }
                if (n.y + n.height() <= this.height) continue;
                this.height = n.y + n.height() + 20;
            }
            this.width += 20;
            this.height += 20;
            this.back = new BufferedImage(this.width, this.height, 5);
            this.setPreferredSize(new Dimension(this.width, this.height));
        }

        private void deleteEmptyLevels() {
            this.maxLevel = 0;
            for (DrawNode n : this.nodes) {
                if (n.level <= this.maxLevel) continue;
                this.maxLevel = n.level;
            }
            int level = 0;
            while (level <= this.maxLevel) {
                boolean empty = true;
                for (DrawNode n : this.nodes) {
                    if (n.level != level) continue;
                    empty = false;
                    break;
                }
                if (empty) {
                    for (DrawNode n : this.nodes) {
                        if (n.level <= level) continue;
                        --n.level;
                    }
                    --this.maxLevel;
                    continue;
                }
                ++level;
            }
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            if (this.back != null) {
                this.draw(this.back.getGraphics());
                g.drawImage(this.back, 0, 0, null);
            }
        }

        private void draw(Graphics g) {
            Graphics2D g2d = (Graphics2D)g;
            g2d.setColor(Color.white);
            g2d.fillRect(0, 0, this.back.getWidth(), this.back.getHeight());
            g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            for (DrawNode n : this.nodes) {
                n.paintArrows(g2d);
            }
            for (DrawNode n : this.nodes) {
                n.paintNode(g2d);
            }
        }

        private void locateNodes() {
            Random rnd = new Random();
            DrawNode[] levels = new DrawNode[this.maxLevel + 1];
            for (DrawNode n : this.nodes) {
                n.x = 20 + n.level * 300;
                DrawNode prev = levels[n.level];
                n.y = prev == null ? 20 : prev.y + prev.height() + 60 + rnd.nextInt(15) - 7;
                levels[n.level] = n;
            }
        }

        private void preprocessOrderings(Landmarks landmarks) {
            ArrayList<DrawNode> rootNodes = new ArrayList<DrawNode>();
            ArrayList<LandmarkOrdering> ords = landmarks.getOrderings(3, false);
            for (LandmarkOrdering o : ords) {
                LandmarkSet ls1 = new LandmarkSet(o.getNode1());
                LandmarkSet ls2 = new LandmarkSet(o.getNode2());
                this.graph.addEdge(ls1, ls2, o.getType());
            }
            for (int i = 0; i < this.graph.numNodes(); ++i) {
                this.nodes.add(new DrawNode(i, this.graph.getNode(i), this.scale));
            }
            for (DrawNode n : this.nodes) {
                ArrayList<Graph.Adjacent<Integer>> adj = this.graph.getAdjacents(n.index);
                for (Graph.Adjacent<Integer> a : adj) {
                    n.addNext(this.nodes.get(a.dst), (Integer)a.label);
                }
                if (!this.graph.isRoot(n.index)) continue;
                rootNodes.add(n);
            }
            if (rootNodes.isEmpty() && this.graph.numNodes() > 0) {
                int[] nList = this.graph.sortNodesByIndegree();
                int minDegree = this.graph.inDegree(nList[0]);
                for (int i = 0; i < nList.length; ++i) {
                    if (this.graph.inDegree(nList[i]) != minDegree) continue;
                    rootNodes.add(this.nodes.get(nList[i]));
                }
            }
            boolean[] placedNodes = new boolean[this.nodes.size()];
            for (DrawNode n : rootNodes) {
                n.level = 0;
                placedNodes[n.index] = true;
            }
            for (int i = 0; i < placedNodes.length; ++i) {
                if (placedNodes[i]) continue;
                this.placeNode(this.nodes.get(i), rootNodes);
            }
        }

        private void placeNode(DrawNode n, ArrayList<DrawNode> rootNodes) {
            n.level = 0;
            for (DrawNode orig : rootNodes) {
                int dist = this.graph.maxDistanceWithCycles(orig.index, n.index);
                if (dist == 0x1FFFFFFF || dist <= n.level) continue;
                n.level = dist;
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (e.getButton() == 1 && this.selected == null) {
                this.mouseX = e.getX();
                this.mouseY = e.getY();
                for (DrawNode n : this.nodes) {
                    if (!n.isSelected(this.mouseX, this.mouseY)) continue;
                    this.selected = n;
                    break;
                }
            } else if (e.getButton() == 3) {
                this.popUpMenu.show(e.getComponent(), e.getX(), e.getY());
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.selected = null;
            if (e.getButton() == 3) {
                this.popUpMenu.show(e.getComponent(), e.getX(), e.getY());
            }
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (this.selected != null) {
                this.selected.move(e.getX() - this.mouseX, e.getY() - this.mouseY);
                this.mouseX = e.getX();
                this.mouseY = e.getY();
                this.repaint();
            }
        }

        @Override
        public void mouseMoved(MouseEvent e) {
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent e) {
            int m = e.getWheelRotation();
            if (m > 0 && this.scale < 4.0) {
                this.scale += 0.25;
            } else if (m < 0 && this.scale > 0.25) {
                this.scale -= 0.25;
            }
            this.setPreferredSize(new Dimension((int)((double)this.width * this.scale), (int)((double)this.height * this.scale)));
            this.back = new BufferedImage((int)((double)this.width * this.scale), (int)((double)this.height * this.scale), 5);
            for (DrawNode n : this.nodes) {
                n.setScale(this.scale);
            }
            this.repaint();
            this.revalidate();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == this.popUpMenu.itemTrans) {
                this.landmarks.filterTransitiveOrders();
                this.generateNodes();
                this.popUpMenu.itemTrans.setEnabled(false);
                this.repaint();
                this.revalidate();
            } else if (e.getSource() == this.popUpMenu.itemCycles) {
                this.landmarks.removeCycles();
                this.generateNodes();
                this.popUpMenu.itemCycles.setEnabled(false);
                this.repaint();
                this.revalidate();
            } else if (e.getSource() == this.popUpMenu.itemCopy) {
                if (this.back == null) {
                    return;
                }
                PlanViewerImp.ImageSelection imageSelection = new PlanViewerImp.ImageSelection(this.back);
                Toolkit.getDefaultToolkit().getSystemClipboard().setContents(imageSelection, null);
            }
        }

        private class PopUpMenu
        extends JPopupMenu {
            private static final long serialVersionUID = 1L;
            JMenuItem itemTrans = new JMenuItem("Filter transitive orderings");
            JMenuItem itemCycles;
            JMenuItem itemCopy;

            public PopUpMenu() {
                this.add(this.itemTrans);
                this.itemCycles = new JMenuItem("Remove cycles");
                this.add(this.itemCycles);
                this.itemCopy = new JMenuItem("Copy to clipboard");
                this.add(this.itemCopy);
            }
        }
    }

    private static class DrawNode {
        static Font NODE_FONT = new Font("Arial Narrow", 0, 16);
        static final int BOX_WIDTH = 150;
        int index;
        int x;
        int y;
        int level;
        int lineHeight;
        double scale;
        LandmarkSet lset;
        ArrayList<DrawNode> nextNodes;
        ArrayList<Integer> arrowTypes;

        public DrawNode(int i, LandmarkSet ls, double scale) {
            this.index = i;
            this.lset = ls;
            this.level = -1;
            this.scale = scale;
            this.lineHeight = 14;
            this.nextNodes = new ArrayList();
            this.arrowTypes = new ArrayList();
        }

        private int scale(int n) {
            return (int)(this.scale * (double)n);
        }

        private void drawArrow(Graphics2D g, int x, int y, int xx, int yy) {
            float arrowWidth = 6.0f;
            float theta = 0.423f;
            int[] xPoints = new int[3];
            int[] yPoints = new int[3];
            float[] vecLine = new float[2];
            float[] vecLeft = new float[2];
            xPoints[0] = xx;
            yPoints[0] = yy;
            vecLine[0] = (float)xPoints[0] - (float)x;
            vecLine[1] = (float)yPoints[0] - (float)y;
            vecLeft[0] = -vecLine[1];
            vecLeft[1] = vecLine[0];
            float fLength = (float)Math.sqrt(vecLine[0] * vecLine[0] + vecLine[1] * vecLine[1]);
            float th = arrowWidth / (2.0f * fLength);
            float ta = arrowWidth / (2.0f * ((float)Math.tan(theta) / 2.0f) * fLength);
            float baseX = (float)xPoints[0] - ta * vecLine[0];
            float baseY = (float)yPoints[0] - ta * vecLine[1];
            xPoints[1] = (int)(baseX + th * vecLeft[0]);
            yPoints[1] = (int)(baseY + th * vecLeft[1]);
            xPoints[2] = (int)(baseX - th * vecLeft[0]);
            yPoints[2] = (int)(baseY - th * vecLeft[1]);
            g.drawLine(x, y, (int)baseX, (int)baseY);
            g.fillPolygon(xPoints, yPoints, 3);
        }

        public int height() {
            return this.lset.landmarks.size() * this.lineHeight + 8;
        }

        public void paintNode(Graphics2D g2d) {
            g2d.setFont(NODE_FONT);
            FontMetrics metrics = g2d.getFontMetrics(NODE_FONT);
            this.lineHeight = metrics.getHeight();
            int h = this.height();
            int w = this.scale(150);
            if (this.lset.disjunctive) {
                g2d.setColor(Color.lightGray);
            } else {
                g2d.setColor(Color.white);
            }
            g2d.fillRect(this.scale(this.x), this.scale(this.y), w, h);
            g2d.setColor(Color.black);
            g2d.drawRect(this.scale(this.x), this.scale(this.y), w, h);
            int ty = this.scale(this.y);
            for (int i = 0; i < this.lset.landmarks.size(); ++i) {
                String l = (String)this.lset.landmarks.get(i);
                if (this.lset.disjunctive) {
                    if (i == 0) {
                        l = "{" + l;
                    }
                    if (i == this.lset.landmarks.size() - 1) {
                        l = l + "}";
                    }
                }
                int ws = metrics.stringWidth(l);
                g2d.drawString(l, this.scale(this.x) + (w - ws) / 2, ty + this.lineHeight);
                ty += this.lineHeight;
            }
        }

        public void paintArrows(Graphics2D g2d) {
            int py = this.scale(this.y) + this.height() / 2;
            for (int i = 0; i < this.nextNodes.size(); ++i) {
                DrawNode n = this.nextNodes.get(i);
                switch (this.arrowTypes.get(i)) {
                    case 2: {
                        g2d.setColor(Color.blue);
                        break;
                    }
                    default: {
                        g2d.setColor(Color.darkGray);
                    }
                }
                this.drawArrow(g2d, this.scale(this.x + 150), py, this.scale(n.x), this.scale(n.y) + n.height() / 2);
            }
        }

        public void addNext(DrawNode next, int type) {
            for (DrawNode n : this.nextNodes) {
                if (n.index != next.index) continue;
                return;
            }
            this.nextNodes.add(next);
            this.arrowTypes.add(type);
        }

        public void setScale(double s) {
            this.scale = s;
            int fs = s <= 0.25 ? 8 : (s <= 0.5 ? 9 : (s <= 0.75 ? 12 : (s <= 1.5 ? 16 : (s <= 2.5 ? 18 : 16))));
            NODE_FONT = new Font("Arial Narrow", 0, fs);
        }

        public boolean isSelected(int x, int y) {
            int rx = (int)((double)x / this.scale);
            int ry = (int)((double)y / this.scale);
            return rx >= this.x && ry >= this.y && rx <= this.x + 150 && ry <= this.y + this.height();
        }

        public void move(int incX, int incY) {
            this.x = (int)((double)this.x + (double)incX / this.scale);
            this.y = (int)((double)this.y + (double)incY / this.scale);
        }
    }

    private static class LandmarkSet {
        private final ArrayList<String> landmarks = new ArrayList();
        private final boolean disjunctive;

        public LandmarkSet(LandmarkNode n) {
            this.disjunctive = !n.isSingleLiteral();
            for (LandmarkFluent f : n.getLiterals()) {
                this.landmarks.add(f.toString());
            }
        }

        public boolean equals(Object x) {
            LandmarkSet ls = (LandmarkSet)x;
            if (ls.landmarks.size() != this.landmarks.size() || ls.disjunctive != this.disjunctive) {
                return false;
            }
            for (String l : ls.landmarks) {
                if (this.landmarks.contains(l)) continue;
                return false;
            }
            return true;
        }

        public int hashCode() {
            int res = 0;
            for (String l : this.landmarks) {
                res += l.hashCode();
            }
            return res;
        }

        public String toString() {
            String res = this.disjunctive ? "{" : "";
            for (int i = 0; i < this.landmarks.size(); ++i) {
                if (i > 0) {
                    res = res + "\n";
                }
                res = res + this.landmarks.get(i);
            }
            return this.disjunctive ? res + "}" : res;
        }
    }
}

