"use strict";
/*********************************************************************************************************************
 Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.

 Licensed under the Apache License, Version 2.0 (the "License").
 You may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 ******************************************************************************************************************** */
Object.defineProperty(exports, "__esModule", { value: true });
exports.PDKPipelinePyProject = void 0;
const fs = require("fs");
const path = require("path");
const projen_1 = require("projen");
const awscdk_1 = require("projen/lib/awscdk");
const python_1 = require("projen/lib/python");
/**
 * Synthesizes a Python Project with a CI/CD pipeline.
 *
 * @pjid pdk-pipeline-py
 */
class PDKPipelinePyProject extends awscdk_1.AwsCdkPythonApp {
    constructor(options) {
        super({
            github: false,
            sample: false,
            pytest: false,
            ...options,
            appEntrypoint: options.appEntrypoint || `${options.moduleName}/pipeline.py`,
        });
        ["aws_prototyping_sdk", "pyhumps"].forEach((dep) => this.addDependency(dep));
        new projen_1.SampleDir(this, this.moduleName, {
            sourceDir: path.join(__dirname, "..", "samples", "python", "infra"),
        });
        this.pytest = new python_1.Pytest(this, options.pytestOptions);
        new projen_1.SampleDir(this, this.testdir, {
            files: {
                "__init__.py": "",
                "test_pipeline.py": fs
                    .readFileSync(path.join(__dirname, "..", "samples", "python", "tests", "test_pipeline.py"))
                    .toString()
                    .replace("infra.", `${this.moduleName}.`),
            },
        });
    }
}
exports.PDKPipelinePyProject = PDKPipelinePyProject;
//# sourceMappingURL=data:application/json;base64,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