import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface FunctionResourceConfig extends cdktf.TerraformMetaArguments {
    /**
    * Body of the function.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/postgresql/r/function#body FunctionResource#body}
    */
    readonly body: string;
    /**
    * The database where the function is located. If not specified, the provider default database is used.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/postgresql/r/function#database FunctionResource#database}
    */
    readonly database?: string;
    /**
    * Automatically drop objects that depend on the function (such as operators or triggers), and in turn all objects that depend on those objects.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/postgresql/r/function#drop_cascade FunctionResource#drop_cascade}
    */
    readonly dropCascade?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/postgresql/r/function#id FunctionResource#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Name of the function.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/postgresql/r/function#name FunctionResource#name}
    */
    readonly name: string;
    /**
    * Function return type.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/postgresql/r/function#returns FunctionResource#returns}
    */
    readonly returns?: string;
    /**
    * Schema where the function is located. If not specified, the provider default schema is used.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/postgresql/r/function#schema FunctionResource#schema}
    */
    readonly schema?: string;
    /**
    * arg block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/postgresql/r/function#arg FunctionResource#arg}
    */
    readonly arg?: FunctionResourceArg[] | cdktf.IResolvable;
}
export interface FunctionResourceArg {
    /**
    * An expression to be used as default value if the parameter is not specified.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/postgresql/r/function#default FunctionResource#default}
    */
    readonly default?: string;
    /**
    * The argument mode. One of: IN, OUT, INOUT, or VARIADIC
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/postgresql/r/function#mode FunctionResource#mode}
    */
    readonly mode?: string;
    /**
    * The argument name. The name may be required for some languages or depending on the argument mode.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/postgresql/r/function#name FunctionResource#name}
    */
    readonly name?: string;
    /**
    * The argument type.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/postgresql/r/function#type FunctionResource#type}
    */
    readonly type: string;
}
export declare function functionResourceArgToTerraform(struct?: FunctionResourceArg | cdktf.IResolvable): any;
export declare class FunctionResourceArgOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): FunctionResourceArg | cdktf.IResolvable | undefined;
    set internalValue(value: FunctionResourceArg | cdktf.IResolvable | undefined);
    private _default?;
    get default(): string;
    set default(value: string);
    resetDefault(): void;
    get defaultInput(): string | undefined;
    private _mode?;
    get mode(): string;
    set mode(value: string);
    resetMode(): void;
    get modeInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
export declare class FunctionResourceArgList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: FunctionResourceArg[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): FunctionResourceArgOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/postgresql/r/function postgresql_function}
*/
export declare class FunctionResource extends cdktf.TerraformResource {
    static readonly tfResourceType = "postgresql_function";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/postgresql/r/function postgresql_function} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options FunctionResourceConfig
    */
    constructor(scope: Construct, id: string, config: FunctionResourceConfig);
    private _body?;
    get body(): string;
    set body(value: string);
    get bodyInput(): string | undefined;
    private _database?;
    get database(): string;
    set database(value: string);
    resetDatabase(): void;
    get databaseInput(): string | undefined;
    private _dropCascade?;
    get dropCascade(): boolean | cdktf.IResolvable;
    set dropCascade(value: boolean | cdktf.IResolvable);
    resetDropCascade(): void;
    get dropCascadeInput(): boolean | cdktf.IResolvable | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _returns?;
    get returns(): string;
    set returns(value: string);
    resetReturns(): void;
    get returnsInput(): string | undefined;
    private _schema?;
    get schema(): string;
    set schema(value: string);
    resetSchema(): void;
    get schemaInput(): string | undefined;
    private _arg;
    get arg(): FunctionResourceArgList;
    putArg(value: FunctionResourceArg[] | cdktf.IResolvable): void;
    resetArg(): void;
    get argInput(): cdktf.IResolvable | FunctionResourceArg[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
