# generated by datamodel-codegen:
#   filename:  entities.yaml
#   timestamp: 2021-10-27T11:51:44+00:00

from __future__ import annotations

from datetime import datetime
from enum import Enum
from typing import Any, Dict, List, Optional

from pydantic import AnyUrl, BaseModel, Extra, Field


class BooleanFieldStat(BaseModel):
    true_count: int
    false_count: int
    nulls_count: int


class ComplexFieldStat(BaseModel):
    nulls_count: int
    unique_count: int


class NumberFieldStat(BaseModel):
    low_value: float
    high_value: float
    mean_value: Optional[float] = None
    median_value: Optional[float] = None
    nulls_count: int
    unique_count: int


class StringFieldStat(BaseModel):
    max_length: int
    avg_length: float
    nulls_count: int
    unique_count: int


class BinaryFieldStat(BaseModel):
    max_length: int
    avg_length: float
    nulls_count: int
    unique_count: int


class IntegerFieldStat(BaseModel):
    low_value: int
    high_value: int
    mean_value: Optional[int] = None
    median_value: Optional[int] = None
    nulls_count: int
    unique_count: int


class DateTimeFieldStat(BaseModel):
    low_value: datetime
    high_value: datetime
    mean_value: Optional[datetime] = None
    median_value: Optional[datetime] = None
    nulls_count: int
    unique_count: int


class Type(Enum):
    TYPE_STRING = 'TYPE_STRING'
    TYPE_NUMBER = 'TYPE_NUMBER'
    TYPE_INTEGER = 'TYPE_INTEGER'
    TYPE_BOOLEAN = 'TYPE_BOOLEAN'
    TYPE_CHAR = 'TYPE_CHAR'
    TYPE_DATETIME = 'TYPE_DATETIME'
    TYPE_TIME = 'TYPE_TIME'
    TYPE_STRUCT = 'TYPE_STRUCT'
    TYPE_BINARY = 'TYPE_BINARY'
    TYPE_LIST = 'TYPE_LIST'
    TYPE_MAP = 'TYPE_MAP'
    TYPE_UNION = 'TYPE_UNION'
    TYPE_DURATION = 'TYPE_DURATION'
    TYPE_UNKNOWN = 'TYPE_UNKNOWN'


class DataSetFieldType(BaseModel):
    type: Type
    logical_type: Optional[str] = None
    is_nullable: bool


class DataTransformer(BaseModel):
    source_code_url: Optional[str] = None
    sql: Optional[str] = None
    inputs: List[str]
    outputs: List[str]


class DataConsumer(BaseModel):
    inputs: Optional[List[str]] = None


class DataInput(BaseModel):
    pass


class DataQualityTestExpectation(BaseModel):
    class Config:
        extra = Extra.allow

    type: Optional[str] = Field(None, example='expect_table_row_count_to_be_between')


class LinkedUrl(BaseModel):
    name: str
    url: str


class Status(Enum):
    SUCCESS = 'SUCCESS'
    FAILED = 'FAILED'
    SKIPPED = 'SKIPPED'
    BROKEN = 'BROKEN'
    ABORTED = 'ABORTED'
    RUNNING = 'RUNNING'
    UNKNOWN = 'UNKNOWN'


class DataTransformerRun(BaseModel):
    transformer_oddrn: str
    start_time: datetime
    end_time: Optional[datetime] = None
    status_reason: Optional[str] = None
    status: Status


class Status1(Enum):
    SUCCESS = 'SUCCESS'
    FAILED = 'FAILED'
    SKIPPED = 'SKIPPED'
    BROKEN = 'BROKEN'
    ABORTED = 'ABORTED'
    RUNNING = 'RUNNING'
    UNKNOWN = 'UNKNOWN'


class DataQualityTestRun(BaseModel):
    data_quality_test_oddrn: str
    start_time: datetime
    end_time: datetime
    status_reason: Optional[str] = None
    status: Status1


class DataEntityType(Enum):
    TABLE = 'TABLE'
    VIEW = 'VIEW'
    FILE = 'FILE'
    FEATURE_GROUP = 'FEATURE_GROUP'
    KAFKA_TOPIC = 'KAFKA_TOPIC'
    JOB = 'JOB'
    JOB_RUN = 'JOB_RUN'
    EXPERIMENT = 'EXPERIMENT'
    ML_MODEL = 'ML_MODEL'
    ML_MODEL_TRAINING = 'ML_MODEL_TRAINING'
    DASHBOARD = 'DASHBOARD'
    UNKNOWN = 'UNKNOWN'


class MetadataExtension(BaseModel):
    schema_url: AnyUrl = Field(
        ...,
        description='The JSON Pointer (https://tools.ietf.org/html/rfc6901) URL to the corresponding version of the schema definition for this extension',
        example='https://raw.githubusercontent.com/opendatadiscovery/opendatadiscovery-specification/main/specification/extensions/glue.json#/definitions/GlueDataSetExtension',
    )
    metadata: Dict[str, Any]


class BaseObject(BaseModel):
    oddrn: str = Field(..., example='//aws/glue/{account_id}/{database}/{tablename}')
    name: str
    description: Optional[str] = None
    owner: Optional[str] = Field(None, example='//aws/iam/{account_id}/user/name')
    metadata: Optional[List[MetadataExtension]] = None


class DataSetFieldStat(BaseModel):
    complex_stats: Optional[ComplexFieldStat] = None
    boolean_stats: Optional[BooleanFieldStat] = None
    integer_stats: Optional[IntegerFieldStat] = None
    number_stats: Optional[NumberFieldStat] = None
    string_stats: Optional[StringFieldStat] = None
    binary_stats: Optional[BinaryFieldStat] = None
    datetime_stats: Optional[DateTimeFieldStat] = None


class DataSetField(BaseObject):
    parent_field_oddrn: Optional[str] = None
    type: DataSetFieldType
    is_key: Optional[bool] = None
    is_value: Optional[bool] = None
    default_value: Optional[str] = None
    stats: Optional[DataSetFieldStat] = None


class DataQualityTest(BaseModel):
    suite_name: str
    dataset_list: List[str]
    expectation: DataQualityTestExpectation
    suite_url: Optional[str] = None
    linked_url_list: Optional[List[LinkedUrl]] = None


class DataSet(BaseModel):
    parent_oddrn: Optional[str] = None
    rows_number: Optional[int] = None
    field_list: List[DataSetField]


class DataEntity(BaseObject):
    updated_at: Optional[datetime] = None
    created_at: Optional[datetime] = None
    type: DataEntityType
    dataset: Optional[DataSet] = None
    data_transformer: Optional[DataTransformer] = None
    data_transformer_run: Optional[DataTransformerRun] = None
    data_quality_test: Optional[DataQualityTest] = None
    data_quality_test_run: Optional[DataQualityTestRun] = None
    data_input: Optional[DataInput] = None
    data_consumer: Optional[DataConsumer] = None


class DataEntityList(BaseModel):
    data_source_oddrn: str = Field(..., example='//aws/glue/123456789010/')
    items: Optional[List[DataEntity]] = None
