
# LLMStudio by [TensorOps](http://tensorops.ai "TensorOps")

Craft. 🧠 Test. 🤖 Perfect. ⚡️

Your AI playground for prompt perfection.

[![LLM Studio Intro Video](http://img.youtube.com/vi/I9h701fbD18/0.jpg)](http://www.youtube.com/watch?v=I9h701fbD18 "Intro to LLMStudio")

---

## Table of Contents

- [Features](#features)
- [Installation](#installation)
- [About LLM Studio](#about-llm-studio)
- [Documentation](#documentation)

---

## 🌟 Features

1. **Python Client Gateway**: Seamless integration with multiple LLMs and chaining libraries such as LangChain.
2. **Prompt Editing UI**: An intuitive interface designed for prompt engineering.
3. **History Management**: Track past runs and easily export your data as needed.

---

## 🚀 Installation

To get started with LLM Studio, you can use our DockerHub image for a swift setup:

```
docker pull tensoropsai/llmstudio
docker run --rm -p 3001:3001 tensoropsai/llmstudio
```

Once installed, access LLM Studio at [http://localhost:3001/](http://localhost:3001/).

---

## 🤔 About LLM Studio

Powered by TensorOps, LLM Studio redefines your experience with Google's PaLM and OpenAI's GPT language models. More than just a tool, it’s an evolving environment where teams can experiment, modify, and optimize their interactions with advanced language models.

Benefits include:
- **Streamlined Prompt Engineering**: Simplify and enhance your prompt design process.
- **Execution History**: Keep a detailed log of past executions, track progress, and make iterative improvements effortlessly.
- **Effortless Data Export**: Share your team's endeavors by exporting data to shareable CSV files.

Step into the future of AI with LLM Studio.

---

## 📖 Documentation

Details on how to use LLM Studio will be provided soon. Stay tuned!

---

Thank you for choosing LLM Studio. Your journey to perfecting AI interactions begins here.
