# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['karp',
 'karp.auth',
 'karp.auth.application',
 'karp.auth.application.queries',
 'karp.auth.domain',
 'karp.auth.domain.entities',
 'karp.auth.domain.value_objects',
 'karp.auth_infrastructure',
 'karp.auth_infrastructure.queries',
 'karp.auth_infrastructure.services',
 'karp.cliapp',
 'karp.cliapp.subapps',
 'karp.db_infrastructure',
 'karp.db_infrastructure.types',
 'karp.foundation',
 'karp.foundation.value_objects',
 'karp.lex',
 'karp.lex.application',
 'karp.lex.application.queries',
 'karp.lex.application.repositories',
 'karp.lex.application.use_cases',
 'karp.lex.domain',
 'karp.lex.domain.commands',
 'karp.lex.domain.entities',
 'karp.lex.domain.events',
 'karp.lex.domain.value_objects',
 'karp.lex_infrastructure',
 'karp.lex_infrastructure.queries',
 'karp.lex_infrastructure.repositories',
 'karp.lex_infrastructure.sql',
 'karp.main',
 'karp.main.migrations',
 'karp.main.migrations.versions',
 'karp.search',
 'karp.search.application',
 'karp.search.application.queries',
 'karp.search.application.repositories',
 'karp.search.application.transformers',
 'karp.search.domain',
 'karp.search.domain.query_dsl',
 'karp.search_infrastructure',
 'karp.search_infrastructure.elasticsearch6',
 'karp.search_infrastructure.queries',
 'karp.search_infrastructure.repositories',
 'karp.search_infrastructure.transformers',
 'karp.tests',
 'karp.tests.e2e',
 'karp.tests.factories',
 'karp.tests.foundation',
 'karp.tests.foundation.unit',
 'karp.tests.integration',
 'karp.tests.integration.auth',
 'karp.tests.unit',
 'karp.tests.unit.auth',
 'karp.tests.unit.auth_infrastructure',
 'karp.tests.unit.lex',
 'karp.tests.unit.lex.value_objects',
 'karp.tests.unit.lex_infrastructure',
 'karp.tests.unit.search',
 'karp.tests.unit.search_infrastructure',
 'karp.util',
 'karp.util.convert',
 'karp.utility',
 'karp.webapp',
 'karp.webapp.contrib',
 'karp.webapp.dependencies',
 'karp.webapp.routes']

package_data = \
{'': ['*'],
 'karp': ['data_files/*', 'schema/*'],
 'karp.tests': ['data/*', 'data/config/*']}

install_requires = \
['Deprecated>=1.2.13,<2.0.0',
 'TatSu>=5.8.3,<6.0.0',
 'alembic>=1.8.1,<2.0.0',
 'asgi-correlation-id>=3.0.1,<4.0.0',
 'elasticsearch-dsl>=6,<7',
 'elasticsearch>=6,<7',
 'environs>=9.3.4,<10.0.0',
 'fastapi>=0.88.0,<0.89.0',
 'injector>=0.20.1,<0.21.0',
 'json-streams>=0.12.0,<0.13.0',
 'paradigmextract>=0.1.1,<0.2.0',
 'pydantic>=1.10.2,<2.0.0',
 'pyjwt[crypto]>=2.6.0,<3.0.0',
 'python-dotenv>=0.19.0,<0.20.0',
 'python-json-logger>=2.0.4,<3.0.0',
 'regex>=2022.8.17,<2023.0.0',
 'sb-json-tools>=0.9.1,<0.10.0',
 'sqlalchemy-json>=0.5.0,<0.6.0',
 'sqlalchemy-utils>=0.38.3,<0.39.0',
 'sqlalchemy>=1.4.44,<2.0.0',
 'tabulate>=0.9.0,<0.10.0',
 'tenacity>=8.0.1,<9.0.0',
 'tqdm>=4.64.1,<5.0.0',
 'typer>=0.7.0,<0.8.0',
 'ulid-py>=1.1.0,<2.0.0',
 'urllib3>=1.26.13,<2.0.0']

extras_require = \
{'mysql': ['PyMySQL>=1.0.2,<2.0.0',
           'aiomysql>=0.1.1,<0.2.0',
           'mysqlclient>=2.1.1,<3.0.0'],
 'sqlite': ['aiosqlite>=0.17.0,<0.18.0']}

entry_points = \
{'console_scripts': ['karp-cli = karp.cliapp.main:cliapp'],
 'karp.infrastructure': ['es6 = karp.infrastructure.elasticsearch6',
                         'jwt = karp.infrastructure.jwt',
                         'sql = karp.infrastructure.sql',
                         'testing = karp.infrastructure.testing']}

setup_kwargs = {
    'name': 'karp-backend',
    'version': '6.1.1',
    'description': 'Karp backend',
    'long_description': "# Karp backend\n\n[![PyPI version](https://badge.fury.io/py/karp-backend.svg)](https://badge.fury.io/py/karp-backend)\n[![Build Status](https://github.com/spraakbanken/karp-backend/workflows/Build/badge.svg)](https://github.com/spraakbanken/karp-backend/actions)\n[![CodeScene Code Health](https://codescene.io/projects/24151/status-badges/code-health)](https://codescene.io/projects/24151)\n[![codecov](https://codecov.io/gh/spraakbanken/karp-backend/branch/main/graph/badge.svg?token=iwTQnHKOpm)](https://codecov.io/gh/spraakbanken/karp-backend)\n\nThis in the version 6 of Karp backend, [for the legacy version (v5)](https://github.com/spraakbanken/karp-backend-v5).\n\n## Setup\n\nThis project uses [poetry](https://python-poetry.org) and\n[MariaDB](https://mariadb.org/).\n\n1. Run `make install` or `make install-dev` for a develop-install\n2. Install MariaDB and create a database\n3. Setup environment variables (can be placed in a `.env` file in the root and then **?** `poetry run` sets those):\n   ```\n   export DB_DATABASE=<name of database>\n   export DB_USER=<database user>\n   export DB_PASSWORD=<user's password>\n   export DB_HOST=localhost\n   export AUTH_JWT_PUBKEY_PATH=/path/to/pubkey\n   ```\n4. Activate the virtual environment by running: `poetry shell`\n5. Run `karp-cli db up` to initialize database\n6. Run `make serve` or `make serve-w-reload` to start development server\n\n   or `poetry shell` and then `uvicorn asgi:app`\n\n7. To setup Elasticsearch, download Elasticsearch 6.x and start it\n8. Install elasticsearch python libs for the right version\n   1. If you use Elasticsearch 6.x, run `source <VENV_NAME>/bin/activate` and `pip install -e .[elasticsearch6]`\n9. Add environment variables\n\n```\nexport ES_ENABLED=true\nexport ELASTICSEARCH_HOST=localhost:9200\nexport SEARCH_CONTEXT=es6_search_service\n```\n\n## Create test resources\n\n1. `poetry shell` and then:\n2. `karp-cli entry-repo create karp/tests/data/config/places.json`\n3. `karp-cli resource create karp/tests/data/config/places.json`\n4. `karp-cli entries add places tests/data/places.jsonl`\n5. Do the same for `municipalities`\n6. `karp-cli resource publish places`\n7. `karp-cli resource publish municipalities`\n\n## Pre-processing data before publishing\n\n** TODO: review this **\nCan be used to have less downtime, because sometimes the preprocessing may\nbe faster on another machine than the machine that talks to Elasticsearch.\nDo `create` and `import` on both machines, with the same data. Use\nmachine 1 to preprocess and use result on machine 2.\n\n1. Create resource and import data as usual.\n2. Run `karp-cli preprocess --resource_id places --version 2 --filename places_preprocessed`\n\n   `places_preprocessed` will contain a pickled dataset containing everything that is needed\n\n3. Run `karp-cli publish_preprocessed --resource_id places --version 2 --data places_preprocessed`\n4. Alternatively run `karp-cli reindex_preprocessed --resource_id places --data places_preprocessed`\n   , if the resource was already published.\n\n## Technologies\n\n### Python\n\n- Poetry >= 3.10\n- FastAPI\n- SQLAlchemy\n- Typer\n- Elasticsearch\n- Elasticsearch DSL\n\n### Databases\n\n- MariaDB\n- Elasticsearch\n\n## Development\n\n### Version handling\n\nVersion can be bumped with [`bump2version`](https://pypi.org/project/bump2version/).\n\nUsage:\n\n- Increase patch number `a.b.X => a.b.(X+1)`: `make bumpversion` or `bumpversion patch`\n- Increase minor number `a.X.c => a.(X+1).0`: `make bumpversion-minor` or `bumpversion minor`\n- Increase major number `X.b.c => (X+1).0.0`: `make bumpversion-major` or `bumpversion major`\n- To custom version `a.b.c => X.Y.Z`: `bumpversion --new-version X.Y.Z`\n\n`bumpversion` is configured in [`.bumpversion.cfg`](.bumpversion.cfg).\n\nThe version is changed in the following files:\n\n- [`setup.py`](setup.py)\n- [`src/karp/__init__.py`](src/karp/__init__.py)\n- [`.bumpversion.cfg`](.bumpversion.cfg)\n- [`doc/karp_api_spec.yaml`](doc/karp_api_spec.yaml)\n",
    'author': 'Språkbanken at the University of Gothenburg',
    'author_email': 'sb-info@svenska.gu.se',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'https://spraakbanken.gu.se',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'extras_require': extras_require,
    'entry_points': entry_points,
    'python_requires': '>=3.10,<4.0',
}


setup(**setup_kwargs)
