from .marsis.ais import PSAMExMarsisAISDataFromLabel

__all__ = ['PDS_OBJECT_CLASSES', 'MEX_MARSIS_AIS_FREQUENCY_TABLES']


PDS_OBJECT_CLASSES = {
    'MEX-M-MARSIS-3-RDR-AIS-EXT4-V1.0': PSAMExMarsisAISDataFromLabel
}

# FREQUENCY TABLES EXTRACTED FORM DOCUMENT/AIS_FREQ_TABLE.TXT

MEX_MARSIS_AIS_FREQUENCY_TABLES = {
    1: [
        109.4, 120.3, 131.2, 142.2, 153.1, 164.1, 175.0, 185.9, 196.9, 207.8,
        218.7, 229.7, 240.6, 251.6, 262.5, 273.4, 284.4, 295.3, 306.2, 317.2,
        328.1, 339.0, 350.0, 360.9, 371.9, 382.8, 393.7, 404.7, 415.6, 426.5,
        437.5, 448.4, 459.4, 470.3, 481.2, 492.2, 503.1, 514.0, 525.0, 535.9,
        546.9, 557.8, 579.7, 601.5, 623.4, 645.3, 667.2, 689.0, 710.9, 732.8,
        754.7, 776.5, 798.4, 820.3, 842.1, 864.0, 885.9, 907.8, 929.6, 951.5,
        973.4, 995.3, 1017.1, 1039.0, 1060.9, 1082.8, 1104.6, 1126.5, 1148.4, 1170.3,
        1192.1, 1214.0, 1235.9, 1257.8, 1279.6, 1301.5, 1323.4, 1345.3, 1367.1, 1389.0,
        1410.9, 1432.7, 1454.6, 1476.5, 1498.4, 1520.2, 1542.1, 1564.0, 1585.9, 1607.7,
        1629.6, 1651.5, 1673.4, 1717.1, 1760.9, 1804.6, 1848.4, 1892.1, 1935.8, 1979.6,
        2023.3, 2067.1, 2110.8, 2154.6, 2198.3, 2242.1, 2285.8, 2329.6, 2504.6, 2548.3,
        2592.1, 2635.8, 2679.6, 2723.3, 2767.1, 2810.8, 2854.6, 2898.3, 2942.1, 2985.8,
        3029.5, 3073.3, 3117.0, 3160.8, 3204.5, 3248.3, 3292.0, 3335.8, 3379.5, 3423.3,
        3467.0, 3510.8, 3554.5, 3598.3, 3642.0, 3685.8, 3729.5, 3773.3, 3817.0, 3860.8,
        3904.5, 3992.0, 4079.5, 4167.0, 4254.5, 4342.0, 4429.5, 4517.0, 4604.5, 4692.0,
        4779.5, 4867.0, 4954.5, 5042.0, 5129.5, 5216.9, 5304.4, 5391.9, 5479.4, 5501.3,
        ],
    2: [
        100.0, 165.8, 231.6, 297.4, 362.7, 428.5, 494.3, 560.1, 625.9, 691.7,
        757.1, 822.9, 888.7, 954.5, 1020.3, 1086.1, 1151.4, 1217.2, 1283.0, 1348.8,
        1414.6, 1480.4, 1545.8, 1611.6, 1677.4, 1743.2, 1809.0, 1874.8, 1940.6, 2006.0,
        2071.7, 2137.5, 2203.3, 2269.1, 2334.9, 2367.4, 2400.3, 2433.2, 2466.1, 2499.0,
        2531.9, 2564.8, 2597.7, 2630.6, 2663.5, 2696.4, 2729.3, 2761.8, 2794.7, 2827.6,
        2860.5, 2893.4, 2926.3, 2959.2, 2992.1, 3024.9, 3057.8, 3090.7, 3123.6, 3156.5,
        3189.0, 3221.9, 3254.8, 3287.7, 3320.6, 3331.7, 3342.4, 3353.5, 3364.6, 3375.3,
        3386.4, 3397.5, 3408.2, 3419.3, 3430.4, 3441.1, 3452.2, 3462.9, 3474.0, 3485.1,
        3495.8, 3506.9, 3518.0, 3528.7, 3539.8, 3550.9, 3561.6, 3572.7, 3583.4, 3594.5,
        3605.6, 3616.3, 3627.4, 3638.5, 3649.2, 3660.3, 3671.4, 3682.1, 3693.2, 3704.3,
        3715.0, 3726.1, 3736.8, 3747.9, 3759.0, 3769.6, 3780.8, 3791.9, 3802.5, 3813.7,
        3824.8, 3835.4, 3857.2, 3879.5, 3901.2, 3923.0, 3945.3, 3967.0, 3988.8, 4010.6,
        4032.8, 4054.6, 4076.4, 4098.6, 4120.4, 4142.2, 4164.0, 4186.2, 4208.0, 4229.8,
        4251.6, 4273.8, 4295.6, 4339.6, 4383.2, 4427.2, 4470.8, 4514.8, 4558.4, 4602.4,
        4646.4, 4690.0, 4734.0, 4777.5, 4821.5, 4865.1, 4909.1, 4952.7, 4996.7, 5040.7,
        5084.3, 5128.3, 5171.9, 5215.9, 5259.5, 5303.5, 5347.1, 5391.1, 5435.1, 5478.7,
        ],
    3: [
        109.4, 120.3, 131.2, 142.2, 153.1, 164.1, 175.0, 185.9, 196.9, 207.8,
        218.7, 229.7, 240.6, 251.6, 262.5, 273.4, 284.4, 295.3, 306.2, 317.2,
        328.1, 339.0, 350.0, 360.9, 371.9, 382.8, 393.7, 404.7, 415.6, 426.5,
        437.5, 448.4, 459.4, 470.3, 481.2, 492.2, 503.1, 514.0, 525.0, 535.9,
        546.9, 557.8, 568.7, 579.7, 590.6, 601.5, 612.5, 623.4, 634.3, 645.3,
        656.2, 667.2, 678.1, 689.0, 700.0, 710.9, 721.8, 732.8, 743.7, 754.7,
        765.6, 776.5, 787.5, 798.4, 809.3, 820.3, 831.2, 842.1, 853.1, 864.0,
        875.0, 885.9, 896.8, 907.8, 918.7, 929.6, 940.6, 951.5, 962.5, 973.4,
        984.3, 995.3, 1006.2, 1017.1, 1028.1, 1039.0, 1050.0, 1060.9, 1071.8, 1082.8,
        1093.7, 1104.6, 1115.6, 1126.5, 1137.4, 1148.4, 1159.3, 1170.3, 1181.2, 1192.1,
        1203.1, 1214.0, 1224.9, 1235.9, 1246.8, 1257.8, 1268.7, 1279.6, 1290.6, 1301.5,
        1312.4, 1323.4, 1334.3, 1345.3, 1356.2, 1367.1, 1378.1, 1389.0, 1399.9, 1410.9,
        1421.8, 1432.7, 1443.7, 1454.6, 1465.6, 1476.5, 1487.4, 1498.4, 1509.3, 1520.2,
        1531.2, 1542.1, 1553.1, 1564.0, 1574.9, 1585.9, 1596.8, 1607.7, 1618.7, 1629.6,
        1640.6, 1651.5, 1662.4, 1673.4, 1684.3, 1695.2, 1706.2, 1717.1, 1728.0, 1739.0,
        1749.9, 1760.9, 1771.8, 1782.7, 1793.7, 1804.6, 1815.5, 1826.5, 1837.4, 1848.4,
        ],
    4: [
        309.4, 320.3, 331.2, 342.2, 353.1, 364.1, 375.0, 385.9, 396.9, 407.8,
        418.7, 429.7, 440.6, 451.6, 462.5, 473.4, 484.4, 495.3, 506.2, 517.2,
        528.1, 539.0, 550.0, 560.9, 571.9, 582.8, 593.7, 604.7, 615.6, 626.5,
        637.5, 648.4, 659.4, 670.3, 681.2, 692.2, 703.1, 714.0, 725.0, 735.9,
        746.9, 757.8, 768.7, 779.7, 790.6, 801.5, 812.5, 823.4, 834.3, 845.3,
        856.2, 867.2, 878.1, 889.0, 900.0, 910.9, 921.8, 932.8, 943.7, 954.7,
        965.6, 976.5, 987.5, 998.4, 1009.3, 1020.3, 1031.2, 1042.1, 1053.1, 1064.0,
        1075.0, 1085.9, 1096.8, 1107.8, 1118.7, 1129.6, 1140.6, 1151.5, 1162.5, 1173.4,
        1184.3, 1195.3, 1206.2, 1217.1, 1228.1, 1239.0, 1250.0, 1260.9, 1271.8, 1282.8,
        1293.7, 1304.6, 1315.6, 1326.5, 1337.4, 1348.4, 1359.3, 1370.3, 1381.2, 1392.1,
        1403.1, 1414.0, 1424.9, 1435.9, 1446.8, 1457.8, 1468.7, 1479.6, 1490.6, 1501.5,
        1512.4, 1523.4, 1534.3, 1545.3, 1556.2, 1567.1, 1578.1, 1589.0, 1599.9, 1610.9,
        1621.8, 1632.7, 1643.7, 1654.6, 1665.6, 1676.5, 1687.4, 1698.4, 1709.3, 1720.2,
        1731.2, 1742.1, 1753.1, 1764.0, 1774.9, 1785.9, 1796.8, 1807.7, 1818.7, 1829.6,
        1840.6, 1851.5, 1862.4, 1873.4, 1884.3, 1895.2, 1906.2, 1917.1, 1928.0, 1939.0,
        1949.9, 1960.9, 1971.8, 1982.7, 1993.7, 2004.6, 2015.5, 2026.5, 2037.4, 2048.4,
        ],
    5: [
        509.4, 520.3, 531.2, 542.2, 553.1, 564.1, 575.0, 585.9, 596.9, 607.8,
        618.7, 629.7, 640.6, 651.6, 662.5, 673.4, 684.4, 695.3, 706.2, 717.2,
        728.1, 739.0, 750.0, 760.9, 771.9, 782.8, 793.7, 804.7, 815.6, 826.5,
        837.5, 848.4, 859.4, 870.3, 881.2, 892.2, 903.1, 914.0, 925.0, 935.9,
        946.9, 957.8, 968.7, 979.7, 990.6, 1001.5, 1012.5, 1023.4, 1034.3, 1045.3,
        1056.2, 1067.2, 1078.1, 1089.0, 1100.0, 1110.9, 1121.8, 1132.8, 1143.7, 1154.7,
        1165.6, 1176.5, 1187.5, 1198.4, 1209.3, 1220.3, 1231.2, 1242.1, 1253.1, 1264.0,
        1275.0, 1285.9, 1296.8, 1307.8, 1318.7, 1329.6, 1340.6, 1351.5, 1362.5, 1373.4,
        1384.3, 1395.3, 1406.2, 1417.1, 1428.1, 1439.0, 1450.0, 1460.9, 1471.8, 1482.8,
        1493.7, 1504.6, 1515.6, 1526.5, 1537.4, 1548.4, 1559.3, 1570.3, 1581.2, 1592.1,
        1603.1, 1614.0, 1624.9, 1635.9, 1646.8, 1657.8, 1668.7, 1679.6, 1690.6, 1701.5,
        1712.4, 1723.4, 1734.3, 1745.3, 1756.2, 1767.1, 1778.1, 1789.0, 1799.9, 1810.9,
        1821.8, 1832.7, 1843.7, 1854.6, 1865.6, 1876.5, 1887.4, 1898.4, 1909.3, 1920.2,
        1931.2, 1942.1, 1953.1, 1964.0, 1974.9, 1985.9, 1996.8, 2007.7, 2018.7, 2029.6,
        2040.6, 2051.5, 2062.4, 2073.4, 2084.3, 2095.2, 2106.2, 2117.1, 2128.0, 2139.0,
        2149.9, 2160.9, 2171.8, 2182.7, 2193.7, 2204.6, 2215.5, 2226.5, 2237.4, 2248.4,
        ],
    6: [
        709.4, 720.3, 731.2, 742.2, 753.1, 764.1, 775.0, 785.9, 796.9, 807.8,
        818.7, 829.7, 840.6, 851.6, 862.5, 873.4, 884.4, 895.3, 906.2, 917.2,
        928.1, 939.0, 950.0, 960.9, 971.9, 982.8, 993.7, 1004.7, 1015.6, 1026.5,
        1037.5, 1048.4, 1059.4, 1070.3, 1081.2, 1092.2, 1103.1, 1114.0, 1125.0, 1135.9,
        1146.9, 1157.8, 1168.7, 1179.7, 1190.6, 1201.5, 1212.5, 1223.4, 1234.3, 1245.3,
        1256.2, 1267.2, 1278.1, 1289.0, 1300.0, 1310.9, 1321.8, 1332.8, 1343.7, 1354.7,
        1365.6, 1376.5, 1387.5, 1398.4, 1409.3, 1420.3, 1431.2, 1442.1, 1453.1, 1464.0,
        1475.0, 1485.9, 1496.8, 1507.8, 1518.7, 1529.6, 1540.6, 1551.5, 1562.5, 1573.4,
        1584.3, 1595.3, 1606.2, 1617.1, 1628.1, 1639.0, 1650.0, 1660.9, 1671.8, 1682.8,
        1693.7, 1704.6, 1715.6, 1726.5, 1737.4, 1748.4, 1759.3, 1770.3, 1781.2, 1792.1,
        1803.1, 1814.0, 1824.9, 1835.9, 1846.8, 1857.8, 1868.7, 1879.6, 1890.6, 1901.5,
        1912.4, 1923.4, 1934.3, 1945.3, 1956.2, 1967.1, 1978.1, 1989.0, 1999.9, 2010.9,
        2021.8, 2032.7, 2043.7, 2054.6, 2065.6, 2076.5, 2087.4, 2098.4, 2109.3, 2120.2,
        2131.2, 2142.1, 2153.1, 2164.0, 2174.9, 2185.9, 2196.8, 2207.7, 2218.7, 2229.6,
        2240.6, 2251.5, 2262.4, 2273.4, 2284.3, 2295.2, 2306.2, 2317.1, 2328.0, 2505.0,
        2515.9, 2526.9, 2537.8, 2548.7, 2559.7, 2570.6, 2581.5, 2592.5, 2603.4, 2614.4,
        ],
    7: [
        909.4, 920.3, 931.2, 942.2, 953.1, 964.1, 975.0, 985.9, 996.9, 1007.8,
        1018.7, 1029.7, 1040.6, 1051.6, 1062.5, 1073.4, 1084.4, 1095.3, 1106.2, 1117.2,
        1128.1, 1139.0, 1150.0, 1160.9, 1171.9, 1182.8, 1193.7, 1204.7, 1215.6, 1226.5,
        1237.5, 1248.4, 1259.4, 1270.3, 1281.2, 1292.2, 1303.1, 1314.0, 1325.0, 1335.9,
        1346.9, 1357.8, 1368.7, 1379.7, 1390.6, 1401.5, 1412.5, 1423.4, 1434.3, 1445.3,
        1456.2, 1467.2, 1478.1, 1489.0, 1500.0, 1510.9, 1521.8, 1532.8, 1543.7, 1554.7,
        1565.6, 1576.5, 1587.5, 1598.4, 1609.3, 1620.3, 1631.2, 1642.1, 1653.1, 1664.0,
        1675.0, 1685.9, 1696.8, 1707.8, 1718.7, 1729.6, 1740.6, 1751.5, 1762.5, 1773.4,
        1784.3, 1795.3, 1806.2, 1817.1, 1828.1, 1839.0, 1850.0, 1860.9, 1871.8, 1882.8,
        1893.7, 1904.6, 1915.6, 1926.5, 1937.4, 1948.4, 1959.3, 1970.3, 1981.2, 1992.1,
        2003.1, 2014.0, 2024.9, 2035.9, 2046.8, 2057.8, 2068.7, 2079.6, 2090.6, 2101.5,
        2112.4, 2123.4, 2134.3, 2145.3, 2156.2, 2167.1, 2178.1, 2189.0, 2199.9, 2210.9,
        2221.8, 2232.7, 2243.7, 2254.6, 2265.6, 2276.5, 2287.4, 2298.4, 2309.3, 2320.2,
        2504.2, 2515.1, 2526.1, 2537.0, 2547.9, 2558.9, 2569.8, 2580.7, 2591.7, 2602.6,
        2613.6, 2624.5, 2635.4, 2646.4, 2657.3, 2668.2, 2679.2, 2690.1, 2701.0, 2712.0,
        2722.9, 2733.9, 2744.8, 2755.7, 2766.7, 2777.6, 2788.5, 2799.5, 2810.4, 2821.4,
        ],
    8: [
        1109.4, 1120.3, 1131.2, 1142.2, 1153.1, 1164.1, 1175.0, 1185.9, 1196.9, 1207.8,
        1218.7, 1229.7, 1240.6, 1251.6, 1262.5, 1273.4, 1284.4, 1295.3, 1306.2, 1317.2,
        1328.1, 1339.0, 1350.0, 1360.9, 1371.9, 1382.8, 1393.7, 1404.7, 1415.6, 1426.5,
        1437.5, 1448.4, 1459.4, 1470.3, 1481.2, 1492.2, 1503.1, 1514.0, 1525.0, 1535.9,
        1546.9, 1557.8, 1568.7, 1579.7, 1590.6, 1601.5, 1612.5, 1623.4, 1634.3, 1645.3,
        1656.2, 1667.2, 1678.1, 1689.0, 1700.0, 1710.9, 1721.8, 1732.8, 1743.7, 1754.7,
        1765.6, 1776.5, 1787.5, 1798.4, 1809.3, 1820.3, 1831.2, 1842.1, 1853.1, 1864.0,
        1875.0, 1885.9, 1896.8, 1907.8, 1918.7, 1929.6, 1940.6, 1951.5, 1962.5, 1973.4,
        1984.3, 1995.3, 2006.2, 2017.1, 2028.1, 2039.0, 2050.0, 2060.9, 2071.8, 2082.8,
        2093.7, 2104.6, 2115.6, 2126.5, 2137.4, 2148.4, 2159.3, 2170.3, 2181.2, 2192.1,
        2203.1, 2214.0, 2224.9, 2235.9, 2246.8, 2257.8, 2268.7, 2279.6, 2290.6, 2301.5,
        2312.4, 2323.4, 2504.3, 2515.3, 2526.2, 2537.1, 2548.1, 2559.0, 2569.9, 2580.9,
        2591.8, 2602.7, 2613.7, 2624.6, 2635.6, 2646.5, 2657.4, 2668.4, 2679.3, 2690.2,
        2701.2, 2712.1, 2723.1, 2734.0, 2744.9, 2755.9, 2766.8, 2777.7, 2788.7, 2799.6,
        2810.6, 2821.5, 2832.4, 2843.4, 2854.3, 2865.2, 2876.2, 2887.1, 2898.0, 2909.0,
        2919.9, 2930.9, 2941.8, 2952.7, 2963.7, 2974.6, 2985.5, 2996.5, 3007.4, 3018.4,
        ],
    9: [
        1859.3, 1870.2, 1881.2, 1892.1, 1903.0, 1914.0, 1924.9, 1935.8, 1946.8, 1957.7,
        1968.7, 1979.6, 1990.5, 2001.5, 2012.4, 2023.3, 2034.3, 2045.2, 2056.2, 2067.1,
        2078.0, 2089.0, 2099.9, 2110.8, 2121.8, 2132.7, 2143.7, 2154.6, 2165.5, 2176.5,
        2187.4, 2198.3, 2209.3, 2220.2, 2231.1, 2242.1, 2253.0, 2264.0, 2274.9, 2285.8,
        2296.8, 2307.7, 2318.6, 2329.6, 2504.6, 2515.5, 2526.4, 2537.4, 2548.3, 2559.3,
        2570.2, 2581.1, 2592.1, 2603.0, 2613.9, 2624.9, 2635.8, 2646.8, 2657.7, 2668.6,
        2679.6, 2690.5, 2701.4, 2712.4, 2723.3, 2734.3, 2745.2, 2756.1, 2767.1, 2778.0,
        2788.9, 2799.9, 2810.8, 2821.7, 2832.7, 2843.6, 2854.6, 2865.5, 2876.4, 2887.4,
        2898.3, 2909.2, 2920.2, 2931.1, 2942.1, 2953.0, 2963.9, 2974.9, 2985.8, 2996.7,
        3007.7, 3018.6, 3029.5, 3040.5, 3051.4, 3062.4, 3073.3, 3084.2, 3095.2, 3106.1,
        3117.0, 3128.0, 3138.9, 3149.9, 3160.8, 3171.7, 3182.7, 3193.6, 3204.5, 3215.5,
        3226.4, 3237.4, 3248.3, 3259.2, 3270.2, 3281.1, 3292.0, 3303.0, 3313.9, 3324.8,
        3335.8, 3346.7, 3357.7, 3368.6, 3379.5, 3390.5, 3401.4, 3412.3, 3423.3, 3434.2,
        3445.2, 3456.1, 3467.0, 3478.0, 3488.9, 3499.8, 3510.8, 3521.7, 3532.7, 3543.6,
        3554.5, 3565.5, 3576.4, 3587.3, 3598.3, 3609.2, 3620.1, 3631.1, 3642.0, 3653.0,
        3663.9, 3674.8, 3685.8, 3696.7, 3707.6, 3718.6, 3729.5, 3740.5, 3751.4, 3762.3,
        ],
    10: [
        3773.3, 3784.2, 3795.1, 3806.1, 3817.0, 3828.0, 3838.9, 3849.8, 3860.8, 3871.7,
        3882.6, 3893.6, 3904.5, 3915.4, 3926.4, 3937.3, 3948.3, 3959.2, 3970.1, 3981.1,
        3992.0, 4002.9, 4013.9, 4024.8, 4035.8, 4046.7, 4057.6, 4068.6, 4079.5, 4090.4,
        4101.4, 4112.3, 4123.2, 4134.2, 4145.1, 4156.1, 4167.0, 4177.9, 4188.9, 4199.8,
        4210.7, 4221.7, 4232.6, 4243.6, 4254.5, 4265.4, 4276.4, 4287.3, 4298.2, 4309.2,
        4320.1, 4331.1, 4342.0, 4352.9, 4363.9, 4374.8, 4385.7, 4396.7, 4407.6, 4418.5,
        4429.5, 4440.4, 4451.4, 4462.3, 4473.2, 4484.2, 4495.1, 4506.0, 4517.0, 4527.9,
        4538.9, 4549.8, 4560.7, 4571.7, 4582.6, 4593.5, 4604.5, 4615.4, 4626.4, 4637.3,
        4648.2, 4659.2, 4670.1, 4681.0, 4692.0, 4702.9, 4713.8, 4724.8, 4735.7, 4746.7,
        4757.6, 4768.5, 4779.5, 4790.4, 4801.3, 4812.3, 4823.2, 4834.2, 4845.1, 4856.0,
        4867.0, 4877.9, 4888.8, 4899.8, 4910.7, 4921.7, 4932.6, 4943.5, 4954.5, 4965.4,
        4976.3, 4987.3, 4998.2, 5009.1, 5020.1, 5031.0, 5042.0, 5052.9, 5063.8, 5074.8,
        5085.7, 5096.6, 5107.6, 5118.5, 5129.5, 5140.4, 5151.3, 5162.3, 5173.2, 5184.1,
        5195.1, 5206.0, 5216.9, 5227.9, 5238.8, 5249.8, 5260.7, 5271.6, 5282.6, 5293.5,
        5304.4, 5315.4, 5326.3, 5337.3, 5348.2, 5359.1, 5370.1, 5381.0, 5391.9, 5402.9,
        5413.8, 5424.8, 5435.7, 5446.6, 5457.6, 5468.5, 5479.4, 5490.4, 5501.3, 5501.3,
        ],
    11: [
        109.4, 131.2, 153.1, 175.0, 196.9, 218.7, 240.6, 262.5, 284.4, 306.2,
        328.1, 350.0, 371.9, 393.7, 415.6, 437.5, 459.4, 481.2, 503.1, 525.0,
        546.9, 579.7, 623.4, 667.2, 710.9, 754.7, 798.4, 842.1, 885.9, 929.6,
        973.4, 1017.1, 1060.9, 1104.6, 1148.4, 1192.1, 1235.9, 1279.6, 1323.4, 1367.1,
        1410.9, 1454.6, 1498.4, 1542.1, 1585.9, 1629.6, 1673.4, 1760.9, 1848.4, 1935.8,
        2023.3, 2110.8, 2198.3, 2285.8, 2373.3, 2460.8, 2548.3, 2635.8, 2723.3, 2810.8,
        2898.3, 2985.8, 3073.3, 3160.8, 3248.3, 3335.8, 3423.3, 3510.8, 3598.3, 3685.8,
        3773.3, 3860.8, 3992.0, 4167.0, 4342.0, 4517.0, 4692.0, 4867.0, 5042.0, 5216.9,
        109.4, 131.2, 153.1, 175.0, 196.9, 218.7, 240.6, 262.5, 284.4, 306.2,
        328.1, 350.0, 371.9, 393.7, 415.6, 437.5, 459.4, 481.2, 503.1, 525.0,
        546.9, 579.7, 623.4, 667.2, 710.9, 754.7, 798.4, 842.1, 885.9, 929.6,
        973.4, 1017.1, 1060.9, 1104.6, 1148.4, 1192.1, 1235.9, 1279.6, 1323.4, 1367.1,
        1410.9, 1454.6, 1498.4, 1542.1, 1585.9, 1629.6, 1673.4, 1760.9, 1848.4, 1935.8,
        2023.3, 2110.8, 2198.3, 2285.8, 2373.3, 2460.8, 2548.3, 2635.8, 2723.3, 2810.8,
        2898.3, 2985.8, 3073.3, 3160.8, 3248.3, 3335.8, 3423.3, 3510.8, 3598.3, 3685.8,
        3773.3, 3860.8, 3992.0, 4167.0, 4342.0, 4517.0, 4692.0, 4867.0, 5042.0, 5216.9,
        ],
    12: [
        109.4, 120.3, 131.2, 142.2, 153.1, 164.1, 175.0, 185.9, 196.9, 207.8,
        218.7, 229.7, 240.6, 251.6, 262.5, 273.4, 284.4, 295.3, 306.2, 317.2,
        328.1, 339.0, 350.0, 360.9, 371.9, 382.8, 393.7, 404.7, 415.6, 426.5,
        437.5, 448.4, 459.4, 470.3, 481.2, 492.2, 503.1, 514.0, 525.0, 535.9,
        546.9, 557.8, 568.7, 579.7, 590.6, 601.5, 612.5, 623.4, 634.3, 645.3,
        656.2, 667.2, 678.1, 689.0, 700.0, 710.9, 721.8, 732.8, 743.7, 754.7,
        765.6, 776.5, 787.5, 798.4, 809.3, 820.3, 831.2, 842.1, 853.1, 864.0,
        875.0, 885.9, 896.8, 907.8, 918.7, 929.6, 940.6, 951.5, 962.5, 973.4,
        984.3, 995.3, 1006.2, 1017.1, 1028.1, 1039.0, 1050.0, 1060.9, 1071.8, 1082.8,
        1093.7, 1104.6, 1115.6, 1126.5, 1137.4, 1148.4, 1159.3, 1170.3, 1181.2, 1192.1,
        1203.1, 1214.0, 1224.9, 1235.9, 1246.8, 1257.8, 1268.7, 1279.6, 1290.6, 1301.5,
        1312.4, 1323.4, 1334.3, 1345.3, 1356.2, 1367.1, 1378.1, 1389.0, 1399.9, 1410.9,
        1421.8, 1432.7, 1443.7, 1454.6, 1465.6, 1476.5, 1487.4, 1498.4, 1509.3, 1520.2,
        1531.2, 1542.1, 1585.9, 1629.6, 1673.4, 1760.9, 1848.4, 1935.8, 2023.3, 2110.8,
        2198.3, 2285.8, 2373.3, 2460.8, 2548.3, 2635.8, 2723.3, 2810.8, 2898.3, 2985.8,
        3073.3, 3160.8, 3248.3, 3335.8, 3423.3, 3510.8, 3598.3, 3685.8, 3773.3, 3860.8,
        ],
    13: [
        109.4, 131.2, 153.1, 175.0, 196.9, 218.7, 240.6, 262.5, 284.4, 306.2,
        328.1, 350.0, 371.9, 393.7, 415.6, 437.5, 459.4, 481.2, 503.1, 525.0,
        546.9, 568.7, 590.6, 612.5, 634.3, 656.2, 678.1, 700.0, 721.8, 743.7,
        765.6, 787.5, 809.3, 831.2, 853.1, 875.0, 896.8, 918.7, 940.6, 962.5,
        984.3, 1006.2, 1028.1, 1050.0, 1071.8, 1093.7, 1115.6, 1137.4, 1159.3, 1181.2,
        1203.1, 1224.9, 1246.8, 1268.7, 1290.6, 1312.4, 1334.3, 1356.2, 1378.1, 1399.9,
        1421.8, 1443.7, 1465.6, 1487.4, 1509.3, 1531.2, 1553.1, 1574.9, 1596.8, 1618.7,
        1640.6, 1662.4, 1684.3, 1706.2, 1728.0, 1749.9, 1771.8, 1793.7, 1815.5, 1837.4,
        1859.3, 1881.2, 1903.0, 1924.9, 1946.8, 1968.7, 1990.5, 2012.4, 2034.3, 2056.2,
        2078.0, 2099.9, 2121.8, 2143.7, 2165.5, 2187.4, 2209.3, 2231.1, 2253.0, 2274.9,
        2296.8, 2318.6, 2325.5, 2504.4, 2526.3, 2548.1, 2570.0, 2591.9, 2613.8, 2635.6,
        2657.5, 2679.4, 2701.3, 2723.1, 2745.0, 2766.9, 2788.8, 2810.6, 2832.5, 2854.4,
        2876.3, 2898.1, 2920.0, 2941.9, 2963.7, 2985.6, 3007.5, 3029.4, 3051.2, 3073.1,
        3095.0, 3116.9, 3138.7, 3160.6, 3182.5, 3204.4, 3226.2, 3248.1, 3270.0, 3291.9,
        3313.7, 3335.6, 3357.5, 3379.4, 3401.2, 3423.1, 3445.0, 3466.8, 3488.7, 3510.6,
        3532.5, 3554.3, 3576.2, 3598.1, 3620.0, 3641.8, 3663.7, 3685.6, 3707.5, 3729.3,
        ],
    14: [
        509.4, 531.2, 553.1, 575.0, 596.9, 618.7, 640.6, 662.5, 684.4, 706.2,
        728.1, 750.0, 771.9, 793.7, 815.6, 837.5, 859.4, 881.2, 903.1, 925.0,
        946.9, 968.7, 990.6, 1012.5, 1034.3, 1056.2, 1078.1, 1100.0, 1121.8, 1143.7,
        1165.6, 1187.5, 1209.3, 1231.2, 1253.1, 1275.0, 1296.8, 1318.7, 1340.6, 1362.5,
        1384.3, 1406.2, 1428.1, 1450.0, 1471.8, 1493.7, 1515.6, 1537.4, 1559.3, 1581.2,
        1603.1, 1624.9, 1646.8, 1668.7, 1690.6, 1712.4, 1734.3, 1756.2, 1778.1, 1799.9,
        1821.8, 1843.7, 1865.6, 1887.4, 1909.3, 1931.2, 1953.1, 1974.9, 1996.8, 2018.7,
        2040.6, 2062.4, 2084.3, 2106.2, 2128.0, 2149.9, 2171.8, 2193.7, 2215.5, 2237.4,
        2259.3, 2281.2, 2303.0, 2324.9, 2504.8, 2526.7, 2548.5, 2570.4, 2592.3, 2614.2,
        2636.0, 2657.9, 2679.8, 2701.7, 2723.5, 2745.4, 2767.3, 2789.1, 2811.0, 2832.9,
        2854.8, 2876.6, 2898.5, 2920.4, 2942.3, 2964.1, 2986.0, 3007.9, 3029.8, 3051.6,
        3073.5, 3095.4, 3117.3, 3139.1, 3161.0, 3182.9, 3204.8, 3226.6, 3248.5, 3270.4,
        3292.3, 3314.1, 3336.0, 3357.9, 3379.7, 3401.6, 3423.5, 3445.4, 3467.2, 3489.1,
        3511.0, 3532.9, 3554.7, 3576.6, 3598.5, 3620.4, 3642.2, 3664.1, 3686.0, 3707.9,
        3729.7, 3751.6, 3773.5, 3795.4, 3817.2, 3839.1, 3861.0, 3882.8, 3904.7, 3926.6,
        3948.5, 3970.3, 3992.2, 4014.1, 4036.0, 4057.8, 4079.7, 4101.6, 4123.5, 4145.3,
        ],
    15: [
        909.4, 931.2, 953.1, 975.0, 996.9, 1018.7, 1040.6, 1062.5, 1084.4, 1106.2,
        1128.1, 1150.0, 1171.9, 1193.7, 1215.6, 1237.5, 1259.4, 1281.2, 1303.1, 1325.0,
        1346.9, 1368.7, 1390.6, 1412.5, 1434.3, 1456.2, 1478.1, 1500.0, 1521.8, 1543.7,
        1565.6, 1587.5, 1609.3, 1631.2, 1653.1, 1675.0, 1696.8, 1718.7, 1740.6, 1762.5,
        1784.3, 1806.2, 1828.1, 1850.0, 1871.8, 1893.7, 1915.6, 1937.4, 1959.3, 1981.2,
        2003.1, 2024.9, 2046.8, 2068.7, 2090.6, 2112.4, 2134.3, 2156.2, 2178.1, 2199.9,
        2221.8, 2243.7, 2265.6, 2287.4, 2309.3, 2325.2, 2504.1, 2525.9, 2547.8, 2569.7,
        2591.6, 2613.4, 2635.3, 2657.2, 2679.0, 2700.9, 2722.8, 2744.7, 2766.5, 2788.4,
        2810.3, 2832.2, 2854.0, 2875.9, 2897.8, 2919.7, 2941.5, 2963.4, 2985.3, 3007.2,
        3029.0, 3050.9, 3072.8, 3094.7, 3116.5, 3138.4, 3160.3, 3182.1, 3204.0, 3225.9,
        3247.8, 3269.6, 3291.5, 3313.4, 3335.3, 3357.1, 3379.0, 3400.9, 3422.8, 3444.6,
        3466.5, 3488.4, 3510.3, 3532.1, 3554.0, 3575.9, 3597.8, 3619.6, 3641.5, 3663.4,
        3685.3, 3707.1, 3729.0, 3750.9, 3772.7, 3794.6, 3816.5, 3838.4, 3860.2, 3882.1,
        3904.0, 3925.9, 3947.7, 3969.6, 3991.5, 4013.4, 4035.2, 4057.1, 4079.0, 4100.9,
        4122.7, 4144.6, 4166.5, 4188.4, 4210.2, 4232.1, 4254.0, 4275.8, 4297.7, 4319.6,
        4341.5, 4363.3, 4385.2, 4407.1, 4429.0, 4450.8, 4472.7, 4494.6, 4516.5, 4538.3,
        ],
    16: [
        1309.4, 1331.2, 1353.1, 1375.0, 1396.9, 1418.7, 1440.6, 1462.5, 1484.4, 1506.2,
        1528.1, 1550.0, 1571.9, 1593.7, 1615.6, 1637.5, 1659.4, 1681.2, 1703.1, 1725.0,
        1746.9, 1768.7, 1790.6, 1812.5, 1834.3, 1856.2, 1878.1, 1900.0, 1921.8, 1943.7,
        1965.6, 1987.5, 2009.3, 2031.2, 2053.1, 2075.0, 2096.8, 2118.7, 2140.6, 2162.5,
        2184.3, 2206.2, 2228.1, 2250.0, 2271.8, 2293.7, 2315.6, 2325.4, 2504.3, 2526.2,
        2548.1, 2569.9, 2591.8, 2613.7, 2635.6, 2657.4, 2679.3, 2701.2, 2723.1, 2744.9,
        2766.8, 2788.7, 2810.6, 2832.4, 2854.3, 2876.2, 2898.1, 2919.9, 2941.8, 2963.7,
        2985.6, 3007.4, 3029.3, 3051.2, 3073.0, 3094.9, 3116.8, 3138.7, 3160.5, 3182.4,
        3204.3, 3226.2, 3248.0, 3269.9, 3291.8, 3313.7, 3335.5, 3357.4, 3379.3, 3401.2,
        3423.0, 3444.9, 3466.8, 3488.7, 3510.5, 3532.4, 3554.3, 3576.1, 3598.0, 3619.9,
        3641.8, 3663.6, 3685.5, 3707.4, 3729.3, 3751.1, 3773.0, 3794.9, 3816.8, 3838.6,
        3860.5, 3882.4, 3904.3, 3926.1, 3948.0, 3969.9, 3991.8, 4013.6, 4035.5, 4057.4,
        4079.3, 4101.1, 4123.0, 4144.9, 4166.7, 4188.6, 4210.5, 4232.4, 4254.2, 4276.1,
        4298.0, 4319.9, 4341.7, 4363.6, 4385.5, 4407.4, 4429.2, 4451.1, 4473.0, 4494.9,
        4516.7, 4538.6, 4560.5, 4582.4, 4604.2, 4626.1, 4648.0, 4669.8, 4691.7, 4713.6,
        4735.5, 4757.3, 4779.2, 4801.1, 4823.0, 4844.8, 4866.7, 4888.6, 4910.5, 4932.3,
    ],
}