# generated by datamodel-codegen:
#   filename:  api_constrained.yaml
#   timestamp: 2019-07-26T00:00:00+00:00

from __future__ import annotations

from typing import Annotated

from pydantic import AnyUrl, BaseModel, Field, RootModel


class Pet(BaseModel):
    id: Annotated[int, Field(ge=0, le=9223372036854775807)]
    name: Annotated[str, Field(max_length=256)]
    tag: Annotated[str | None, Field(max_length=64)] = None


class Pets(RootModel[list[Pet]]):
    root: Annotated[list[Pet], Field(max_length=10, min_length=1)]


class UID(RootModel[int]):
    root: Annotated[int, Field(ge=0)]


class Phone(RootModel[str]):
    root: Annotated[str, Field(min_length=3)]


class FaxItem(RootModel[str]):
    root: Annotated[str, Field(min_length=3)]


class User(BaseModel):
    id: Annotated[int, Field(ge=0)]
    name: Annotated[str, Field(max_length=256)]
    tag: Annotated[str | None, Field(max_length=64)] = None
    uid: UID
    phones: Annotated[list[Phone] | None, Field(max_length=10)] = None
    fax: list[FaxItem] | None = None
    height: Annotated[int | float | None, Field(ge=1.0, le=300.0)] = None
    weight: Annotated[float | int | None, Field(ge=1.0, le=1000.0)] = None
    age: Annotated[int | None, Field(gt=0, le=200)] = None
    rating: Annotated[float | None, Field(gt=0.0, le=5.0)] = None


class Users(RootModel[list[User]]):
    root: list[User]


class Id(RootModel[str]):
    root: str


class Rules(RootModel[list[str]]):
    root: list[str]


class Error(BaseModel):
    code: int
    message: str


class Api(BaseModel):
    apiKey: Annotated[
        str | None, Field(description='To be used as a dataset parameter value')
    ] = None
    apiVersionNumber: Annotated[
        str | None, Field(description='To be used as a version parameter value')
    ] = None
    apiUrl: Annotated[
        AnyUrl | None, Field(description="The URL describing the dataset's fields")
    ] = None
    apiDocumentationUrl: Annotated[
        AnyUrl | None, Field(description='A URL to the API console for each API')
    ] = None


class Apis(RootModel[list[Api]]):
    root: list[Api]


class Event(BaseModel):
    name: str | None = None


class Result(BaseModel):
    event: Event | None = None
