# generated by datamodel-codegen:
#   filename:  api.yaml
#   timestamp: 2019-07-26T00:00:00+00:00

from __future__ import annotations

from pydantic import AnyUrl, BaseModel, ConfigDict, Field, RootModel


class Pet(BaseModel):
    model_config = ConfigDict(
        extra='allow',
    )
    id: int
    name: str
    tag: str | None = None


class Pets(RootModel[list[Pet]]):
    root: list[Pet]


class User(BaseModel):
    model_config = ConfigDict(
        extra='allow',
    )
    id: int
    name: str
    tag: str | None = None


class Users(RootModel[list[User]]):
    root: list[User]


class Id(RootModel[str]):
    root: str


class Rules(RootModel[list[str]]):
    root: list[str]


class Error(BaseModel):
    model_config = ConfigDict(
        extra='allow',
    )
    code: int
    message: str


class Api(BaseModel):
    model_config = ConfigDict(
        extra='allow',
    )
    apiKey: str | None = Field(
        None, description='To be used as a dataset parameter value'
    )
    apiVersionNumber: str | None = Field(
        None, description='To be used as a version parameter value'
    )
    apiUrl: AnyUrl | None = Field(
        None, description="The URL describing the dataset's fields"
    )
    apiDocumentationUrl: AnyUrl | None = Field(
        None, description='A URL to the API console for each API'
    )


class Apis(RootModel[list[Api]]):
    root: list[Api]


class Event(BaseModel):
    model_config = ConfigDict(
        extra='allow',
    )
    name: str | None = None


class Result(BaseModel):
    model_config = ConfigDict(
        extra='allow',
    )
    event: Event | None = None
