# generated by datamodel-codegen:
#   filename:  person.json
#   timestamp: 2019-07-26T00:00:00+00:00

from __future__ import annotations

from enum import Enum

from pydantic import BaseModel, Extra, Field, conint


class Fur(Enum):
    Short_hair = 'Short hair'
    Long_hair = 'Long hair'


class Noodle(Enum):
    ramen = 'ramen'
    spaghetti = 'spaghetti'


class Soup(Enum):
    bean = 'bean'
    mushroom = 'mushroom'
    tomato = 'tomato'


class Coffee(Enum):
    Black = 'Black'
    Espresso = 'Espresso'


class Tea(Enum):
    Oolong = 'Oolong'
    Green = 'Green'


class Pet(BaseModel):
    name: str | None = None
    age: int | None = None
    fur: Fur | None = None


class Friend(BaseModel):
    class Config:
        extra = Extra.allow

    name: str = Field(..., example='John Doe')
    phone_number: str | None = Field(None, example='(555) 555-1234')
    food: list[Noodle | Soup] | None = None


class Friends(BaseModel):
    __root__: list[Friend] = Field(..., title='Friends')


class Person(BaseModel):
    first_name: str = Field(..., description="The person's first name.")
    last_name: str = Field(..., description="The person's last name.")
    age: conint(ge=0) | None = Field(None, description='Age in years.')
    pets: list[Pet] | None = None
    friends: Friends | None = None
    robot: Robot | None = None
    comment: None = None
    drink: list[Coffee | Tea] | None = None
    food: list[Noodle | Soup] | None = None


class Robot(Pet):
    friends: Person | None = None
    drink: Coffee | None = None
    food: Noodle | None = None
    pet: Pet | None = None


Person.update_forward_refs()
